/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.ITriggerPointManager;
import org.eclipse.ui.internal.activities.Persistence;
import org.eclipse.ui.internal.activities.ws.AbstractTriggerPoint;
import org.eclipse.ui.internal.activities.ws.RegistryTriggerPoint;

public class TriggerPointManager
implements ITriggerPointManager,
IExtensionChangeHandler {
    private HashMap triggerMap = new HashMap();

    public TriggerPointManager() {
        this.triggerMap.put("org.eclipse.ui.internal.UnknownTriggerPoint", new AbstractTriggerPoint(){

            @Override
            public String getId() {
                return "org.eclipse.ui.internal.UnknownTriggerPoint";
            }

            @Override
            public String getStringHint(String string) {
                if ("interactive".equals(string)) {
                    return Boolean.TRUE.toString();
                }
                return null;
            }

            @Override
            public boolean getBooleanHint(String string) {
                return "interactive".equals(string);
            }
        });
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        IExtensionPoint iExtensionPoint = this.getExtensionPointFilter();
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            this.addExtension(iExtensionTracker, iExtensionArray[n]);
            ++n;
        }
    }

    @Override
    public ITriggerPoint getTriggerPoint(String string) {
        return (ITriggerPoint)this.triggerMap.get(string);
    }

    @Override
    public Set getDefinedTriggerPointIds() {
        return this.triggerMap.entrySet();
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof RegistryTriggerPoint) {
                this.triggerMap.remove(((RegistryTriggerPoint)object).getId());
            }
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("triggerPoint")) {
                String string = iConfigurationElement.getAttribute("id");
                if (string == null) {
                    Persistence.log(iConfigurationElement, "Invalid trigger point", "missing a unique identifier");
                } else {
                    RegistryTriggerPoint registryTriggerPoint = new RegistryTriggerPoint(string, iConfigurationElement);
                    this.triggerMap.put(string, registryTriggerPoint);
                    iExtensionTracker.registerObject(iExtension, (Object)registryTriggerPoint, 2);
                }
            }
            ++n;
        }
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "activitySupport");
    }
}

