/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.activities.ws.TriggerPointAdvisorDescriptor;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.RegistryReader;

public class TriggerPointAdvisorRegistry {
    private static TriggerPointAdvisorRegistry instance;

    private TriggerPointAdvisorRegistry() {
    }

    public static TriggerPointAdvisorRegistry getInstance() {
        if (instance == null) {
            instance = new TriggerPointAdvisorRegistry();
        }
        return instance;
    }

    public TriggerPointAdvisorDescriptor[] getAdvisors() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "activitySupport");
        if (iExtensionPoint == null) {
            return new TriggerPointAdvisorDescriptor[0];
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        iExtensionArray = RegistryReader.orderExtensions(iExtensionArray);
        ArrayList<TriggerPointAdvisorDescriptor> arrayList = new ArrayList<TriggerPointAdvisorDescriptor>(iExtensionArray.length);
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n2].getName().equals("triggerPointAdvisor")) {
                    try {
                        TriggerPointAdvisorDescriptor triggerPointAdvisorDescriptor = new TriggerPointAdvisorDescriptor(iConfigurationElementArray[n2]);
                        arrayList.add(triggerPointAdvisorDescriptor);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        WorkbenchPlugin.log("invalid trigger point advisor extension", StatusUtil.newStatus(4, illegalArgumentException.getMessage(), (Throwable)illegalArgumentException));
                    }
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new TriggerPointAdvisorDescriptor[arrayList.size()]);
    }

    public TriggerPointAdvisorDescriptor getAdvisorForProduct(String string) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "activitySupport");
        if (iExtensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        String string2 = this.getAdvisorForProduct(string, iExtensionArray = RegistryReader.orderExtensions(iExtensionArray));
        if (string2 == null) {
            return null;
        }
        TriggerPointAdvisorDescriptor[] triggerPointAdvisorDescriptorArray = this.getAdvisors();
        int n = 0;
        while (n < triggerPointAdvisorDescriptorArray.length) {
            if (triggerPointAdvisorDescriptorArray[n].getId().equals(string2)) {
                return triggerPointAdvisorDescriptorArray[n];
            }
            ++n;
        }
        return null;
    }

    private String getAdvisorForProduct(String string, IExtension[] iExtensionArray) {
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n2].getName().equals("triggerPointAdvisorProductBinding")) {
                    String string2 = iConfigurationElementArray[n2].getAttribute("triggerPointAdvisorId");
                    String string3 = iConfigurationElementArray[n2].getAttribute("productId");
                    if (string2 == null || string3 == null) {
                        Status status = new Status(4, iConfigurationElementArray[n2].getDeclaringExtension().getNamespace(), 4, "triggerPointAdvisorId and productId must be defined.", (Throwable)new IllegalArgumentException());
                        WorkbenchPlugin.log("Invalid trigger point advisor binding", (IStatus)status);
                    } else if (string.equals(string3)) {
                        return string2;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }
}

