/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.activities.Persistence;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageBindingRegistry
implements IExtensionChangeHandler {
    private String tag;
    private ImageRegistry registry = new ImageRegistry();

    public ImageBindingRegistry(String string) {
        this.tag = string;
        IExtension[] iExtensionArray = this.getExtensionPointFilter().getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            this.addExtension(PlatformUI.getWorkbench().getExtensionTracker(), iExtensionArray[n]);
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals(this.tag)) {
                ImageDescriptor imageDescriptor;
                String string = iConfigurationElement.getAttribute("id");
                String string2 = iConfigurationElement.getAttribute("icon");
                if (string2 == null || string == null) {
                    Persistence.log(iConfigurationElement, "Invalid activity image binding", "definition must contain icon and ID");
                } else if (this.registry.getDescriptor(string) == null && (imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(iConfigurationElement.getNamespace(), string2)) != null) {
                    this.registry.put(string, imageDescriptor);
                    iExtensionTracker.registerObject(iExtension, (Object)string, 2);
                }
            }
            ++n;
        }
    }

    public IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "activitySupport");
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof String) {
                this.registry.remove((String)objectArray[n]);
            }
            ++n;
        }
    }

    public ImageDescriptor getImageDescriptor(String string) {
        return this.registry.getDescriptor(string);
    }

    void dispose() {
        this.registry.dispose();
    }
}

