/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import com.ibm.icu.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.activities.WorkbenchTriggerPointAdvisor;
import org.eclipse.ui.internal.activities.ws.ActivityContentProvider;
import org.eclipse.ui.internal.activities.ws.ActivityLabelProvider;

public class EnablementDialog
extends Dialog {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(EnablementDialog.class.getName());
    private Button dontAskButton;
    private Set activitiesToEnable = new HashSet(7);
    private Collection activityIds;
    private boolean dontAsk;
    private Button detailsButton;
    boolean showDetails = false;
    private Composite detailsComposite;
    private Label detailsLabel;
    private String selectedActivity;
    private Text detailsText;
    private Properties strings;

    public EnablementDialog(Shell shell, Collection collection, Properties properties) {
        super(shell);
        this.activityIds = collection;
        this.strings = properties;
    }

    protected Control createDialogArea(Composite composite) {
        String string;
        Object object;
        Object object2;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Font font = composite.getFont();
        composite2.setFont(font);
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setFont(font);
        IActivityManager iActivityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        if (this.activityIds.size() == 1) {
            object2 = (String)this.activityIds.iterator().next();
            this.activitiesToEnable.add(object2);
            this.selectedActivity = object2;
            object = iActivityManager.getActivity((String)object2);
            try {
                string = object.getName();
            }
            catch (NotDefinedException notDefinedException) {
                string = object.getId();
            }
            label.setText(MessageFormat.format((String)RESOURCE_BUNDLE.getString("requiresSingle"), (Object[])new Object[]{string}));
            label = new Label(composite2, 0);
            label.setText(this.strings.getProperty(WorkbenchTriggerPointAdvisor.PROCEED_SINGLE, RESOURCE_BUNDLE.getString(WorkbenchTriggerPointAdvisor.PROCEED_SINGLE)));
            label.setLayoutData((Object)new GridData(768));
            label.setFont(font);
        } else {
            label.setText(RESOURCE_BUNDLE.getString("requiresMulti"));
            object2 = new HashSet(this.activityIds);
            object = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2084);
            object.setContentProvider((IContentProvider)new ActivityContentProvider());
            object.setLabelProvider((IBaseLabelProvider)new ActivityLabelProvider(iActivityManager));
            object.setInput(object2);
            object.setCheckedElements(object2.toArray());
            object.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                    if (checkStateChangedEvent.getChecked()) {
                        EnablementDialog.this.activitiesToEnable.add(checkStateChangedEvent.getElement());
                    } else {
                        EnablementDialog.this.activitiesToEnable.remove(checkStateChangedEvent.getElement());
                    }
                    EnablementDialog.this.getButton(0).setEnabled(!EnablementDialog.this.activitiesToEnable.isEmpty());
                }
            });
            object.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    EnablementDialog.this.selectedActivity = (String)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                    EnablementDialog.this.setDetails();
                }
            });
            this.activitiesToEnable.addAll(object2);
            object.getControl().setLayoutData((Object)new GridData(768));
            object.getControl().setFont(font);
            label = new Label(composite2, 0);
            label.setText(this.strings.getProperty(WorkbenchTriggerPointAdvisor.PROCEED_MULTI, RESOURCE_BUNDLE.getString(WorkbenchTriggerPointAdvisor.PROCEED_MULTI)));
            label.setLayoutData((Object)new GridData(768));
            label.setFont(font);
        }
        object2 = new Label(composite2, 258);
        object2.setLayoutData((Object)new GridData(768));
        this.dontAskButton = new Button(composite2, 32);
        this.dontAskButton.setSelection(false);
        this.dontAskButton.setLayoutData((Object)new GridData(768));
        this.dontAskButton.setText(this.strings.getProperty(WorkbenchTriggerPointAdvisor.DONT_ASK, RESOURCE_BUNDLE.getString(WorkbenchTriggerPointAdvisor.DONT_ASK)));
        this.dontAskButton.setFont(font);
        this.detailsComposite = new Composite(composite2, 0);
        object = new GridLayout();
        ((GridLayout)object).marginHeight = 0;
        ((GridLayout)object).marginWidth = 0;
        this.detailsComposite.setLayout((Layout)object);
        this.detailsLabel = new Label(this.detailsComposite, 0);
        this.detailsLabel.setLayoutData((Object)new GridData(768));
        this.detailsLabel.setFont(font);
        this.detailsText = new Text(this.detailsComposite, 2632);
        this.detailsText.setLayoutData((Object)new GridData(1808));
        this.detailsText.setFont(font);
        this.setDetails();
        string = new GridData(1808);
        this.detailsComposite.setLayoutData((Object)string);
        this.setDetailHints();
        return composite2;
    }

    protected void setDetails() {
        if (this.selectedActivity == null) {
            this.detailsLabel.setText(this.strings.getProperty(WorkbenchTriggerPointAdvisor.NO_DETAILS, RESOURCE_BUNDLE.getString(WorkbenchTriggerPointAdvisor.NO_DETAILS)));
            this.detailsText.setText("");
        } else {
            String string;
            String string2;
            IActivity iActivity = PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getActivity(this.selectedActivity);
            try {
                string2 = iActivity.getName();
            }
            catch (NotDefinedException notDefinedException) {
                string2 = this.selectedActivity;
            }
            try {
                string = iActivity.getDescription();
            }
            catch (NotDefinedException notDefinedException) {
                string = RESOURCE_BUNDLE.getString("noDescAvailable");
            }
            this.detailsLabel.setText(MessageFormat.format((String)RESOURCE_BUNDLE.getString("detailsLabel"), (Object[])new Object[]{string2}));
            this.detailsText.setText(string);
        }
    }

    protected void setDetailHints() {
        GridData gridData = (GridData)this.detailsComposite.getLayoutData();
        if (this.showDetails) {
            Composite composite = this.detailsComposite.getParent();
            gridData.widthHint = composite.getSize().x - ((GridLayout)composite.getLayout()).marginWidth * 2;
            gridData.heightHint = this.convertHeightInCharsToPixels(5);
        } else {
            gridData.widthHint = 0;
            gridData.heightHint = 0;
        }
    }

    private void setDetailButtonLabel() {
        if (!this.showDetails) {
            this.detailsButton.setText(RESOURCE_BUNDLE.getString("showDetails"));
        } else {
            this.detailsButton.setText(RESOURCE_BUNDLE.getString("hideDetails"));
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(RESOURCE_BUNDLE.getString("title"));
    }

    public boolean getDontAsk() {
        return this.dontAsk;
    }

    public Set getActivitiesToEnable() {
        return this.activitiesToEnable;
    }

    protected void okPressed() {
        this.dontAsk = this.dontAskButton.getSelection();
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.detailsButton = this.createButton(composite, 13, "", false);
        this.setDetailButtonLabel();
    }

    protected void buttonPressed(int n) {
        if (n == 13) {
            this.detailsPressed();
            return;
        }
        super.buttonPressed(n);
    }

    private void detailsPressed() {
        this.showDetails = !this.showDetails;
        this.setDetailButtonLabel();
        this.setDetailHints();
        this.setDetails();
        ((Composite)this.getDialogArea()).layout(true);
        this.getShell().setSize(this.getShell().computeSize(-1, -1));
    }
}

