/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.IMutableActivityManager;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.internal.activities.InternalActivityHelper;
import org.eclipse.ui.internal.activities.ws.ActivityCategoryContentProvider;
import org.eclipse.ui.internal.activities.ws.ActivityCategoryLabelProvider;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.activities.ws.CategorizedActivity;

public class ActivityEnabler {
    private static final int ALL = 2;
    private static final int NONE = 0;
    private static final int SOME = 1;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            Object object = ((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
            try {
                if (object instanceof ICategory) {
                    ActivityEnabler.this.descriptionText.setText(((ICategory)object).getDescription());
                } else if (object instanceof IActivity) {
                    ActivityEnabler.this.descriptionText.setText(((IActivity)object).getDescription());
                }
            }
            catch (NotDefinedException notDefinedException) {
                ActivityEnabler.this.descriptionText.setText("");
            }
        }
    };
    private ICheckStateListener checkListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
            HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList(ActivityEnabler.this.dualViewer.getCheckedElements()));
            Object object = checkStateChangedEvent.getElement();
            if (object instanceof ICategory) {
                ActivityEnabler.this.dualViewer.setSubtreeChecked(object, checkStateChangedEvent.getChecked());
                ActivityEnabler.this.dualViewer.setGrayed(object, false);
                Object[] objectArray = ActivityEnabler.this.provider.getChildren(object);
                int n = 0;
                while (n < objectArray.length) {
                    this.handleDuplicateActivities(checkStateChangedEvent.getChecked(), objectArray[n]);
                    ++n;
                }
            } else {
                this.handleActivityCheck(hashSet, object);
                this.handleDuplicateActivities(checkStateChangedEvent.getChecked(), object);
            }
        }

        private void handleDuplicateActivities(boolean bl, Object object) {
            Object[] objectArray = ActivityEnabler.this.provider.getDuplicateCategoryActivities((CategorizedActivity)object);
            CategorizedActivity categorizedActivity = null;
            int n = 0;
            while (n < objectArray.length) {
                categorizedActivity = (CategorizedActivity)objectArray[n];
                ActivityEnabler.this.dualViewer.setChecked((Object)categorizedActivity, bl);
                this.handleActivityCheck(new HashSet<Object>(Arrays.asList(ActivityEnabler.this.dualViewer.getCheckedElements())), categorizedActivity);
                ++n;
            }
        }

        private void handleActivityCheck(Set set, Object object) {
            CategorizedActivity categorizedActivity = (CategorizedActivity)object;
            Object[] objectArray = ActivityEnabler.this.provider.getChildren(categorizedActivity.getCategory());
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (set.contains(objectArray[n3])) {
                    ++n2;
                }
                ++n3;
            }
            if (n2 == objectArray.length) {
                n = 2;
            } else if (n2 != 0) {
                n = 1;
            }
            if (n == 0) {
                set.remove(categorizedActivity.getCategory());
            } else {
                set.add(categorizedActivity.getCategory());
            }
            ActivityEnabler.this.dualViewer.setGrayed((Object)categorizedActivity.getCategory(), n == 1);
            ActivityEnabler.this.dualViewer.setCheckedElements(set.toArray());
            this.handleRequiredActivities(set, object);
        }

        private void handleRequiredActivities(Set set, Object object) {
            Object[] objectArray = null;
            if (set.contains(object)) {
                objectArray = ActivityEnabler.this.provider.getChildRequiredActivities(((CategorizedActivity)object).getId());
                int n = 0;
                while (n < objectArray.length) {
                    if (!set.contains(objectArray[n])) {
                        ActivityEnabler.this.dualViewer.setChecked(objectArray[n], true);
                        this.handleActivityCheck(new HashSet<Object>(Arrays.asList(ActivityEnabler.this.dualViewer.getCheckedElements())), objectArray[n]);
                    }
                    ++n;
                }
            } else {
                objectArray = ActivityEnabler.this.provider.getParentRequiredActivities(((CategorizedActivity)object).getId());
                int n = 0;
                while (n < objectArray.length) {
                    if (set.contains(objectArray[n])) {
                        ActivityEnabler.this.dualViewer.setChecked(objectArray[n], false);
                        this.handleActivityCheck(new HashSet<Object>(Arrays.asList(ActivityEnabler.this.dualViewer.getCheckedElements())), objectArray[n]);
                    }
                    ++n;
                }
            }
        }
    };
    protected CheckboxTreeViewer dualViewer;
    private Set managedActivities = new HashSet(7);
    protected ActivityCategoryContentProvider provider = new ActivityCategoryContentProvider();
    protected Text descriptionText;
    private Properties strings;
    private IMutableActivityManager activitySupport;

    public ActivityEnabler(IMutableActivityManager iMutableActivityManager, Properties properties) {
        this.activitySupport = iMutableActivityManager;
        this.strings = properties;
    }

    public Control createControl(Composite composite) {
        GC gC = new GC((Drawable)composite);
        gC.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.createGridLayoutWithoutMargins(1, fontMetrics));
        new Label(composite2, 0).setText(String.valueOf(this.strings.getProperty("activityName", ActivityMessages.ActivityEnabler_activities)) + ':');
        this.dualViewer = new CheckboxTreeViewer(composite2);
        this.dualViewer.setComparator(new ViewerComparator());
        this.dualViewer.setLabelProvider((IBaseLabelProvider)new ActivityCategoryLabelProvider());
        this.dualViewer.setContentProvider((IContentProvider)this.provider);
        this.dualViewer.setInput((Object)this.activitySupport);
        GridData gridData = new GridData(4, 4, true, true);
        this.dualViewer.getControl().setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)this.createGridLayoutWithoutMargins(2, fontMetrics));
        Button button = new Button(composite3, 8);
        button.setText(ActivityMessages.ActivityEnabler_selectAll);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ActivityEnabler.this.toggleTreeEnablement(true);
            }
        });
        this.setButtonLayoutData(button, fontMetrics);
        Button button2 = new Button(composite3, 8);
        button2.setText(ActivityMessages.ActivityEnabler_deselectAll);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ActivityEnabler.this.toggleTreeEnablement(false);
            }
        });
        this.setButtonLayoutData(button2, fontMetrics);
        new Label(composite2, 0).setText(ActivityMessages.ActivityEnabler_description);
        this.descriptionText = new Text(composite2, 2632);
        gridData = new GridData(4, 4, true, false);
        gridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)5);
        this.descriptionText.setLayoutData((Object)gridData);
        this.setInitialStates();
        this.dualViewer.addCheckStateListener(this.checkListener);
        this.dualViewer.addSelectionChangedListener(this.selectionListener);
        this.dualViewer.setSelection((ISelection)new StructuredSelection());
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private GridLayout createGridLayoutWithoutMargins(int n, FontMetrics fontMetrics) {
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
        gridLayout.verticalSpacing = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
        return gridLayout;
    }

    private GridData setButtonLayoutData(Button button, FontMetrics fontMetrics) {
        GridData gridData = new GridData(256);
        int n = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point point = button.computeSize(-1, -1, true);
        gridData.widthHint = Math.max(n, point.x);
        button.setLayoutData((Object)gridData);
        return gridData;
    }

    private void setInitialStates() {
        Set set = this.activitySupport.getEnabledActivityIds();
        this.setEnabledStates(set);
    }

    private void setEnabledStates(Set set) {
        Set set2 = this.activitySupport.getDefinedCategoryIds();
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>(10);
        ArrayList<ICategory> arrayList2 = new ArrayList<ICategory>(10);
        for (String string : set2) {
            ICategory iCategory = this.activitySupport.getCategory(string);
            int n = 0;
            Set set3 = InternalActivityHelper.getActivityIdsForCategory(this.activitySupport, iCategory);
            int n2 = 0;
            for (String string2 : set3) {
                this.managedActivities.add(string2);
                if (!set.contains(string2)) continue;
                IActivity iActivity = this.activitySupport.getActivity(string2);
                arrayList.add(new CategorizedActivity(iCategory, iActivity));
                ++n2;
            }
            if (n2 == set3.size()) {
                n = 2;
            } else if (n2 > 0) {
                n = 1;
            }
            if (n == 0) continue;
            arrayList.add(iCategory);
            if (n != 1) continue;
            arrayList2.add(iCategory);
        }
        this.dualViewer.setCheckedElements(arrayList.toArray());
        this.dualViewer.setGrayedElements(arrayList2.toArray());
    }

    public void updateActivityStates() {
        HashSet<String> hashSet = new HashSet<String>(this.activitySupport.getEnabledActivityIds());
        hashSet.removeAll(this.managedActivities);
        Object[] objectArray = this.dualViewer.getCheckedElements();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (!(object instanceof ICategory) && !this.dualViewer.getGrayed(object)) {
                hashSet.add(((IActivity)object).getId());
            }
            ++n;
        }
        this.activitySupport.setEnabledActivityIds(hashSet);
    }

    public void restoreDefaults() {
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.activitySupport.getDefinedActivityIds();
        for (String string : set) {
            IActivity iActivity = this.activitySupport.getActivity(string);
            try {
                if (!iActivity.isDefaultEnabled()) continue;
                hashSet.add(string);
            }
            catch (NotDefinedException notDefinedException) {}
        }
        this.setEnabledStates(hashSet);
    }

    protected void toggleTreeEnablement(boolean bl) {
        Object[] objectArray = this.provider.getElements(this.activitySupport);
        this.dualViewer.setGrayedElements(new Object[0]);
        int n = 0;
        while (n < objectArray.length) {
            this.dualViewer.expandToLevel(objectArray[n], -1);
            this.dualViewer.setSubtreeChecked(objectArray[n], bl);
            ++n;
        }
    }
}

