/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.NotDefinedException;

public class ActivityCategoryLabelProvider
extends LabelProvider {
    private LocalResourceManager manager;
    private Map descriptorMap = new HashMap();

    public ActivityCategoryLabelProvider() {
        this.manager = new LocalResourceManager(JFaceResources.getResources());
    }

    public Image getImage(Object object) {
        try {
            ImageDescriptor imageDescriptor = this.getDescriptor(object);
            if (imageDescriptor != null) {
                return this.manager.createImage(imageDescriptor);
            }
        }
        catch (DeviceResourceException deviceResourceException) {}
        return null;
    }

    private ImageDescriptor getDescriptor(Object object) {
        ImageDescriptor imageDescriptor = (ImageDescriptor)this.descriptorMap.get(object);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        if (object instanceof ICategory) {
            ICategory iCategory = (ICategory)object;
            imageDescriptor = PlatformUI.getWorkbench().getActivitySupport().getImageDescriptor(iCategory);
            if (imageDescriptor != null) {
                this.descriptorMap.put(object, imageDescriptor);
            }
        } else if (object instanceof IActivity) {
            IActivity iActivity = (IActivity)object;
            imageDescriptor = PlatformUI.getWorkbench().getActivitySupport().getImageDescriptor(iActivity);
            if (imageDescriptor != null) {
                this.descriptorMap.put(object, imageDescriptor);
            }
        }
        return imageDescriptor;
    }

    public String getText(Object object) {
        if (object instanceof IActivity) {
            IActivity iActivity = (IActivity)object;
            try {
                return iActivity.getName();
            }
            catch (NotDefinedException notDefinedException) {
                return iActivity.getId();
            }
        }
        if (object instanceof ICategory) {
            ICategory iCategory = (ICategory)object;
            try {
                return iCategory.getName();
            }
            catch (NotDefinedException notDefinedException) {
                return iCategory.getId();
            }
        }
        return super.getText(object);
    }

    public void dispose() {
        this.manager.dispose();
        this.descriptorMap.clear();
    }
}

