/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityRequirementBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;
import org.eclipse.ui.internal.util.ConfigurationElementMemento;

public final class Persistence {
    static final String PACKAGE_BASE = "activities";
    static final String PACKAGE_FULL = "org.eclipse.ui.activities";
    static final String PACKAGE_PREFIX = "org.eclipse.ui";
    static final String TAG_ACTIVITY = "activity";
    static final String TAG_ACTIVITY_REQUIREMENT_BINDING = "activityRequirementBinding";
    static final String TAG_DEFAULT_ENABLEMENT = "defaultEnablement";
    static final String TAG_ACTIVITY_ID = "activityId";
    static final String TAG_ACTIVITY_PATTERN_BINDING = "activityPatternBinding";
    static final String TAG_CATEGORY = "category";
    static final String TAG_CATEGORY_ACTIVITY_BINDING = "categoryActivityBinding";
    static final String TAG_CATEGORY_ID = "categoryId";
    static final String TAG_REQUIRED_ACTIVITY_ID = "requiredActivityId";
    static final String TAG_ID = "id";
    static final String TAG_NAME = "name";
    static final String TAG_PATTERN = "pattern";
    static final String TAG_IS_EQUALITY_PATTERN = "isEqualityPattern";
    static final String TAG_SOURCE_ID = "sourceId";
    static final String TAG_DESCRIPTION = "description";
    public static final String ACTIVITY_REQUIREMENT_BINDING_DESC = "Invalid activity requirement binding";
    public static final String ACTIVITY_DESC = "Invalid activity";
    public static final String ACTIVITY_PATTERN_BINDING_DESC = "Invalid activity pattern binding";
    public static final String CATEGORY_ACTIVITY_BINDING_DESC = "Invalid category activity binding";
    public static final String CATEGORY_DESC = "Invalid category description";
    public static final String ACTIVITY_IMAGE_BINDING_DESC = "Invalid activity image binding";
    public static final String ACTIVITY_TRIGGER_DESC = "Invalid trigger point";
    public static final String ACTIVITY_TRIGGER_HINT_DESC = "Invalid trigger point hint";
    public static final String shortContextTemplate = " (contributed by ''{0}'')";
    public static final String fullContextTemplate = " (contributed by ''{0}'', extension ID ''{1}'')";

    static ActivityRequirementBindingDefinition readActivityRequirementBindingDefinition(IMemento iMemento, String string) {
        String string2 = iMemento.getString(TAG_REQUIRED_ACTIVITY_ID);
        if (string2 == null) {
            Persistence.log(iMemento, ACTIVITY_REQUIREMENT_BINDING_DESC, "missing ID of the required activity");
            return null;
        }
        String string3 = iMemento.getString(TAG_ACTIVITY_ID);
        if (string3 == null) {
            Persistence.log(iMemento, ACTIVITY_REQUIREMENT_BINDING_DESC, "missing ID of the activity to bind");
            return null;
        }
        String string4 = string != null ? string : iMemento.getString(TAG_SOURCE_ID);
        return new ActivityRequirementBindingDefinition(string2, string3, string4);
    }

    static String readDefaultEnablement(IMemento iMemento) {
        return iMemento.getString(TAG_ID);
    }

    static ActivityDefinition readActivityDefinition(IMemento iMemento, String string) {
        String string2 = iMemento.getString(TAG_ID);
        if (string2 == null) {
            Persistence.log(iMemento, ACTIVITY_DESC, "missing a unique identifier");
            return null;
        }
        String string3 = iMemento.getString(TAG_NAME);
        if (string3 == null) {
            Persistence.log(iMemento, ACTIVITY_DESC, "missing a translatable name");
            return null;
        }
        String string4 = iMemento.getString(TAG_DESCRIPTION);
        if (string4 == null) {
            string4 = "";
        }
        String string5 = string != null ? string : iMemento.getString(TAG_SOURCE_ID);
        return new ActivityDefinition(string2, string3, string5, string4);
    }

    static ActivityPatternBindingDefinition readActivityPatternBindingDefinition(IMemento iMemento, String string) {
        String string2 = iMemento.getString(TAG_ACTIVITY_ID);
        if (string2 == null) {
            Persistence.log(iMemento, ACTIVITY_PATTERN_BINDING_DESC, "missing an ID of the activity to bind");
            return null;
        }
        String string3 = iMemento.getString(TAG_PATTERN);
        if (string3 == null) {
            Persistence.log(iMemento, ACTIVITY_PATTERN_BINDING_DESC, "missing the pattern to be bound");
            return null;
        }
        String string4 = string != null ? string : iMemento.getString(TAG_SOURCE_ID);
        String string5 = iMemento.getString(TAG_IS_EQUALITY_PATTERN);
        boolean bl = string5 != null && string5.equals("true");
        return new ActivityPatternBindingDefinition(string2, string3, string4, bl);
    }

    static CategoryActivityBindingDefinition readCategoryActivityBindingDefinition(IMemento iMemento, String string) {
        String string2 = iMemento.getString(TAG_ACTIVITY_ID);
        if (string2 == null) {
            Persistence.log(iMemento, CATEGORY_ACTIVITY_BINDING_DESC, "missing the ID of the activity to bind");
            return null;
        }
        String string3 = iMemento.getString(TAG_CATEGORY_ID);
        if (string3 == null) {
            Persistence.log(iMemento, CATEGORY_ACTIVITY_BINDING_DESC, "missing the ID of the category to bind");
            return null;
        }
        String string4 = string != null ? string : iMemento.getString(TAG_SOURCE_ID);
        return new CategoryActivityBindingDefinition(string2, string3, string4);
    }

    static CategoryDefinition readCategoryDefinition(IMemento iMemento, String string) {
        String string2 = iMemento.getString(TAG_ID);
        if (string2 == null) {
            Persistence.log(iMemento, CATEGORY_DESC, "has no ID");
            return null;
        }
        String string3 = iMemento.getString(TAG_NAME);
        if (string3 == null) {
            Persistence.log(iMemento, CATEGORY_DESC, "missing a translatable name");
            return null;
        }
        String string4 = iMemento.getString(TAG_DESCRIPTION);
        if (string4 == null) {
            string4 = "";
        }
        String string5 = string != null ? string : iMemento.getString(TAG_SOURCE_ID);
        return new CategoryDefinition(string2, string3, string5, string4);
    }

    private Persistence() {
    }

    public static void log(IMemento iMemento, String string, String string2) {
        if (iMemento instanceof ConfigurationElementMemento) {
            ConfigurationElementMemento configurationElementMemento = (ConfigurationElementMemento)iMemento;
            Persistence.log(string, string2, configurationElementMemento.getContributorName(), configurationElementMemento.getExtensionID());
        } else {
            Persistence.log(string, string2, null, null);
        }
    }

    public static void log(IConfigurationElement iConfigurationElement, String string, String string2) {
        String string3 = iConfigurationElement.getContributor().getName();
        String string4 = iConfigurationElement.getDeclaringExtension().getUniqueIdentifier();
        Persistence.log(string, string2, string3, string4);
    }

    public static void log(String string, String string2, String string3, String string4) {
        String string5 = String.valueOf(string) + ": " + string2;
        if (string3 != null && string4 != null) {
            string5 = String.valueOf(string5) + NLS.bind((String)fullContextTemplate, (Object)string3, (Object)string4);
        } else if (string3 != null) {
            string5 = String.valueOf(string5) + NLS.bind((String)shortContextTemplate, (Object)string3);
        }
        WorkbenchPlugin.log(string5);
    }
}

