/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityEvent;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.CategoryEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityRequirementBinding;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IMutableActivityManager;
import org.eclipse.ui.activities.ITriggerPointAdvisor;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.internal.activities.AbstractActivityManager;
import org.eclipse.ui.internal.activities.Activity;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBinding;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityRegistryEvent;
import org.eclipse.ui.internal.activities.ActivityRequirementBinding;
import org.eclipse.ui.internal.activities.ActivityRequirementBindingDefinition;
import org.eclipse.ui.internal.activities.Category;
import org.eclipse.ui.internal.activities.CategoryActivityBinding;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;
import org.eclipse.ui.internal.activities.ExtensionActivityRegistry;
import org.eclipse.ui.internal.activities.IActivityRegistry;
import org.eclipse.ui.internal.activities.IActivityRegistryListener;
import org.eclipse.ui.internal.activities.Identifier;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;

public final class MutableActivityManager
extends AbstractActivityManager
implements IMutableActivityManager,
Cloneable {
    private Map activitiesById = new HashMap();
    private Map activityRequirementBindingsByActivityId = new HashMap();
    private Map activityDefinitionsById = new HashMap();
    private Map activityPatternBindingsByActivityId = new HashMap();
    private IActivityRegistry activityRegistry;
    private Map categoriesById = new HashMap();
    private Map categoryActivityBindingsByCategoryId = new HashMap();
    private Map categoryDefinitionsById = new HashMap();
    private Set definedActivityIds = new HashSet();
    private Set definedCategoryIds = new HashSet();
    private Set enabledActivityIds = new HashSet();
    private Map identifiersById = new HashMap();
    private boolean addingEvaluationListener = false;
    private List deferredIdentifiers = Collections.synchronizedList(new LinkedList());
    private Job deferredIdentifierJob = null;
    private final IActivityRegistryListener activityRegistryListener = new IActivityRegistryListener(){

        @Override
        public void activityRegistryChanged(ActivityRegistryEvent activityRegistryEvent) {
            MutableActivityManager.this.readRegistry(false);
        }
    };
    private Map refsByActivityDefinition = new HashMap();
    private IPropertyChangeListener enabledWhenListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (MutableActivityManager.this.addingEvaluationListener) {
                return;
            }
            Object object = propertyChangeEvent.getNewValue();
            boolean bl = object == null ? false : (Boolean)object;
            String string = propertyChangeEvent.getProperty();
            IActivity iActivity = (IActivity)MutableActivityManager.this.activitiesById.get(string);
            if (iActivity.isEnabled() != bl) {
                if (bl) {
                    MutableActivityManager.this.addExpressionEnabledActivity(string);
                } else {
                    MutableActivityManager.this.removeExpressionEnabledActivity(string);
                }
            }
        }
    };
    private ITriggerPointAdvisor advisor;

    public MutableActivityManager(ITriggerPointAdvisor iTriggerPointAdvisor) {
        this(iTriggerPointAdvisor, new ExtensionActivityRegistry(Platform.getExtensionRegistry()));
    }

    public MutableActivityManager(ITriggerPointAdvisor iTriggerPointAdvisor, IActivityRegistry iActivityRegistry) {
        Assert.isNotNull((Object)iActivityRegistry);
        Assert.isNotNull((Object)iTriggerPointAdvisor);
        this.advisor = iTriggerPointAdvisor;
        this.activityRegistry = iActivityRegistry;
        this.activityRegistry.addActivityRegistryListener(this.activityRegistryListener);
        this.readRegistry(true);
    }

    @Override
    public synchronized IActivity getActivity(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        Activity activity = (Activity)this.activitiesById.get(string);
        if (activity == null) {
            activity = new Activity(string);
            this.updateActivity(activity);
            this.activitiesById.put(string, activity);
        }
        return activity;
    }

    @Override
    public synchronized ICategory getCategory(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        Category category = (Category)this.categoriesById.get(string);
        if (category == null) {
            category = new Category(string);
            this.updateCategory(category);
            this.categoriesById.put(string, category);
        }
        return category;
    }

    @Override
    public synchronized Set getDefinedActivityIds() {
        return Collections.unmodifiableSet(this.definedActivityIds);
    }

    @Override
    public synchronized Set getDefinedCategoryIds() {
        return Collections.unmodifiableSet(this.definedCategoryIds);
    }

    @Override
    public synchronized Set getEnabledActivityIds() {
        return Collections.unmodifiableSet(this.enabledActivityIds);
    }

    @Override
    public synchronized IIdentifier getIdentifier(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        Identifier identifier = (Identifier)this.identifiersById.get(string);
        if (identifier == null) {
            identifier = new Identifier(string);
            this.updateIdentifier(identifier);
            this.identifiersById.put(string, identifier);
        }
        return identifier;
    }

    private void getRequiredActivityIds(Set set, Set set2) {
        for (String string : set) {
            IActivity iActivity = this.getActivity(string);
            HashSet<String> hashSet = new HashSet<String>();
            Set set3 = iActivity.getActivityRequirementBindings();
            for (IActivityRequirementBinding iActivityRequirementBinding : set3) {
                hashSet.add(iActivityRequirementBinding.getRequiredActivityId());
            }
            hashSet.removeAll(set2);
            set2.addAll(hashSet);
            this.getRequiredActivityIds(hashSet, set2);
        }
    }

    private void notifyActivities(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            ActivityEvent activityEvent = (ActivityEvent)entry.getValue();
            Activity activity = (Activity)this.activitiesById.get(string);
            if (activity == null) continue;
            activity.fireActivityChanged(activityEvent);
        }
    }

    private void notifyCategories(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            CategoryEvent categoryEvent = (CategoryEvent)entry.getValue();
            Category category = (Category)this.categoriesById.get(string);
            if (category == null) continue;
            category.fireCategoryChanged(categoryEvent);
        }
    }

    private void notifyIdentifiers(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            IdentifierEvent identifierEvent = (IdentifierEvent)entry.getValue();
            Identifier identifier = (Identifier)this.identifiersById.get(string);
            if (identifier == null) continue;
            identifier.fireIdentifierChanged(identifierEvent);
        }
    }

    private void readRegistry(boolean bl) {
        Set<CategoryActivityBinding> set;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Map.Entry entry2;
        Object object6;
        Object object10;
        Object object11;
        Object object12;
        Object object13;
        if (!this.isRegexpSupported()) {
            return;
        }
        this.clearExpressions();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.activityRegistry.getActivityDefinitions());
        HashMap hashMap = new HashMap(ActivityDefinition.activityDefinitionsById(arrayList, false));
        Object object14 = hashMap.values().iterator();
        while (object14.hasNext()) {
            object13 = (ActivityDefinition)object14.next();
            object12 = ((ActivityDefinition)object13).getName();
            if (object12 != null && ((String)object12).length() != 0) continue;
            object14.remove();
        }
        object14 = new ArrayList();
        object14.addAll(this.activityRegistry.getCategoryDefinitions());
        object13 = new HashMap(CategoryDefinition.categoryDefinitionsById((Collection)object14, false));
        object12 = object13.values().iterator();
        while (object12.hasNext()) {
            object11 = (CategoryDefinition)object12.next();
            object10 = ((CategoryDefinition)object11).getName();
            if (object10 != null && ((String)object10).length() != 0) continue;
            object12.remove();
        }
        object12 = ActivityRequirementBindingDefinition.activityRequirementBindingDefinitionsByActivityId(this.activityRegistry.getActivityRequirementBindingDefinitions());
        object11 = new HashMap();
        for (Map.Entry object92 : object12.entrySet()) {
            Collection collection;
            object6 = (String)object92.getKey();
            if (!hashMap.containsKey(object6) || (collection = (Collection)object92.getValue()) == null) continue;
            for (Map.Entry entry2 : collection) {
                object5 = ((ActivityRequirementBindingDefinition)((Object)entry2)).getRequiredActivityId();
                if (!hashMap.containsKey(object5)) continue;
                object4 = new ActivityRequirementBinding((String)object5, (String)object6);
                object3 = (Set)object11.get(object6);
                if (object3 == null) {
                    object3 = new HashSet<Object>();
                    object11.put(object6, object3);
                }
                object3.add(object4);
            }
        }
        object10 = ActivityPatternBindingDefinition.activityPatternBindingDefinitionsByActivityId(this.activityRegistry.getActivityPatternBindingDefinitions());
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry3 : object10.entrySet()) {
            String string = (String)entry3.getKey();
            if (!hashMap.containsKey(string) || (entry2 = (Collection)entry3.getValue()) == null) continue;
            object5 = entry2.iterator();
            while (object5.hasNext()) {
                object4 = (ActivityPatternBindingDefinition)object5.next();
                object3 = ((ActivityPatternBindingDefinition)object4).getPattern();
                if (object3 == null || ((String)object3).length() == 0) continue;
                object2 = new ActivityPatternBinding(string, (String)object3, ((ActivityPatternBindingDefinition)object4).isEqualityPattern());
                object = (Set)hashMap2.get(string);
                if (object == null) {
                    object = new HashSet<Object>();
                    hashMap2.put(string, (HashSet<Object>)object);
                }
                object.add(object2);
            }
        }
        object6 = CategoryActivityBindingDefinition.categoryActivityBindingDefinitionsByCategoryId(this.activityRegistry.getCategoryActivityBindingDefinitions());
        HashMap<Object, HashSet<CategoryActivityBinding>> hashMap3 = new HashMap<Object, HashSet<CategoryActivityBinding>>();
        for (Map.Entry entry2 : object6.entrySet()) {
            object5 = (String)entry2.getKey();
            if (!object13.containsKey(object5) || (object4 = (Collection)entry2.getValue()) == null) continue;
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (CategoryActivityBindingDefinition)object3.next();
                object = ((CategoryActivityBindingDefinition)object2).getActivityId();
                if (!hashMap.containsKey(object)) continue;
                CategoryActivityBinding categoryActivityBinding = new CategoryActivityBinding((String)object, (String)object5);
                set = (HashSet<CategoryActivityBinding>)hashMap3.get(object5);
                if (set == null) {
                    set = new HashSet<CategoryActivityBinding>();
                    hashMap3.put(object5, (HashSet<CategoryActivityBinding>)set);
                }
                set.add(categoryActivityBinding);
            }
        }
        this.activityRequirementBindingsByActivityId = object11;
        this.activityDefinitionsById = hashMap;
        this.activityPatternBindingsByActivityId = hashMap2;
        this.categoryActivityBindingsByCategoryId = hashMap3;
        this.categoryDefinitionsById = object13;
        boolean bl2 = false;
        entry2 = new HashSet(hashMap.keySet());
        object5 = null;
        if (!entry2.equals(this.definedActivityIds)) {
            object5 = this.definedActivityIds;
            this.definedActivityIds = entry2;
            bl2 = true;
        }
        boolean bl3 = false;
        object3 = new HashSet(object13.keySet());
        object2 = null;
        if (!object3.equals(this.definedCategoryIds)) {
            object2 = this.definedCategoryIds;
            this.definedCategoryIds = object3;
            bl3 = true;
        }
        object = new HashSet(this.enabledActivityIds);
        this.getRequiredActivityIds(this.enabledActivityIds, (Set)object);
        boolean bl4 = false;
        set = null;
        if (!this.enabledActivityIds.equals(object)) {
            set = this.enabledActivityIds;
            this.enabledActivityIds = object;
            bl4 = true;
        }
        Map map = this.updateActivities(this.activitiesById.keySet());
        Map map2 = this.updateCategories(this.categoriesById.keySet());
        Map map3 = this.updateIdentifiers(this.identifiersById.keySet());
        if (bl2 || bl3 || bl4) {
            this.fireActivityManagerChanged(new ActivityManagerEvent(this, bl2, bl3, bl4, (Set)object5, (Set)object2, set));
        }
        if (map != null) {
            this.notifyActivities(map);
        }
        if (map2 != null) {
            this.notifyCategories(map2);
        }
        if (map3 != null) {
            this.notifyIdentifiers(map3);
        }
        if (bl) {
            this.setEnabledActivityIds(new HashSet(this.activityRegistry.getDefaultEnabledActivities()));
        }
    }

    private void clearExpressions() {
        IEvaluationService iEvaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        for (IEvaluationReference iEvaluationReference : this.refsByActivityDefinition.values()) {
            iEvaluationService.removeEvaluationListener(iEvaluationReference);
        }
        this.refsByActivityDefinition.clear();
    }

    private boolean isRegexpSupported() {
        try {
            Class.forName("java.util.regex.Pattern");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public synchronized void setEnabledActivityIds(Set hashSet) {
        hashSet = new HashSet(hashSet);
        HashSet hashSet2 = new HashSet(hashSet);
        this.getRequiredActivityIds(hashSet, hashSet2);
        hashSet = hashSet2;
        HashSet hashSet3 = null;
        boolean bl = false;
        Map map = null;
        Set set = null;
        if (!this.enabledActivityIds.equals(hashSet)) {
            set = this.enabledActivityIds;
            bl = true;
            HashSet hashSet4 = new HashSet(hashSet);
            hashSet4.removeAll(set);
            HashSet hashSet5 = new HashSet(set);
            hashSet5.removeAll(hashSet);
            this.removeExpressionControlledActivities(hashSet4);
            this.removeExpressionControlledActivities(hashSet5);
            hashSet3 = new HashSet(hashSet4);
            hashSet3.addAll(hashSet5);
            if (hashSet3.size() > 0) {
                hashSet.addAll(hashSet4);
                hashSet.removeAll(hashSet5);
                this.enabledActivityIds = hashSet;
                map = this.updateActivities(hashSet3);
            } else {
                return;
            }
        }
        this.updateListeners(bl, map, hashSet3, set);
    }

    private void updateListeners(boolean bl, Map map, Set set, Set set2) {
        Map map2;
        if (bl && (map2 = this.updateIdentifiers(this.identifiersById.keySet(), set)) != null) {
            this.notifyIdentifiers(map2);
        }
        if (map != null) {
            this.notifyActivities(map);
        }
        if (bl) {
            this.fireActivityManagerChanged(new ActivityManagerEvent(this, false, false, true, null, null, set2));
        }
    }

    private void addExpressionEnabledActivity(String string) {
        HashSet hashSet = new HashSet(this.enabledActivityIds);
        this.enabledActivityIds.add(string);
        this.updateExpressionEnabledActivities(string, hashSet);
    }

    private void removeExpressionEnabledActivity(String string) {
        HashSet hashSet = new HashSet(this.enabledActivityIds);
        this.enabledActivityIds.remove(string);
        this.updateExpressionEnabledActivities(string, hashSet);
    }

    private void updateExpressionEnabledActivities(String string, Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        Map map = this.updateActivities(hashSet);
        this.updateListeners(true, map, hashSet, set);
    }

    private void removeExpressionControlledActivities(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IActivity iActivity = (IActivity)this.activitiesById.get(string);
            Expression expression = iActivity.getExpression();
            if (expression == null) continue;
            iterator.remove();
        }
    }

    private Map updateActivities(Collection collection) {
        TreeMap<String, ActivityEvent> treeMap = new TreeMap<String, ActivityEvent>();
        for (String string : collection) {
            ActivityEvent activityEvent;
            Activity activity = (Activity)this.activitiesById.get(string);
            if (activity == null || (activityEvent = this.updateActivity(activity)) == null) continue;
            treeMap.put(string, activityEvent);
        }
        return treeMap;
    }

    private ActivityEvent updateActivity(Activity activity) {
        boolean bl;
        Set set = (Set)this.activityRequirementBindingsByActivityId.get(activity.getId());
        boolean bl2 = activity.setActivityRequirementBindings(set != null ? set : Collections.EMPTY_SET);
        Set set2 = (Set)this.activityPatternBindingsByActivityId.get(activity.getId());
        boolean bl3 = activity.setActivityPatternBindings(set2 != null ? set2 : Collections.EMPTY_SET);
        ActivityDefinition activityDefinition = (ActivityDefinition)this.activityDefinitionsById.get(activity.getId());
        boolean bl4 = activity.setDefined(activityDefinition != null);
        IEvaluationReference iEvaluationReference = (IEvaluationReference)this.refsByActivityDefinition.get(activityDefinition);
        IEvaluationService iEvaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        boolean bl5 = false;
        if (activityDefinition != null && iEvaluationService != null) {
            activity.setExpression(activityDefinition.getEnabledWhen());
            if (iEvaluationReference == null && activityDefinition.getEnabledWhen() != null) {
                this.addingEvaluationListener = true;
                try {
                    iEvaluationReference = iEvaluationService.addEvaluationListener(activityDefinition.getEnabledWhen(), this.enabledWhenListener, activityDefinition.getId());
                    bl5 = true;
                }
                finally {
                    this.addingEvaluationListener = false;
                }
                if (iEvaluationReference != null) {
                    this.refsByActivityDefinition.put(activityDefinition, iEvaluationReference);
                }
            }
        }
        if (iEvaluationReference != null && iEvaluationService != null) {
            bl = activity.setEnabled(iEvaluationReference.evaluate(iEvaluationService.getCurrentState()));
            if (bl5 && activity.isEnabled()) {
                this.enabledActivityIds.add(activity.getId());
            }
        } else {
            bl = activity.setEnabled(this.enabledActivityIds.contains(activity.getId()));
        }
        boolean bl6 = activity.setName(activityDefinition != null ? activityDefinition.getName() : null);
        boolean bl7 = activity.setDescription(activityDefinition != null ? activityDefinition.getDescription() : null);
        boolean bl8 = activity.setDefaultEnabled(this.activityRegistry.getDefaultEnabledActivities().contains(activity.getId()));
        if (bl2 || bl3 || bl4 || bl || bl6 || bl7 || bl8) {
            return new ActivityEvent(activity, bl2, bl3, bl4, bl7, bl, bl6, bl8);
        }
        return null;
    }

    private Map updateCategories(Collection collection) {
        TreeMap<String, CategoryEvent> treeMap = new TreeMap<String, CategoryEvent>();
        for (String string : collection) {
            CategoryEvent categoryEvent;
            Category category = (Category)this.categoriesById.get(string);
            if (category == null || (categoryEvent = this.updateCategory(category)) == null) continue;
            treeMap.put(string, categoryEvent);
        }
        return treeMap;
    }

    private CategoryEvent updateCategory(Category category) {
        Set set = (Set)this.categoryActivityBindingsByCategoryId.get(category.getId());
        boolean bl = category.setCategoryActivityBindings(set != null ? set : Collections.EMPTY_SET);
        CategoryDefinition categoryDefinition = (CategoryDefinition)this.categoryDefinitionsById.get(category.getId());
        boolean bl2 = category.setDefined(categoryDefinition != null);
        boolean bl3 = category.setName(categoryDefinition != null ? categoryDefinition.getName() : null);
        boolean bl4 = category.setDescription(categoryDefinition != null ? categoryDefinition.getDescription() : null);
        if (bl || bl2 || bl3 || bl4) {
            return new CategoryEvent(category, bl, bl2, bl4, bl3);
        }
        return null;
    }

    private IdentifierEvent updateIdentifier(Identifier identifier) {
        return this.updateIdentifier(identifier, this.definedActivityIds);
    }

    private IdentifierEvent updateIdentifier(Identifier identifier, Set set) {
        String string = identifier.getId();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.enabledActivityIds.size() == this.definedActivityIds.size()) {
            bl = true;
            bl3 = identifier.setEnabled(bl);
            identifier.setActivityIds(Collections.EMPTY_SET);
            this.deferredIdentifiers.add(identifier);
            this.getUpdateJob().schedule();
            if (bl3) {
                return new IdentifierEvent(identifier, bl2, bl3);
            }
        } else {
            HashSet hashSet2 = new HashSet(set);
            if (identifier.getActivityIds() != null) {
                hashSet2.addAll(identifier.getActivityIds());
            }
            for (String string2 : hashSet2) {
                Activity activity = (Activity)this.getActivity(string2);
                if (!activity.isMatch(string)) continue;
                hashSet.add(string2);
            }
            bl2 = identifier.setActivityIds(hashSet);
            if (this.advisor != null) {
                bl = this.advisor.computeEnablement(this, identifier);
            }
            bl3 = identifier.setEnabled(bl);
            if (bl2 || bl3) {
                return new IdentifierEvent(identifier, bl2, bl3);
            }
        }
        return null;
    }

    private Map updateIdentifiers(Collection collection) {
        return this.updateIdentifiers(collection, this.definedActivityIds);
    }

    private Map updateIdentifiers(Collection collection, Set set) {
        TreeMap<String, IdentifierEvent> treeMap = new TreeMap<String, IdentifierEvent>();
        for (String string : collection) {
            IdentifierEvent identifierEvent;
            Identifier identifier = (Identifier)this.identifiersById.get(string);
            if (identifier == null || (identifierEvent = this.updateIdentifier(identifier, set)) == null) continue;
            treeMap.put(string, identifierEvent);
        }
        return treeMap;
    }

    public void unhookRegistryListeners() {
        this.activityRegistry.removeActivityRegistryListener(this.activityRegistryListener);
    }

    public synchronized Object clone() {
        MutableActivityManager mutableActivityManager = new MutableActivityManager(this.advisor, this.activityRegistry);
        mutableActivityManager.setEnabledActivityIds(this.getEnabledActivityIds());
        return mutableActivityManager;
    }

    private Job getUpdateJob() {
        if (this.deferredIdentifierJob == null) {
            this.deferredIdentifierJob = new Job("Identifier Update Job"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    while (!MutableActivityManager.this.deferredIdentifiers.isEmpty()) {
                        Object object;
                        Object object22;
                        Identifier identifier = (Identifier)MutableActivityManager.this.deferredIdentifiers.remove(0);
                        HashSet<Object> hashSet = new HashSet<Object>();
                        for (Object object22 : MutableActivityManager.this.definedActivityIds) {
                            object = (Activity)MutableActivityManager.this.getActivity((String)object22);
                            if (!((Activity)object).isMatch(identifier.getId())) continue;
                            hashSet.add(object22);
                        }
                        boolean bl = identifier.setActivityIds(hashSet);
                        if (!bl) continue;
                        object22 = new IdentifierEvent(identifier, bl, false);
                        object = new HashMap(1);
                        object.put(identifier.getId(), object22);
                        UIJob uIJob = new UIJob("Identifier Update Job", (Map)object){
                            private final /* synthetic */ Map val$identifierEventsByIdentifierId;
                            {
                                this.val$identifierEventsByIdentifierId = map;
                                super(string);
                            }

                            @Override
                            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                                MutableActivityManager.this.notifyIdentifiers(this.val$identifierEventsByIdentifierId);
                                return Status.OK_STATUS;
                            }
                        };
                        uIJob.setSystem(true);
                        uIJob.schedule();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.deferredIdentifierJob.setSystem(true);
        }
        return this.deferredIdentifierJob;
    }
}

