/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.ICategoryActivityBinding;

public final class InternalActivityHelper {
    public static Set getActivityIdsForCategory(IActivityManager iActivityManager, ICategory iCategory) {
        Set set = iCategory.getCategoryActivityBindings();
        HashSet<String> hashSet = new HashSet<String>();
        for (ICategoryActivityBinding iCategoryActivityBinding : set) {
            String string = iCategoryActivityBinding.getActivityId();
            if (iActivityManager.getActivity(string).getExpression() != null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static boolean isEnabled(IActivityManager iActivityManager, String string) {
        ICategory iCategory = iActivityManager.getCategory(string);
        if (iCategory.isDefined()) {
            Set set = InternalActivityHelper.getActivityIdsForCategory(iActivityManager, iCategory);
            if (iActivityManager.getEnabledActivityIds().containsAll(set)) {
                return true;
            }
        }
        return false;
    }

    public static Set getEnabledCategories(IActivityManager iActivityManager) {
        Set set = iActivityManager.getDefinedCategoryIds();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!InternalActivityHelper.isEnabled(iActivityManager, string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public static Set getPartiallyEnabledCategories(IActivityManager iActivityManager) {
        Set set = iActivityManager.getDefinedCategoryIds();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!InternalActivityHelper.isPartiallyEnabled(iActivityManager, string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static boolean isPartiallyEnabled(IActivityManager iActivityManager, String string) {
        Set set = InternalActivityHelper.getActivityIdsForCategory(iActivityManager, iActivityManager.getCategory(string));
        int n = 0;
        for (String string2 : set) {
            if (!iActivityManager.getEnabledActivityIds().contains(string2)) continue;
            ++n;
        }
        return n > 0 && n != set.size();
    }
}

