/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.internal.util.Util;

final class Identifier
implements IIdentifier {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = Identifier.class.getName().hashCode();
    private static final Set strongReferences = new HashSet();
    private Set activityIds = Collections.EMPTY_SET;
    private transient String[] activityIdsAsArray = new String[0];
    private boolean enabled;
    private transient int hashCode = HASH_INITIAL;
    private String id;
    private ListenerList identifierListeners;
    private transient String string;

    Identifier(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.id = string;
    }

    @Override
    public void addIdentifierListener(IIdentifierListener iIdentifierListener) {
        if (iIdentifierListener == null) {
            throw new NullPointerException();
        }
        if (this.identifierListeners == null) {
            this.identifierListeners = new ListenerList();
        }
        this.identifierListeners.add((Object)iIdentifierListener);
        strongReferences.add(this);
    }

    public int compareTo(Object object) {
        Identifier identifier = (Identifier)object;
        int n = Util.compare((Comparable[])this.activityIdsAsArray, (Comparable[])identifier.activityIdsAsArray);
        if (n == 0 && (n = Util.compare(this.enabled, identifier.enabled)) == 0) {
            n = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)identifier.id));
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Identifier)) {
            return false;
        }
        Identifier identifier = (Identifier)object;
        if (!Util.equals(this.activityIds, identifier.activityIds)) {
            return false;
        }
        if (!Util.equals(this.enabled, identifier.enabled)) {
            return false;
        }
        return Util.equals(this.id, identifier.id);
    }

    void fireIdentifierChanged(IdentifierEvent identifierEvent) {
        if (identifierEvent == null) {
            throw new NullPointerException();
        }
        if (this.identifierListeners != null) {
            Object[] objectArray = this.identifierListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                ((IIdentifierListener)object).identifierChanged(identifierEvent);
                ++n;
            }
        }
    }

    @Override
    public Set getActivityIds() {
        return this.activityIds;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.activityIds);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.enabled);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void removeIdentifierListener(IIdentifierListener iIdentifierListener) {
        if (iIdentifierListener == null) {
            throw new NullPointerException();
        }
        if (this.identifierListeners != null) {
            this.identifierListeners.remove((Object)iIdentifierListener);
            if (this.identifierListeners.isEmpty()) {
                strongReferences.remove(this);
            }
        }
    }

    boolean setActivityIds(Set set) {
        if (!Util.equals(set = Util.safeCopy(set, String.class), this.activityIds)) {
            this.activityIds = set;
            this.activityIdsAsArray = this.activityIds.toArray(new String[this.activityIds.size()]);
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.activityIds);
            stringBuffer.append(',');
            stringBuffer.append(this.enabled);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

