/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.activities.AbstractActivityRegistry;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityRequirementBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;
import org.eclipse.ui.internal.activities.Persistence;
import org.eclipse.ui.internal.util.ConfigurationElementMemento;
import org.eclipse.ui.statushandlers.StatusManager;

final class ExtensionActivityRegistry
extends AbstractActivityRegistry {
    private static final String PREFIX = "UIActivities.";
    private List activityRequirementBindingDefinitions;
    private List activityDefinitions;
    private List activityPatternBindingDefinitions;
    private List categoryActivityBindingDefinitions;
    private List categoryDefinitions;
    private List defaultEnabledActivities;
    private IExtensionRegistry extensionRegistry;

    ExtensionActivityRegistry(IExtensionRegistry iExtensionRegistry) {
        if (iExtensionRegistry == null) {
            throw new NullPointerException();
        }
        this.extensionRegistry = iExtensionRegistry;
        this.extensionRegistry.addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
                IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "activities");
                if (iExtensionDeltaArray.length != 0) {
                    try {
                        ExtensionActivityRegistry.this.load();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        try {
            this.load();
        }
        catch (IOException iOException) {}
    }

    private String getNamespace(IConfigurationElement iConfigurationElement) {
        IExtension iExtension;
        String string = null;
        if (iConfigurationElement != null && (iExtension = iConfigurationElement.getDeclaringExtension()) != null) {
            string = iExtension.getNamespace();
        }
        return string;
    }

    private ActivityDefinition getActivityDefinitionById(String string) {
        int n = this.activityDefinitions.size();
        int n2 = 0;
        while (n2 < n) {
            ActivityDefinition activityDefinition = (ActivityDefinition)this.activityDefinitions.get(n2);
            if (activityDefinition.getId().equals(string)) {
                return activityDefinition;
            }
            ++n2;
        }
        return null;
    }

    private void load() throws IOException {
        Object object;
        Object object22;
        if (this.activityRequirementBindingDefinitions == null) {
            this.activityRequirementBindingDefinitions = new ArrayList();
        } else {
            this.activityRequirementBindingDefinitions.clear();
        }
        if (this.activityDefinitions == null) {
            this.activityDefinitions = new ArrayList();
        } else {
            this.activityDefinitions.clear();
        }
        if (this.activityPatternBindingDefinitions == null) {
            this.activityPatternBindingDefinitions = new ArrayList();
        } else {
            this.activityPatternBindingDefinitions.clear();
        }
        if (this.categoryActivityBindingDefinitions == null) {
            this.categoryActivityBindingDefinitions = new ArrayList();
        } else {
            this.categoryActivityBindingDefinitions.clear();
        }
        if (this.categoryDefinitions == null) {
            this.categoryDefinitions = new ArrayList();
        } else {
            this.categoryDefinitions.clear();
        }
        if (this.defaultEnabledActivities == null) {
            this.defaultEnabledActivities = new ArrayList();
        } else {
            this.defaultEnabledActivities.clear();
        }
        IConfigurationElement[] iConfigurationElementArray = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.activities");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            object22 = iConfigurationElement.getName();
            if ("activityRequirementBinding".equals(object22)) {
                this.readActivityRequirementBindingDefinition(iConfigurationElement);
            } else if ("activity".equals(object22)) {
                this.readActivityDefinition(iConfigurationElement);
            } else if ("activityPatternBinding".equals(object22)) {
                this.readActivityPatternBindingDefinition(iConfigurationElement);
            } else if ("categoryActivityBinding".equals(object22)) {
                this.readCategoryActivityBindingDefinition(iConfigurationElement);
            } else if ("category".equals(object22)) {
                this.readCategoryDefinition(iConfigurationElement);
            } else if ("defaultEnablement".equals(object22)) {
                this.readDefaultEnablement(iConfigurationElement);
            }
            ++n;
        }
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        for (Object object22 : this.activityDefinitions) {
            object = ((ActivityDefinition)object22).getId();
            String string = this.createPreferenceKey((String)object);
            if ("".equals(iPreferenceStore.getDefaultString(string))) continue;
            if (iPreferenceStore.getDefaultBoolean(string)) {
                if (this.defaultEnabledActivities.contains(object) || ((ActivityDefinition)object22).getEnabledWhen() != null) continue;
                this.defaultEnabledActivities.add(object);
                continue;
            }
            this.defaultEnabledActivities.remove(object);
        }
        int n2 = 0;
        while (n2 < this.defaultEnabledActivities.size()) {
            object22 = (String)this.defaultEnabledActivities.get(n2);
            object = this.getActivityDefinitionById((String)object22);
            if (object != null && ((ActivityDefinition)object).getEnabledWhen() != null) {
                this.defaultEnabledActivities.remove(n2);
                StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.ui", "Default enabled activity declarations will be ignored (id: " + (String)object22 + ")"));
                continue;
            }
            ++n2;
        }
        Iterator iterator = this.activityRequirementBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            object22 = (ActivityRequirementBindingDefinition)iterator.next();
            object = this.getActivityDefinitionById(((ActivityRequirementBindingDefinition)object22).getRequiredActivityId());
            if (object != null && ((ActivityDefinition)object).getEnabledWhen() != null) {
                iterator.remove();
                StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.ui", "Expression activity cannot have requirements (id: " + ((ActivityDefinition)object).getId() + ")"));
                continue;
            }
            object = this.getActivityDefinitionById(((ActivityRequirementBindingDefinition)object22).getActivityId());
            if (object == null || ((ActivityDefinition)object).getEnabledWhen() == null) continue;
            iterator.remove();
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.ui", "Expression activity cannot be required (id: " + ((ActivityDefinition)object).getId() + ")"));
        }
        boolean bl = false;
        if (!this.activityRequirementBindingDefinitions.equals(((AbstractActivityRegistry)this).activityRequirementBindingDefinitions)) {
            ((AbstractActivityRegistry)this).activityRequirementBindingDefinitions = Collections.unmodifiableList(new ArrayList(this.activityRequirementBindingDefinitions));
            bl = true;
        }
        if (!this.activityDefinitions.equals(((AbstractActivityRegistry)this).activityDefinitions)) {
            ((AbstractActivityRegistry)this).activityDefinitions = Collections.unmodifiableList(new ArrayList(this.activityDefinitions));
            bl = true;
        }
        if (!this.activityPatternBindingDefinitions.equals(((AbstractActivityRegistry)this).activityPatternBindingDefinitions)) {
            ((AbstractActivityRegistry)this).activityPatternBindingDefinitions = Collections.unmodifiableList(new ArrayList(this.activityPatternBindingDefinitions));
            bl = true;
        }
        if (!this.categoryActivityBindingDefinitions.equals(((AbstractActivityRegistry)this).categoryActivityBindingDefinitions)) {
            ((AbstractActivityRegistry)this).categoryActivityBindingDefinitions = Collections.unmodifiableList(new ArrayList(this.categoryActivityBindingDefinitions));
            bl = true;
        }
        if (!this.categoryDefinitions.equals(((AbstractActivityRegistry)this).categoryDefinitions)) {
            ((AbstractActivityRegistry)this).categoryDefinitions = Collections.unmodifiableList(new ArrayList(this.categoryDefinitions));
            bl = true;
        }
        if (!this.defaultEnabledActivities.equals(((AbstractActivityRegistry)this).defaultEnabledActivities)) {
            ((AbstractActivityRegistry)this).defaultEnabledActivities = Collections.unmodifiableList(new ArrayList(this.defaultEnabledActivities));
            bl = true;
        }
        if (bl) {
            this.fireActivityRegistryChanged();
        }
    }

    private String createPreferenceKey(String string) {
        return PREFIX + string;
    }

    private void readDefaultEnablement(IConfigurationElement iConfigurationElement) {
        String string = Persistence.readDefaultEnablement(new ConfigurationElementMemento(iConfigurationElement));
        if (string != null) {
            this.defaultEnabledActivities.add(string);
        }
    }

    private void readActivityRequirementBindingDefinition(IConfigurationElement iConfigurationElement) {
        ActivityRequirementBindingDefinition activityRequirementBindingDefinition = Persistence.readActivityRequirementBindingDefinition(new ConfigurationElementMemento(iConfigurationElement), this.getNamespace(iConfigurationElement));
        if (activityRequirementBindingDefinition != null) {
            this.activityRequirementBindingDefinitions.add(activityRequirementBindingDefinition);
        }
    }

    private void readActivityDefinition(IConfigurationElement iConfigurationElement) {
        ActivityDefinition activityDefinition = Persistence.readActivityDefinition(new ConfigurationElementMemento(iConfigurationElement), this.getNamespace(iConfigurationElement));
        if (activityDefinition != null) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren("enabledWhen");
            if (iConfigurationElementArray2.length == 1 && (iConfigurationElementArray = iConfigurationElementArray2[0].getChildren()).length == 1) {
                try {
                    Expression expression = ExpressionConverter.getDefault().perform(iConfigurationElementArray[0]);
                    activityDefinition.setEnabledWhen(expression);
                }
                catch (CoreException coreException) {
                    StatusManager.getManager().handle(coreException, WorkbenchPlugin.PI_WORKBENCH);
                }
            }
            this.activityDefinitions.add(activityDefinition);
        }
    }

    private void readActivityPatternBindingDefinition(IConfigurationElement iConfigurationElement) {
        ActivityPatternBindingDefinition activityPatternBindingDefinition = Persistence.readActivityPatternBindingDefinition(new ConfigurationElementMemento(iConfigurationElement), this.getNamespace(iConfigurationElement));
        if (activityPatternBindingDefinition != null) {
            this.activityPatternBindingDefinitions.add(activityPatternBindingDefinition);
        }
    }

    private void readCategoryActivityBindingDefinition(IConfigurationElement iConfigurationElement) {
        CategoryActivityBindingDefinition categoryActivityBindingDefinition = Persistence.readCategoryActivityBindingDefinition(new ConfigurationElementMemento(iConfigurationElement), this.getNamespace(iConfigurationElement));
        if (categoryActivityBindingDefinition != null) {
            this.categoryActivityBindingDefinitions.add(categoryActivityBindingDefinition);
        }
    }

    private void readCategoryDefinition(IConfigurationElement iConfigurationElement) {
        CategoryDefinition categoryDefinition = Persistence.readCategoryDefinition(new ConfigurationElementMemento(iConfigurationElement), this.getNamespace(iConfigurationElement));
        if (categoryDefinition != null) {
            this.categoryDefinitions.add(categoryDefinition);
        }
    }
}

