/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.ui.internal.util.Util;

public final class CategoryDefinition
implements Comparable {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = CategoryDefinition.class.getName().hashCode();
    private transient int hashCode = HASH_INITIAL;
    private String id;
    private String name;
    private String sourceId;
    private transient String string;
    private String description;

    static Map categoryDefinitionsById(Collection collection, boolean bl) {
        if (collection == null) {
            throw new NullPointerException();
        }
        HashMap<String, CategoryDefinition> hashMap = new HashMap<String, CategoryDefinition>();
        for (Object e : collection) {
            Util.assertInstance(e, CategoryDefinition.class);
            CategoryDefinition categoryDefinition = (CategoryDefinition)e;
            String string = categoryDefinition.getId();
            if (!bl && string == null) continue;
            hashMap.put(string, categoryDefinition);
        }
        return hashMap;
    }

    static Map categoryDefinitionsByName(Collection collection, boolean bl) {
        if (collection == null) {
            throw new NullPointerException();
        }
        HashMap<String, HashSet<CategoryDefinition>> hashMap = new HashMap<String, HashSet<CategoryDefinition>>();
        for (Object e : collection) {
            Util.assertInstance(e, CategoryDefinition.class);
            CategoryDefinition categoryDefinition = (CategoryDefinition)e;
            String string = categoryDefinition.getName();
            if (!bl && string == null) continue;
            HashSet<CategoryDefinition> hashSet = (HashSet<CategoryDefinition>)hashMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<CategoryDefinition>();
                hashMap.put(string, hashSet);
            }
            hashSet.add(categoryDefinition);
        }
        return hashMap;
    }

    public CategoryDefinition(String string, String string2, String string3, String string4) {
        this.id = string;
        this.name = string2;
        this.sourceId = string3;
        this.description = string4;
    }

    public int compareTo(Object object) {
        CategoryDefinition categoryDefinition = (CategoryDefinition)object;
        int n = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)categoryDefinition.id));
        if (n == 0 && (n = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)categoryDefinition.name))) == 0) {
            n = Util.compare((Comparable)((Object)this.sourceId), (Comparable)((Object)categoryDefinition.sourceId));
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CategoryDefinition)) {
            return false;
        }
        CategoryDefinition categoryDefinition = (CategoryDefinition)object;
        if (!Util.equals(this.id, categoryDefinition.id)) {
            return false;
        }
        if (!Util.equals(this.name, categoryDefinition.name)) {
            return false;
        }
        return Util.equals(this.sourceId, categoryDefinition.sourceId);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.name);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.sourceId);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.sourceId);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public String getDescription() {
        return this.description;
    }
}

