/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.activities.CategoryEvent;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.ICategoryActivityBinding;
import org.eclipse.ui.activities.ICategoryListener;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.internal.util.Util;

final class Category
implements ICategory {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = Category.class.getName().hashCode();
    private static final Set strongReferences = new HashSet();
    private Set categoryActivityBindings;
    private transient ICategoryActivityBinding[] categoryActivityBindingsAsArray;
    private List categoryListeners;
    private boolean defined;
    private transient int hashCode = HASH_INITIAL;
    private String id;
    private String name;
    private transient String string;
    private String description;

    Category(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.id = string;
    }

    @Override
    public void addCategoryListener(ICategoryListener iCategoryListener) {
        if (iCategoryListener == null) {
            throw new NullPointerException();
        }
        if (this.categoryListeners == null) {
            this.categoryListeners = new ArrayList();
        }
        if (!this.categoryListeners.contains(iCategoryListener)) {
            this.categoryListeners.add(iCategoryListener);
        }
        strongReferences.add(this);
    }

    public int compareTo(Object object) {
        Category category = (Category)object;
        int n = Util.compare(this.categoryActivityBindingsAsArray, category.categoryActivityBindingsAsArray);
        if (n == 0 && (n = Util.compare(this.defined, category.defined)) == 0 && (n = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)category.id))) == 0) {
            n = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)category.name));
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Category)) {
            return false;
        }
        Category category = (Category)object;
        if (!Util.equals(this.categoryActivityBindings, category.categoryActivityBindings)) {
            return false;
        }
        if (!Util.equals(this.defined, category.defined)) {
            return false;
        }
        if (!Util.equals(this.id, category.id)) {
            return false;
        }
        return Util.equals(this.name, category.name);
    }

    void fireCategoryChanged(CategoryEvent categoryEvent) {
        if (categoryEvent == null) {
            throw new NullPointerException();
        }
        if (this.categoryListeners != null) {
            int n = 0;
            while (n < this.categoryListeners.size()) {
                ((ICategoryListener)this.categoryListeners.get(n)).categoryChanged(categoryEvent);
                ++n;
            }
        }
    }

    @Override
    public Set getCategoryActivityBindings() {
        return this.categoryActivityBindings;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.name;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.categoryActivityBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.defined);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.name);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    @Override
    public boolean isDefined() {
        return this.defined;
    }

    @Override
    public void removeCategoryListener(ICategoryListener iCategoryListener) {
        if (iCategoryListener == null) {
            throw new NullPointerException();
        }
        if (this.categoryListeners != null) {
            this.categoryListeners.remove(iCategoryListener);
        }
        if (this.categoryListeners.isEmpty()) {
            strongReferences.remove(this);
        }
    }

    boolean setCategoryActivityBindings(Set set) {
        if (!Util.equals(set = Util.safeCopy(set, ICategoryActivityBinding.class), this.categoryActivityBindings)) {
            this.categoryActivityBindings = set;
            this.categoryActivityBindingsAsArray = this.categoryActivityBindings.toArray(new ICategoryActivityBinding[this.categoryActivityBindings.size()]);
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDefined(boolean bl) {
        if (bl != this.defined) {
            this.defined = bl;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setName(String string) {
        if (!Util.equals(string, this.name)) {
            this.name = string;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.categoryActivityBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    @Override
    public String getDescription() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.description;
    }

    public boolean setDescription(String string) {
        if (!Util.equals(string, this.description)) {
            this.description = string;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }
}

