/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class ActivityPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_ACTIVITY_ENABLED = "isActivityEnabled";
    private static final String PROPERTY_IS_CATEGORY_ENABLED = "isCategoryEnabled";

    public boolean test(Object object, String string, Object[] objectArray, Object object2) {
        if (objectArray.length == 1 && object instanceof IWorkbench && objectArray[0] instanceof String) {
            if (PROPERTY_IS_ACTIVITY_ENABLED.equals(string)) {
                return ActivityPropertyTester.isActivityEnabled((String)objectArray[0], (IWorkbench)object);
            }
            if (PROPERTY_IS_CATEGORY_ENABLED.equals(string)) {
                return ActivityPropertyTester.isCategoryEnabled((String)objectArray[0], (IWorkbench)object);
            }
        }
        return false;
    }

    private static boolean isActivityEnabled(String string, IWorkbench iWorkbench) {
        try {
            IWorkbenchActivitySupport iWorkbenchActivitySupport = iWorkbench.getActivitySupport();
            IActivityManager iActivityManager = iWorkbenchActivitySupport.getActivityManager();
            return iActivityManager.getActivity(string).isEnabled();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isCategoryEnabled(String string, IWorkbench iWorkbench) {
        try {
            IWorkbenchActivitySupport iWorkbenchActivitySupport = iWorkbench.getActivitySupport();
            IActivityManager iActivityManager = iWorkbenchActivitySupport.getActivityManager();
            return WorkbenchActivityHelper.isEnabled(iActivityManager, string);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

