/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.internal.util.Util;

public final class ActivityPatternBindingDefinition {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = ActivityPatternBindingDefinition.class.getName().hashCode();
    private String activityId;
    private transient int hashCode = HASH_INITIAL;
    private String pattern;
    private String sourceId;
    private transient String string;
    private boolean isEqualityPattern;

    static Map activityPatternBindingDefinitionsByActivityId(Collection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        HashMap<String, ArrayList<ActivityPatternBindingDefinition>> hashMap = new HashMap<String, ArrayList<ActivityPatternBindingDefinition>>();
        for (Object e : collection) {
            Util.assertInstance(e, ActivityPatternBindingDefinition.class);
            ActivityPatternBindingDefinition activityPatternBindingDefinition = (ActivityPatternBindingDefinition)e;
            String string = activityPatternBindingDefinition.getActivityId();
            if (string == null) continue;
            ArrayList<ActivityPatternBindingDefinition> arrayList = (ArrayList<ActivityPatternBindingDefinition>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ActivityPatternBindingDefinition>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(activityPatternBindingDefinition);
        }
        return hashMap;
    }

    public ActivityPatternBindingDefinition(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public ActivityPatternBindingDefinition(String string, String string2, String string3, boolean bl) {
        this.activityId = string;
        this.pattern = string2;
        this.sourceId = string3;
        this.isEqualityPattern = bl;
    }

    public int compareTo(Object object) {
        ActivityPatternBindingDefinition activityPatternBindingDefinition = (ActivityPatternBindingDefinition)object;
        int n = Util.compare((Comparable)((Object)this.activityId), (Comparable)((Object)activityPatternBindingDefinition.activityId));
        if (n == 0 && (n = Util.compare((Comparable)((Object)this.pattern), (Comparable)((Object)activityPatternBindingDefinition.pattern))) == 0 && (n = Util.compare(this.isEqualityPattern, activityPatternBindingDefinition.isEqualityPattern)) == 0) {
            n = Util.compare((Comparable)((Object)this.sourceId), (Comparable)((Object)activityPatternBindingDefinition.sourceId));
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ActivityPatternBindingDefinition)) {
            return false;
        }
        ActivityPatternBindingDefinition activityPatternBindingDefinition = (ActivityPatternBindingDefinition)object;
        if (!Util.equals(this.activityId, activityPatternBindingDefinition.activityId)) {
            return false;
        }
        if (!Util.equals(this.pattern, activityPatternBindingDefinition.pattern)) {
            return false;
        }
        if (!Util.equals(this.isEqualityPattern, activityPatternBindingDefinition.isEqualityPattern)) {
            return false;
        }
        return Util.equals(this.sourceId, activityPatternBindingDefinition.sourceId);
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public boolean isEqualityPattern() {
        return this.isEqualityPattern;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.activityId);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.pattern);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.sourceId);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.activityId);
            stringBuffer.append(',');
            stringBuffer.append(this.isEqualityPattern);
            stringBuffer.append(',');
            stringBuffer.append(this.pattern);
            stringBuffer.append(',');
            stringBuffer.append(this.sourceId);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

