/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.regex.Pattern;
import org.eclipse.ui.activities.IActivityPatternBinding;
import org.eclipse.ui.internal.activities.PatternUtil;
import org.eclipse.ui.internal.util.Util;

public final class ActivityPatternBinding
implements IActivityPatternBinding {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = ActivityPatternBinding.class.getName().hashCode();
    private String activityId;
    private transient int hashCode = HASH_INITIAL;
    private Pattern pattern;
    private String patternString;
    private boolean isEqualityPattern;
    private transient String string;

    public ActivityPatternBinding(String string, String string2) {
        this(string, Pattern.compile(string2));
    }

    public ActivityPatternBinding(String string, String string2, boolean bl) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.activityId = string;
        this.isEqualityPattern = bl;
        if (bl) {
            this.patternString = string2;
            this.pattern = null;
        } else {
            this.patternString = null;
            this.pattern = Pattern.compile(string2);
        }
    }

    public ActivityPatternBinding(String string, Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.activityId = string;
        this.pattern = pattern;
        this.isEqualityPattern = false;
        this.patternString = null;
    }

    public int compareTo(Object object) {
        ActivityPatternBinding activityPatternBinding = (ActivityPatternBinding)object;
        int n = Util.compare((Comparable)((Object)this.activityId), (Comparable)((Object)activityPatternBinding.activityId));
        if (n == 0 && (n = Util.compare(this.isEqualityPattern, activityPatternBinding.isEqualityPattern)) == 0) {
            n = Util.compare((Comparable)((Object)this.getPattern().pattern()), (Comparable)((Object)activityPatternBinding.getPattern().pattern()));
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ActivityPatternBinding)) {
            return false;
        }
        ActivityPatternBinding activityPatternBinding = (ActivityPatternBinding)object;
        if (!Util.equals(this.activityId, activityPatternBinding.activityId)) {
            return false;
        }
        if (!Util.equals(this.isEqualityPattern, activityPatternBinding.isEqualityPattern)) {
            return false;
        }
        return Util.equals(this.getPattern(), activityPatternBinding.getPattern());
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(PatternUtil.quotePattern(this.patternString));
        }
        return this.pattern;
    }

    @Override
    public String getString() {
        if (this.isEqualityPattern) {
            return this.patternString;
        }
        return this.getPattern().pattern();
    }

    @Override
    public boolean isEqualityPattern() {
        return this.isEqualityPattern;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.activityId);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.pattern);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.activityId);
            stringBuffer.append(',');
            stringBuffer.append(this.isEqualityPattern());
            stringBuffer.append(',');
            stringBuffer.append(this.getString());
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public boolean isMatch(String string) {
        if (this.isEqualityPattern) {
            return this.patternString.equals(string);
        }
        return this.pattern.matcher(string).matches();
    }
}

