/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.ui.internal.util.Util;

public final class ActivityDefinition
implements Comparable {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = ActivityDefinition.class.getName().hashCode();
    private transient int hashCode = HASH_INITIAL;
    private String id;
    private String name;
    private String sourceId;
    private String description;
    private transient String string;
    private Expression enabledWhen;

    static Map activityDefinitionsById(Collection collection, boolean bl) {
        if (collection == null) {
            throw new NullPointerException();
        }
        HashMap<String, ActivityDefinition> hashMap = new HashMap<String, ActivityDefinition>();
        for (Object e : collection) {
            Util.assertInstance(e, ActivityDefinition.class);
            ActivityDefinition activityDefinition = (ActivityDefinition)e;
            String string = activityDefinition.getId();
            if (!bl && string == null) continue;
            hashMap.put(string, activityDefinition);
        }
        return hashMap;
    }

    static Map activityDefinitionsByName(Collection collection, boolean bl) {
        if (collection == null) {
            throw new NullPointerException();
        }
        HashMap<String, HashSet<ActivityDefinition>> hashMap = new HashMap<String, HashSet<ActivityDefinition>>();
        for (Object e : collection) {
            Util.assertInstance(e, ActivityDefinition.class);
            ActivityDefinition activityDefinition = (ActivityDefinition)e;
            String string = activityDefinition.getName();
            if (!bl && string == null) continue;
            HashSet<ActivityDefinition> hashSet = (HashSet<ActivityDefinition>)hashMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<ActivityDefinition>();
                hashMap.put(string, hashSet);
            }
            hashSet.add(activityDefinition);
        }
        return hashMap;
    }

    public ActivityDefinition(String string, String string2, String string3, String string4) {
        this.id = string;
        this.name = string2;
        this.sourceId = string3;
        this.description = string4;
    }

    public int compareTo(Object object) {
        ActivityDefinition activityDefinition = (ActivityDefinition)object;
        int n = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)activityDefinition.id));
        if (n == 0 && (n = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)activityDefinition.name))) == 0) {
            n = Util.compare((Comparable)((Object)this.sourceId), (Comparable)((Object)activityDefinition.sourceId));
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ActivityDefinition)) {
            return false;
        }
        ActivityDefinition activityDefinition = (ActivityDefinition)object;
        if (!Util.equals(this.id, activityDefinition.id)) {
            return false;
        }
        if (!Util.equals(this.name, activityDefinition.name)) {
            return false;
        }
        return Util.equals(this.sourceId, activityDefinition.sourceId);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.name);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.sourceId);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.sourceId);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public String getDescription() {
        return this.description;
    }

    void setEnabledWhen(Expression expression) {
        this.enabledWhen = expression;
    }

    public Expression getEnabledWhen() {
        return this.enabledWhen;
    }
}

