/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.ui.activities.ActivityEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityListener;
import org.eclipse.ui.activities.IActivityPatternBinding;
import org.eclipse.ui.activities.IActivityRequirementBinding;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.internal.activities.ActivityPatternBinding;
import org.eclipse.ui.internal.util.Util;

final class Activity
implements IActivity {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = Activity.class.getName().hashCode();
    private static final Set strongReferences = new HashSet();
    private Set activityRequirementBindings;
    private transient IActivityRequirementBinding[] activityRequirementBindingsAsArray;
    private List activityListeners;
    private Set activityPatternBindings;
    private transient IActivityPatternBinding[] activityPatternBindingsAsArray;
    private boolean defined;
    private boolean enabled;
    private transient int hashCode = HASH_INITIAL;
    private String id;
    private String name;
    private transient String string;
    private String description;
    private boolean defaultEnabled;
    private Expression expression;

    Activity(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.id = string;
    }

    @Override
    public void addActivityListener(IActivityListener iActivityListener) {
        if (iActivityListener == null) {
            throw new NullPointerException();
        }
        if (this.activityListeners == null) {
            this.activityListeners = new ArrayList();
        }
        if (!this.activityListeners.contains(iActivityListener)) {
            this.activityListeners.add(iActivityListener);
        }
        strongReferences.add(this);
    }

    public int compareTo(Object object) {
        Activity activity = (Activity)object;
        int n = Util.compare(this.activityRequirementBindingsAsArray, activity.activityRequirementBindingsAsArray);
        if (n == 0 && (n = Util.compare(this.activityPatternBindingsAsArray, activity.activityPatternBindingsAsArray)) == 0 && (n = Util.compare(this.defined, activity.defined)) == 0 && (n = Util.compare(this.enabled, activity.enabled)) == 0 && (n = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)activity.id))) == 0) {
            n = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)activity.name));
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Activity)) {
            return false;
        }
        Activity activity = (Activity)object;
        if (!Util.equals(this.activityRequirementBindings, activity.activityRequirementBindings)) {
            return false;
        }
        if (!Util.equals(this.activityPatternBindings, activity.activityPatternBindings)) {
            return false;
        }
        if (!Util.equals(this.defined, activity.defined)) {
            return false;
        }
        if (!Util.equals(this.enabled, activity.enabled)) {
            return false;
        }
        if (!Util.equals(this.id, activity.id)) {
            return false;
        }
        return Util.equals(this.name, activity.name);
    }

    void fireActivityChanged(ActivityEvent activityEvent) {
        if (activityEvent == null) {
            throw new NullPointerException();
        }
        if (this.activityListeners != null) {
            int n = 0;
            while (n < this.activityListeners.size()) {
                ((IActivityListener)this.activityListeners.get(n)).activityChanged(activityEvent);
                ++n;
            }
        }
    }

    @Override
    public Set getActivityRequirementBindings() {
        return this.activityRequirementBindings;
    }

    @Override
    public Set getActivityPatternBindings() {
        return this.activityPatternBindings;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.name;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.activityRequirementBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.activityPatternBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.defined);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.enabled);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.name);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    @Override
    public boolean isDefined() {
        return this.defined;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMatch(String string) {
        if (this.isDefined()) {
            for (ActivityPatternBinding activityPatternBinding : this.activityPatternBindings) {
                if (!activityPatternBinding.isMatch(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeActivityListener(IActivityListener iActivityListener) {
        if (iActivityListener == null) {
            throw new NullPointerException();
        }
        if (this.activityListeners != null) {
            this.activityListeners.remove(iActivityListener);
        }
        if (this.activityListeners.isEmpty()) {
            strongReferences.remove(this);
        }
    }

    boolean setActivityRequirementBindings(Set set) {
        if (!Util.equals(set = Util.safeCopy(set, IActivityRequirementBinding.class), this.activityRequirementBindings)) {
            this.activityRequirementBindings = set;
            this.activityRequirementBindingsAsArray = this.activityRequirementBindings.toArray(new IActivityRequirementBinding[this.activityRequirementBindings.size()]);
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setActivityPatternBindings(Set set) {
        if (!Util.equals(set = Util.safeCopy(set, IActivityPatternBinding.class), this.activityPatternBindings)) {
            this.activityPatternBindings = set;
            this.activityPatternBindingsAsArray = this.activityPatternBindings.toArray(new IActivityPatternBinding[this.activityPatternBindings.size()]);
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDefined(boolean bl) {
        if (bl != this.defined) {
            this.defined = bl;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setName(String string) {
        if (!Util.equals(string, this.name)) {
            this.name = string;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    void setExpression(Expression expression) {
        this.expression = expression;
    }

    boolean setDescription(String string) {
        if (!Util.equals(string, this.description)) {
            this.description = string;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.activityRequirementBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.activityPatternBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(',');
            stringBuffer.append(this.enabled);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    @Override
    public String getDescription() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.description;
    }

    @Override
    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }

    boolean setDefaultEnabled(boolean bl) {
        if (!Util.equals(bl, this.defaultEnabled)) {
            this.defaultEnabled = bl;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }
}

