/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ui.internal.activities.ActivityRegistryEvent;
import org.eclipse.ui.internal.activities.IActivityRegistry;
import org.eclipse.ui.internal.activities.IActivityRegistryListener;

public abstract class AbstractActivityRegistry
implements IActivityRegistry {
    protected List activityRequirementBindingDefinitions = Collections.EMPTY_LIST;
    protected List activityDefinitions = Collections.EMPTY_LIST;
    protected List activityPatternBindingDefinitions = Collections.EMPTY_LIST;
    private ActivityRegistryEvent activityRegistryEvent;
    private List activityRegistryListeners;
    protected List categoryActivityBindingDefinitions = Collections.EMPTY_LIST;
    protected List categoryDefinitions = Collections.EMPTY_LIST;
    protected List defaultEnabledActivities = Collections.EMPTY_LIST;

    protected AbstractActivityRegistry() {
    }

    @Override
    public void addActivityRegistryListener(IActivityRegistryListener iActivityRegistryListener) {
        if (iActivityRegistryListener == null) {
            throw new NullPointerException();
        }
        if (this.activityRegistryListeners == null) {
            this.activityRegistryListeners = new ArrayList();
        }
        if (!this.activityRegistryListeners.contains(iActivityRegistryListener)) {
            this.activityRegistryListeners.add(iActivityRegistryListener);
        }
    }

    protected void fireActivityRegistryChanged() {
        if (this.activityRegistryListeners != null) {
            int n = 0;
            while (n < this.activityRegistryListeners.size()) {
                if (this.activityRegistryEvent == null) {
                    this.activityRegistryEvent = new ActivityRegistryEvent(this);
                }
                ((IActivityRegistryListener)this.activityRegistryListeners.get(n)).activityRegistryChanged(this.activityRegistryEvent);
                ++n;
            }
        }
    }

    @Override
    public List getActivityRequirementBindingDefinitions() {
        return this.activityRequirementBindingDefinitions;
    }

    @Override
    public List getActivityDefinitions() {
        return this.activityDefinitions;
    }

    @Override
    public List getActivityPatternBindingDefinitions() {
        return this.activityPatternBindingDefinitions;
    }

    @Override
    public List getCategoryActivityBindingDefinitions() {
        return this.categoryActivityBindingDefinitions;
    }

    @Override
    public List getCategoryDefinitions() {
        return this.categoryDefinitions;
    }

    @Override
    public void removeActivityRegistryListener(IActivityRegistryListener iActivityRegistryListener) {
        if (iActivityRegistryListener == null) {
            throw new NullPointerException();
        }
        if (this.activityRegistryListeners != null) {
            this.activityRegistryListeners.remove(iActivityRegistryListener);
        }
    }

    @Override
    public List getDefaultEnabledActivities() {
        return this.defaultEnabledActivities;
    }
}

