/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.actions.AbstractWorkingSetPulldownDelegate;
import org.eclipse.ui.internal.actions.ConfigureWindowWorkingSetsDialog;

public class SelectWorkingSetsAction
extends AbstractWorkingSetPulldownDelegate {
    @Override
    protected void fillMenu(Menu menu) {
        IWorkingSet[][] iWorkingSetArray = this.splitSets();
        int n = 0;
        while (n < iWorkingSetArray.length) {
            IWorkingSet[] iWorkingSetArray2 = iWorkingSetArray[n];
            int n2 = 0;
            while (n2 < iWorkingSetArray2.length) {
                IWorkingSet iWorkingSet = iWorkingSetArray2[n2];
                ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)new ToggleWorkingSetAction(iWorkingSet));
                actionContributionItem.fill(menu, -1);
                ++n2;
            }
            Separator separator = new Separator();
            separator.fill(menu, -1);
            ++n;
        }
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)new ManageWorkingSetsAction());
        actionContributionItem.fill(menu, -1);
    }

    private IWorkingSet[] getEnabledSets() {
        return this.getWindow().getActivePage().getWorkingSets();
    }

    private boolean isWorkingSetEnabled(IWorkingSet iWorkingSet) {
        IWorkingSet[] iWorkingSetArray = this.getEnabledSets();
        int n = 0;
        while (n < iWorkingSetArray.length) {
            if (iWorkingSetArray[n].equals(iWorkingSet)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void run(IAction iAction) {
        ConfigureWindowWorkingSetsDialog configureWindowWorkingSetsDialog = new ConfigureWindowWorkingSetsDialog(this.getWindow());
        configureWindowWorkingSetsDialog.open();
    }

    private class ManageWorkingSetsAction
    extends Action {
        ManageWorkingSetsAction() {
            super(WorkbenchMessages.Edit);
        }

        public void run() {
            SelectWorkingSetsAction.this.run((IAction)this);
        }
    }

    private class ToggleWorkingSetAction
    extends Action {
        private IWorkingSet set;

        ToggleWorkingSetAction(IWorkingSet iWorkingSet) {
            super(iWorkingSet.getLabel(), 2);
            this.setImageDescriptor(iWorkingSet.getImageDescriptor());
            this.set = iWorkingSet;
            this.setChecked(SelectWorkingSetsAction.this.isWorkingSetEnabled(iWorkingSet));
        }

        public void runWithEvent(Event event) {
            HashSet<IWorkingSet> hashSet = new HashSet<IWorkingSet>(Arrays.asList(SelectWorkingSetsAction.this.getWindow().getActivePage().getWorkingSets()));
            if (this.isChecked()) {
                boolean bl;
                boolean bl2 = bl = (event.stateMask & KeyLookupFactory.getDefault().formalModifierLookup("M1")) != 0;
                if (bl) {
                    hashSet.clear();
                }
                hashSet.add(this.set);
            } else {
                hashSet.remove(this.set);
            }
            SelectWorkingSetsAction.this.getWindow().getActivePage().setWorkingSets(hashSet.toArray(new IWorkingSet[hashSet.size()]));
        }
    }
}

