/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class SelectWorkingSetAction
extends Action {
    private Shell shell;
    private WorkingSetFilterActionGroup actionGroup;

    public SelectWorkingSetAction(WorkingSetFilterActionGroup workingSetFilterActionGroup, Shell shell) {
        super(WorkbenchMessages.SelectWorkingSetAction_text);
        Assert.isNotNull((Object)workingSetFilterActionGroup);
        this.setToolTipText(WorkbenchMessages.SelectWorkingSetAction_toolTip);
        this.shell = shell;
        this.actionGroup = workingSetFilterActionGroup;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.select_working_set_action_context");
    }

    public void run() {
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog iWorkingSetSelectionDialog = iWorkingSetManager.createWorkingSetSelectionDialog(this.shell, false);
        IWorkingSet iWorkingSet = this.actionGroup.getWorkingSet();
        if (iWorkingSet != null) {
            iWorkingSetSelectionDialog.setSelection(new IWorkingSet[]{iWorkingSet});
        }
        if (iWorkingSetSelectionDialog.open() == 0) {
            IWorkingSet[] iWorkingSetArray = iWorkingSetSelectionDialog.getSelection();
            if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
                this.actionGroup.setWorkingSet(iWorkingSetArray[0]);
                iWorkingSetManager.addRecentWorkingSet(iWorkingSetArray[0]);
            } else {
                this.actionGroup.setWorkingSet(null);
            }
        } else {
            this.actionGroup.setWorkingSet(iWorkingSet);
        }
    }
}

