/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizardShortcutAction
extends Action
implements IPluginContribution {
    private IWizardDescriptor wizardElement;
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private IWorkbenchWindow window;

    public NewWizardShortcutAction(IWorkbenchWindow iWorkbenchWindow, IWizardDescriptor iWizardDescriptor) {
        super(iWizardDescriptor.getLabel());
        this.setToolTipText(iWizardDescriptor.getDescription());
        this.setImageDescriptor(iWizardDescriptor.getImageDescriptor());
        this.setId(ActionFactory.NEW.getId());
        this.wizardElement = iWizardDescriptor;
        this.window = iWorkbenchWindow;
    }

    public IWizardDescriptor getWizardDescriptor() {
        return this.wizardElement;
    }

    public void run() {
        Class clazz;
        IEditorInput iEditorInput;
        IWorkbenchPart iWorkbenchPart;
        INewWizard iNewWizard;
        try {
            iNewWizard = (INewWizard)this.wizardElement.createWizard();
        }
        catch (CoreException coreException) {
            ErrorDialog.openError((Shell)this.window.getShell(), (String)WorkbenchMessages.NewWizardShortcutAction_errorTitle, (String)WorkbenchMessages.NewWizardShortcutAction_errorMessage, (IStatus)coreException.getStatus());
            return;
        }
        ISelection iSelection = this.window.getSelectionService().getSelection();
        StructuredSelection structuredSelection = StructuredSelection.EMPTY;
        if (iSelection instanceof IStructuredSelection) {
            structuredSelection = this.wizardElement.adaptedSelection((IStructuredSelection)iSelection);
        } else {
            iWorkbenchPart = this.window.getPartService().getActivePart();
            if (iWorkbenchPart instanceof IEditorPart) {
                Object object;
                iEditorInput = ((IEditorPart)iWorkbenchPart).getEditorInput();
                clazz = LegacyResourceSupport.getFileClass();
                if (iEditorInput != null && clazz != null && (object = Util.getAdapter(iEditorInput, clazz)) != null) {
                    structuredSelection = new StructuredSelection(object);
                }
            }
        }
        iNewWizard.init(this.window.getWorkbench(), (IStructuredSelection)structuredSelection);
        iWorkbenchPart = this.window.getShell();
        iEditorInput = new WizardDialog((Shell)iWorkbenchPart, (IWizard)iNewWizard);
        iEditorInput.create();
        clazz = iEditorInput.getShell().getSize();
        iEditorInput.getShell().setSize(Math.max(500, ((Point)clazz).x), Math.max(500, ((Point)clazz).y));
        this.window.getWorkbench().getHelpSystem().setHelp((Control)iEditorInput.getShell(), "org.eclipse.ui.new_wizard_shortcut_context");
        if (this.wizardElement.canFinishEarly() && !this.wizardElement.hasPages()) {
            iNewWizard.performFinish();
            iEditorInput.close();
        } else {
            iEditorInput.open();
        }
    }

    @Override
    public String getLocalId() {
        IPluginContribution iPluginContribution = this.getPluginContribution();
        if (iPluginContribution != null) {
            return iPluginContribution.getLocalId();
        }
        return this.wizardElement.getId();
    }

    @Override
    public String getPluginId() {
        IPluginContribution iPluginContribution = this.getPluginContribution();
        if (iPluginContribution != null) {
            return iPluginContribution.getPluginId();
        }
        return null;
    }

    private IPluginContribution getPluginContribution() {
        return (IPluginContribution)Util.getAdapter(this.wizardElement, IPluginContribution.class);
    }
}

