/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.QuickMenuCreator;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.AbstractWorkingSetPulldownDelegate;

public class ModifyWorkingSetDelegate
extends AbstractWorkingSetPulldownDelegate
implements IExecutableExtension,
IActionDelegate2 {
    private QuickMenuCreator contextMenuCreator = new QuickMenuCreator(){

        @Override
        protected void fillMenu(IMenuManager iMenuManager) {
            ModifyWorkingSetDelegate.this.fillMenu(iMenuManager);
        }
    };
    private boolean add = true;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.refreshEnablement();
        }

        private void refreshEnablement() {
            ModifyWorkingSetDelegate.this.selectionChanged(ModifyWorkingSetDelegate.this.actionProxy, ModifyWorkingSetDelegate.this.getSelection());
        }
    };
    private IAction actionProxy;

    @Override
    public void run(IAction iAction) {
        this.contextMenuCreator.createMenu();
    }

    @Override
    public void runWithEvent(IAction iAction, Event event) {
        if (event.type == 1 || event.type == 2) {
            this.run(iAction);
        }
    }

    @Override
    public void init(IWorkbenchWindow iWorkbenchWindow) {
        super.init(iWorkbenchWindow);
        this.getWindow().getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.listener);
    }

    @Override
    public void dispose() {
        this.getWindow().getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.listener);
        super.dispose();
        this.contextMenuCreator.dispose();
    }

    @Override
    public void fillMenu(Menu menu) {
        List list = this.getItems();
        int n = 0;
        while (n < list.size()) {
            IContributionItem iContributionItem;
            Object e = list.get(n);
            if (e instanceof IAction) {
                iContributionItem = new ActionContributionItem((IAction)e);
                iContributionItem.fill(menu, -1);
            } else {
                iContributionItem = (IContributionItem)e;
                iContributionItem.fill(menu, -1);
            }
            ++n;
        }
        if (this.add) {
            Separator separator = null;
            if (menu.getItemCount() > 0) {
                separator = new Separator();
                separator.fill(menu, -1);
            }
            separator = new ActionContributionItem((IAction)new NewWorkingSetAction());
            separator.fill(menu, -1);
        }
    }

    private List getItems() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        ISelection iSelection = this.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            if (!this.add) {
                Action action = new Action(WorkbenchMessages.NoApplicableWorkingSets){};
                action.setEnabled(false);
                arrayList.add(action);
            }
            return arrayList;
        }
        IWorkingSet[][] iWorkingSetArray = this.splitSets();
        Object[] objectArray = ((IStructuredSelection)iSelection).toArray();
        boolean bl = false;
        int n = 0;
        while (n < iWorkingSetArray.length) {
            int n2 = arrayList.size();
            IWorkingSet[] iWorkingSetArray2 = iWorkingSetArray[n];
            int n3 = 0;
            while (n3 < iWorkingSetArray2.length) {
                IWorkingSet iWorkingSet = iWorkingSetArray2[n3];
                HashSet<IAdaptable> hashSet = new HashSet<IAdaptable>();
                hashSet.addAll(Arrays.asList(iWorkingSet.getElements()));
                boolean bl2 = false;
                IAdaptable[] iAdaptableArray = new IAdaptable[objectArray.length];
                System.arraycopy(objectArray, 0, iAdaptableArray, 0, objectArray.length);
                iAdaptableArray = iWorkingSet.adaptElements(iAdaptableArray);
                if (iAdaptableArray.length > 0 && this.add) {
                    int n4 = 0;
                    while (n4 < iAdaptableArray.length) {
                        if (!hashSet.contains(iAdaptableArray[n4])) {
                            bl2 = true;
                            break;
                        }
                        ++n4;
                    }
                } else if (iAdaptableArray.length > 0) {
                    int n5 = 0;
                    while (n5 < iAdaptableArray.length) {
                        if (hashSet.contains(iAdaptableArray[n5])) {
                            bl2 = true;
                            break;
                        }
                        ++n5;
                    }
                }
                if (bl2) {
                    if (bl) {
                        arrayList.add((Action)new Separator());
                        bl = false;
                    }
                    ModifyAction modifyAction = new ModifyAction(iWorkingSet, iAdaptableArray);
                    arrayList.add(modifyAction);
                }
                ++n3;
            }
            bl |= arrayList.size() > n2;
            ++n;
        }
        if (arrayList.isEmpty() && !this.add) {
            Action action = new Action(WorkbenchMessages.NoApplicableWorkingSets){};
            action.setEnabled(false);
            arrayList.add(action);
        }
        return arrayList;
    }

    private void fillMenu(IMenuManager iMenuManager) {
        List list = this.getItems();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof IAction) {
                iMenuManager.add((IAction)e);
            } else {
                IContributionItem iContributionItem = (IContributionItem)e;
                iMenuManager.add(iContributionItem);
            }
            ++n;
        }
    }

    @Override
    public void selectionChanged(IAction iAction, ISelection iSelection) {
        super.selectionChanged(iAction, iSelection);
        if (iSelection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)this.getSelection()).toArray();
            boolean bl = true;
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (!(object instanceof IAdaptable) || object instanceof IWorkingSet) {
                    bl = false;
                    break;
                }
                ++n;
            }
            iAction.setEnabled(bl);
        } else {
            iAction.setEnabled(false);
        }
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        if (object instanceof String) {
            this.add = Boolean.valueOf((String)object);
        }
    }

    @Override
    public void init(IAction iAction) {
        this.actionProxy = iAction;
    }

    private class ModifyAction
    extends Action {
        private IWorkingSet set;
        private IAdaptable[] selectedElements;

        private ModifyAction(IWorkingSet iWorkingSet, IAdaptable[] iAdaptableArray) {
            super(iWorkingSet.getLabel(), 2);
            this.set = iWorkingSet;
            this.selectedElements = iAdaptableArray;
            this.setImageDescriptor(iWorkingSet.getImageDescriptor());
        }

        public void run() {
            List<IAdaptable> list = Arrays.asList(this.set.getElements());
            HashSet<IAdaptable> hashSet = new HashSet<IAdaptable>(list.size() + this.selectedElements.length);
            hashSet.addAll(list);
            List<IAdaptable> list2 = Arrays.asList(this.selectedElements);
            if (ModifyWorkingSetDelegate.this.add) {
                hashSet.addAll(list2);
            } else {
                hashSet.removeAll(list2);
            }
            this.set.setElements(hashSet.toArray(new IAdaptable[hashSet.size()]));
        }
    }

    public class NewWorkingSetAction
    extends Action {
        public NewWorkingSetAction() {
            super(WorkbenchMessages.NewWorkingSet);
        }

        public void run() {
            IWorkingSet iWorkingSet;
            IWorkingSetManager iWorkingSetManager = WorkbenchPlugin.getDefault().getWorkingSetManager();
            IWorkingSetNewWizard iWorkingSetNewWizard = iWorkingSetManager.createWorkingSetNewWizard(null);
            WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)iWorkingSetNewWizard);
            wizardDialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)wizardDialog.getShell(), "org.eclipse.ui.working_set_new_wizard_context");
            if (wizardDialog.open() == 0 && (iWorkingSet = iWorkingSetNewWizard.getSelection()) != null) {
                iWorkingSetManager.addWorkingSet(iWorkingSet);
            }
        }
    }
}

