/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class HelpSearchContributionItem
extends ControlContribution {
    private static final String ID = "org.eclipse.ui.helpSearch";
    private IWorkbenchWindow window;
    private Combo combo;
    private int MAX_ITEM_COUNT = 10;

    public HelpSearchContributionItem(IWorkbenchWindow iWorkbenchWindow) {
        this(iWorkbenchWindow, ID);
    }

    public HelpSearchContributionItem(IWorkbenchWindow iWorkbenchWindow, String string) {
        super(string);
        Assert.isNotNull((Object)iWorkbenchWindow);
        this.window = iWorkbenchWindow;
    }

    protected Control createControl(Composite composite) {
        this.combo = new Combo(composite, 0);
        this.combo.setToolTipText(WorkbenchMessages.WorkbenchWindow_searchCombo_toolTip);
        String[] stringArray = WorkbenchPlugin.getDefault().getDialogSettings().getArray(ID);
        if (stringArray != null) {
            this.combo.setItems(stringArray);
        }
        this.combo.setText(WorkbenchMessages.WorkbenchWindow_searchCombo_text);
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.character == '\r') {
                    HelpSearchContributionItem.this.doSearch(HelpSearchContributionItem.this.combo.getText(), true);
                }
            }
        });
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = HelpSearchContributionItem.this.combo.getSelectionIndex();
                if (n != -1) {
                    HelpSearchContributionItem.this.doSearch(HelpSearchContributionItem.this.combo.getItem(n), false);
                }
            }
        });
        return this.combo;
    }

    protected int computeWidth(Control control) {
        return control.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    private void doSearch(String string, boolean bl) {
        if (string.length() == 0) {
            this.window.getWorkbench().getHelpSystem().displaySearch();
            return;
        }
        if (bl) {
            boolean bl2 = false;
            int n = 0;
            while (n < this.combo.getItemCount()) {
                String string2 = this.combo.getItem(n);
                if (string2.equalsIgnoreCase(string)) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
            if (!bl2) {
                this.combo.add(string, 0);
                if (this.combo.getItemCount() > this.MAX_ITEM_COUNT) {
                    this.combo.remove(this.combo.getItemCount() - 1);
                }
                WorkbenchPlugin.getDefault().getDialogSettings().put(ID, this.combo.getItems());
            }
        }
        this.window.getWorkbench().getHelpSystem().search(string);
    }
}

