/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.internal.WorkbenchMessages;

public class EditWorkingSetAction
extends Action {
    private Shell shell;
    private WorkingSetFilterActionGroup actionGroup;

    public EditWorkingSetAction(WorkingSetFilterActionGroup workingSetFilterActionGroup, Shell shell) {
        super(WorkbenchMessages.EditWorkingSetAction_text);
        Assert.isNotNull((Object)workingSetFilterActionGroup);
        this.setToolTipText(WorkbenchMessages.EditWorkingSetAction_toolTip);
        this.shell = shell;
        this.actionGroup = workingSetFilterActionGroup;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.edit_working_set_action_context");
    }

    public void run() {
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet iWorkingSet = this.actionGroup.getWorkingSet();
        if (iWorkingSet == null) {
            this.setEnabled(false);
            return;
        }
        IWorkingSetEditWizard iWorkingSetEditWizard = iWorkingSetManager.createWorkingSetEditWizard(iWorkingSet);
        if (iWorkingSetEditWizard == null) {
            String string = WorkbenchMessages.EditWorkingSetAction_error_nowizard_title;
            String string2 = WorkbenchMessages.EditWorkingSetAction_error_nowizard_message;
            MessageDialog.openError((Shell)this.shell, (String)string, (String)string2);
            return;
        }
        WizardDialog wizardDialog = new WizardDialog(this.shell, (IWizard)iWorkingSetEditWizard);
        wizardDialog.create();
        if (wizardDialog.open() == 0) {
            this.actionGroup.setWorkingSet(iWorkingSetEditWizard.getSelection());
        }
    }
}

