/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.services.IServiceLocator;

public class CommandAction
extends Action {
    private IHandlerService handlerService = null;
    private ParameterizedCommand parameterizedCommand = null;
    private ICommandListener commandListener;

    protected CommandAction() {
    }

    public CommandAction(IServiceLocator iServiceLocator, String string) {
        this(iServiceLocator, string, null);
    }

    public CommandAction(IServiceLocator iServiceLocator, String string, Map map) {
        if (string == null) {
            throw new NullPointerException("commandIdIn must not be null");
        }
        this.init(iServiceLocator, string, map);
    }

    protected ICommandListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new ICommandListener(){

                public void commandChanged(CommandEvent commandEvent) {
                    if ((commandEvent.isHandledChanged() || commandEvent.isEnabledChanged()) && commandEvent.getCommand().isDefined()) {
                        CommandAction.this.setEnabled(commandEvent.getCommand().isEnabled());
                    }
                }
            };
        }
        return this.commandListener;
    }

    private void createCommand(ICommandService iCommandService, String string, Map map) {
        Command command = iCommandService.getCommand(string);
        if (!command.isDefined()) {
            WorkbenchPlugin.log("Command " + string + " is undefined");
            return;
        }
        if (map == null) {
            this.parameterizedCommand = new ParameterizedCommand(command, null);
            return;
        }
        this.parameterizedCommand = ParameterizedCommand.generateCommand((Command)command, (Map)map);
    }

    public void dispose() {
        this.handlerService = null;
        if (this.commandListener != null) {
            this.parameterizedCommand.getCommand().removeCommandListener(this.commandListener);
            this.commandListener = null;
        }
        this.parameterizedCommand = null;
    }

    public void runWithEvent(Event event) {
        if (this.handlerService == null) {
            String string = this.parameterizedCommand == null ? "unknownCommand" : this.parameterizedCommand.getId();
            WorkbenchPlugin.log("Cannot run " + string + " before command action has been initialized");
            return;
        }
        try {
            if (this.parameterizedCommand != null) {
                this.handlerService.executeCommand(this.parameterizedCommand, event);
            }
        }
        catch (Exception exception) {
            WorkbenchPlugin.log(exception);
        }
    }

    public void run() {
        this.runWithEvent(null);
    }

    protected void init(IServiceLocator iServiceLocator, String string, Map map) {
        if (this.handlerService != null) {
            return;
        }
        this.handlerService = (IHandlerService)iServiceLocator.getService(IHandlerService.class);
        ICommandService iCommandService = (ICommandService)iServiceLocator.getService(ICommandService.class);
        ICommandImageService iCommandImageService = (ICommandImageService)iServiceLocator.getService(ICommandImageService.class);
        this.createCommand(iCommandService, string, map);
        if (this.parameterizedCommand != null) {
            this.setId(this.parameterizedCommand.getId());
            this.setActionDefinitionId(this.parameterizedCommand.getId());
            try {
                this.setText(this.parameterizedCommand.getName());
            }
            catch (NotDefinedException notDefinedException) {}
            this.parameterizedCommand.getCommand().addCommandListener(this.getCommandListener());
            this.parameterizedCommand.getCommand().setEnabled((Object)this.handlerService.getCurrentState());
            this.setEnabled(this.parameterizedCommand.getCommand().isEnabled());
            this.setImageDescriptor(iCommandImageService.getImageDescriptor(string, 0));
            this.setDisabledImageDescriptor(iCommandImageService.getImageDescriptor(string, 1));
            this.setHoverImageDescriptor(iCommandImageService.getImageDescriptor(string, 2));
        }
    }

    protected ParameterizedCommand getParameterizedCommand() {
        return this.parameterizedCommand;
    }

    public String getActionDefinitionId() {
        return super.getActionDefinitionId();
    }
}

