/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public abstract class AbstractWorkingSetPulldownDelegate
implements IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate2 {
    private Menu menubarMenu;
    private Menu toolbarMenu;
    private ISelection selection;
    private IWorkbenchWindow window;

    @Override
    public void dispose() {
        if (this.menubarMenu != null) {
            this.menubarMenu.dispose();
            this.menubarMenu = null;
        }
        if (this.toolbarMenu != null) {
            this.toolbarMenu.dispose();
            this.toolbarMenu = null;
        }
    }

    @Override
    public Menu getMenu(Control control) {
        if (this.toolbarMenu != null) {
            this.toolbarMenu.dispose();
        }
        this.toolbarMenu = new Menu(control);
        this.initMenu(this.toolbarMenu);
        return this.toolbarMenu;
    }

    @Override
    public Menu getMenu(Menu menu) {
        if (this.menubarMenu != null) {
            this.menubarMenu.dispose();
        }
        this.menubarMenu = new Menu(menu);
        this.initMenu(this.menubarMenu);
        return this.menubarMenu;
    }

    private void initMenu(Menu menu) {
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Menu menu = (Menu)menuEvent.widget;
                MenuItem[] menuItemArray = menu.getItems();
                int n = 0;
                while (n < menuItemArray.length) {
                    menuItemArray[n].dispose();
                    ++n;
                }
                AbstractWorkingSetPulldownDelegate.this.fillMenu(menu);
            }
        });
    }

    protected abstract void fillMenu(Menu var1);

    protected IWorkingSet[][] splitSets() {
        List<IWorkingSet> list;
        IWorkingSet[] iWorkingSetArray = this.getWindow().getWorkbench().getWorkingSetManager().getWorkingSets();
        HashMap<String, ArrayList<IWorkingSet>> hashMap = new HashMap<String, ArrayList<IWorkingSet>>();
        WorkingSetRegistry workingSetRegistry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        int n = 0;
        while (n < iWorkingSetArray.length) {
            String string = iWorkingSetArray[n].getId();
            if (!WorkbenchActivityHelper.filterItem(workingSetRegistry.getWorkingSetDescriptor(string))) {
                list = (List)hashMap.get(string);
                if (list == null) {
                    list = new ArrayList<IWorkingSet>();
                    hashMap.put(string, (ArrayList<IWorkingSet>)list);
                }
                list.add(iWorkingSetArray[n]);
            }
            ++n;
        }
        IWorkingSet[][] iWorkingSetArray2 = new IWorkingSet[hashMap.keySet().size()][];
        int n2 = 0;
        list = hashMap.keySet().iterator();
        while (list.hasNext()) {
            List list2 = (List)hashMap.get(list.next());
            iWorkingSetArray2[n2] = new IWorkingSet[list2.size()];
            list2.toArray(iWorkingSetArray2[n2++]);
        }
        return iWorkingSetArray2;
    }

    @Override
    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.window = iWorkbenchWindow;
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }

    @Override
    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.selection = iSelection;
    }

    protected ISelection getSelection() {
        return this.selection;
    }
}

