/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.about.InstallationPage;
import org.eclipse.ui.internal.about.InstallationDialog;
import org.eclipse.ui.internal.about.ProductInfoPage;

public abstract class ProductInfoDialog
extends InstallationDialog {
    ProductInfoPage page;
    String title;
    String helpContextId;

    protected ProductInfoDialog(Shell shell) {
        super(shell, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public void initializeDialog(ProductInfoPage productInfoPage, String string, String string2) {
        this.page = productInfoPage;
        this.title = string;
        this.helpContextId = string2;
    }

    @Override
    protected void createFolderItems(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.title);
        Composite composite = new Composite((Composite)tabFolder, 2048);
        composite.setLayout((Layout)new GridLayout());
        tabItem.setControl((Control)composite);
        this.page.createControl(composite);
        tabItem.setData((Object)this.page);
        tabItem.setData("ID", (Object)this.page.getId());
        this.page.setPageContainer(this);
        tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ProductInfoDialog.this.page.dispose();
            }
        });
        composite.layout(true, true);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.createButtons(this.page);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, this.helpContextId);
        }
    }

    @Override
    protected String pageToId(InstallationPage installationPage) {
        Assert.isLegal((installationPage == this.page ? 1 : 0) != 0);
        return this.page.getId();
    }
}

