/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.about.IInstallationPageContainer;
import org.eclipse.ui.about.InstallationPage;
import org.eclipse.ui.internal.ConfigurationInfo;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.services.IServiceLocator;

public class InstallationDialog
extends TrayDialog
implements IInstallationPageContainer {
    protected static final String ID = "ID";
    private static final String DIALOG_SETTINGS_SECTION = "InstallationDialogSettings";
    private static final int TAB_WIDTH_IN_DLUS = 440;
    private static final int TAB_HEIGHT_IN_DLUS = 320;
    private static String lastSelectedTabId = null;
    private TabFolder folder;
    IServiceLocator serviceLocator;
    private ButtonManager buttonManager;
    private Map pageToId = new HashMap();
    private Dialog modalParent;

    public InstallationDialog(Shell shell, IServiceLocator iServiceLocator) {
        super(shell);
        this.serviceLocator = iServiceLocator;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String string = "";
        IProduct iProduct = Platform.getProduct();
        if (iProduct != null && iProduct.getName() != null) {
            string = iProduct.getName();
        }
        shell.setText(NLS.bind((String)WorkbenchMessages.InstallationDialog_ShellTitle, (Object)string));
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.folder = new TabFolder(composite2, 0);
        this.configureFolder();
        this.createFolderItems(this.folder);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(440);
        gridData.heightHint = this.convertVerticalDLUsToPixels(320);
        this.folder.setLayoutData((Object)gridData);
        this.folder.addSelectionListener((SelectionListener)this.createFolderSelectionListener());
        this.folder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                InstallationDialog.this.releaseContributions();
            }
        });
        return composite2;
    }

    protected void createFolderItems(TabFolder tabFolder) {
        IConfigurationElement[] iConfigurationElementArray = ConfigurationInfo.getSortedExtensions(this.loadElements());
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            TabItem tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(iConfigurationElement.getAttribute("name"));
            tabItem.setData((Object)iConfigurationElement);
            tabItem.setData(ID, (Object)iConfigurationElement.getAttribute("id"));
            Composite composite = new Composite((Composite)tabFolder, 0);
            composite.setLayout((Layout)new GridLayout());
            tabItem.setControl((Control)composite);
            ++n;
        }
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        boolean bl = false;
        if (this.folder.getItemCount() > 0) {
            if (lastSelectedTabId != null) {
                TabItem[] tabItemArray = this.folder.getItems();
                int n = 0;
                while (n < tabItemArray.length) {
                    if (tabItemArray[n].getData(ID).equals(lastSelectedTabId)) {
                        this.folder.setSelection(n);
                        this.tabSelected(tabItemArray[n]);
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.tabSelected(this.folder.getItem(0));
            }
        }
        Dialog.applyDialogFont((Control)this.folder);
        return control;
    }

    private SelectionAdapter createFolderSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InstallationDialog.this.tabSelected((TabItem)selectionEvent.item);
            }
        };
    }

    private void tabSelected(TabItem tabItem) {
        InstallationPage installationPage;
        Composite composite;
        Object object;
        if (tabItem.getData() instanceof IConfigurationElement) {
            object = (IConfigurationElement)tabItem.getData();
            composite = (Composite)tabItem.getControl();
            try {
                installationPage = (InstallationPage)((Object)object.createExecutableExtension("class"));
                installationPage.createControl(composite);
                Dialog.applyDialogFont((Control)composite);
                installationPage.setPageContainer(this);
                this.pageToId.put(installationPage, object.getAttribute("id"));
                this.createButtons(installationPage);
                tabItem.setData((Object)installationPage);
                tabItem.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent disposeEvent) {
                        installationPage.dispose();
                    }
                });
                composite.layout(true, true);
            }
            catch (CoreException coreException) {
                Label label = new Label(composite, 0);
                label.setText(coreException.getMessage());
                tabItem.setData(null);
            }
        }
        object = (String)tabItem.getData(ID);
        this.rememberSelectedTab((String)object);
        this.buttonManager.update((String)object);
        composite = this.createButton(this.buttonManager.getParent(), 12, IDialogConstants.CLOSE_LABEL, true);
        installationPage = (GridData)composite.getLayoutData();
        ((GridData)installationPage).horizontalAlignment = 1;
        ((GridData)installationPage).horizontalIndent = this.convertHorizontalDLUsToPixels(61) / 2;
        this.getButtonBar().getParent().layout(true, true);
    }

    protected void createButtons(InstallationPage installationPage) {
        installationPage.createPageButtons(this.buttonManager.getParent());
        Dialog.applyDialogFont((Control)this.buttonManager.getParent());
    }

    private void rememberSelectedTab(String string) {
        lastSelectedTabId = string;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.makeColumnsEqualWidth = false;
        this.buttonManager = new ButtonManager(composite);
    }

    private void configureFolder() {
    }

    private IConfigurationElement[] loadElements() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "installationPages");
        return iExtensionPoint.getConfigurationElements();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return iDialogSettings2;
    }

    protected void releaseContributions() {
        this.buttonManager.clear();
    }

    @Override
    public void closeModalContainers() {
        this.close();
        if (this.modalParent != null) {
            this.modalParent.close();
        }
    }

    protected void buttonPressed(int n) {
        if (12 == n) {
            this.okPressed();
        }
    }

    @Override
    public void registerPageButton(InstallationPage installationPage, Button button) {
        this.buttonManager.addPageButton(this.pageToId(installationPage), button);
    }

    protected String pageToId(InstallationPage installationPage) {
        String string = (String)this.pageToId.get((Object)installationPage);
        Assert.isLegal((string != null ? 1 : 0) != 0);
        return string;
    }

    public void setModalParent(Dialog dialog) {
        this.modalParent = dialog;
    }

    class ButtonManager {
        private Composite composite;
        HashMap buttonMap = new HashMap();

        public ButtonManager(Composite composite) {
            this.composite = composite;
        }

        public Composite getParent() {
            return this.composite;
        }

        public void update(String string) {
            Control control;
            if (this.composite == null || this.composite.isDisposed()) {
                return;
            }
            GC gC = new GC((Drawable)this.composite);
            FontMetrics fontMetrics = gC.getFontMetrics();
            gC.dispose();
            List list = (List)this.buttonMap.get(string);
            Control[] controlArray = this.composite.getChildren();
            int n = 0;
            Button button = InstallationDialog.this.getButton(12);
            int n2 = 0;
            while (n2 < controlArray.length) {
                control = controlArray[n2];
                if (button == control) {
                    button.dispose();
                } else {
                    control.setVisible(false);
                    this.setButtonLayoutData(fontMetrics, control, false);
                }
                ++n2;
            }
            if (list != null) {
                n2 = 0;
                while (n2 < list.size()) {
                    control = (Button)list.get(n2);
                    control.setVisible(true);
                    this.setButtonLayoutData(fontMetrics, control, true);
                    GridData gridData = (GridData)control.getLayoutData();
                    gridData.exclude = false;
                    ++n;
                    ++n2;
                }
            }
            GridLayout gridLayout = (GridLayout)this.composite.getLayout();
            gridLayout.numColumns = n;
            this.composite.layout(true);
        }

        protected void setButtonLayoutData(FontMetrics fontMetrics, Control control, boolean bl) {
            GridData gridData = new GridData(256);
            int n = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
            Point point = control.computeSize(-1, -1, true);
            gridData.widthHint = Math.max(n, point.x);
            gridData.exclude = !bl;
            control.setLayoutData((Object)gridData);
        }

        public void addPageButton(String string, Button button) {
            ArrayList<Button> arrayList = (ArrayList<Button>)this.buttonMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Button>(1);
                this.buttonMap.put(string, arrayList);
            }
            arrayList.add(button);
        }

        public void clear() {
            this.buttonMap = new HashMap();
        }
    }
}

