/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.about.ISystemSummarySection;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.internal.about.AboutBundleGroupData;
import org.eclipse.ui.internal.about.AboutData;
import org.eclipse.ui.internal.util.Util;
import org.osgi.framework.Bundle;

public class ConfigurationLogDefaultSection
implements ISystemSummarySection {
    private static final String ECLIPSE_PROPERTY_PREFIX = "eclipse.";

    @Override
    public void write(PrintWriter printWriter) {
        this.appendProperties(printWriter);
        this.appendFeatures(printWriter);
        this.appendRegistry(printWriter);
        this.appendUserPreferences(printWriter);
    }

    private void appendProperties(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println(WorkbenchMessages.SystemSummary_systemProperties);
        Properties properties = System.getProperties();
        TreeSet<Object> treeSet = new TreeSet<Object>(new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.compareTo(string2);
            }
        });
        treeSet.addAll(properties.keySet());
        for (String string : treeSet) {
            String string2 = properties.getProperty(string);
            printWriter.print(string);
            printWriter.print('=');
            if (string.startsWith(ECLIPSE_PROPERTY_PREFIX)) {
                ConfigurationLogDefaultSection.printEclipseProperty(printWriter, string2);
                continue;
            }
            if (string.toUpperCase().indexOf("PASSWORD") != -1) {
                int n = 0;
                while (n < string2.length()) {
                    printWriter.print('*');
                    ++n;
                }
                printWriter.println();
                continue;
            }
            printWriter.println(string2);
        }
    }

    private static void printEclipseProperty(PrintWriter printWriter, String string) {
        String[] stringArray = Util.getArrayFromList(string, "\n");
        int n = 0;
        while (n < stringArray.length) {
            printWriter.println(stringArray[n]);
            ++n;
        }
    }

    private void appendFeatures(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println(WorkbenchMessages.SystemSummary_features);
        IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
        LinkedList<AboutBundleGroupData> linkedList = new LinkedList<AboutBundleGroupData>();
        if (iBundleGroupProviderArray != null) {
            int n = 0;
            while (n < iBundleGroupProviderArray.length) {
                IBundleGroup[] iBundleGroupArray = iBundleGroupProviderArray[n].getBundleGroups();
                int n2 = 0;
                while (n2 < iBundleGroupArray.length) {
                    linkedList.add(new AboutBundleGroupData(iBundleGroupArray[n2]));
                    ++n2;
                }
                ++n;
            }
        }
        AboutData[] aboutDataArray = linkedList.toArray(new AboutBundleGroupData[0]);
        AboutData.sortById(false, aboutDataArray);
        int n = 0;
        while (n < aboutDataArray.length) {
            AboutData aboutData = aboutDataArray[n];
            Object[] objectArray = new String[]{aboutData.getId(), aboutData.getVersion(), aboutData.getName()};
            printWriter.println(NLS.bind((String)WorkbenchMessages.SystemSummary_featureVersion, (Object[])objectArray));
            ++n;
        }
    }

    private void appendRegistry(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println(WorkbenchMessages.SystemSummary_pluginRegistry);
        Bundle[] bundleArray = WorkbenchPlugin.getDefault().getBundles();
        AboutData[] aboutDataArray = new AboutBundleData[bundleArray.length];
        int n = 0;
        while (n < bundleArray.length) {
            aboutDataArray[n] = new AboutBundleData(bundleArray[n]);
            ++n;
        }
        AboutData.sortById(false, aboutDataArray);
        n = 0;
        while (n < aboutDataArray.length) {
            AboutData aboutData = aboutDataArray[n];
            Object[] objectArray = new String[]{aboutData.getId(), aboutData.getVersion(), aboutData.getName(), ((AboutBundleData)aboutData).getStateName()};
            printWriter.println(NLS.bind((String)WorkbenchMessages.SystemSummary_descriptorIdVersionState, (Object[])objectArray));
            ++n;
        }
    }

    private void appendUserPreferences(PrintWriter printWriter) {
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        IEclipsePreferences iEclipsePreferences = iPreferencesService.getRootNode();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            iPreferencesService.exportPreferences(iEclipsePreferences, (OutputStream)byteArrayOutputStream, null);
        }
        catch (CoreException coreException) {
            printWriter.println("Error reading preferences " + coreException.toString());
        }
        printWriter.println();
        printWriter.println(WorkbenchMessages.SystemSummary_userPreferences);
        BufferedReader bufferedReader = null;
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, "8859_1"));
            char[] cArray = new char[8192];
            while ((n = bufferedReader.read(cArray)) > 0) {
                printWriter.write(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            printWriter.println("Error reading preferences " + iOException.toString());
        }
    }
}

