/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class BundleSigningInfo {
    private Composite composite;
    private Text date;
    private StyledText certificate;
    private AboutBundleData data;

    public void setData(AboutBundleData aboutBundleData) {
        this.data = aboutBundleData;
        this.startJobs();
    }

    public Control createContents(Composite composite) {
        this.composite = new Composite(composite, 2048);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.composite.setLayout((Layout)gridLayout);
        Label label = new Label(this.composite, 0);
        label.setText(WorkbenchMessages.BundleSigningTray_Signing_Date);
        GridData gridData = new GridData(4, 1, true, false);
        this.date = new Text(this.composite, 8);
        GC gC = new GC((Drawable)this.date);
        gC.setFont(JFaceResources.getDialogFont());
        Point point = gC.stringExtent(DateFormat.getDateTimeInstance().format(new Date()));
        gridData.widthHint = point.x;
        gC.dispose();
        this.date.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.date.setLayoutData((Object)gridData);
        label = new Label(this.composite, 0);
        label.setText(WorkbenchMessages.BundleSigningTray_Signing_Certificate);
        gridData = new GridData(1, 1, true, false);
        gridData.horizontalSpan = 2;
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.certificate = new StyledText(this.composite, 74);
        this.certificate.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.certificate.setLayoutData((Object)gridData);
        Dialog.applyDialogFont((Control)this.composite);
        this.startJobs();
        return this.composite;
    }

    private void startJobs() {
        if (!this.isOpen()) {
            return;
        }
        this.certificate.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.date.setText(WorkbenchMessages.BundleSigningTray_Working);
        final BundleContext bundleContext = WorkbenchPlugin.getDefault().getBundleContext();
        final ServiceReference serviceReference = bundleContext.getServiceReference(SignedContentFactory.class.getName());
        if (serviceReference == null) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.BundleSigningTray_Cant_Find_Service), 1);
            return;
        }
        final SignedContentFactory signedContentFactory = (SignedContentFactory)bundleContext.getService(serviceReference);
        if (signedContentFactory == null) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.BundleSigningTray_Cant_Find_Service), 1);
            return;
        }
        final AboutBundleData aboutBundleData = this.data;
        final Job job = new Job(NLS.bind((String)WorkbenchMessages.BundleSigningTray_Determine_Signer_For, (Object)aboutBundleData.getId())){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                final String[] stringArray = new String[]{WorkbenchMessages.BundleSigningTray_Unsigned, WorkbenchMessages.BundleSigningTray_Unsigned};
                try {
                    if (aboutBundleData != BundleSigningInfo.this.data) {
                        return Status.OK_STATUS;
                    }
                    SignedContent signedContent = signedContentFactory.getSignedContent(aboutBundleData.getBundle());
                    if (aboutBundleData != BundleSigningInfo.this.data) {
                        return Status.OK_STATUS;
                    }
                    SignerInfo[] signerInfoArray = signedContent.getSignerInfos();
                    if (!BundleSigningInfo.this.isOpen() && BundleSigningInfo.this.data == aboutBundleData) {
                        return Status.OK_STATUS;
                    }
                    if (signerInfoArray.length > 0) {
                        Comparable<StringBuffer> comparable;
                        Properties[] propertiesArray = BundleSigningInfo.this.parseCerts(signerInfoArray[0].getCertificateChain());
                        if (propertiesArray.length == 0) {
                            stringArray[0] = WorkbenchMessages.BundleSigningTray_Unknown;
                        } else {
                            comparable = new StringBuffer();
                            Iterator<Map.Entry<Object, Object>> iterator = propertiesArray[0].entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry<Object, Object> entry = iterator.next();
                                ((StringBuffer)comparable).append(entry.getKey());
                                ((StringBuffer)comparable).append('=');
                                ((StringBuffer)comparable).append(entry.getValue());
                                if (!iterator.hasNext()) continue;
                                ((StringBuffer)comparable).append('\n');
                            }
                            stringArray[0] = ((StringBuffer)comparable).toString();
                        }
                        comparable = signedContent.getSigningTime(signerInfoArray[0]);
                        stringArray[1] = comparable != null ? DateFormat.getDateTimeInstance().format((Date)comparable) : WorkbenchMessages.BundleSigningTray_Unknown;
                    }
                }
                catch (IOException iOException) {
                    StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, iOException.getMessage(), (Throwable)iOException), 1);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, generalSecurityException.getMessage(), (Throwable)generalSecurityException), 1);
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!BundleSigningInfo.this.isOpen() && BundleSigningInfo.this.data != aboutBundleData) {
                            return;
                        }
                        BundleSigningInfo.this.certificate.setText(stringArray[0]);
                        BundleSigningInfo.this.date.setText(stringArray[1]);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.belongsTo((Object)job);
        job.schedule();
        Job job2 = new Job(WorkbenchMessages.BundleSigningTray_Unget_Signing_Service){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    2.getJobManager().join((Object)job, iProgressMonitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (InterruptedException interruptedException) {}
                bundleContext.ungetService(serviceReference);
                return Status.OK_STATUS;
            }
        };
        job2.setSystem(true);
        job2.schedule();
    }

    private boolean isOpen() {
        return this.certificate != null && !this.certificate.isDisposed();
    }

    private Properties[] parseCerts(Certificate[] certificateArray) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>(certificateArray.length);
        int n = 0;
        while (n < certificateArray.length) {
            Properties properties;
            if (certificateArray[n] instanceof X509Certificate && (properties = this.parseCert(((X509Certificate)certificateArray[n]).getSubjectDN().getName())) != null) {
                arrayList.add(properties);
            }
            ++n;
        }
        return arrayList.toArray(new Properties[arrayList.size()]);
    }

    private Properties parseCert(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Properties properties = new Properties();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n <= 0 || n >= string2.length() - 2) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (string4.length() > 2) {
                if (string4.charAt(0) == '\"') {
                    string4 = string4.substring(1);
                }
                if (string4.charAt(string4.length() - 1) == '\"') {
                    string4 = string4.substring(0, string4.length() - 1);
                }
            }
            properties.setProperty(string3, string4);
        }
        return properties;
    }

    public void dispose() {
        this.composite.dispose();
    }
}

