/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutItem;
import org.eclipse.ui.internal.misc.StatusUtil;

public class AboutUtils {
    private static final String ERROR_LOG_COPY_FILENAME = "log";

    public static AboutItem scan(String string) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = string.indexOf("://");
        while (n >= 0) {
            char c;
            boolean bl = false;
            int n2 = n;
            do {
                c = ' ';
                if (--n2 > -1) {
                    c = string.charAt(n2);
                }
                boolean bl2 = bl = c == '\"';
            } while (Character.isUnicodeIdentifierStart(c));
            ++n2;
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 3), " \t\n\r\f<>", false);
            if (!stringTokenizer.hasMoreTokens()) {
                return null;
            }
            int n3 = stringTokenizer.nextToken().length() + 3 + n - n2;
            if (bl) {
                int n4 = -1;
                int n5 = string.indexOf(34, n2);
                int n6 = string.indexOf(32, n2);
                if (n5 != -1 && n6 != -1) {
                    n4 = Math.min(n5, n6);
                } else if (n5 != -1) {
                    n4 = n5;
                } else if (n6 != -1) {
                    n4 = n6;
                }
                if (n4 != -1) {
                    n3 = n4 - n2;
                }
            }
            arrayList.add(new int[]{n2, n3});
            arrayList2.add(string.substring(n2, n2 + n3));
            n = string.indexOf("://", n2 + n3 + 1);
        }
        return new AboutItem(string, (int[][])arrayList.toArray((T[])new int[arrayList.size()][2]), arrayList2.toArray(new String[arrayList2.size()]));
    }

    public static boolean openBrowser(Shell shell, URL uRL) {
        if (uRL != null) {
            try {
                uRL = Platform.asLocalURL((URL)uRL);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (uRL == null) {
            return false;
        }
        AboutUtils.openLink(shell, uRL.toString());
        return true;
    }

    public static void openLink(Shell shell, String string) {
        if (string.startsWith("file:")) {
            string = string.substring(5);
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            string = "file:///" + string;
        }
        IWorkbenchBrowserSupport iWorkbenchBrowserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser iWebBrowser = iWorkbenchBrowserSupport.getExternalBrowser();
            iWebBrowser.openURL(new URL(AboutUtils.urlEncodeForSpaces(string.toCharArray())));
        }
        catch (MalformedURLException malformedURLException) {
            AboutUtils.openWebBrowserError(shell, string, malformedURLException);
        }
        catch (PartInitException partInitException) {
            AboutUtils.openWebBrowserError(shell, string, (Throwable)((Object)partInitException));
        }
    }

    private static String urlEncodeForSpaces(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == ' ') {
                stringBuffer.append("%20");
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static void openWebBrowserError(Shell shell, String string, Throwable throwable) {
        String string2 = WorkbenchMessages.ProductInfoDialog_errorTitle;
        String string3 = NLS.bind((String)WorkbenchMessages.ProductInfoDialog_unableToOpenWebBrowser, (Object)string);
        IStatus iStatus = WorkbenchPlugin.getStatus(throwable);
        StatusUtil.handleStatus(iStatus, String.valueOf(string2) + ": " + string3, 2, shell);
    }

    public static void openErrorLogBrowser(Shell shell) {
        String string = Platform.getLogFileLocation().toOSString();
        File file = new File(string);
        if (file.exists()) {
            File file2 = AboutUtils.makeDisplayCopy(file);
            if (file2 != null) {
                AboutUtils.openLink(shell, "file:///" + file2.getAbsolutePath());
                return;
            }
            AboutUtils.openLink(shell, "file:///" + string);
            return;
        }
        MessageDialog.openInformation((Shell)shell, (String)WorkbenchMessages.AboutSystemDialog_noLogTitle, (String)NLS.bind((String)WorkbenchMessages.AboutSystemDialog_noLogMessage, (Object)string));
    }

    private static File makeDisplayCopy(File file) {
        IPath iPath = WorkbenchPlugin.getDefault().getDataLocation();
        if (iPath == null) {
            return null;
        }
        iPath = iPath.append(ERROR_LOG_COPY_FILENAME);
        File file2 = iPath.toFile();
        FileReader fileReader = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            int n;
            fileReader = new FileReader(file);
            outputStreamWriter = new FileWriter(file2);
            char[] cArray = new char[4096];
            while ((n = fileReader.read(cArray, 0, cArray.length)) > 0) {
                outputStreamWriter.write(cArray, 0, n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {
                return null;
            }
            return null;
        }
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (IOException iOException2) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException3) {
                return null;
            }
            return null;
        }
        try {
            if (fileReader != null) {
                fileReader.close();
            }
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return file2;
    }
}

