/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.about.AboutItem;
import org.eclipse.ui.internal.about.AboutUtils;

public class AboutTextManager {
    private StyledText styledText;
    private Cursor handCursor;
    private Cursor busyCursor;
    private boolean mouseDown = false;
    private boolean dragEvent = false;
    private AboutItem item;

    public static AboutItem scan(String string) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = string.indexOf("://");
        while (n >= 0) {
            char c;
            boolean bl = false;
            int n2 = n;
            do {
                c = ' ';
                if (--n2 > -1) {
                    c = string.charAt(n2);
                }
                boolean bl2 = bl = c == '\"';
            } while (Character.isUnicodeIdentifierStart(c));
            ++n2;
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 3), " \t\n\r\f<>", false);
            if (!stringTokenizer.hasMoreTokens()) {
                return null;
            }
            int n3 = stringTokenizer.nextToken().length() + 3 + n - n2;
            if (bl) {
                int n4 = -1;
                int n5 = string.indexOf(34, n2);
                int n6 = string.indexOf(32, n2);
                if (n5 != -1 && n6 != -1) {
                    n4 = Math.min(n5, n6);
                } else if (n5 != -1) {
                    n4 = n5;
                } else if (n6 != -1) {
                    n4 = n6;
                }
                if (n4 != -1) {
                    n3 = n4 - n2;
                }
            }
            arrayList.add(new int[]{n2, n3});
            arrayList2.add(string.substring(n2, n2 + n3));
            n = string.indexOf("://", n2 + n3 + 1);
        }
        return new AboutItem(string, (int[][])arrayList.toArray((T[])new int[arrayList.size()][2]), arrayList2.toArray(new String[arrayList2.size()]));
    }

    public AboutTextManager(StyledText styledText) {
        this.styledText = styledText;
        this.createCursors();
        this.addListeners();
    }

    private void createCursors() {
        this.handCursor = new Cursor((Device)this.styledText.getDisplay(), 21);
        this.busyCursor = new Cursor((Device)this.styledText.getDisplay(), 1);
        this.styledText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AboutTextManager.this.handCursor.dispose();
                AboutTextManager.this.handCursor = null;
                AboutTextManager.this.busyCursor.dispose();
                AboutTextManager.this.busyCursor = null;
            }
        });
    }

    protected void addListeners() {
        this.styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button != 1) {
                    return;
                }
                AboutTextManager.this.mouseDown = true;
            }

            public void mouseUp(MouseEvent mouseEvent) {
                AboutTextManager.this.mouseDown = false;
                int n = AboutTextManager.this.styledText.getCaretOffset();
                if (AboutTextManager.this.dragEvent) {
                    AboutTextManager.this.dragEvent = false;
                    if (AboutTextManager.this.item != null && AboutTextManager.this.item.isLinkAt(n)) {
                        AboutTextManager.this.styledText.setCursor(AboutTextManager.this.handCursor);
                    }
                } else if (AboutTextManager.this.item != null && AboutTextManager.this.item.isLinkAt(n)) {
                    AboutTextManager.this.styledText.setCursor(AboutTextManager.this.busyCursor);
                    AboutUtils.openLink(AboutTextManager.this.styledText.getShell(), AboutTextManager.this.item.getLinkAt(n));
                    StyleRange styleRange = AboutTextManager.this.getCurrentRange();
                    AboutTextManager.this.styledText.setSelectionRange(styleRange.start, styleRange.length);
                    AboutTextManager.this.styledText.setCursor(null);
                }
            }
        });
        this.styledText.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                if (AboutTextManager.this.mouseDown) {
                    if (!AboutTextManager.this.dragEvent) {
                        StyledText styledText = (StyledText)mouseEvent.widget;
                        styledText.setCursor(null);
                    }
                    AboutTextManager.this.dragEvent = true;
                    return;
                }
                StyledText styledText = (StyledText)mouseEvent.widget;
                int n = -1;
                try {
                    n = styledText.getOffsetAtLocation(new Point(mouseEvent.x, mouseEvent.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (n == -1) {
                    styledText.setCursor(null);
                } else if (AboutTextManager.this.item != null && AboutTextManager.this.item.isLinkAt(n)) {
                    styledText.setCursor(AboutTextManager.this.handCursor);
                } else {
                    styledText.setCursor(null);
                }
            }
        });
        this.styledText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                switch (traverseEvent.detail) {
                    case 2: {
                        traverseEvent.doit = true;
                        break;
                    }
                    case 16: {
                        StyleRange styleRange;
                        Point point = AboutTextManager.this.styledText.getSelection();
                        int n = AboutTextManager.this.styledText.getCharCount();
                        if (point.x == n && point.y == n) {
                            AboutTextManager.this.styledText.setSelection(0);
                        }
                        if ((styleRange = AboutTextManager.this.findNextRange()) == null) {
                            AboutTextManager.this.styledText.setSelection(0);
                            traverseEvent.doit = true;
                            break;
                        }
                        AboutTextManager.this.styledText.setSelectionRange(styleRange.start, styleRange.length);
                        traverseEvent.doit = true;
                        traverseEvent.detail = 0;
                        break;
                    }
                    case 8: {
                        StyleRange styleRange;
                        Point point = AboutTextManager.this.styledText.getSelection();
                        if (point.x == 0 && point.y == 0) {
                            AboutTextManager.this.styledText.setSelection(AboutTextManager.this.styledText.getCharCount());
                        }
                        if ((styleRange = AboutTextManager.this.findPreviousRange()) == null) {
                            AboutTextManager.this.styledText.setSelection(AboutTextManager.this.styledText.getCharCount());
                            traverseEvent.doit = true;
                            break;
                        }
                        AboutTextManager.this.styledText.setSelectionRange(styleRange.start, styleRange.length);
                        traverseEvent.doit = true;
                        traverseEvent.detail = 0;
                        break;
                    }
                }
            }
        });
        this.styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                StyledText styledText = (StyledText)keyEvent.widget;
                if (keyEvent.character == ' ' || keyEvent.character == '\r') {
                    if (AboutTextManager.this.item != null) {
                        int n = styledText.getSelection().x + 1;
                        if (AboutTextManager.this.item.isLinkAt(n)) {
                            styledText.setCursor(AboutTextManager.this.busyCursor);
                            AboutUtils.openLink(AboutTextManager.this.styledText.getShell(), AboutTextManager.this.item.getLinkAt(n));
                            StyleRange styleRange = AboutTextManager.this.getCurrentRange();
                            styledText.setSelectionRange(styleRange.start, styleRange.length);
                            styledText.setCursor(null);
                        }
                    }
                    return;
                }
            }
        });
    }

    public AboutItem getItem() {
        return this.item;
    }

    public void setItem(AboutItem aboutItem) {
        this.item = aboutItem;
        if (aboutItem != null) {
            this.styledText.setText(aboutItem.getText());
            this.setLinkRanges(aboutItem.getLinkRanges());
        }
    }

    private StyleRange getCurrentRange() {
        StyleRange[] styleRangeArray = this.styledText.getStyleRanges();
        int n = this.styledText.getSelection().y;
        int n2 = this.styledText.getSelection().x;
        int n3 = 0;
        while (n3 < styleRangeArray.length) {
            if (n2 >= styleRangeArray[n3].start && n <= styleRangeArray[n3].start + styleRangeArray[n3].length) {
                return styleRangeArray[n3];
            }
            ++n3;
        }
        return null;
    }

    private StyleRange findNextRange() {
        StyleRange[] styleRangeArray = this.styledText.getStyleRanges();
        int n = this.styledText.getSelection().y;
        int n2 = 0;
        while (n2 < styleRangeArray.length) {
            if (styleRangeArray[n2].start >= n) {
                return styleRangeArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private StyleRange findPreviousRange() {
        StyleRange[] styleRangeArray = this.styledText.getStyleRanges();
        int n = this.styledText.getSelection().x;
        int n2 = styleRangeArray.length - 1;
        while (n2 > -1) {
            if (styleRangeArray[n2].start + styleRangeArray[n2].length - 1 < n) {
                return styleRangeArray[n2];
            }
            --n2;
        }
        return null;
    }

    private void setLinkRanges(int[][] nArray) {
        Color color = JFaceColors.getHyperlinkText((Display)this.styledText.getShell().getDisplay());
        int n = 0;
        while (n < nArray.length) {
            StyleRange styleRange = new StyleRange(nArray[n][0], nArray[n][1], color, null);
            this.styledText.setStyleRange(styleRange);
            ++n;
        }
    }
}

