/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ConfigurationInfo;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutUtils;
import org.eclipse.ui.internal.about.ProductInfoPage;
import org.eclipse.ui.progress.WorkbenchJob;

public final class AboutSystemPage
extends ProductInfoPage {
    private static final String ID = "productInfo.system";
    private static final int BROWSE_ERROR_LOG_BUTTON = 1024;
    private static final int COPY_TO_CLIPBOARD_BUTTON = 1025;
    private Text text;

    public void createControl(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.system_summary_dialog_context");
        Composite composite2 = this.createOuterComposite(composite);
        this.text = new Text(composite2, 527114);
        this.text.setBackground(composite.getDisplay().getSystemColor(25));
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.convertVerticalDLUsToPixels(300);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        this.text.setLayoutData((Object)gridData);
        this.text.setFont(JFaceResources.getTextFont());
        this.fetchConfigurationInfo(this.text);
        this.setControl((Control)composite2);
    }

    @Override
    public void createPageButtons(Composite composite) {
        Button button = this.createButton(composite, 1024, WorkbenchMessages.AboutSystemDialog_browseErrorLogName);
        String string = Platform.getLogFileLocation().toOSString();
        button.setEnabled(new File(string).exists());
        this.createButton(composite, 1025, WorkbenchMessages.AboutSystemDialog_copyToClipboardName);
    }

    @Override
    String getId() {
        return ID;
    }

    public void copyToClipboard() {
        if (this.text == null) {
            return;
        }
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.text.getShell().getDisplay());
            String string = this.text.getSelectionText();
            if (string.length() == 0) {
                string = this.text.getText();
            }
            clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    @Override
    protected void buttonPressed(int n) {
        switch (n) {
            case 1024: {
                this.openErrorLogBrowser();
                break;
            }
            case 1025: {
                this.runCopyToClipboard();
            }
        }
        super.buttonPressed(n);
    }

    private void openErrorLogBrowser() {
        AboutUtils.openErrorLogBrowser(this.getShell());
    }

    private void runCopyToClipboard() {
        if (this.text == null) {
            return;
        }
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.getShell().getDisplay());
            clipboard.setContents(new Object[]{this.text.getText()}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    private void fetchConfigurationInfo(final Text text) {
        text.setText(WorkbenchMessages.AboutSystemPage_RetrievingSystemInfo);
        WorkbenchJob workbenchJob = new WorkbenchJob(WorkbenchMessages.AboutSystemPage_FetchJobTitle){

            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                String string = ConfigurationInfo.getSystemSummary();
                if (!text.isDisposed()) {
                    text.setText(string);
                }
                return Status.OK_STATUS;
            }
        };
        workbenchJob.schedule();
    }
}

