/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.ConfigureColumns;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.internal.about.AboutUtils;
import org.eclipse.ui.internal.about.BundleSigningInfo;
import org.eclipse.ui.internal.about.ProductInfoPage;
import org.eclipse.ui.internal.about.TableComparator;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.Bundle;

public class AboutPluginsPage
extends ProductInfoPage {
    private static final String ID = "productInfo.plugins";
    private static final int TABLE_HEIGHT = 200;
    private static final int MORE_ID = 1025;
    private static final int SIGNING_ID = 1026;
    private static final int COLUMNS_ID = 1027;
    private static final IPath baseNLPath = new Path("$nl$");
    private static final String PLUGININFO = "about.html";
    private static final int PLUGIN_NAME_COLUMN_INDEX = 2;
    private static final int SIGNING_AREA_PERCENTAGE = 30;
    private TableViewer vendorInfo;
    private Button moreInfo;
    private Button signingInfo;
    private String message;
    private String helpContextId = "org.eclipse.ui.about_plugins_dialog_context";
    private String[] columnTitles = new String[]{WorkbenchMessages.AboutPluginsDialog_signed, WorkbenchMessages.AboutPluginsDialog_provider, WorkbenchMessages.AboutPluginsDialog_pluginName, WorkbenchMessages.AboutPluginsDialog_version, WorkbenchMessages.AboutPluginsDialog_pluginId};
    private Bundle[] bundles = WorkbenchPlugin.getDefault().getBundles();
    private AboutBundleData[] bundleInfos;
    private SashForm sashForm;
    private BundleSigningInfo signingArea;

    public void setBundles(Bundle[] bundleArray) {
        this.bundles = bundleArray;
    }

    public void setHelpContextId(String string) {
        this.helpContextId = string;
    }

    @Override
    public void setMessage(String string) {
        this.message = string;
    }

    protected void handleSigningInfoPressed() {
        if (this.signingArea == null) {
            this.signingArea = new BundleSigningInfo();
            AboutBundleData aboutBundleData = (AboutBundleData)((IStructuredSelection)this.vendorInfo.getSelection()).getFirstElement();
            this.signingArea.setData(aboutBundleData);
            this.signingArea.createContents((Composite)this.sashForm);
            this.sashForm.setWeights(new int[]{70, 30});
            this.signingInfo.setText(WorkbenchMessages.AboutPluginsDialog_signingInfo_hide);
        } else {
            this.signingInfo.setText(WorkbenchMessages.AboutPluginsDialog_signingInfo_show);
            this.signingArea.dispose();
            this.signingArea = null;
            this.sashForm.setWeights(new int[]{100});
        }
    }

    @Override
    public void createPageButtons(Composite composite) {
        this.moreInfo = this.createButton(composite, 1025, WorkbenchMessages.AboutPluginsDialog_moreInfo);
        this.moreInfo.setEnabled(false);
        this.signingInfo = this.createButton(composite, 1026, WorkbenchMessages.AboutPluginsDialog_signingInfo_show);
        this.signingInfo.setEnabled(false);
        this.createButton(composite, 1027, WorkbenchMessages.AboutPluginsDialog_columns);
    }

    public void createControl(Composite composite) {
        AboutBundleData aboutBundleData;
        this.initializeDialogUnits((Control)composite);
        HashMap<String, AboutBundleData> hashMap = new HashMap<String, AboutBundleData>();
        int n = 0;
        while (n < this.bundles.length) {
            aboutBundleData = new AboutBundleData(this.bundles[n]);
            if (BundleUtility.isReady(aboutBundleData.getState()) && !hashMap.containsKey(aboutBundleData.getVersionedId())) {
                hashMap.put(aboutBundleData.getVersionedId(), aboutBundleData);
            }
            ++n;
        }
        this.bundleInfos = hashMap.values().toArray(new AboutBundleData[0]);
        WorkbenchPlugin.class.getSigners();
        this.sashForm = new SashForm(composite, 65792);
        FillLayout fillLayout = new FillLayout();
        this.sashForm.setLayout((Layout)fillLayout);
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        aboutBundleData = new GridData(1808);
        this.sashForm.setLayoutData((Object)aboutBundleData);
        Composite composite2 = this.createOuterComposite((Composite)this.sashForm);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, this.helpContextId);
        if (this.message != null) {
            Label label = new Label(composite2, 0);
            label.setLayoutData((Object)new GridData(768));
            label.setFont(composite.getFont());
            label.setText(this.message);
        }
        this.createTable(composite2);
        this.setControl((Control)composite2);
    }

    protected void createTable(Composite composite) {
        this.vendorInfo = new TableViewer(composite, 68356);
        this.vendorInfo.setUseHashlookup(true);
        this.vendorInfo.getTable().setHeaderVisible(true);
        this.vendorInfo.getTable().setLinesVisible(true);
        this.vendorInfo.getTable().setFont(composite.getFont());
        this.vendorInfo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                AboutPluginsPage.this.checkEnablement();
            }
        });
        TableComparator tableComparator = new TableComparator();
        this.vendorInfo.setComparator((ViewerComparator)tableComparator);
        int[] nArray = new int[]{this.convertHorizontalDLUsToPixels(30), this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(70), this.convertHorizontalDLUsToPixels(130)};
        int n = 0;
        while (n < this.columnTitles.length) {
            TableColumn tableColumn = new TableColumn(this.vendorInfo.getTable(), 0);
            if (n == 2) {
                this.updateTableSorting(n);
            }
            tableColumn.setWidth(nArray[n]);
            tableColumn.setText(this.columnTitles[n]);
            final int n2 = n++;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AboutPluginsPage.this.updateTableSorting(n2);
                }
            });
        }
        this.vendorInfo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.vendorInfo.setLabelProvider((IBaseLabelProvider)new BundleTableLabelProvider());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertVerticalDLUsToPixels(200);
        this.vendorInfo.getTable().setLayoutData((Object)gridData);
        this.vendorInfo.setInput((Object)this.bundleInfos);
    }

    private void updateTableSorting(int n) {
        TableComparator tableComparator = (TableComparator)this.vendorInfo.getComparator();
        if (n == tableComparator.getSortColumn()) {
            tableComparator.setAscending(!tableComparator.isAscending());
        }
        tableComparator.setSortColumn(n);
        this.vendorInfo.getTable().setSortColumn(this.vendorInfo.getTable().getColumn(n));
        this.vendorInfo.getTable().setSortDirection(tableComparator.isAscending() ? 128 : 1024);
        this.vendorInfo.refresh(false);
    }

    private URL getMoreInfoURL(AboutBundleData aboutBundleData, boolean bl) {
        Bundle bundle = Platform.getBundle((String)aboutBundleData.getId());
        if (bundle == null) {
            return null;
        }
        URL uRL = Platform.find((Bundle)bundle, (IPath)baseNLPath.append(PLUGININFO), null);
        if (!bl) {
            return uRL;
        }
        if (uRL != null) {
            try {
                URL uRL2 = Platform.asLocalURL((URL)uRL);
                try {
                    URL uRL3 = new URL(uRL, "about_files");
                    if (uRL3 != null) {
                        Platform.asLocalURL((URL)uRL3);
                    }
                }
                catch (IOException iOException) {}
                return uRL2;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    @Override
    String getId() {
        return ID;
    }

    private void checkEnablement() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.vendorInfo.getSelection();
        if (iStructuredSelection.getFirstElement() instanceof AboutBundleData) {
            AboutBundleData aboutBundleData = (AboutBundleData)iStructuredSelection.getFirstElement();
            this.moreInfo.setEnabled(this.selectionHasInfo(aboutBundleData));
            this.signingInfo.setEnabled(true);
            if (this.signingArea != null) {
                this.signingArea.setData(aboutBundleData);
            }
        } else {
            this.signingInfo.setEnabled(false);
            this.moreInfo.setEnabled(false);
        }
    }

    @Override
    protected void buttonPressed(int n) {
        switch (n) {
            case 1025: {
                this.handleMoreInfoPressed();
                break;
            }
            case 1026: {
                this.handleSigningInfoPressed();
                break;
            }
            case 1027: {
                this.handleColumnsPressed();
                break;
            }
            default: {
                super.buttonPressed(n);
            }
        }
    }

    private boolean selectionHasInfo(AboutBundleData aboutBundleData) {
        URL uRL = this.getMoreInfoURL(aboutBundleData, false);
        if (uRL == null && WorkbenchPlugin.DEBUG) {
            WorkbenchPlugin.log("Problem reading plugin info for: " + aboutBundleData.getName());
        }
        return uRL != null;
    }

    protected void handleMoreInfoPressed() {
        if (this.vendorInfo == null) {
            return;
        }
        if (this.vendorInfo.getSelection().isEmpty()) {
            return;
        }
        AboutBundleData aboutBundleData = (AboutBundleData)((IStructuredSelection)this.vendorInfo.getSelection()).getFirstElement();
        if (!AboutUtils.openBrowser(this.getShell(), this.getMoreInfoURL(aboutBundleData, true))) {
            String string = NLS.bind((String)WorkbenchMessages.AboutPluginsDialog_unableToOpenFile, (Object)PLUGININFO, (Object)aboutBundleData.getId());
            StatusUtil.handleStatus(String.valueOf(WorkbenchMessages.AboutPluginsDialog_errorTitle) + ": " + string, 2, this.getShell());
        }
    }

    private void handleColumnsPressed() {
        ConfigureColumns.forTable((Table)this.vendorInfo.getTable(), (IShellProvider)this);
    }

    public class BundleTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private LinkedList resolveQueue = new LinkedList();
        private List updateQueue = new ArrayList();
        private Job resolveJob = new Job(AboutPluginsPage.class.getName()){
            {
                this.setSystem(true);
                this.setPriority(20);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor iProgressMonitor) {
                while (AboutPluginsPage.this.vendorInfo != null) {
                    Table table = AboutPluginsPage.this.vendorInfo.getTable();
                    if (table == null || table.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    AboutBundleData aboutBundleData = null;
                    List list = BundleTableLabelProvider.this.resolveQueue;
                    synchronized (list) {
                        if (BundleTableLabelProvider.this.resolveQueue.isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        aboutBundleData = (AboutBundleData)BundleTableLabelProvider.this.resolveQueue.removeFirst();
                    }
                    try {
                        aboutBundleData.isSigned();
                        list = BundleTableLabelProvider.this.updateQueue;
                        synchronized (list) {
                            BundleTableLabelProvider.this.updateQueue.add(aboutBundleData);
                        }
                        BundleTableLabelProvider.this.updateJob.schedule();
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        continue;
                    }
                    break;
                }
                return Status.OK_STATUS;
            }
        };
        private Job updateJob = new WorkbenchJob(PlatformUI.getWorkbench().getDisplay(), AboutPluginsPage.class.getName()){
            {
                this.setSystem(true);
                this.setPriority(50);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                Control control;
                while ((control = AboutPluginsPage.this.getControl()) != null && !control.isDisposed()) {
                    Object[] objectArray = null;
                    List list = BundleTableLabelProvider.this.updateQueue;
                    synchronized (list) {
                        if (BundleTableLabelProvider.this.updateQueue.isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        objectArray = BundleTableLabelProvider.this.updateQueue.toArray(new AboutBundleData[BundleTableLabelProvider.this.updateQueue.size()]);
                        BundleTableLabelProvider.this.updateQueue.clear();
                    }
                    BundleTableLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BundleTableLabelProvider.this, objectArray));
                }
                return Status.OK_STATUS;
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image getColumnImage(Object object, int n) {
            if (n == 0 && object instanceof AboutBundleData) {
                AboutBundleData aboutBundleData = (AboutBundleData)object;
                if (aboutBundleData.isSignedDetermined()) {
                    return WorkbenchImages.getImage(aboutBundleData.isSigned() ? "IMG_OBJ_SIGNED_YES" : "IMG_OBJ_SIGNED_NO");
                }
                LinkedList linkedList = this.resolveQueue;
                synchronized (linkedList) {
                    this.resolveQueue.add(aboutBundleData);
                }
                this.resolveJob.schedule();
                return WorkbenchImages.getImage("IMG_OBJ_SIGNED_UNKNOWN");
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof AboutBundleData) {
                AboutBundleData aboutBundleData = (AboutBundleData)object;
                switch (n) {
                    case 1: {
                        return aboutBundleData.getProviderName();
                    }
                    case 2: {
                        return aboutBundleData.getName();
                    }
                    case 3: {
                        return aboutBundleData.getVersion();
                    }
                    case 4: {
                        return aboutBundleData.getId();
                    }
                }
            }
            return "";
        }
    }
}

