/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ConfigureColumns;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutBundleGroupData;
import org.eclipse.ui.internal.about.AboutData;
import org.eclipse.ui.internal.about.AboutTextManager;
import org.eclipse.ui.internal.about.AboutUtils;
import org.eclipse.ui.internal.about.ProductInfoPage;
import org.eclipse.ui.internal.dialogs.AboutPluginsDialog;
import org.osgi.framework.Bundle;

public class AboutFeaturesPage
extends ProductInfoPage {
    private static final String ID = "productInfo.features";
    private static final int TABLE_HEIGHT = 150;
    private static final int INFO_HEIGHT = 100;
    private static final int MORE_ID = 1025;
    private static final int PLUGINS_ID = 1026;
    private static final int COLUMNS_ID = 1027;
    private Table table;
    private Label imageLabel;
    private StyledText text;
    private AboutTextManager textManager;
    private Composite infoArea;
    private Map cachedImages = new HashMap();
    private AboutBundleGroupData[] bundleGroupInfos;
    private String[] columnTitles = new String[]{WorkbenchMessages.AboutFeaturesDialog_provider, WorkbenchMessages.AboutFeaturesDialog_featureName, WorkbenchMessages.AboutFeaturesDialog_version, WorkbenchMessages.AboutFeaturesDialog_featureId};
    private int lastColumnChosen = 0;
    private boolean reverseSort = false;
    private AboutBundleGroupData lastSelection = null;
    private Button pluginsButton;
    private Button moreButton;
    private static Map featuresMap;

    public void setBundleGroupInfos(AboutBundleGroupData[] aboutBundleGroupDataArray) {
        this.bundleGroupInfos = aboutBundleGroupDataArray;
    }

    @Override
    String getId() {
        return ID;
    }

    private void initializeBundleGroupInfos() {
        if (this.bundleGroupInfos == null) {
            IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
            LinkedList<AboutBundleGroupData> linkedList = new LinkedList<AboutBundleGroupData>();
            if (iBundleGroupProviderArray != null) {
                int n = 0;
                while (n < iBundleGroupProviderArray.length) {
                    IBundleGroup[] iBundleGroupArray = iBundleGroupProviderArray[n].getBundleGroups();
                    int n2 = 0;
                    while (n2 < iBundleGroupArray.length) {
                        linkedList.add(new AboutBundleGroupData(iBundleGroupArray[n2]));
                        ++n2;
                    }
                    ++n;
                }
            }
            this.bundleGroupInfos = linkedList.toArray(new AboutBundleGroupData[0]);
        } else {
            AboutBundleGroupData[] aboutBundleGroupDataArray = this.bundleGroupInfos;
            this.bundleGroupInfos = new AboutBundleGroupData[aboutBundleGroupDataArray.length];
            System.arraycopy(aboutBundleGroupDataArray, 0, this.bundleGroupInfos, 0, aboutBundleGroupDataArray.length);
        }
        AboutData.sortByProvider(this.reverseSort, this.bundleGroupInfos);
    }

    private void handlePluginInfoPressed() {
        TableItem[] tableItemArray = this.table.getSelection();
        if (tableItemArray.length <= 0) {
            return;
        }
        AboutBundleGroupData aboutBundleGroupData = (AboutBundleGroupData)tableItemArray[0].getData();
        IBundleGroup iBundleGroup = aboutBundleGroupData.getBundleGroup();
        Bundle[] bundleArray = iBundleGroup == null ? new Bundle[]{} : iBundleGroup.getBundles();
        AboutPluginsDialog aboutPluginsDialog = new AboutPluginsDialog(this.getShell(), this.getProductName(), bundleArray, WorkbenchMessages.AboutFeaturesDialog_pluginInfoTitle, NLS.bind((String)WorkbenchMessages.AboutFeaturesDialog_pluginInfoMessage, (Object)iBundleGroup.getIdentifier()), "org.eclipse.ui.about_features_plugins_dialog_context");
        aboutPluginsDialog.open();
    }

    @Override
    public void createPageButtons(Composite composite) {
        this.moreButton = this.createButton(composite, 1025, WorkbenchMessages.AboutFeaturesDialog_moreInfo);
        this.pluginsButton = this.createButton(composite, 1026, WorkbenchMessages.AboutFeaturesDialog_pluginsInfo);
        this.createButton(composite, 1027, WorkbenchMessages.AboutFeaturesDialog_columns);
        TableItem[] tableItemArray = this.table.getSelection();
        if (tableItemArray.length > 0) {
            this.updateButtons((AboutBundleGroupData)tableItemArray[0].getData());
        }
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        composite.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AboutFeaturesPage.this.disposeImages();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.about_features_dialog_context");
        Composite composite2 = this.createOuterComposite(composite);
        this.createTable(composite2);
        this.createInfoArea(composite2);
        this.setControl((Control)composite2);
    }

    protected void createInfoArea(Composite composite) {
        Font font = composite.getFont();
        this.infoArea = new Composite(composite, 2048);
        this.infoArea.setBackground(this.infoArea.getDisplay().getSystemColor(25));
        this.infoArea.setBackgroundMode(2);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = this.convertVerticalDLUsToPixels(100);
        this.infoArea.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.infoArea.setLayout((Layout)gridLayout);
        this.imageLabel = new Label(this.infoArea, 0);
        gridData = new GridData(4, 1, false, false);
        gridData.widthHint = 32;
        gridData.heightHint = 32;
        this.imageLabel.setLayoutData((Object)gridData);
        this.imageLabel.setFont(font);
        this.text = new StyledText(this.infoArea, 586);
        this.text.setAlwaysShowScrollBars(false);
        this.text.setFont(composite.getFont());
        gridData = new GridData(4, 4, true, true);
        this.text.setLayoutData((Object)gridData);
        this.text.setFont(font);
        this.text.setCursor(null);
        this.textManager = new AboutTextManager(this.text);
        TableItem[] tableItemArray = this.table.getSelection();
        if (tableItemArray.length > 0) {
            this.updateInfoArea((AboutBundleGroupData)tableItemArray[0].getData());
        }
    }

    protected void createTable(Composite composite) {
        int n;
        this.initializeBundleGroupInfos();
        this.table = new Table(composite, 68356);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertVerticalDLUsToPixels(150);
        this.table.setLayoutData((Object)gridData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(composite.getFont());
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.item == null) {
                    return;
                }
                AboutBundleGroupData aboutBundleGroupData = (AboutBundleGroupData)selectionEvent.item.getData();
                AboutFeaturesPage.this.updateInfoArea(aboutBundleGroupData);
                AboutFeaturesPage.this.updateButtons(aboutBundleGroupData);
            }
        });
        int[] nArray = new int[]{this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(70), this.convertHorizontalDLUsToPixels(130)};
        int n2 = 0;
        while (n2 < this.columnTitles.length) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setWidth(nArray[n2]);
            tableColumn.setText(this.columnTitles[n2]);
            n = n2++;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AboutFeaturesPage.this.sort(n);
                }
            });
        }
        String string = this.lastSelection == null ? null : this.lastSelection.getId();
        int n3 = 0;
        n = 0;
        while (n < this.bundleGroupInfos.length) {
            if (this.bundleGroupInfos[n].getId().equals(string)) {
                n3 = n;
            }
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(AboutFeaturesPage.createRow(this.bundleGroupInfos[n]));
            tableItem.setData((Object)this.bundleGroupInfos[n]);
            ++n;
        }
        if (this.bundleGroupInfos.length > 0) {
            this.table.setSelection(n3);
            this.table.showSelection();
        }
    }

    private void disposeImages() {
        for (Image image : this.cachedImages.values()) {
            image.dispose();
        }
    }

    private void updateButtons(AboutBundleGroupData aboutBundleGroupData) {
        if (aboutBundleGroupData == null) {
            this.moreButton.setEnabled(false);
            this.pluginsButton.setEnabled(false);
            return;
        }
        if (featuresMap == null) {
            this.moreButton.setEnabled(true);
            this.pluginsButton.setEnabled(true);
            return;
        }
        this.moreButton.setEnabled(aboutBundleGroupData.getLicenseUrl() != null);
        this.pluginsButton.setEnabled(true);
    }

    private void updateInfoArea(AboutBundleGroupData aboutBundleGroupData) {
        if (aboutBundleGroupData == null) {
            this.imageLabel.setImage(null);
            this.text.setText("");
            return;
        }
        ImageDescriptor imageDescriptor = aboutBundleGroupData.getFeatureImage();
        Image image = (Image)this.cachedImages.get(imageDescriptor);
        if (image == null && imageDescriptor != null) {
            image = imageDescriptor.createImage();
            this.cachedImages.put(imageDescriptor, image);
        }
        this.imageLabel.setImage(image);
        String string = aboutBundleGroupData.getAboutText();
        this.textManager.setItem(null);
        if (string != null) {
            this.textManager.setItem(AboutUtils.scan(string));
        }
        if (this.textManager.getItem() == null) {
            this.text.setText(WorkbenchMessages.AboutFeaturesDialog_noInformation);
        }
    }

    public void setInitialSelection(AboutBundleGroupData aboutBundleGroupData) {
        this.lastSelection = aboutBundleGroupData;
    }

    private void sort(int n) {
        if (this.lastColumnChosen == n) {
            this.reverseSort = !this.reverseSort;
        } else {
            this.reverseSort = false;
            this.lastColumnChosen = n;
        }
        if (this.table.getItemCount() <= 1) {
            return;
        }
        int n2 = this.table.getSelectionIndex();
        if (n2 != -1) {
            this.lastSelection = this.bundleGroupInfos[n2];
        }
        switch (n) {
            case 0: {
                AboutData.sortByProvider(this.reverseSort, this.bundleGroupInfos);
                break;
            }
            case 1: {
                AboutData.sortByName(this.reverseSort, this.bundleGroupInfos);
                break;
            }
            case 2: {
                AboutData.sortByVersion(this.reverseSort, this.bundleGroupInfos);
                break;
            }
            case 3: {
                AboutData.sortById(this.reverseSort, this.bundleGroupInfos);
            }
        }
        this.table.setSortColumn(this.table.getColumn(n));
        this.table.setSortDirection(this.reverseSort ? 1024 : 128);
        this.refreshTable();
    }

    private void refreshTable() {
        TableItem[] tableItemArray = this.table.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            tableItemArray[n].setText(AboutFeaturesPage.createRow(this.bundleGroupInfos[n]));
            tableItemArray[n].setData((Object)this.bundleGroupInfos[n]);
            ++n;
        }
        n = -1;
        if (this.lastSelection != null) {
            String string = this.lastSelection.getId();
            int n2 = 0;
            while (n2 < this.bundleGroupInfos.length) {
                if (string.equalsIgnoreCase(this.bundleGroupInfos[n2].getId())) {
                    n = n2;
                }
                ++n2;
            }
            this.table.setSelection(n);
            this.table.showSelection();
        }
        this.updateInfoArea(this.lastSelection);
    }

    private static String[] createRow(AboutBundleGroupData aboutBundleGroupData) {
        return new String[]{aboutBundleGroupData.getProviderName(), aboutBundleGroupData.getName(), aboutBundleGroupData.getVersion(), aboutBundleGroupData.getId()};
    }

    protected Collection getSelectionValue() {
        if (this.table == null || this.table.isDisposed()) {
            return null;
        }
        TableItem[] tableItemArray = this.table.getSelection();
        if (tableItemArray.length <= 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(tableItemArray[0].getData());
        return arrayList;
    }

    private void handleColumnsPressed() {
        ConfigureColumns.forTable((Table)this.table, (IShellProvider)this);
    }

    private void handleMoreInfoPressed() {
        TableItem[] tableItemArray = this.table.getSelection();
        if (tableItemArray.length <= 0) {
            return;
        }
        AboutBundleGroupData aboutBundleGroupData = (AboutBundleGroupData)tableItemArray[0].getData();
        if (aboutBundleGroupData == null || !AboutUtils.openBrowser(this.getShell(), aboutBundleGroupData.getLicenseUrl())) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchMessages.AboutFeaturesDialog_noInfoTitle, (String)WorkbenchMessages.AboutFeaturesDialog_noInformation);
        }
    }

    @Override
    protected void buttonPressed(int n) {
        switch (n) {
            case 1025: {
                this.handleMoreInfoPressed();
                break;
            }
            case 1026: {
                this.handlePluginInfoPressed();
                break;
            }
            case 1027: {
                this.handleColumnsPressed();
                break;
            }
            default: {
                super.buttonPressed(n);
            }
        }
    }
}

