/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class AboutData {
    private String providerName;
    private String name;
    private String version;
    private String id;
    private String versionedId = null;

    protected AboutData(String string, String string2, String string3, String string4) {
        this.providerName = string == null ? "" : string;
        this.name = string2 == null ? "" : string2;
        this.version = string3 == null ? "" : string3;
        this.id = string4 == null ? "" : string4;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionedId() {
        if (this.versionedId == null) {
            this.versionedId = String.valueOf(this.getId()) + "_" + this.getVersion();
        }
        return this.versionedId;
    }

    private static void reverse(AboutData[] aboutDataArray) {
        List<AboutData> list = Arrays.asList(aboutDataArray);
        Collections.reverse(list);
        int n = 0;
        while (n < aboutDataArray.length) {
            aboutDataArray[n] = list.get(n);
            ++n;
        }
    }

    public static void sortByProvider(boolean bl, AboutData[] aboutDataArray) {
        if (bl) {
            AboutData.reverse(aboutDataArray);
            return;
        }
        Arrays.sort(aboutDataArray, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object object, Object object2) {
                String string;
                AboutData aboutData = (AboutData)object;
                AboutData aboutData2 = (AboutData)object2;
                String string2 = aboutData.getProviderName();
                if (!string2.equals(string = aboutData2.getProviderName())) {
                    return this.collator.compare(string2, string);
                }
                return this.collator.compare(aboutData.getName(), aboutData2.getName());
            }
        });
    }

    public static void sortByName(boolean bl, AboutData[] aboutDataArray) {
        if (bl) {
            AboutData.reverse(aboutDataArray);
            return;
        }
        Arrays.sort(aboutDataArray, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object object, Object object2) {
                AboutData aboutData = (AboutData)object;
                AboutData aboutData2 = (AboutData)object2;
                return this.collator.compare(aboutData.getName(), aboutData2.getName());
            }
        });
    }

    public static void sortByVersion(boolean bl, AboutData[] aboutDataArray) {
        if (bl) {
            AboutData.reverse(aboutDataArray);
            return;
        }
        Arrays.sort(aboutDataArray, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object object, Object object2) {
                String string;
                AboutData aboutData = (AboutData)object;
                AboutData aboutData2 = (AboutData)object2;
                String string2 = aboutData.getVersion();
                if (!string2.equals(string = aboutData2.getVersion())) {
                    return this.collator.compare(string2, string);
                }
                return this.collator.compare(aboutData.getName(), aboutData2.getName());
            }
        });
    }

    public static void sortById(boolean bl, AboutData[] aboutDataArray) {
        if (bl) {
            AboutData.reverse(aboutDataArray);
            return;
        }
        Arrays.sort(aboutDataArray, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object object, Object object2) {
                String string;
                AboutData aboutData = (AboutData)object;
                AboutData aboutData2 = (AboutData)object2;
                String string2 = aboutData.getId();
                if (!string2.equals(string = aboutData2.getId())) {
                    return this.collator.compare(string2, string);
                }
                return this.collator.compare(aboutData.getName(), aboutData2.getName());
            }
        });
    }

    protected static URL getURL(String string) {
        try {
            if (string != null) {
                return new URL(string);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    protected static ImageDescriptor getImage(URL uRL) {
        return uRL == null ? null : ImageDescriptor.createFromURL((URL)uRL);
    }

    protected static ImageDescriptor getImage(String string) {
        return AboutData.getImage(AboutData.getURL(string));
    }
}

