/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class AboutBundleData
extends AboutData {
    private Bundle bundle;
    private boolean isSignedDetermined = false;
    private boolean isSigned;

    public AboutBundleData(Bundle bundle) {
        super(AboutBundleData.getResourceString(bundle, "Bundle-Vendor"), AboutBundleData.getResourceString(bundle, "Bundle-Name"), AboutBundleData.getResourceString(bundle, "Bundle-Version"), bundle.getSymbolicName());
        this.bundle = bundle;
    }

    public int getState() {
        return this.bundle.getState();
    }

    public String getStateName() {
        switch (this.getState()) {
            case 2: {
                return WorkbenchMessages.AboutPluginsDialog_state_installed;
            }
            case 4: {
                return WorkbenchMessages.AboutPluginsDialog_state_resolved;
            }
            case 8: {
                return WorkbenchMessages.AboutPluginsDialog_state_starting;
            }
            case 16: {
                return WorkbenchMessages.AboutPluginsDialog_state_stopping;
            }
            case 1: {
                return WorkbenchMessages.AboutPluginsDialog_state_uninstalled;
            }
            case 32: {
                return WorkbenchMessages.AboutPluginsDialog_state_active;
            }
        }
        return WorkbenchMessages.AboutPluginsDialog_state_unknown;
    }

    private static String getResourceString(Bundle bundle, String string) {
        String string2 = (String)bundle.getHeaders().get(string);
        return string2 == null ? null : Platform.getResourceString((Bundle)bundle, (String)string2);
    }

    public boolean isSignedDetermined() {
        return this.isSignedDetermined;
    }

    public boolean isSigned() throws IllegalStateException {
        if (this.isSignedDetermined) {
            return this.isSigned;
        }
        BundleContext bundleContext = WorkbenchPlugin.getDefault().getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(SignedContentFactory.class.getName());
        if (serviceReference == null) {
            throw new IllegalStateException();
        }
        SignedContentFactory signedContentFactory = (SignedContentFactory)bundleContext.getService(serviceReference);
        try {
            try {
                this.isSignedDetermined = true;
                SignedContent signedContent = signedContentFactory.getSignedContent(this.bundle);
                this.isSigned = signedContent != null && signedContent.isSigned();
            }
            catch (IOException iOException) {
                this.isSigned = false;
                bundleContext.ungetService(serviceReference);
            }
            catch (GeneralSecurityException generalSecurityException) {
                this.isSigned = false;
                bundleContext.ungetService(serviceReference);
            }
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
        return this.isSigned;
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

