/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;

public class WorkingSetMenuContributionItem
extends ContributionItem {
    private Image image;
    private int id;
    private IWorkingSet workingSet;
    private WorkingSetFilterActionGroup actionGroup;

    public static String getId(int n) {
        return String.valueOf(WorkingSetMenuContributionItem.class.getName()) + "." + n;
    }

    public WorkingSetMenuContributionItem(int n, WorkingSetFilterActionGroup workingSetFilterActionGroup, IWorkingSet iWorkingSet) {
        super(WorkingSetMenuContributionItem.getId(n));
        Assert.isNotNull((Object)workingSetFilterActionGroup);
        Assert.isNotNull((Object)iWorkingSet);
        this.id = n;
        this.actionGroup = workingSetFilterActionGroup;
        this.workingSet = iWorkingSet;
    }

    public void fill(Menu menu, int n) {
        ImageDescriptor imageDescriptor;
        MenuItem menuItem = new MenuItem(menu, 16, n);
        menuItem.setText("&" + this.id + " " + this.workingSet.getLabel());
        menuItem.setSelection(this.workingSet.equals(this.actionGroup.getWorkingSet()));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                WorkingSetMenuContributionItem.this.actionGroup.setWorkingSet(WorkingSetMenuContributionItem.this.workingSet);
                iWorkingSetManager.addRecentWorkingSet(WorkingSetMenuContributionItem.this.workingSet);
            }
        });
        if (this.image == null && (imageDescriptor = this.workingSet.getImageDescriptor()) != null) {
            this.image = imageDescriptor.createImage();
        }
        menuItem.setImage(this.image);
    }

    public boolean isDynamic() {
        return true;
    }

    public void dispose() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = null;
        super.dispose();
    }
}

