/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.AbstractWorkingSetManager;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;

public class WorkingSetManager
extends AbstractWorkingSetManager
implements IWorkingSetManager,
BundleListener {
    public static final String WORKING_SET_STATE_FILENAME = "workingsets.xml";
    private boolean restoreInProgress;
    private boolean savePending;

    public WorkingSetManager(BundleContext bundleContext) {
        super(bundleContext);
    }

    @Override
    public void addRecentWorkingSet(IWorkingSet iWorkingSet) {
        this.internalAddRecentWorkingSet(iWorkingSet);
        this.saveState();
    }

    @Override
    public void addWorkingSet(IWorkingSet iWorkingSet) {
        super.addWorkingSet(iWorkingSet);
        this.saveState();
    }

    private File getWorkingSetStateFile() {
        IPath iPath = WorkbenchPlugin.getDefault().getDataLocation();
        if (iPath == null) {
            return null;
        }
        iPath = iPath.append(WORKING_SET_STATE_FILENAME);
        return iPath.toFile();
    }

    @Override
    public void removeWorkingSet(IWorkingSet iWorkingSet) {
        if (this.internalRemoveWorkingSet(iWorkingSet)) {
            this.saveState();
        }
    }

    public void restoreState() {
        block9: {
            File file = this.getWorkingSetStateFile();
            if (file != null && file.exists()) {
                block8: {
                    try {
                        this.restoreInProgress = true;
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
                        XMLMemento xMLMemento = XMLMemento.createReadRoot(bufferedReader);
                        this.restoreWorkingSetState(xMLMemento);
                        this.restoreMruList(xMLMemento);
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        this.handleInternalError(iOException, WorkbenchMessages.ProblemRestoringWorkingSetState_title, WorkbenchMessages.ProblemRestoringWorkingSetState_message);
                        this.restoreInProgress = false;
                        break block8;
                    }
                    catch (WorkbenchException workbenchException) {
                        try {
                            this.handleInternalError((Exception)((Object)workbenchException), WorkbenchMessages.ProblemRestoringWorkingSetState_title, WorkbenchMessages.ProblemRestoringWorkingSetState_message);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.restoreInProgress = false;
                        }
                    }
                    this.restoreInProgress = false;
                }
                if (!this.savePending) break block9;
                this.saveState();
                this.savePending = false;
            }
        }
    }

    private void saveState() {
        if (this.restoreInProgress) {
            this.savePending = true;
            return;
        }
        File file = this.getWorkingSetStateFile();
        if (file == null) {
            return;
        }
        try {
            this.saveState(file);
        }
        catch (IOException iOException) {
            file.delete();
            this.handleInternalError(iOException, WorkbenchMessages.ProblemSavingWorkingSetState_title, WorkbenchMessages.ProblemSavingWorkingSetState_message);
        }
    }

    @Override
    public void workingSetChanged(IWorkingSet iWorkingSet, String string, Object object) {
        this.saveState();
        super.workingSetChanged(iWorkingSet, string, object);
    }

    private void handleInternalError(Exception exception, String string, String string2) {
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, string2, (Throwable)exception);
        StatusAdapter statusAdapter = new StatusAdapter((IStatus)status);
        statusAdapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, string);
        StatusManager.getManager().handle(statusAdapter, 1);
    }
}

