/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AbstractWorkingSet;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkingSetManager;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.internal.util.Util;

public class WorkingSet
extends AbstractWorkingSet {
    private static final String DEFAULT_ID = "org.eclipse.ui.resourceWorkingSetPage";
    private String editPageId;

    public WorkingSet(String string, String string2, IAdaptable[] iAdaptableArray) {
        super(string, string2);
        this.internalSetElements(iAdaptableArray);
    }

    protected WorkingSet(String string, String string2, IMemento iMemento) {
        super(string, string2);
        String string3;
        this.workingSetMemento = iMemento;
        if (this.workingSetMemento != null && (string3 = this.workingSetMemento.getString("id")) != null) {
            this.setUniqueId(string3);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WorkingSet) {
            WorkingSet workingSet = (WorkingSet)object;
            return Util.equals(workingSet.getName(), this.getName()) && Util.equals(workingSet.getElementsArray(), this.getElementsArray()) && Util.equals(workingSet.getId(), this.getId());
        }
        return false;
    }

    @Override
    public boolean isEditable() {
        WorkingSetDescriptor workingSetDescriptor = this.getDescriptor(null);
        return workingSetDescriptor != null && workingSetDescriptor.isEditable();
    }

    @Override
    public String getId() {
        return this.editPageId;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        WorkingSetDescriptor workingSetDescriptor = this.getDescriptor(DEFAULT_ID);
        if (workingSetDescriptor == null) {
            return null;
        }
        return workingSetDescriptor.getIcon();
    }

    public int hashCode() {
        int n = this.getName().hashCode();
        if (this.editPageId != null) {
            n &= this.editPageId.hashCode();
        }
        return n;
    }

    @Override
    void restoreWorkingSet() {
        IMemento[] iMementoArray = this.workingSetMemento.getChildren("item");
        final HashSet hashSet = new HashSet();
        int n = 0;
        while (n < iMementoArray.length) {
            final IMemento iMemento = iMementoArray[n];
            final String string = iMemento.getString("factoryID");
            if (string == null) {
                WorkbenchPlugin.log("Unable to restore working set item - no factory ID.");
            } else {
                final IElementFactory iElementFactory = PlatformUI.getWorkbench().getElementFactory(string);
                if (iElementFactory == null) {
                    WorkbenchPlugin.log("Unable to restore working set item - cannot instantiate factory: " + string);
                } else {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable("Unable to restore working set item - exception while invoking factory: " + string){

                        public void run() throws Exception {
                            IAdaptable iAdaptable = iElementFactory.createElement(iMemento);
                            if (iAdaptable == null) {
                                if (Policy.DEBUG_WORKING_SETS) {
                                    WorkbenchPlugin.log("Unable to restore working set item - cannot instantiate item: " + string);
                                }
                            } else {
                                hashSet.add(iAdaptable);
                            }
                        }
                    });
                }
            }
            ++n;
        }
        this.internalSetElements(hashSet.toArray(new IAdaptable[hashSet.size()]));
    }

    @Override
    public void saveState(IMemento iMemento) {
        if (this.workingSetMemento != null) {
            iMemento.putMemento(this.workingSetMemento);
        } else {
            iMemento.putString("name", this.getName());
            iMemento.putString("label", this.getLabel());
            iMemento.putString("id", this.getUniqueId());
            iMemento.putString("editPageId", this.editPageId);
            for (IAdaptable iAdaptable : this.elements) {
                final IPersistableElement iPersistableElement = (IPersistableElement)Util.getAdapter(iAdaptable, IPersistableElement.class);
                if (iPersistableElement == null) continue;
                final IMemento iMemento2 = iMemento.createChild("item");
                iMemento2.putString("factoryID", iPersistableElement.getFactoryId());
                SafeRunner.run((ISafeRunnable)new SafeRunnable("Problems occurred while saving persistable item state"){

                    public void run() throws Exception {
                        iPersistableElement.saveState(iMemento2);
                    }
                });
            }
        }
    }

    @Override
    public void setElements(IAdaptable[] iAdaptableArray) {
        this.internalSetElements(iAdaptableArray);
        this.fireWorkingSetChanged("workingSetContentChange", null);
    }

    @Override
    public void setId(String string) {
        this.editPageId = string;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isSelfUpdating() {
        WorkingSetDescriptor workingSetDescriptor = this.getDescriptor(null);
        return workingSetDescriptor != null && workingSetDescriptor.getUpdaterClassName() != null;
    }

    @Override
    public boolean isAggregateWorkingSet() {
        return false;
    }

    private WorkingSetDescriptor getDescriptor(String string) {
        WorkingSetRegistry workingSetRegistry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        String string2 = this.getId();
        if (string2 == null) {
            string2 = string;
        }
        if (string2 == null) {
            return null;
        }
        return workingSetRegistry.getWorkingSetDescriptor(string2);
    }

    @Override
    public IAdaptable[] adaptElements(IAdaptable[] iAdaptableArray) {
        IWorkingSetManager iWorkingSetManager = this.getManager();
        if (iWorkingSetManager instanceof WorkingSetManager) {
            WorkingSetDescriptor workingSetDescriptor = this.getDescriptor(null);
            if (workingSetDescriptor == null || !workingSetDescriptor.isElementAdapterClassLoaded()) {
                return iAdaptableArray;
            }
            return ((WorkingSetManager)iWorkingSetManager).getElementAdapter(workingSetDescriptor).adaptElements(this, iAdaptableArray);
        }
        return iAdaptableArray;
    }
}

