/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.provisional.presentations.IActionBarPresentationFactory;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.WorkbenchPresentationFactory;

public final class WorkbenchWindowConfigurer
implements IWorkbenchWindowConfigurer {
    private WorkbenchWindow window;
    private int shellStyle = 0x4F0 | Window.getDefaultOrientation();
    private String windowTitle;
    private boolean showFastViewBars = false;
    private boolean showPerspectiveBar = false;
    private boolean showStatusLine = true;
    private boolean showToolBar = true;
    private boolean showMenuBar = true;
    private boolean showProgressIndicator = false;
    private Map extraData = new HashMap(1);
    private ArrayList transferTypes = new ArrayList(3);
    private DropTargetListener dropTargetListener = null;
    private WindowActionBarConfigurer actionBarConfigurer = null;
    private Point initialSize = new Point(1024, 768);
    private AbstractPresentationFactory presentationFactory = null;

    WorkbenchWindowConfigurer(WorkbenchWindow workbenchWindow) {
        if (workbenchWindow == null) {
            throw new IllegalArgumentException();
        }
        this.window = workbenchWindow;
        this.windowTitle = WorkbenchPlugin.getDefault().getProductName();
        if (this.windowTitle == null) {
            this.windowTitle = "";
        }
    }

    @Override
    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    @Override
    public IWorkbenchConfigurer getWorkbenchConfigurer() {
        return Workbench.getInstance().getWorkbenchConfigurer();
    }

    String basicGetTitle() {
        return this.windowTitle;
    }

    @Override
    public String getTitle() {
        Shell shell = this.window.getShell();
        if (shell != null) {
            this.windowTitle = shell.getText();
        }
        return this.windowTitle;
    }

    @Override
    public void setTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.windowTitle = string;
        Shell shell = this.window.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(TextProcessor.process((String)string, (String)WorkbenchWindow.TEXT_DELIMITERS));
        }
    }

    @Override
    public boolean getShowMenuBar() {
        return this.showMenuBar;
    }

    @Override
    public void setShowMenuBar(boolean bl) {
        this.showMenuBar = bl;
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getWindow();
        Shell shell = workbenchWindow.getShell();
        if (shell != null) {
            boolean bl2;
            boolean bl3 = bl2 = shell.getMenuBar() != null;
            if (bl != bl2) {
                if (bl) {
                    shell.setMenuBar(workbenchWindow.getMenuBarManager().getMenu());
                } else {
                    shell.setMenuBar(null);
                }
            }
        }
    }

    @Override
    public boolean getShowCoolBar() {
        return this.showToolBar;
    }

    @Override
    public void setShowCoolBar(boolean bl) {
        this.showToolBar = bl;
    }

    @Override
    public boolean getShowFastViewBars() {
        return this.showFastViewBars;
    }

    @Override
    public void setShowFastViewBars(boolean bl) {
        this.showFastViewBars = bl;
        this.window.setFastViewBarVisible(bl);
    }

    @Override
    public boolean getShowPerspectiveBar() {
        return this.showPerspectiveBar;
    }

    @Override
    public void setShowPerspectiveBar(boolean bl) {
        this.showPerspectiveBar = bl;
    }

    @Override
    public boolean getShowStatusLine() {
        return this.showStatusLine;
    }

    @Override
    public void setShowStatusLine(boolean bl) {
        this.showStatusLine = bl;
        this.window.setStatusLineVisible(bl);
    }

    @Override
    public boolean getShowProgressIndicator() {
        return this.showProgressIndicator;
    }

    @Override
    public void setShowProgressIndicator(boolean bl) {
        this.showProgressIndicator = bl;
    }

    @Override
    public Object getData(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.extraData.get(string);
    }

    @Override
    public void setData(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (object != null) {
            this.extraData.put(string, object);
        } else {
            this.extraData.remove(string);
        }
    }

    @Override
    public void addEditorAreaTransfer(Transfer transfer) {
        if (transfer != null && !this.transferTypes.contains(transfer)) {
            this.transferTypes.add(transfer);
            Transfer[] transferArray = new Transfer[this.transferTypes.size()];
            this.transferTypes.toArray(transferArray);
            IWorkbenchPage[] iWorkbenchPageArray = this.window.getPages();
            int n = 0;
            while (n < iWorkbenchPageArray.length) {
                WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchPageArray[n];
                DropTarget dropTarget = ((EditorSashContainer)workbenchPage.getEditorPresentation().getLayoutPart()).getDropTarget();
                if (dropTarget != null) {
                    dropTarget.setTransfer(transferArray);
                }
                ++n;
            }
        }
    }

    @Override
    public void configureEditorAreaDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener != null) {
            this.dropTargetListener = dropTargetListener;
            IWorkbenchPage[] iWorkbenchPageArray = this.window.getPages();
            int n = 0;
            while (n < iWorkbenchPageArray.length) {
                WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchPageArray[n];
                DropTarget dropTarget = ((EditorSashContainer)workbenchPage.getEditorPresentation().getLayoutPart()).getDropTarget();
                if (dropTarget != null) {
                    dropTarget.addDropListener(this.dropTargetListener);
                }
                ++n;
            }
        }
    }

    Transfer[] getTransfers() {
        Transfer[] transferArray = new Transfer[this.transferTypes.size()];
        this.transferTypes.toArray(transferArray);
        return transferArray;
    }

    DropTargetListener getDropTargetListener() {
        return this.dropTargetListener;
    }

    @Override
    public IActionBarConfigurer getActionBarConfigurer() {
        if (this.actionBarConfigurer == null) {
            this.actionBarConfigurer = new WindowActionBarConfigurer();
        }
        return this.actionBarConfigurer;
    }

    boolean containsCoolItem(String string) {
        this.getActionBarConfigurer();
        return this.actionBarConfigurer.containsCoolItem(string);
    }

    @Override
    public int getShellStyle() {
        return this.shellStyle;
    }

    @Override
    public void setShellStyle(int n) {
        this.shellStyle = n;
    }

    @Override
    public Point getInitialSize() {
        return this.initialSize;
    }

    @Override
    public void setInitialSize(Point point) {
        this.initialSize = point;
    }

    @Override
    public AbstractPresentationFactory getPresentationFactory() {
        if (this.presentationFactory == null) {
            this.presentationFactory = this.createDefaultPresentationFactory();
        }
        return this.presentationFactory;
    }

    private AbstractPresentationFactory createDefaultPresentationFactory() {
        final String string = ((Workbench)this.window.getWorkbench()).getPresentationId();
        if (string != null && string.length() > 0) {
            final AbstractPresentationFactory[] abstractPresentationFactoryArray = new AbstractPresentationFactory[1];
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    abstractPresentationFactoryArray[0] = WorkbenchPlugin.getDefault().getPresentationFactory(string);
                }
            });
            if (abstractPresentationFactoryArray[0] != null) {
                return abstractPresentationFactoryArray[0];
            }
        }
        PrefUtil.getAPIPreferenceStore().setValue("presentationFactoryId", "org.eclipse.ui.presentations.default");
        return new WorkbenchPresentationFactory();
    }

    @Override
    public void setPresentationFactory(AbstractPresentationFactory abstractPresentationFactory) {
        if (abstractPresentationFactory == null) {
            throw new IllegalArgumentException();
        }
        this.presentationFactory = abstractPresentationFactory;
    }

    public void createDefaultContents(Shell shell) {
        this.window.createDefaultContents(shell);
    }

    @Override
    public Menu createMenuBar() {
        return this.window.getMenuManager().createMenuBar(this.window.getShell());
    }

    @Override
    public Control createCoolBarControl(Composite composite) {
        ICoolBarManager iCoolBarManager = this.window.getCoolBarManager2();
        if (iCoolBarManager != null) {
            if (iCoolBarManager instanceof ICoolBarManager2) {
                return ((ICoolBarManager2)iCoolBarManager).createControl2(composite);
            }
            if (iCoolBarManager instanceof CoolBarManager) {
                return ((CoolBarManager)iCoolBarManager).createControl(composite);
            }
        }
        return null;
    }

    @Override
    public Control createStatusLineControl(Composite composite) {
        return this.window.getStatusLineManager().createControl(composite);
    }

    @Override
    public Control createPageComposite(Composite composite) {
        return this.window.createPageComposite(composite);
    }

    @Override
    public IStatus saveState(IMemento iMemento) {
        return this.window.saveState(iMemento);
    }

    class WindowActionBarConfigurer
    implements IActionBarConfigurer2 {
        private IActionBarConfigurer2 proxy;

        WindowActionBarConfigurer() {
        }

        public void setProxy(IActionBarConfigurer2 iActionBarConfigurer2) {
            this.proxy = iActionBarConfigurer2;
        }

        @Override
        public IWorkbenchWindowConfigurer getWindowConfigurer() {
            return WorkbenchWindowConfigurer.this.window.getWindowConfigurer();
        }

        boolean containsCoolItem(String string) {
            ICoolBarManager iCoolBarManager = this.getCoolBarManager();
            if (iCoolBarManager == null) {
                return false;
            }
            IContributionItem iContributionItem = iCoolBarManager.find(string);
            return iContributionItem != null;
        }

        @Override
        public IStatusLineManager getStatusLineManager() {
            if (this.proxy != null) {
                return this.proxy.getStatusLineManager();
            }
            return WorkbenchWindowConfigurer.this.window.getStatusLineManager();
        }

        @Override
        public IMenuManager getMenuManager() {
            if (this.proxy != null) {
                return this.proxy.getMenuManager();
            }
            return WorkbenchWindowConfigurer.this.window.getMenuManager();
        }

        @Override
        public ICoolBarManager getCoolBarManager() {
            if (this.proxy != null) {
                return this.proxy.getCoolBarManager();
            }
            return WorkbenchWindowConfigurer.this.window.getCoolBarManager2();
        }

        @Override
        public void registerGlobalAction(IAction iAction) {
            if (this.proxy != null) {
                this.proxy.registerGlobalAction(iAction);
            }
            WorkbenchWindowConfigurer.this.window.registerGlobalAction(iAction);
        }

        private IActionBarPresentationFactory getActionBarPresentationFactory() {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getWindowConfigurer().getWindow();
            return workbenchWindow.getActionBarPresentationFactory();
        }

        @Override
        public IToolBarManager createToolBarManager() {
            if (this.proxy != null) {
                return this.proxy.createToolBarManager();
            }
            return this.getActionBarPresentationFactory().createToolBarManager();
        }

        @Override
        public IToolBarContributionItem createToolBarContributionItem(IToolBarManager iToolBarManager, String string) {
            if (this.proxy != null) {
                return this.proxy.createToolBarContributionItem(iToolBarManager, string);
            }
            return this.getActionBarPresentationFactory().createToolBarContributionItem(iToolBarManager, string);
        }
    }
}

