/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.State;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.internal.provisional.action.IToolBarManager2;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.ActionPresentation;
import org.eclipse.ui.internal.ActionSetsEvent;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.HeapStatus;
import org.eclipse.ui.internal.IBackgroundSaveListener;
import org.eclipse.ui.internal.IReorderListener;
import org.eclipse.ui.internal.PageListenerList;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectiveBarManager;
import org.eclipse.ui.internal.PerspectiveListenerList;
import org.eclipse.ui.internal.PerspectiveSwitcher;
import org.eclipse.ui.internal.PlaceholderContributionItem;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.ShellPool;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.TrimDropTarget;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WWinPartService;
import org.eclipse.ui.internal.WindowTrimProxy;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.dialogs.CustomizePerspectiveDialog;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.handlers.ActionCommandMappingService;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.layout.CacheWrapper;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.TrimLayout;
import org.eclipse.ui.internal.menus.IActionSetsListener;
import org.eclipse.ui.internal.menus.LegacyActionPersistence;
import org.eclipse.ui.internal.menus.TrimBarManager2;
import org.eclipse.ui.internal.menus.TrimContributionManager;
import org.eclipse.ui.internal.menus.WorkbenchMenuService;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.UIListenerLogging;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.presentations.DefaultActionBarPresentationFactory;
import org.eclipse.ui.internal.progress.ProgressRegion;
import org.eclipse.ui.internal.progress.TaskBarProgressManager;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.provisional.presentations.IActionBarPresentationFactory;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.UIExtensionTracker;
import org.eclipse.ui.internal.services.EvaluationReference;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.tweaklets.WorkbenchImplementation;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IEvaluationService;

public class WorkbenchWindow
extends ApplicationWindow
implements IWorkbenchWindow {
    private WorkbenchWindowAdvisor windowAdvisor;
    private ActionBarAdvisor actionBarAdvisor;
    private int number;
    private PageList pageList = new PageList();
    private PageListenerList pageListeners = new PageListenerList();
    private PerspectiveListenerList perspectiveListeners = new PerspectiveListenerList();
    private WWinPartService partService = new WWinPartService(this);
    private ActionPresentation actionPresentation;
    private WWinActionBars actionBars;
    private boolean updateDisabled = true;
    private boolean closing = false;
    private boolean shellActivated = false;
    private FastViewBar fastViewBar;
    private PerspectiveSwitcher perspectiveSwitcher = null;
    private TrimLayout defaultLayout;
    ProgressRegion progressRegion = null;
    private TrimBarManager2 trimMgr2 = null;
    private TrimContributionManager trimContributionMgr = null;
    private final ServiceLocator serviceLocator;
    private HeapStatus heapStatus;
    private WindowTrimProxy heapStatusTrim = null;
    private boolean emptyWindowContentsCreated = false;
    private Control emptyWindowContents;
    private Rectangle normalBounds;
    private boolean asMaximizedState = false;
    private CBanner topBar;
    private IWindowTrim topBarTrim;
    private Point lastShellSize = new Point(0, 0);
    private Composite pageComposite;
    private int submenus = 0;
    private WorkbenchWindowConfigurer windowConfigurer = null;
    private ListenerList genericPropertyListeners = new ListenerList();
    private ShellPool detachedWindowShells;
    static final String TEXT_DELIMITERS = String.valueOf(TextProcessor.getDefaultDelimiters()) + "-";
    static final String GRP_PAGES = "pages";
    static final String GRP_PERSPECTIVES = "perspectives";
    static final String GRP_FAST_VIEWS = "fastViews";
    static final int VGAP = 0;
    static final int CLIENT_INSET = 3;
    static final int BAR_SIZE = 23;
    public static final String PROP_COOLBAR_VISIBLE = "coolbarVisible";
    public static final String PROP_PERSPECTIVEBAR_VISIBLE = "perspectiveBarVisible";
    public static final String PROP_STATUS_LINE_VISIBLE = "statusLineVisible";
    public static final int SHOW_VIEW_SUBMENU = 1;
    public static final int OPEN_PERSPECTIVE_SUBMENU = 2;
    public static final int NEW_WIZARD_SUBMENU = 4;
    private final boolean COCOA = Platform.getWS().equals("cocoa");
    private static final int FILL_ALL_ACTION_BARS = 14;
    private TrimDropTarget trimDropTarget;
    private boolean coolBarVisible = true;
    private boolean perspectiveBarVisible = true;
    private boolean fastViewBarVisible = true;
    private boolean statusLineVisible = true;
    private IWindowTrim statusLineTrim = null;
    private Map globalActionHandlersByCommandId = new HashMap();
    private List handlerActivations = new ArrayList();
    private int largeUpdates = 0;
    private IExtensionTracker tracker;
    private IExtensionChangeHandler actionSetHandler = new IExtensionChangeHandler(){

        public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object[] objectArray = WorkbenchWindow.this.getWorkbench().getExtensionTracker().getObjects(iExtension);
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof IActionSetDescriptor && (object = (IActionSetDescriptor)objectArray[n]).isInitiallyVisible()) {
                    arrayList.add(object);
                }
                ++n;
            }
            if (arrayList.isEmpty()) {
                return;
            }
            IActionSetDescriptor[] iActionSetDescriptorArray = arrayList.toArray(new IActionSetDescriptor[arrayList.size()]);
            object = WorkbenchWindow.this.getActiveWorkbenchPage();
            if (object != null) {
                Perspective[] perspectiveArray = ((WorkbenchPage)object).getOpenInternalPerspectives();
                int n2 = 0;
                while (n2 < perspectiveArray.length) {
                    perspectiveArray[n2].turnOnActionSets(iActionSetDescriptorArray);
                    ++n2;
                }
            }
            WorkbenchWindow.this.updateActionSets();
        }

        public void removeExtension(IExtension iExtension, Object[] objectArray) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof PluginActionSetBuilder.Binding) {
                    PluginActionSetBuilder.Binding binding = (PluginActionSetBuilder.Binding)objectArray[n];
                    binding.tracker = null;
                    binding.builder.removeActionExtensions(binding.set, binding.window);
                    binding.set.dispose();
                }
                ++n;
            }
            Perspective[] perspectiveArray = WorkbenchWindow.this.getActiveWorkbenchPage().getOpenInternalPerspectives();
            boolean bl = true;
            IContextService iContextService = (IContextService)WorkbenchWindow.this.getService(IContextService.class);
            try {
                iContextService.deferUpdates(true);
                int n2 = 0;
                while (n2 < perspectiveArray.length) {
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        if (objectArray[n3] instanceof IActionSetDescriptor) {
                            perspectiveArray[n2].removeActionSet((IActionSetDescriptor)objectArray[n3]);
                            WorkbenchWindow.this.getActionPresentation().removeActionSet((IActionSetDescriptor)objectArray[n3]);
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            finally {
                iContextService.deferUpdates(false);
            }
            if (bl) {
                WorkbenchWindow.this.updateActionSets();
            }
        }
    };
    private IContributionManagerOverrides menuOverride = new IContributionManagerOverrides(){

        public Integer getAccelerator(IContributionItem iContributionItem) {
            return null;
        }

        public String getAcceleratorText(IContributionItem iContributionItem) {
            return null;
        }

        public Boolean getEnabled(IContributionItem iContributionItem) {
            return null;
        }

        public String getText(IContributionItem iContributionItem) {
            return null;
        }

        public Boolean getVisible(IContributionItem iContributionItem) {
            IWorkbenchPage iWorkbenchPage = WorkbenchWindow.this.getActivePage();
            if (iWorkbenchPage == null) {
                return null;
            }
            Perspective perspective = ((WorkbenchPage)iWorkbenchPage).getActivePerspective();
            String string = CustomizePerspectiveDialog.getIDFromIContributionItem(iContributionItem);
            if (string == null) {
                return null;
            }
            if (perspective != null && perspective.getHiddenMenuItems().contains(string)) {
                return Boolean.FALSE;
            }
            return null;
        }
    };
    private IContributionManagerOverrides toolbarOverride = new IContributionManagerOverrides(){

        public Integer getAccelerator(IContributionItem iContributionItem) {
            return null;
        }

        public String getAcceleratorText(IContributionItem iContributionItem) {
            return null;
        }

        public Boolean getEnabled(IContributionItem iContributionItem) {
            return null;
        }

        public String getText(IContributionItem iContributionItem) {
            return null;
        }

        public Boolean getVisible(IContributionItem iContributionItem) {
            IWorkbenchPage iWorkbenchPage = WorkbenchWindow.this.getActivePage();
            if (iWorkbenchPage == null) {
                return null;
            }
            Perspective perspective = ((WorkbenchPage)iWorkbenchPage).getActivePerspective();
            String string = CustomizePerspectiveDialog.getIDFromIContributionItem(iContributionItem);
            if (string == null) {
                return null;
            }
            if (perspective != null && perspective.getHiddenToolbarItems().contains(string)) {
                return Boolean.FALSE;
            }
            if (!iContributionItem.isVisible()) {
                return Boolean.FALSE;
            }
            return null;
        }
    };
    private Map toolbarLabelContributions = new HashMap();
    private Set menuRestrictions = new HashSet();
    private ListenerList actionSetListeners = null;
    private ListenerList backgroundSaveListeners = new ListenerList(1);

    public void addSubmenu(int n) {
        this.submenus |= n;
    }

    public boolean containsSubmenu(int n) {
        return (this.submenus & n) != 0;
    }

    public WorkbenchWindow(int n) {
        super(null);
        this.number = n;
        this.coolBarVisible = PrefUtil.getInternalPreferenceStore().getBoolean("coolBarVisible");
        this.perspectiveBarVisible = PrefUtil.getInternalPreferenceStore().getBoolean(PROP_PERSPECTIVEBAR_VISIBLE);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IServiceLocatorCreator iServiceLocatorCreator = (IServiceLocatorCreator)iWorkbench.getService(IServiceLocatorCreator.class);
        this.serviceLocator = (ServiceLocator)iServiceLocatorCreator.createServiceLocator(iWorkbench, null, new IDisposable(){

            @Override
            public void dispose() {
                Shell shell = WorkbenchWindow.this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    WorkbenchWindow.this.close();
                }
            }
        });
        this.initializeDefaultServices();
        this.addMenuBar();
        if (this.COCOA) {
            this.addToolBar(0);
        } else {
            this.addCoolBar(0);
        }
        this.addStatusLine();
        this.getExtensionTracker().registerHandler(this.actionSetHandler, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getActionSetExtensionPoint()));
        this.fireWindowOpening();
        this.setShellStyle(this.getWindowConfigurer().getShellStyle());
        this.fillActionBars(14);
    }

    private IExtensionPoint getActionSetExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "actionSets");
    }

    protected int perspectiveBarStyle() {
        return 8520000;
    }

    void registerGlobalAction(IAction iAction) {
        String string = iAction.getActionDefinitionId();
        if (string != null) {
            Object object;
            Object v = this.globalActionHandlersByCommandId.get(string);
            if (v instanceof ActionHandler) {
                object = (ActionHandler)v;
                object.dispose();
            }
            if (iAction instanceof CommandAction) {
                object = iAction.getId();
                if (object != null) {
                    IActionCommandMappingService iActionCommandMappingService = (IActionCommandMappingService)this.serviceLocator.getService(IActionCommandMappingService.class);
                    iActionCommandMappingService.map((String)object, string);
                }
            } else {
                this.globalActionHandlersByCommandId.put(string, new ActionHandler(iAction));
            }
        }
        this.submitGlobalActions();
    }

    void submitGlobalActions() {
        Object object;
        Object object222;
        IHandlerService iHandlerService = (IHandlerService)this.getWorkbench().getService(IHandlerService.class);
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.globalActionHandlersByCommandId);
        ArrayList<Object> arrayList = new ArrayList<Object>(hashMap.size());
        for (Object object222 : this.handlerActivations) {
            object = object222.getCommandId();
            Object object3 = hashMap.get(object);
            if (object3 == object222.getHandler()) {
                hashMap.remove(object);
                arrayList.add(object222);
                continue;
            }
            iHandlerService.deactivateHandler((IHandlerActivation)object222);
        }
        object222 = this.getShell();
        if (object222 != null) {
            object = new ActiveShellExpression((Shell)object222);
            for (Map.Entry entry : hashMap.entrySet()) {
                String string = (String)entry.getKey();
                IHandler iHandler = (IHandler)entry.getValue();
                arrayList.add(iHandlerService.activateHandler(string, iHandler, (Expression)object));
            }
        }
        this.handlerActivations = arrayList;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.genericPropertyListeners.add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.genericPropertyListeners.remove((Object)iPropertyChangeListener);
    }

    private void firePropertyChanged(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        Object[] objectArray = this.genericPropertyListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
            iPropertyChangeListener.propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    @Override
    public void addPageListener(IPageListener iPageListener) {
        this.pageListeners.addPageListener(iPageListener);
    }

    @Override
    public void addPerspectiveListener(IPerspectiveListener iPerspectiveListener) {
        this.perspectiveListeners.addPerspectiveListener(iPerspectiveListener);
    }

    protected void addPerspectiveBar(int n) {
        Assert.isTrue((this.perspectiveSwitcher == null ? 1 : 0) != 0);
        this.perspectiveSwitcher = new PerspectiveSwitcher(this, this.topBar, n);
    }

    private boolean busyClose() {
        boolean bl = false;
        this.closing = true;
        this.updateDisabled = true;
        try {
            Workbench workbench = this.getWorkbenchImpl();
            if (this.shouldCloseWorkbench(workbench)) {
                bl = workbench.close();
            } else if (this.okToClose()) {
                bl = this.hardClose();
            }
        }
        finally {
            if (!bl) {
                this.closing = false;
                this.updateDisabled = false;
            }
        }
        if (bl && this.tracker != null) {
            this.tracker.close();
        }
        return bl;
    }

    private boolean shouldCloseWorkbench(Workbench workbench) {
        if (workbench.isStarting()) {
            return false;
        }
        if (workbench.isClosing()) {
            return false;
        }
        int n = workbench.getWorkbenchWindowCount();
        if (n > 1) {
            return false;
        }
        return workbench.getWorkbenchConfigurer().getExitOnLastWindowClose();
    }

    protected IWorkbenchPage busyOpenPage(String string, IAdaptable iAdaptable) throws WorkbenchException {
        IWorkbenchPage iWorkbenchPage = null;
        if (this.pageList.isEmpty()) {
            iWorkbenchPage = ((WorkbenchImplementation)Tweaklets.get(WorkbenchImplementation.KEY)).createWorkbenchPage(this, string, iAdaptable);
            this.pageList.add(iWorkbenchPage);
            this.firePageOpened(iWorkbenchPage);
            this.setActivePage(iWorkbenchPage);
        } else {
            IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().openWorkbenchWindow(string, iAdaptable);
            iWorkbenchPage = iWorkbenchWindow.getActivePage();
        }
        return iWorkbenchPage;
    }

    public int open() {
        if (this.getPages().length == 0) {
            this.showEmptyWindowContents();
        }
        this.fireWindowCreated();
        this.getWindowAdvisor().openIntro();
        int n = super.open();
        this.getShell().layout();
        this.fireWindowOpened();
        if (this.perspectiveSwitcher != null) {
            this.perspectiveSwitcher.updatePerspectiveBar();
            this.perspectiveSwitcher.updateBarParent();
        }
        return n;
    }

    protected boolean canHandleShellCloseEvent() {
        if (!super.canHandleShellCloseEvent()) {
            return false;
        }
        final boolean[] blArray = new boolean[1];
        Display display = this.getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                blArray[0] = true;
            }
        });
        while (!blArray[0] && display.readAndDispatch()) {
        }
        return this.fireWindowShellClosing();
    }

    @Override
    public boolean close() {
        final boolean[] blArray = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                blArray[0] = WorkbenchWindow.this.busyClose();
            }
        });
        return blArray[0];
    }

    protected boolean isClosing() {
        return this.closing || this.getWorkbenchImpl().isClosing();
    }

    private void closeAllPages() {
        this.setActivePage(null);
        PageList pageList = this.pageList;
        this.pageList = new PageList();
        Iterator iterator = pageList.iterator();
        while (iterator.hasNext()) {
            WorkbenchPage workbenchPage = (WorkbenchPage)iterator.next();
            this.firePageClosed(workbenchPage);
            workbenchPage.dispose();
        }
        if (!this.closing) {
            this.showEmptyWindowContents();
        }
    }

    public void closeAllPages(boolean bl) {
        boolean bl2;
        if (bl && !(bl2 = this.saveAllPages(true))) {
            return;
        }
        this.closeAllPages();
    }

    protected boolean closePage(IWorkbenchPage iWorkbenchPage, boolean bl) {
        WorkbenchPage workbenchPage;
        boolean bl2;
        if (!this.pageList.contains(iWorkbenchPage)) {
            return false;
        }
        WorkbenchPage workbenchPage2 = (WorkbenchPage)iWorkbenchPage;
        if (bl && workbenchPage2.isSaveNeeded() && !workbenchPage2.saveAllEditors(true)) {
            return false;
        }
        boolean bl3 = bl2 = workbenchPage2 == this.getActiveWorkbenchPage();
        if (bl2) {
            this.setActivePage(null);
        }
        this.pageList.remove(workbenchPage2);
        this.firePageClosed(workbenchPage2);
        workbenchPage2.dispose();
        if (bl2 && (workbenchPage = this.pageList.getNextActive()) != null) {
            this.setActivePage(workbenchPage);
        }
        if (!this.closing && this.pageList.isEmpty()) {
            this.showEmptyWindowContents();
        }
        return true;
    }

    private void showEmptyWindowContents() {
        if (!this.emptyWindowContentsCreated) {
            Composite composite = this.getPageComposite();
            this.emptyWindowContents = this.getWindowAdvisor().createEmptyWindowContents(composite);
            this.emptyWindowContentsCreated = true;
            ((StackLayout)composite.getLayout()).topControl = this.emptyWindowContents;
            composite.layout();
        }
    }

    private void hideEmptyWindowContents() {
        if (this.emptyWindowContentsCreated) {
            if (this.emptyWindowContents != null) {
                this.emptyWindowContents.dispose();
                this.emptyWindowContents = null;
                this.getPageComposite().layout();
            }
            this.emptyWindowContentsCreated = false;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.detachedWindowShells = new ShellPool(shell, 0x434 | WorkbenchWindow.getDefaultOrientation());
        String string = this.getWindowConfigurer().basicGetTitle();
        if (string != null) {
            shell.setText(TextProcessor.process((String)string, (String)TEXT_DELIMITERS));
        }
        IWorkbench iWorkbench = this.getWorkbench();
        iWorkbench.getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.workbench_window_context");
        IContextService iContextService = (IContextService)this.getWorkbench().getService(IContextService.class);
        iContextService.registerShell(shell, 2);
        this.trackShellActivation(shell);
        this.trackShellResize(shell);
    }

    ShellPool getDetachedWindowPool() {
        return this.detachedWindowShells;
    }

    protected void createTrimWidgets(Shell shell) {
    }

    protected Composite createPageComposite(Composite composite) {
        this.pageComposite = new Composite(composite, 0);
        this.pageComposite.setLayout((Layout)new StackLayout());
        return this.pageComposite;
    }

    protected Control createContents(Composite composite) {
        this.getWindowAdvisor().createWindowContents((Shell)composite);
        Assert.isNotNull((Object)this.pageComposite, (String)"createWindowContents must call configurer.createPageComposite");
        return this.pageComposite;
    }

    public void setBannerCurve(boolean bl) {
        if (this.topBar != null) {
            this.topBar.setSimple(bl);
        }
    }

    protected void createDefaultContents(final Shell shell) {
        this.defaultLayout = new TrimLayout();
        shell.setLayout((Layout)this.defaultLayout);
        Menu menu = this.getMenuBarManager().createMenuBar(shell);
        if (this.getWindowConfigurer().getShowMenuBar()) {
            shell.setMenuBar(menu);
        }
        this.topBar = new CBanner((Composite)shell, 0);
        this.setBannerCurve(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        if (this.COCOA) {
            this.createToolBarControl((Composite)shell);
        } else {
            this.topBarTrim = new WindowTrimProxy((Control)this.topBar, "org.eclipse.ui.internal.WorkbenchWindow.topBar", WorkbenchMessages.TrimCommon_Main_TrimName, 0, true);
            CacheWrapper cacheWrapper = new CacheWrapper((Composite)this.topBar);
            final Control control = this.createCoolBarControl(cacheWrapper.getControl());
            control.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle rectangle = shell.getClientArea();
                    if (((WorkbenchWindow)WorkbenchWindow.this).lastShellSize.x == rectangle.width && ((WorkbenchWindow)WorkbenchWindow.this).lastShellSize.y == rectangle.height) {
                        LayoutUtil.resize(control);
                    }
                    ((WorkbenchWindow)WorkbenchWindow.this).lastShellSize.x = rectangle.width;
                    ((WorkbenchWindow)WorkbenchWindow.this).lastShellSize.y = rectangle.height;
                }
            });
            if (this.getWindowConfigurer().getShowCoolBar()) {
                this.topBar.setLeft((Control)cacheWrapper.getControl());
            }
            this.fastViewBar = new FastViewBar(this);
            this.fastViewBar.createControl((Composite)shell);
            if (this.getWindowConfigurer().getShowPerspectiveBar()) {
                this.addPerspectiveBar(this.perspectiveBarStyle());
                this.perspectiveSwitcher.createControl((Composite)shell);
            }
        }
        this.createStatusLine(shell);
        this.createProgressIndicator(shell);
        if (this.getShowHeapStatus()) {
            this.createHeapStatus((Composite)shell);
        }
        this.trimMgr2 = new TrimBarManager2(this);
        this.trimContributionMgr = new TrimContributionManager(this);
        this.trimDropTarget = new TrimDropTarget((Composite)shell, this);
        DragUtil.addDragTarget((Control)shell, this.trimDropTarget);
        DragUtil.addDragTarget(null, this.trimDropTarget);
        this.createPageComposite((Composite)shell);
        this.setLayoutDataForContents();
    }

    private boolean getShowHeapStatus() {
        return PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_MEMORY_MONITOR") || Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.ui/perf/showHeapStatus")) != false;
    }

    private void createHeapStatus(Composite composite) {
        this.heapStatus = new HeapStatus(composite, PrefUtil.getInternalPreferenceStore());
        this.heapStatusTrim = new WindowTrimProxy((Control)this.heapStatus, "org.eclipse.ui.internal.HeapStatus", WorkbenchMessages.TrimCommon_HeapStatus_TrimName, 1152){

            @Override
            public void handleClose() {
                this.getControl().dispose();
            }

            @Override
            public boolean isCloseable() {
                return true;
            }
        };
    }

    protected MenuManager createMenuManager() {
        MenuManager menuManager = super.createMenuManager();
        menuManager.setOverrides(this.menuOverride);
        return menuManager;
    }

    public void setPerspectiveBarLocation(String string) {
        if (this.perspectiveSwitcher != null) {
            this.perspectiveSwitcher.setPerspectiveBarLocation(string);
        }
        this.updateLayoutDataForContents();
        this.getShell().layout();
    }

    private void fireWindowOpening() {
        this.getWindowAdvisor().preWindowOpen();
    }

    void fireWindowRestored() throws WorkbenchException {
        StartupThreading.runWithWorkbenchExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() throws Throwable {
                WorkbenchWindow.this.getWindowAdvisor().postWindowRestore();
            }
        });
    }

    private void fireWindowCreated() {
        this.getWindowAdvisor().postWindowCreate();
    }

    private void fireWindowOpened() {
        this.getWorkbenchImpl().fireWindowOpened(this);
        this.getWindowAdvisor().postWindowOpen();
    }

    private boolean fireWindowShellClosing() {
        return this.getWindowAdvisor().preWindowShellClose();
    }

    private void fireWindowClosed() {
        this.getWindowAdvisor().postWindowClose();
        this.getWorkbenchImpl().fireWindowClosed(this);
    }

    private void firePageActivated(IWorkbenchPage iWorkbenchPage) {
        String string = null;
        if (UIStats.isDebugging(11)) {
            string = "activated " + iWorkbenchPage.getLabel();
        }
        try {
            UIStats.start(11, string);
            UIListenerLogging.logPageEvent(this, iWorkbenchPage, "pageActivated");
            this.pageListeners.firePageActivated(iWorkbenchPage);
            this.partService.pageActivated(iWorkbenchPage);
        }
        catch (Throwable throwable) {
            UIStats.end(11, iWorkbenchPage.getLabel(), string);
            throw throwable;
        }
        UIStats.end(11, iWorkbenchPage.getLabel(), string);
    }

    private void firePageClosed(IWorkbenchPage iWorkbenchPage) {
        String string = null;
        if (UIStats.isDebugging(11)) {
            string = "closed " + iWorkbenchPage.getLabel();
        }
        try {
            UIStats.start(11, string);
            UIListenerLogging.logPageEvent(this, iWorkbenchPage, "pageClosed");
            this.pageListeners.firePageClosed(iWorkbenchPage);
            this.partService.pageClosed(iWorkbenchPage);
        }
        catch (Throwable throwable) {
            UIStats.end(11, iWorkbenchPage.getLabel(), string);
            throw throwable;
        }
        UIStats.end(11, iWorkbenchPage.getLabel(), string);
    }

    private void firePageOpened(IWorkbenchPage iWorkbenchPage) {
        String string = null;
        if (UIStats.isDebugging(11)) {
            string = "opened " + iWorkbenchPage.getLabel();
        }
        try {
            UIStats.start(11, string);
            UIListenerLogging.logPageEvent(this, iWorkbenchPage, "pageOpened");
            this.pageListeners.firePageOpened(iWorkbenchPage);
            this.partService.pageOpened(iWorkbenchPage);
        }
        catch (Throwable throwable) {
            UIStats.end(11, iWorkbenchPage.getLabel(), string);
            throw throwable;
        }
        UIStats.end(11, iWorkbenchPage.getLabel(), string);
    }

    void firePerspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        UIListenerLogging.logPerspectiveEvent(this, iWorkbenchPage, iPerspectiveDescriptor, "perspectiveActivated");
        this.perspectiveListeners.firePerspectiveActivated(iWorkbenchPage, iPerspectiveDescriptor);
    }

    void firePerspectivePreDeactivate(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        UIListenerLogging.logPerspectiveEvent(this, iWorkbenchPage, iPerspectiveDescriptor, "perspectivePreDeactivate");
        this.perspectiveListeners.firePerspectivePreDeactivate(iWorkbenchPage, iPerspectiveDescriptor);
    }

    void firePerspectiveDeactivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        UIListenerLogging.logPerspectiveEvent(this, iWorkbenchPage, iPerspectiveDescriptor, "perspectiveDeactivated");
        this.perspectiveListeners.firePerspectiveDeactivated(iWorkbenchPage, iPerspectiveDescriptor);
    }

    public void firePerspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
        if (iPerspectiveDescriptor != null) {
            UIListenerLogging.logPerspectiveChangedEvent(this, iWorkbenchPage, iPerspectiveDescriptor, null, string);
            this.perspectiveListeners.firePerspectiveChanged(iWorkbenchPage, iPerspectiveDescriptor, string);
        }
    }

    public void firePerspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPartReference iWorkbenchPartReference, String string) {
        if (iPerspectiveDescriptor != null) {
            UIListenerLogging.logPerspectiveChangedEvent(this, iWorkbenchPage, iPerspectiveDescriptor, iWorkbenchPartReference, string);
            this.perspectiveListeners.firePerspectiveChanged(iWorkbenchPage, iPerspectiveDescriptor, iWorkbenchPartReference, string);
        }
    }

    void firePerspectiveClosed(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        UIListenerLogging.logPerspectiveEvent(this, iWorkbenchPage, iPerspectiveDescriptor, "perspectiveClosed");
        this.perspectiveListeners.firePerspectiveClosed(iWorkbenchPage, iPerspectiveDescriptor);
    }

    void firePerspectiveOpened(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        UIListenerLogging.logPerspectiveEvent(this, iWorkbenchPage, iPerspectiveDescriptor, "perspectiveOpened");
        this.perspectiveListeners.firePerspectiveOpened(iWorkbenchPage, iPerspectiveDescriptor);
    }

    void firePerspectiveSavedAs(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IPerspectiveDescriptor iPerspectiveDescriptor2) {
        UIListenerLogging.logPerspectiveSavedAs(this, iWorkbenchPage, iPerspectiveDescriptor, iPerspectiveDescriptor2);
        this.perspectiveListeners.firePerspectiveSavedAs(iWorkbenchPage, iPerspectiveDescriptor, iPerspectiveDescriptor2);
    }

    public WWinActionBars getActionBars() {
        if (this.actionBars == null) {
            this.actionBars = new WWinActionBars(this);
        }
        return this.actionBars;
    }

    @Override
    public IWorkbenchPage getActivePage() {
        return this.pageList.getActive();
    }

    WorkbenchPage getActiveWorkbenchPage() {
        return this.pageList.getActive();
    }

    public Composite getPageComposite() {
        return this.pageComposite;
    }

    public MenuManager getMenuManager() {
        return this.getMenuBarManager();
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public IWorkbenchPage[] getPages() {
        return this.pageList.getPages();
    }

    @Override
    public IPartService getPartService() {
        return this.partService;
    }

    protected Layout getLayout() {
        return null;
    }

    @Override
    public ISelectionService getSelectionService() {
        return this.partService.getSelectionService();
    }

    public boolean getShellActivated() {
        return this.shellActivated;
    }

    public StatusLineManager getStatusLineManager() {
        return super.getStatusLineManager();
    }

    private IWindowTrim getStatusLineTrim() {
        if (this.statusLineTrim == null) {
            this.statusLineTrim = new WindowTrimProxy(this.getStatusLineManager().getControl(), "org.eclipse.jface.action.StatusLineManager", WorkbenchMessages.TrimCommon_StatusLine_TrimName, 0, true);
        }
        return this.statusLineTrim;
    }

    @Override
    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public String getToolbarLabel(String string) {
        ActionSetRegistry actionSetRegistry = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor iActionSetDescriptor = actionSetRegistry.findActionSet(string);
        if (iActionSetDescriptor != null) {
            return iActionSetDescriptor.getLabel();
        }
        if ("org.eclipse.ui.workbench.file".equalsIgnoreCase(string)) {
            return WorkbenchMessages.WorkbenchWindow_FileToolbar;
        }
        if ("org.eclipse.ui.workbench.navigate".equalsIgnoreCase(string)) {
            return WorkbenchMessages.WorkbenchWindow_NavigateToolbar;
        }
        return (String)this.toolbarLabelContributions.get(string);
    }

    public void putToolbarLabel(String string, String string2) {
        this.toolbarLabelContributions.put(string, string2);
    }

    private boolean hardClose() {
        boolean bl;
        try {
            Object object2;
            if (this.toolbarLabelContributions != null) {
                this.toolbarLabelContributions.clear();
                this.toolbarLabelContributions = null;
            }
            IWorkbench iWorkbench = this.getWorkbench();
            IHandlerService iHandlerService = (IHandlerService)iWorkbench.getService(IHandlerService.class);
            iHandlerService.deactivateHandlers(this.handlerActivations);
            for (Object object2 : this.handlerActivations) {
                object2.getHandler().dispose();
            }
            this.handlerActivations.clear();
            this.globalActionHandlersByCommandId.clear();
            object2 = (IContextService)iWorkbench.getService(IContextService.class);
            object2.unregisterShell(this.getShell());
            this.closeAllPages();
            this.fireWindowClosed();
            IMenuService iMenuService = (IMenuService)iWorkbench.getService(IMenuService.class);
            iMenuService.releaseContributions((ContributionManager)this.getActionBars().getMenuManager());
            ICoolBarManager iCoolBarManager = this.getActionBars().getCoolBarManager();
            if (iCoolBarManager != null) {
                iMenuService.releaseContributions((ContributionManager)iCoolBarManager);
            }
            this.getActionBarAdvisor().dispose();
            this.getWindowAdvisor().dispose();
            this.detachedWindowShells.dispose();
            this.progressRegion = null;
            DragUtil.removeDragTarget(null, this.trimDropTarget);
            DragUtil.removeDragTarget((Control)this.getShell(), this.trimDropTarget);
            this.trimDropTarget = null;
            if (this.trimMgr2 != null) {
                this.trimMgr2.dispose();
                this.trimMgr2 = null;
            }
            if (this.trimContributionMgr != null) {
                this.trimContributionMgr.dispose();
                this.trimContributionMgr = null;
            }
        }
        finally {
            bl = super.close();
            this.getActionPresentation().clearActionSets();
            try {
                this.serviceLocator.dispose();
            }
            catch (Exception exception) {
                WorkbenchPlugin.log(exception);
            }
            this.menuRestrictions.clear();
        }
        return bl;
    }

    @Override
    public boolean isApplicationMenu(String string) {
        return this.getActionBarAdvisor().isApplicationMenu(string);
    }

    boolean isWorkbenchCoolItemId(String string) {
        return this.windowConfigurer.containsCoolItem(string);
    }

    void makeVisible() {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.open();
        }
    }

    public boolean okToClose() {
        return this.getWorkbenchImpl().isClosing() || this.saveAllPages(true);
    }

    @Override
    public IWorkbenchPage openPage(final String string, final IAdaptable iAdaptable) throws WorkbenchException {
        Assert.isNotNull((Object)string);
        final Object[] objectArray = new Object[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    objectArray[0] = WorkbenchWindow.this.busyOpenPage(string, iAdaptable);
                }
                catch (WorkbenchException workbenchException) {
                    objectArray[0] = workbenchException;
                }
            }
        });
        if (objectArray[0] instanceof IWorkbenchPage) {
            return (IWorkbenchPage)objectArray[0];
        }
        if (objectArray[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)objectArray[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.WorkbenchWindow_exceptionMessage);
    }

    @Override
    public IWorkbenchPage openPage(IAdaptable iAdaptable) throws WorkbenchException {
        String string = this.getWorkbenchImpl().getPerspectiveRegistry().getDefaultPerspective();
        return this.openPage(string, iAdaptable);
    }

    @Override
    public void removePageListener(IPageListener iPageListener) {
        this.pageListeners.removePageListener(iPageListener);
    }

    @Override
    public void removePerspectiveListener(IPerspectiveListener iPerspectiveListener) {
        this.perspectiveListeners.removePerspectiveListener(iPerspectiveListener);
    }

    private IStatus unableToRestorePage(IMemento iMemento) {
        String string = iMemento.getString("label");
        if (string == null) {
            string = "";
        }
        return new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.WorkbenchWindow_unableToRestorePerspective, (Object)string), null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public IStatus restoreState(IMemento var1_1, IPerspectiveDescriptor var2_2) {
        Assert.isNotNull((Object)this.getShell());
        var3_3 = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.WorkbenchWindow_problemsRestoringWindow, null);
        var4_4 = var1_1.getChild("workbenchWindowAdvisor");
        if (var4_4 != null) {
            var3_3.add(this.getWindowAdvisor().restoreState(var4_4));
        }
        if ((var5_5 = var1_1.getChild("actionBarAdvisor")) != null) {
            var3_3.add(this.getActionBarAdvisor().restoreState(var5_5));
        }
        var6_6 = new Rectangle[1];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                var6_6[0] = WorkbenchWindow.this.getShell().getDisplay().getBounds();
            }
        });
        var7_7 = new Rectangle(0, 0, 0, 0);
        var8_8 = var1_1.getChild("fastViewData");
        if (var8_8 != null && this.fastViewBar != null) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() {
                    WorkbenchWindow.this.fastViewBar.restoreState(var8_8);
                }
            });
        }
        var7_7.x = (var9_9 = var1_1.getInteger("x")) == null ? 0 : var9_9;
        var9_9 = var1_1.getInteger("y");
        var7_7.y = var9_9 == null ? 0 : var9_9;
        var9_9 = var1_1.getInteger("width");
        var7_7.width = var9_9 == null ? 0 : var9_9;
        var9_9 = var1_1.getInteger("height");
        v0 = var7_7.height = var9_9 == null ? 0 : var9_9;
        if (!var7_7.isEmpty()) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() {
                    if (!var7_7.intersects(var6_6[0])) {
                        Rectangle rectangle = WorkbenchWindow.this.getShell().getDisplay().getClientArea();
                        var7_7.x = rectangle.x;
                        var7_7.y = rectangle.y;
                    }
                    WorkbenchWindow.this.getShell().setBounds(var7_7);
                }
            });
        }
        if ("true".equals(var1_1.getString("maximized"))) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() {
                    WorkbenchWindow.this.getShell().setMaximized(true);
                }
            });
        }
        "true".equals(var1_1.getString("minimized"));
        if (this.perspectiveSwitcher != null) {
            this.perspectiveSwitcher.restoreState(var1_1);
        }
        if ((var10_10 = (ICoolBarManager2)this.getCoolBarManager2()) != null) {
            var11_11 = var1_1.getChild("coolbarLayout");
            if (var11_11 != null) {
                this.restoreCoolBarLocked(var10_10, (IMemento)var11_11);
                var12_12 = new ArrayList<E>();
                var13_13 = var11_11.getChildren("coolItem");
                var14_18 = 0;
                while (var14_18 < var13_13.length) {
                    var15_23 /* !! */  = var13_13[var14_18];
                    var16_24 = var15_23 /* !! */ .getString("itemType");
                    if (var16_24 != null) {
                        var17_28 = var15_23 /* !! */ .getString("id");
                        var18_29 = var10_10.find((String)var17_28);
                        if (var17_28 != null && var18_29 != null) {
                            if (Policy.DEBUG_TOOLBAR_DISPOSAL) {
                                System.out.println("Not loading duplicate cool bar item: " + (String)var17_28);
                            }
                            var12_12.add(var18_29);
                        } else {
                            var19_31 = null;
                            if (var16_24.equals("typeSeparator")) {
                                var19_31 = var17_28 != null ? new Separator((String)var17_28) : new Separator();
                            } else if (var17_28 != null) {
                                if (var16_24.equals("typeGroupMarker")) {
                                    var19_31 = new GroupMarker((String)var17_28);
                                } else if (var16_24.equals("typeToolBarContribution") || var16_24.equals("typePlaceholder")) {
                                    var20_33 = var15_23 /* !! */ .getInteger("x");
                                    var21_35 = var15_23 /* !! */ .getInteger("y");
                                    var22_36 = var10_10.find((String)var17_28);
                                    if (var22_36 != null) {
                                        var19_31 = var22_36;
                                    } else {
                                        var23_37 = this.getActionBarPresentationFactory();
                                        var19_31 = var23_37.createToolBarContributionItem((IToolBarManager)var23_37.createToolBarManager(), (String)var17_28);
                                        if (var16_24.equals("typePlaceholder")) {
                                            var24_38 = (IToolBarContributionItem)var19_31;
                                            if (var21_35 != null) {
                                                var24_38.setCurrentHeight(var21_35.intValue());
                                            }
                                            if (var20_33 != null) {
                                                var24_38.setCurrentWidth(var20_33.intValue());
                                            }
                                            var19_31 = new PlaceholderContributionItem(var24_38);
                                        }
                                        var19_31.setVisible(false);
                                        var24_38 = this.findAlphabeticalOrder("additions", (String)var17_28, (IContributionManager)var10_10);
                                        if (var24_38 != null) {
                                            var10_10.insertAfter(var24_38.getId(), (IContributionItem)var19_31);
                                        } else {
                                            var10_10.add((IContributionItem)var19_31);
                                        }
                                    }
                                    if (var20_33 != null && var19_31 instanceof IToolBarContributionItem) {
                                        ((IToolBarContributionItem)var19_31).setCurrentWidth(var20_33.intValue());
                                    }
                                    if (var21_35 != null && var19_31 instanceof IToolBarContributionItem) {
                                        ((IToolBarContributionItem)var19_31).setCurrentHeight(var21_35.intValue());
                                    }
                                }
                            }
                            if (var19_31 != null) {
                                var12_12.add(var19_31);
                                var19_31.setParent((IContributionManager)var10_10);
                                var10_10.markDirty();
                            }
                        }
                    }
                    ++var14_18;
                }
                var14_18 = 0;
                var15_23 /* !! */  = var10_10.getItems();
                var16_25 = 0;
                while (var16_25 < var15_23 /* !! */ .length && var14_18 == 0) {
                    var17_28 = var15_23 /* !! */ [var16_25];
                    if (var17_28 != null) {
                        var18_30 = false;
                        var19_31 = var12_12.iterator();
                        while (var19_31.hasNext()) {
                            var20_33 = (IContributionItem)var19_31.next();
                            if (var20_33 == null || !var20_33.equals(var17_28)) continue;
                            var18_30 = true;
                            break;
                        }
                        if (!var18_30 && var17_28 != null) {
                            var14_18 = 1;
                        }
                    }
                    ++var16_25;
                }
                if (var14_18 == 0) {
                    var16_26 = new IContributionItem[var12_12.size()];
                    var12_12.toArray(var16_26);
                    StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                        @Override
                        public void runWithException() {
                            var10_10.setItems(var16_26);
                        }
                    });
                }
            } else {
                var11_11 = var1_1.getChild("toolbarLayout");
                if (var11_11 != null) {
                    this.restoreOldCoolBar((IMemento)var11_11);
                }
            }
        }
        var11_11 = null;
        var12_12 = var1_1.getChildren("page");
        var13_14 = 0;
        while (var13_14 < ((IMemento[])var12_12).length) {
            block54: {
                var14_19 = var12_12[var13_14];
                var15_23 /* !! */  = var14_19.getString("focus");
                if (var15_23 /* !! */  == null || var15_23 /* !! */ .length() == 0) break block54;
                var16_27 = new IAdaptable[1];
                var17_28 = var14_19.getChild("input");
                if (var17_28 == null) ** GOTO lbl141
                var18_29 = var17_28.getString("factoryID");
                if (var18_29 == null) {
                    WorkbenchPlugin.log("Unable to restore page - no input factory ID.");
                    var3_3.add(this.unableToRestorePage(var14_19));
                } else {
                    block53: {
                        try {
                            UIStats.start(4, "WorkbenchPageFactory");
                            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((IMemento)var17_28){
                                private final /* synthetic */ IMemento val$inputMem;
                                {
                                    this.val$inputMem = iMemento2;
                                }

                                @Override
                                public void runWithException() throws Throwable {
                                    IElementFactory iElementFactory = PlatformUI.getWorkbench().getElementFactory(var18_29);
                                    if (iElementFactory == null) {
                                        WorkbenchPlugin.log("Unable to restore page - cannot instantiate input factory: " + var18_29);
                                        var3_3.add(WorkbenchWindow.this.unableToRestorePage(var14_19));
                                        return;
                                    }
                                    var16_27[0] = iElementFactory.createElement(this.val$inputMem);
                                }
                            });
                            if (var16_27[0] != null) break block53;
                            WorkbenchPlugin.log("Unable to restore page - cannot instantiate input element: " + var18_29);
                            var3_3.add(this.unableToRestorePage(var14_19));
                            break block54;
                        }
                        finally {
                            UIStats.end(4, var18_29, "WorkbenchPageFactory");
                        }
                    }
                    var18_29 = var16_27[0];
                    var19_31 = new WorkbenchPage[1];
                    try {
                        StartupThreading.runWithWorkbenchExceptions(new StartupThreading.StartupRunnable((WorkbenchPage[])var19_31, (IAdaptable)var18_29){
                            private final /* synthetic */ WorkbenchPage[] val$newPage;
                            private final /* synthetic */ IAdaptable val$finalInput;
                            {
                                this.val$newPage = workbenchPageArray;
                                this.val$finalInput = iAdaptable;
                            }

                            @Override
                            public void runWithException() throws WorkbenchException {
                                this.val$newPage[0] = ((WorkbenchImplementation)Tweaklets.get(WorkbenchImplementation.KEY)).createWorkbenchPage(WorkbenchWindow.this, this.val$finalInput);
                            }
                        });
                        var3_3.add(var19_31[0].restoreState(var14_19, var2_2));
                        this.pageList.add(var19_31[0]);
                        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((WorkbenchPage[])var19_31){
                            private final /* synthetic */ WorkbenchPage[] val$newPage;
                            {
                                this.val$newPage = workbenchPageArray;
                            }

                            @Override
                            public void runWithException() throws Throwable {
                                WorkbenchWindow.this.firePageOpened(this.val$newPage[0]);
                            }
                        });
                    }
                    catch (WorkbenchException var20_34) {
                        WorkbenchPlugin.log("Unable to restore perspective - constructor failed.", (Throwable)var20_34);
                        var3_3.add(var20_34.getStatus());
                        break block54;
                    }
                    if (var15_23 /* !! */  != null && var15_23 /* !! */ .length() > 0) {
                        var11_11 = var19_31[0];
                    }
                }
            }
            ++var13_14;
        }
        if (this.pageList.isEmpty()) {
            try {
                var13_15 = this.getWorkbenchImpl().getPerspectiveRegistry().getDefaultPerspective();
                if (var13_15 != null) {
                    var14_20 = new WorkbenchPage[1];
                    StartupThreading.runWithWorkbenchExceptions(new StartupThreading.StartupRunnable(){

                        @Override
                        public void runWithException() throws Throwable {
                            var14_20[0] = ((WorkbenchImplementation)Tweaklets.get(WorkbenchImplementation.KEY)).createWorkbenchPage(WorkbenchWindow.this, var13_15, WorkbenchWindow.this.getDefaultPageInput());
                        }
                    });
                    this.pageList.add(var14_20[0]);
                    StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                        @Override
                        public void runWithException() throws Throwable {
                            WorkbenchWindow.this.firePageOpened(var14_20[0]);
                        }
                    });
                }
            }
            catch (WorkbenchException var13_16) {
                WorkbenchPlugin.log("Unable to create default perspective - constructor failed.", (Throwable)var13_16);
                var3_3.add(var13_16.getStatus());
                var14_21 = WorkbenchPlugin.getDefault().getProductName();
                if (var14_21 == null) {
                    var14_21 = "";
                }
                this.getShell().setText(var14_21);
            }
        }
        if (var11_11 == null) {
            var11_11 = this.pageList.getNextActive();
        }
        var13_17 = var11_11;
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((IWorkbenchPage)var13_17){
            private final /* synthetic */ IWorkbenchPage val$myPage;
            {
                this.val$myPage = iWorkbenchPage;
            }

            @Override
            public void runWithException() throws Throwable {
                WorkbenchWindow.this.setActivePage(this.val$myPage);
            }
        });
        var14_22 = var1_1.getChild("intro");
        if (var14_22 != null) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    WorkbenchWindow.this.getWorkbench().getIntroManager().showIntro(WorkbenchWindow.this, Boolean.valueOf(var14_22.getString("standby")));
                }
            });
        }
        if (this.defaultLayout != null) {
            var3_3.add(this.restoreTrimState(var1_1));
        }
        return var3_3;
    }

    private void restoreCoolBarLocked(final ICoolBarManager2 iCoolBarManager2, IMemento iMemento) {
        final boolean[] blArray = new boolean[1];
        Integer n = iMemento.getInteger("locked");
        if (n != null) {
            blArray[0] = n == 1;
        } else {
            ICommandService iCommandService = (ICommandService)this.getService(ICommandService.class);
            Command command = iCommandService.getCommand("org.eclipse.ui.window.lockToolBar");
            State state = command.getState("org.eclipse.ui.commands.toggleState");
            if (state != null && state.getValue() instanceof Boolean) {
                blArray[0] = (Boolean)state.getValue();
            }
        }
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                iCoolBarManager2.setLockLayout(blArray[0]);
            }
        });
    }

    private boolean restoreOldCoolBar(IMemento iMemento) {
        if (iMemento == null) {
            return false;
        }
        ICoolBarManager2 iCoolBarManager2 = (ICoolBarManager2)this.getCoolBarManager2();
        Integer n = iMemento.getInteger("locked");
        boolean bl = n != null && n == 1;
        iCoolBarManager2.setLockLayout(bl);
        IMemento iMemento2 = iMemento.getChild("toolbarLayout");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (iMemento2 != null && !this.readLayout(iMemento2, arrayList2, arrayList)) {
            return false;
        }
        IMemento iMemento3 = iMemento.getChild("layout");
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        if (iMemento3 != null && !this.readLayout(iMemento3, arrayList4, arrayList3)) {
            return false;
        }
        if (arrayList2 != null) {
            IContributionItem iContributionItem;
            if (arrayList4 != null) {
                int n2 = 0;
                for (String string : arrayList4) {
                    int n3 = -1;
                    for (String object : arrayList2) {
                        if (!object.equals(string)) continue;
                        n3 = arrayList2.indexOf(object);
                        break;
                    }
                    if (n3 == -1) {
                        boolean bl2;
                        int n4 = Math.max(0, Math.min(n2, arrayList2.size()));
                        boolean bl22 = false;
                        for (Integer n5 : arrayList3) {
                            if (n5 > n4) continue;
                            n4 = arrayList2.size();
                            arrayList.add(new Integer(n4));
                            bl2 = true;
                        }
                        arrayList2.add(n4, string);
                        if (!bl2) {
                            int n6 = 0;
                            while (n6 < arrayList.size()) {
                                Integer n5;
                                n5 = (Integer)arrayList.get(n6);
                                if (n5 >= n4) {
                                    arrayList.set(n6, new Integer(n5 + 1));
                                }
                                ++n6;
                            }
                        }
                    }
                    ++n2;
                }
            }
            ArrayList<Object> arrayList5 = new ArrayList<Object>(arrayList2.size());
            for (String string : arrayList2) {
                IContributionItem iContributionItem2 = null;
                iContributionItem = null;
                if (string != null) {
                    iContributionItem2 = iCoolBarManager2.find(string);
                }
                if (iContributionItem2 instanceof IToolBarContributionItem) {
                    iContributionItem = iContributionItem2;
                } else {
                    IActionBarPresentationFactory iActionBarPresentationFactory = this.getActionBarPresentationFactory();
                    iContributionItem = iActionBarPresentationFactory.createToolBarContributionItem((IToolBarManager)iActionBarPresentationFactory.createToolBarManager(), string);
                    iContributionItem.setVisible(false);
                    IContributionItem iContributionItem3 = this.findAlphabeticalOrder("additions", string, (IContributionManager)iCoolBarManager2);
                    if (iContributionItem3 != null) {
                        iCoolBarManager2.insertAfter(iContributionItem3.getId(), iContributionItem);
                    } else {
                        iCoolBarManager2.add(iContributionItem);
                    }
                }
                if (iContributionItem == null) continue;
                arrayList5.add(iContributionItem);
                iContributionItem.setParent((IContributionManager)iCoolBarManager2);
                iCoolBarManager2.markDirty();
            }
            int n7 = 0;
            int n8 = 1;
            while (n8 < arrayList.size()) {
                int n9 = (Integer)arrayList.get(n8) + n7;
                arrayList5.add(n9, new Separator("UserSeparator"));
                ++n7;
                ++n8;
            }
            IContributionItem[] iContributionItemArray = iCoolBarManager2.getItems();
            int n10 = 0;
            while (n10 < iContributionItemArray.length) {
                iContributionItem = iContributionItemArray[n10];
                if (iContributionItem.isGroupMarker()) {
                    arrayList5.add(Math.max(Math.min(n10, arrayList5.size()), 0), iContributionItem);
                }
                ++n10;
            }
            IContributionItem[] iContributionItemArray2 = new IContributionItem[arrayList5.size()];
            arrayList5.toArray(iContributionItemArray2);
            iCoolBarManager2.setItems(iContributionItemArray2);
        }
        return true;
    }

    private boolean readLayout(IMemento iMemento, ArrayList arrayList, ArrayList arrayList2) {
        Object object;
        IMemento[] iMementoArray = iMemento.getChildren("wrapIndex");
        if (iMementoArray == null) {
            return false;
        }
        int n = 0;
        while (n < iMementoArray.length) {
            IMemento iMemento2 = iMementoArray[n];
            object = iMemento2.getInteger("index");
            if (object == null) {
                return false;
            }
            arrayList2.add(object);
            ++n;
        }
        IMemento[] iMementoArray2 = iMemento.getChildren("item");
        if (iMementoArray2 == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < iMementoArray2.length) {
            object = iMementoArray2[n2];
            String string = object.getString("id");
            if (string == null) {
                return false;
            }
            arrayList.add(string);
            ++n2;
        }
        return true;
    }

    private IContributionItem findAlphabeticalOrder(String string, String string2, IContributionManager iContributionManager) {
        IContributionItem[] iContributionItemArray = iContributionManager.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            IContributionItem iContributionItem = iContributionItemArray[n];
            if (iContributionItem.getId() != null && iContributionItem.getId().equals(string)) break;
            ++n;
        }
        int n2 = n + 1;
        while (n2 < iContributionItemArray.length) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            String string3 = iContributionItem.getId();
            if (iContributionItem.isGroupMarker() || string2 != null && string3 != null && string2.compareTo(string3) < 1) break;
            n = n2++;
        }
        if (n >= iContributionItemArray.length) {
            return null;
        }
        return iContributionItemArray[n];
    }

    @Override
    public void run(boolean bl, boolean bl2, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        IWorkbenchContextSupport iWorkbenchContextSupport = this.getWorkbench().getContextSupport();
        boolean bl3 = iWorkbenchContextSupport.isKeyFilterEnabled();
        Control control = this.getFastViewBar() == null ? null : this.getFastViewBar().getControl();
        boolean bl4 = control == null ? false : control.getEnabled();
        ToolBar toolBar = this.getPerspectiveBar() == null ? null : this.getPerspectiveBar().getControl();
        boolean bl5 = toolBar == null ? false : toolBar.getEnabled();
        List list = null;
        try {
            if (control != null && !control.isDisposed()) {
                control.setEnabled(false);
            }
            if (toolBar != null && !toolBar.isDisposed()) {
                toolBar.setEnabled(false);
            }
            if (bl3) {
                iWorkbenchContextSupport.setKeyFilterEnabled(false);
            }
            if (this.defaultLayout != null) {
                list = this.defaultLayout.disableTrim(this.getStatusLineTrim());
            }
            super.run(bl, bl2, iRunnableWithProgress);
        }
        finally {
            if (control != null && !control.isDisposed()) {
                control.setEnabled(bl4);
            }
            if (toolBar != null && !toolBar.isDisposed()) {
                toolBar.setEnabled(bl5);
            }
            if (bl3) {
                iWorkbenchContextSupport.setKeyFilterEnabled(true);
            }
            if (this.defaultLayout != null && list != null) {
                this.defaultLayout.enableTrim(list);
            }
        }
    }

    private boolean saveAllPages(boolean bl) {
        boolean bl2 = true;
        Iterator iterator = this.pageList.iterator();
        while (bl2 && iterator.hasNext()) {
            WorkbenchPage workbenchPage = (WorkbenchPage)iterator.next();
            bl2 = workbenchPage.saveAllEditors(bl);
        }
        return bl2;
    }

    public IStatus saveState(IMemento iMemento) {
        Object object;
        IMemento iMemento2;
        Object object2;
        Object object3;
        ICoolBarManager2 iCoolBarManager2;
        Object object4;
        Object object5;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.WorkbenchWindow_problemsSavingWindow, null);
        if (this.getShell().getMaximized() || this.asMaximizedState) {
            iMemento.putString("maximized", "true");
        }
        if (this.getShell().getMinimized()) {
            iMemento.putString("minimized", "true");
        }
        if (this.normalBounds == null) {
            this.normalBounds = this.getShell().getBounds();
        }
        if (this.COCOA && (object5 = this.getWindowConfigurer().getWindow().getActivePage()) != null && object5.findView("org.eclipse.ui.internal.introview") != null) {
            object4 = this.getToolBarManager2();
            int n = ((ToolBarManager)object4).getControl().getSize().y;
            this.normalBounds.height += n;
        }
        object5 = iMemento.createChild("fastViewData");
        if (this.fastViewBar != null) {
            this.fastViewBar.saveState((IMemento)object5);
        }
        iMemento.putInteger("x", this.normalBounds.x);
        iMemento.putInteger("y", this.normalBounds.y);
        iMemento.putInteger("width", this.normalBounds.width);
        iMemento.putInteger("height", this.normalBounds.height);
        object4 = this.getActivePage();
        if (object4 != null && object4.findView("org.eclipse.ui.internal.introview") != null) {
            IMemento iMemento3 = iMemento.createChild("intro");
            boolean bl = this.getWorkbench().getIntroManager().isIntroStandby(this.getWorkbench().getIntroManager().getIntro());
            iMemento3.putString("standby", String.valueOf(bl));
        }
        IMemento iMemento4 = iMemento.createChild("perspectiveBar");
        if (this.perspectiveSwitcher != null) {
            this.perspectiveSwitcher.saveState(iMemento4);
        }
        if ((iCoolBarManager2 = (ICoolBarManager2)this.getCoolBarManager2()) != null) {
            iCoolBarManager2.refresh();
            object3 = iMemento.createChild("coolbarLayout");
            object2 = iCoolBarManager2.getItems();
            int n = 0;
            while (n < ((IContributionItem[])object2).length) {
                iMemento2 = object3.createChild("coolItem");
                object = object2[n];
                if (object.getId() != null) {
                    iMemento2.putString("id", object.getId());
                }
                if (object.isSeparator()) {
                    iMemento2.putString("itemType", "typeSeparator");
                } else if (object.isGroupMarker() && !object.isSeparator()) {
                    iMemento2.putString("itemType", "typeGroupMarker");
                } else {
                    int n2;
                    int n3;
                    Object object6;
                    if (object instanceof PlaceholderContributionItem) {
                        iMemento2.putString("itemType", "typePlaceholder");
                    } else {
                        iMemento2.putString("itemType", "typeToolBarContribution");
                    }
                    if (object instanceof IToolBarContributionItem) {
                        object6 = (IToolBarContributionItem)object;
                        object6.saveWidgetState();
                        n3 = object6.getCurrentHeight();
                        n2 = object6.getCurrentWidth();
                    } else if (object instanceof PlaceholderContributionItem) {
                        object6 = (PlaceholderContributionItem)object;
                        n3 = ((PlaceholderContributionItem)object6).getHeight();
                        n2 = ((PlaceholderContributionItem)object6).getWidth();
                    } else {
                        n3 = -1;
                        n2 = -1;
                    }
                    iMemento2.putInteger("x", n2);
                    iMemento2.putInteger("y", n3);
                }
                ++n;
            }
        }
        object3 = this.pageList.iterator();
        while (object3.hasNext()) {
            object2 = (WorkbenchPage)object3.next();
            IMemento iMemento5 = iMemento.createChild("page");
            iMemento5.putString("label", ((WorkbenchPage)object2).getLabel());
            multiStatus.add(((WorkbenchPage)object2).saveState(iMemento5));
            if (object2 == this.getActiveWorkbenchPage()) {
                iMemento5.putString("focus", "true");
            }
            if ((iMemento2 = ((WorkbenchPage)object2).getInput()) == null) continue;
            object = (IPersistableElement)Util.getAdapter(iMemento2, IPersistableElement.class);
            if (object == null) {
                WorkbenchPlugin.log("Unable to save page input: " + iMemento2 + ", because it does not adapt to IPersistableElement");
                continue;
            }
            IMemento iMemento6 = iMemento5.createChild("input");
            iMemento6.putString("factoryID", object.getFactoryId());
            object.saveState(iMemento6);
        }
        object2 = iMemento.createChild("workbenchWindowAdvisor");
        multiStatus.add(this.getWindowAdvisor().saveState((IMemento)object2));
        IMemento iMemento7 = iMemento.createChild("actionBarAdvisor");
        multiStatus.add(this.getActionBarAdvisor().saveState(iMemento7));
        if (this.defaultLayout != null) {
            iMemento2 = iMemento.createChild("trimLayout");
            multiStatus.add(this.saveTrimState(iMemento2));
        }
        return multiStatus;
    }

    private IStatus saveTrimState(IMemento iMemento) {
        int[] nArray = this.defaultLayout.getAreaIds();
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            List list = this.defaultLayout.getAreaTrim(n2);
            if (!list.isEmpty()) {
                IMemento iMemento2 = iMemento.createChild("trimArea", Integer.toString(n2));
                for (IWindowTrim iWindowTrim : list) {
                    iMemento2.createChild("trimItem", iWindowTrim.getId());
                }
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    private IStatus restoreTrimState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild("trimLayout");
        if (iMemento2 != null) {
            Object object;
            Object object2;
            IMemento[] iMementoArray = iMemento2.getChildren("trimArea");
            final ArrayList<String> arrayList = new ArrayList<String>();
            List[] listArray = new List[iMementoArray.length];
            int n = 0;
            while (n < iMementoArray.length) {
                listArray[n] = new ArrayList();
                object2 = new ArrayList();
                IMemento iMemento3 = iMementoArray[n];
                object = iMemento3.getChildren("trimItem");
                int n2 = 0;
                while (n2 < ((IMemento[])object).length) {
                    IMemento iMemento4 = object[n2];
                    String string = iMemento4.getID();
                    arrayList.add(string);
                    object2.add(string);
                    IWindowTrim iWindowTrim = this.defaultLayout.getTrim(string);
                    if (iWindowTrim != null) {
                        listArray[n].add(iWindowTrim);
                    }
                    ++n2;
                }
                String string = iMementoArray[n].getID();
                int n3 = Integer.parseInt(string);
                this.defaultLayout.setPreferredLocations(n3, (List)object2);
                ++n;
            }
            n = 0;
            while (n < iMementoArray.length) {
                object2 = iMementoArray[n];
                final int n4 = Integer.parseInt(object2.getID());
                object = listArray[n];
                StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((List)object){
                    private final /* synthetic */ List val$myTrimOrderList;
                    {
                        this.val$myTrimOrderList = list;
                    }

                    @Override
                    public void runWithException() throws Throwable {
                        WorkbenchWindow.this.defaultLayout.updateAreaTrim(n4, this.val$myTrimOrderList, false);
                    }
                });
                ++n;
            }
            if (this.trimMgr2 != null) {
                StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                    @Override
                    public void runWithException() throws Throwable {
                        WorkbenchWindow.this.trimMgr2.updateLocations(arrayList);
                    }
                });
            }
            if (this.trimContributionMgr != null) {
                StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                    @Override
                    public void runWithException() throws Throwable {
                        Perspective perspective;
                        WorkbenchWindow.this.trimContributionMgr.updateLocations(arrayList);
                        WorkbenchPage workbenchPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                        if (workbenchPage != null && (perspective = workbenchPage.getActivePerspective()) != null) {
                            workbenchPage.getEditorPresentation().updateStackButtons();
                            perspective.onActivate();
                        }
                    }
                });
            }
        } else {
            Integer n;
            IMemento iMemento5 = iMemento.getChild("fastViewData");
            if (iMemento5 != null && this.fastViewBar != null && (n = iMemento5.getInteger("fastViewLocation")) != null) {
                StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                    @Override
                    public void runWithException() throws Throwable {
                        WorkbenchWindow.this.fastViewBar.dock(n);
                        WorkbenchWindow.this.getTrimManager().addTrim(n, WorkbenchWindow.this.fastViewBar);
                    }
                });
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public void setActivePage(final IWorkbenchPage iWorkbenchPage) {
        if (this.getActiveWorkbenchPage() == iWorkbenchPage) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                WorkbenchPage workbenchPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (workbenchPage != null) {
                    workbenchPage.onDeactivate();
                }
                if (iWorkbenchPage == null || WorkbenchWindow.this.pageList.contains(iWorkbenchPage)) {
                    WorkbenchWindow.this.pageList.setActive(iWorkbenchPage);
                }
                WorkbenchPage workbenchPage2 = WorkbenchWindow.this.pageList.getActive();
                Composite composite = WorkbenchWindow.this.getPageComposite();
                StackLayout stackLayout = (StackLayout)composite.getLayout();
                if (workbenchPage2 != null) {
                    stackLayout.topControl = workbenchPage2.getClientComposite();
                    composite.layout();
                    WorkbenchWindow.this.hideEmptyWindowContents();
                    workbenchPage2.onActivate();
                    WorkbenchWindow.this.firePageActivated(workbenchPage2);
                    if (workbenchPage2.getPerspective() != null) {
                        WorkbenchWindow.this.firePerspectiveActivated(workbenchPage2, workbenchPage2.getPerspective());
                    }
                } else {
                    stackLayout.topControl = null;
                    composite.layout();
                }
                WorkbenchWindow.this.updateFastViewBar();
                if (WorkbenchWindow.this.isClosing()) {
                    return;
                }
                WorkbenchWindow.this.updateDisabled = false;
                WorkbenchWindow.this.updateActionSets();
                WorkbenchWindow.this.submitGlobalActions();
                if (WorkbenchWindow.this.perspectiveSwitcher != null) {
                    WorkbenchWindow.this.perspectiveSwitcher.update(false);
                }
                WorkbenchWindow.this.getMenuManager().update("text");
            }
        });
    }

    protected boolean toolBarChildrenExist() {
        CoolBar coolBar = (CoolBar)this.getCoolBarControl();
        return coolBar.getItemCount() > 0;
    }

    private Boolean valueOf(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Set getMenuRestrictions() {
        return this.menuRestrictions;
    }

    void liftRestrictions() {
        IMenuService iMenuService;
        if (this.menuRestrictions.isEmpty()) {
            return;
        }
        EvaluationReference[] evaluationReferenceArray = this.menuRestrictions.toArray(new EvaluationReference[this.menuRestrictions.size()]);
        IEvaluationService iEvaluationService = (IEvaluationService)this.serviceLocator.getService(IEvaluationService.class);
        IEvaluationContext iEvaluationContext = iEvaluationService.getCurrentState();
        boolean bl = false;
        int n = 0;
        while (n < evaluationReferenceArray.length) {
            EvaluationReference evaluationReference = evaluationReferenceArray[n];
            evaluationReference.setPostingChanges(true);
            boolean bl2 = evaluationReference.evaluate(iEvaluationContext);
            evaluationReference.clearResult();
            boolean bl3 = evaluationReference.evaluate(iEvaluationContext);
            if (bl2 != bl3) {
                bl = true;
                evaluationReference.getListener().propertyChange(new PropertyChangeEvent((Object)evaluationReference, evaluationReference.getProperty(), (Object)this.valueOf(bl2), (Object)this.valueOf(bl3)));
            }
            ++n;
        }
        if (bl && (iMenuService = (IMenuService)this.getWorkbench().getService(IMenuService.class)) instanceof WorkbenchMenuService) {
            ((WorkbenchMenuService)iMenuService).updateManagers();
        }
    }

    void imposeRestrictions() {
        for (EvaluationReference evaluationReference : this.menuRestrictions) {
            evaluationReference.setPostingChanges(false);
        }
    }

    private void trackShellActivation(Shell shell) {
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent shellEvent) {
                WorkbenchWindow.this.shellActivated = true;
                WorkbenchWindow.this.serviceLocator.activate();
                WorkbenchWindow.this.getWorkbenchImpl().setActivatedWindow(WorkbenchWindow.this);
                WorkbenchPage workbenchPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (workbenchPage != null) {
                    IAdaptable iAdaptable;
                    IWorkbenchPart iWorkbenchPart = workbenchPage.getActivePart();
                    if (iWorkbenchPart != null) {
                        iAdaptable = (PartSite)iWorkbenchPart.getSite();
                        iAdaptable.getPane().shellActivated();
                    }
                    if ((iAdaptable = workbenchPage.getActiveEditor()) != null) {
                        PartSite partSite = (PartSite)iAdaptable.getSite();
                        partSite.getPane().shellActivated();
                    }
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowActivated(WorkbenchWindow.this);
                }
                WorkbenchWindow.this.liftRestrictions();
            }

            public void shellDeactivated(ShellEvent shellEvent) {
                WorkbenchWindow.this.shellActivated = false;
                WorkbenchWindow.this.imposeRestrictions();
                WorkbenchWindow.this.serviceLocator.deactivate();
                WorkbenchPage workbenchPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (workbenchPage != null) {
                    IAdaptable iAdaptable;
                    IWorkbenchPart iWorkbenchPart = workbenchPage.getActivePart();
                    if (iWorkbenchPart != null) {
                        iAdaptable = (PartSite)iWorkbenchPart.getSite();
                        iAdaptable.getPane().shellDeactivated();
                    }
                    if ((iAdaptable = workbenchPage.getActiveEditor()) != null) {
                        PartSite partSite = (PartSite)iAdaptable.getSite();
                        partSite.getPane().shellDeactivated();
                    }
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowDeactivated(WorkbenchWindow.this);
                }
            }
        });
    }

    private void trackShellResize(Shell shell) {
        shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent controlEvent) {
                this.saveBounds();
            }

            public void controlResized(ControlEvent controlEvent) {
                this.saveBounds();
            }

            private void saveBounds() {
                Shell shell = WorkbenchWindow.this.getShell();
                if (shell == null) {
                    return;
                }
                if (shell.isDisposed()) {
                    return;
                }
                if (shell.getMinimized()) {
                    return;
                }
                if (shell.getMaximized()) {
                    WorkbenchWindow.this.asMaximizedState = true;
                    return;
                }
                WorkbenchWindow.this.asMaximizedState = false;
                WorkbenchWindow.this.normalBounds = shell.getBounds();
            }
        });
    }

    public void updateActionBars() {
        if (this.updateDisabled || this.updatesDeferred()) {
            return;
        }
        this.getMenuBarManager().update(false);
        try {
            this.getShell().setLayoutDeferred(true);
            if (this.COCOA) {
                this.getToolBarManager2().update(false);
            } else {
                this.getCoolBarManager2().update(false);
            }
        }
        finally {
            this.getShell().setLayoutDeferred(false);
        }
        this.getStatusLineManager().update(false);
    }

    private boolean updatesDeferred() {
        return this.largeUpdates > 0;
    }

    public final void largeUpdateStart() {
        ++this.largeUpdates;
    }

    public final void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            this.updateActionBars();
        }
    }

    public void updateActionSets() {
        Object object;
        if (this.updateDisabled) {
            return;
        }
        WorkbenchPage workbenchPage = this.getActiveWorkbenchPage();
        if (workbenchPage == null) {
            this.getActionPresentation().clearActionSets();
        } else {
            object = (ICoolBarManager2)this.getCoolBarManager2();
            if (object != null) {
                object.refresh();
            }
            this.getActionPresentation().setActionSets(workbenchPage.getActionSets());
        }
        this.fireActionSetsChanged();
        this.updateActionBars();
        object = "window/launch";
        IMenuManager iMenuManager = this.getMenuBarManager().findMenuUsingPath((String)object);
        IContributionItem iContributionItem = this.getMenuBarManager().findUsingPath((String)object);
        if (iMenuManager == null || iContributionItem == null) {
            return;
        }
        iContributionItem.setVisible(iMenuManager.getItems().length >= 2);
    }

    private final void fireActionSetsChanged() {
        if (this.actionSetListeners != null) {
            Object[] objectArray = this.actionSetListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                IActionSetsListener iActionSetsListener = (IActionSetsListener)objectArray[n];
                WorkbenchPage workbenchPage = this.getActiveWorkbenchPage();
                IActionSetDescriptor[] iActionSetDescriptorArray = workbenchPage == null ? null : workbenchPage.getActionSets();
                ActionSetsEvent actionSetsEvent = new ActionSetsEvent(iActionSetDescriptorArray);
                iActionSetsListener.actionSetsChanged(actionSetsEvent);
                ++n;
            }
        }
    }

    final void addActionSetsListener(IActionSetsListener iActionSetsListener) {
        if (this.actionSetListeners == null) {
            this.actionSetListeners = new ListenerList();
        }
        this.actionSetListeners.add((Object)iActionSetsListener);
    }

    final void removeActionSetsListener(IActionSetsListener iActionSetsListener) {
        if (this.actionSetListeners != null) {
            this.actionSetListeners.remove((Object)iActionSetsListener);
            if (this.actionSetListeners.isEmpty()) {
                this.actionSetListeners = null;
            }
        }
    }

    private void createProgressIndicator(Shell shell) {
        if (this.getWindowConfigurer().getShowProgressIndicator()) {
            this.progressRegion = new ProgressRegion();
            this.progressRegion.createContents((Composite)shell, this);
        }
        if (shell.getDisplay() != null && shell.getDisplay().getSystemTaskBar() != null) {
            String string;
            Object object;
            TaskItem taskItem = null;
            TaskBar taskBar = shell.getDisplay().getSystemTaskBar();
            taskItem = taskBar.getItem(shell);
            if (taskItem == null) {
                taskItem = taskBar.getItem(null);
            }
            if (!(taskItem == null || (object = taskItem.getData(string = String.valueOf(TaskBarProgressManager.class.getName()) + ".instance")) != null && object instanceof TaskBarProgressManager)) {
                taskItem.setData(string, (Object)new TaskBarProgressManager(taskItem));
            }
        }
    }

    WorkbenchWindowConfigurer getWindowConfigurer() {
        if (this.windowConfigurer == null) {
            this.windowConfigurer = new WorkbenchWindowConfigurer(this);
        }
        return this.windowConfigurer;
    }

    private WorkbenchAdvisor getAdvisor() {
        return this.getWorkbenchImpl().getAdvisor();
    }

    WorkbenchWindowAdvisor getWindowAdvisor() {
        if (this.windowAdvisor == null) {
            this.windowAdvisor = this.getAdvisor().createWorkbenchWindowAdvisor(this.getWindowConfigurer());
            Assert.isNotNull((Object)this.windowAdvisor);
        }
        return this.windowAdvisor;
    }

    public ActionBarAdvisor getActionBarAdvisor() {
        if (this.actionBarAdvisor == null) {
            this.actionBarAdvisor = this.getWindowAdvisor().createActionBarAdvisor(this.getWindowConfigurer().getActionBarConfigurer());
            Assert.isNotNull((Object)this.actionBarAdvisor);
        }
        return this.actionBarAdvisor;
    }

    private Workbench getWorkbenchImpl() {
        return Workbench.getInstance();
    }

    public void fillActionBars(int n) {
        Workbench workbench = this.getWorkbenchImpl();
        workbench.largeUpdateStart();
        try {
            this.getActionBarAdvisor().fillActionBars(n);
            IMenuService iMenuService = (IMenuService)this.serviceLocator.getService(IMenuService.class);
            iMenuService.populateContributionManager((ContributionManager)this.getActionBars().getMenuManager(), "menu:org.eclipse.ui.main.menu");
            ICoolBarManager iCoolBarManager = this.getActionBars().getCoolBarManager();
            if (iCoolBarManager != null) {
                iMenuService.populateContributionManager((ContributionManager)iCoolBarManager, "toolbar:org.eclipse.ui.main.toolbar");
            }
        }
        finally {
            workbench.largeUpdateEnd();
        }
    }

    public void fillActionBars(IActionBarConfigurer2 iActionBarConfigurer2, int n) {
        Assert.isNotNull((Object)iActionBarConfigurer2);
        WorkbenchWindowConfigurer.WindowActionBarConfigurer windowActionBarConfigurer = (WorkbenchWindowConfigurer.WindowActionBarConfigurer)this.getWindowConfigurer().getActionBarConfigurer();
        windowActionBarConfigurer.setProxy(iActionBarConfigurer2);
        try {
            this.getActionBarAdvisor().fillActionBars(n | 1);
        }
        finally {
            windowActionBarConfigurer.setProxy(null);
        }
    }

    protected void initializeBounds() {
        Point point = this.getInitialSize();
        Point point2 = this.getInitialLocation(point);
        this.getShell().setBounds(this.getConstrainedShellBounds(new Rectangle(point2.x, point2.y, point.x, point.y)));
    }

    protected void constrainShellSize() {
        Rectangle rectangle = this.getShell().getBounds();
        if (!SwtUtil.intersectsAnyMonitor(Display.getCurrent(), rectangle)) {
            super.constrainShellSize();
        }
    }

    protected Point getInitialLocation(Point point) {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getLocation();
        }
        return super.getInitialLocation(point);
    }

    protected Point getInitialSize() {
        return this.getWindowConfigurer().getInitialSize();
    }

    public void setCoolBarVisible(boolean bl) {
        boolean bl2 = this.coolBarVisible;
        this.coolBarVisible = bl;
        if (bl2 != this.coolBarVisible) {
            this.updateLayoutDataForContents();
            this.firePropertyChanged(PROP_COOLBAR_VISIBLE, bl2 ? Boolean.TRUE : Boolean.FALSE, this.coolBarVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getCoolBarVisible() {
        return this.COCOA ? false : this.getWindowConfigurer().getShowCoolBar() && this.coolBarVisible;
    }

    public void setPerspectiveBarVisible(boolean bl) {
        boolean bl2 = this.perspectiveBarVisible;
        this.perspectiveBarVisible = bl;
        if (bl2 != this.perspectiveBarVisible) {
            this.updateLayoutDataForContents();
            this.firePropertyChanged(PROP_PERSPECTIVEBAR_VISIBLE, bl2 ? Boolean.TRUE : Boolean.FALSE, this.perspectiveBarVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getPerspectiveBarVisible() {
        return this.COCOA ? false : this.getWindowConfigurer().getShowPerspectiveBar() && this.perspectiveBarVisible;
    }

    public void setFastViewBarVisible(boolean bl) {
        boolean bl2 = this.fastViewBarVisible;
        this.fastViewBarVisible = bl;
        if (bl2 != this.fastViewBarVisible) {
            this.updateLayoutDataForContents();
        }
    }

    public boolean getFastViewBarVisible() {
        return this.fastViewBarVisible;
    }

    public void setStatusLineVisible(boolean bl) {
        boolean bl2 = this.statusLineVisible;
        this.statusLineVisible = bl;
        if (bl2 != this.statusLineVisible) {
            this.updateLayoutDataForContents();
            this.firePropertyChanged(PROP_STATUS_LINE_VISIBLE, bl2 ? Boolean.TRUE : Boolean.FALSE, this.statusLineVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getStatusLineVisible() {
        return this.statusLineVisible;
    }

    private void updateLayoutDataForContents() {
        boolean bl;
        if (this.defaultLayout == null) {
            return;
        }
        String string = PlatformUI.getPreferenceStore().getString("DOCK_PERSPECTIVE_BAR");
        boolean bl2 = bl = string != null && string.equalsIgnoreCase("left");
        if (this.getCoolBarVisible() && this.getWindowConfigurer().getShowCoolBar() || this.getPerspectiveBarVisible() && this.getWindowConfigurer().getShowPerspectiveBar() && !bl) {
            if (!this.COCOA && this.defaultLayout.getTrim(this.topBarTrim.getId()) == null) {
                this.defaultLayout.addTrim(128, this.topBarTrim);
            }
            this.topBar.setVisible(true);
        } else {
            if (!this.COCOA) {
                this.defaultLayout.removeTrim(this.topBarTrim);
            }
            this.topBar.setVisible(false);
        }
        if (this.fastViewBar != null) {
            if (this.getFastViewBarVisible() && this.getWindowConfigurer().getShowFastViewBars()) {
                int n = this.fastViewBar.getSide();
                if (this.defaultLayout.getTrim(this.fastViewBar.getId()) == null) {
                    this.defaultLayout.addTrim(n, this.fastViewBar);
                }
                this.fastViewBar.getControl().setVisible(true);
            } else {
                this.defaultLayout.removeTrim(this.fastViewBar);
                this.fastViewBar.getControl().setVisible(false);
            }
        }
        if (this.getStatusLineVisible() && this.getWindowConfigurer().getShowStatusLine()) {
            if (this.defaultLayout.getTrim(this.getStatusLineTrim().getId()) == null) {
                this.defaultLayout.addTrim(1024, this.getStatusLineTrim());
            }
            this.getStatusLineManager().getControl().setVisible(true);
        } else {
            this.defaultLayout.removeTrim(this.getStatusLineTrim());
            this.getStatusLineManager().getControl().setVisible(false);
        }
        if (this.heapStatus != null) {
            if (this.getShowHeapStatus()) {
                if (this.heapStatus.getLayoutData() == null) {
                    this.heapStatusTrim.setWidthHint(this.heapStatus.computeSize((int)-1, (int)-1).x);
                    this.heapStatusTrim.setHeightHint(this.getStatusLineManager().getControl().computeSize((int)-1, (int)-1).y);
                }
                if (this.defaultLayout.getTrim(this.heapStatusTrim.getId()) == null) {
                    this.defaultLayout.addTrim(1024, this.heapStatusTrim);
                }
                this.heapStatus.setVisible(true);
            } else {
                this.defaultLayout.removeTrim(this.heapStatusTrim);
                this.heapStatus.setVisible(false);
            }
        }
        if (this.progressRegion != null) {
            if (this.getWindowConfigurer().getShowProgressIndicator()) {
                if (this.defaultLayout.getTrim(this.progressRegion.getId()) == null) {
                    this.defaultLayout.addTrim(1024, this.progressRegion);
                }
                this.progressRegion.getControl().setVisible(true);
            } else {
                this.defaultLayout.removeTrim(this.progressRegion);
                this.progressRegion.getControl().setVisible(false);
            }
        }
        this.defaultLayout.setCenterControl((Control)this.getPageComposite());
        if (this.trimMgr2 != null) {
            this.trimMgr2.update(true, false, !this.topBar.getVisible());
        }
        if (this.trimContributionMgr != null) {
            this.trimContributionMgr.update(true, !this.topBar.getVisible());
        }
    }

    public boolean getShowFastViewBars() {
        return this.getWindowConfigurer().getShowFastViewBars();
    }

    private void setLayoutDataForContents() {
        this.updateLayoutDataForContents();
    }

    public FastViewBar getFastViewBar() {
        return this.fastViewBar;
    }

    public PerspectiveBarManager getPerspectiveBar() {
        return this.perspectiveSwitcher == null ? null : this.perspectiveSwitcher.getPerspectiveBar();
    }

    public ActionPresentation getActionPresentation() {
        if (this.actionPresentation == null) {
            this.actionPresentation = new ActionPresentation(this);
        }
        return this.actionPresentation;
    }

    public IActionBarPresentationFactory getActionBarPresentationFactory() {
        AbstractPresentationFactory abstractPresentationFactory = this.getWindowConfigurer().getPresentationFactory();
        IActionBarPresentationFactory iActionBarPresentationFactory = abstractPresentationFactory instanceof IActionBarPresentationFactory ? (IActionBarPresentationFactory)((Object)abstractPresentationFactory) : new DefaultActionBarPresentationFactory();
        return iActionBarPresentationFactory;
    }

    protected boolean showTopSeperator() {
        return false;
    }

    protected ICoolBarManager createCoolBarManager2(int n) {
        ICoolBarManager2 iCoolBarManager2 = this.getActionBarPresentationFactory().createCoolBarManager();
        iCoolBarManager2.setOverrides(this.toolbarOverride);
        return iCoolBarManager2;
    }

    protected IToolBarManager createToolBarManager2(int n) {
        IToolBarManager2 iToolBarManager2 = this.getActionBarPresentationFactory().createToolBarManager();
        iToolBarManager2.setOverrides(this.toolbarOverride);
        return iToolBarManager2;
    }

    protected StatusLineManager createStatusLineManager() {
        return (StatusLineManager)this.getWindowConfigurer().getPresentationFactory().createStatusLineManager();
    }

    protected void createStatusLine(Shell shell) {
        this.getWindowConfigurer().getPresentationFactory().createStatusLineControl((IStatusLineManager)this.getStatusLineManager(), (Composite)shell);
    }

    public void updateFastViewBar() {
        if (this.getFastViewBar() != null) {
            this.getFastViewBar().update(true);
        }
    }

    public ProgressRegion getProgressRegion() {
        return this.progressRegion;
    }

    public void addToTrim(IWindowTrim iWindowTrim, int n) {
        IWindowTrim iWindowTrim2 = null;
        this.defaultLayout.addTrim(n, iWindowTrim, iWindowTrim2);
    }

    @Override
    public IExtensionTracker getExtensionTracker() {
        if (this.tracker == null) {
            this.tracker = new UIExtensionTracker(this.getWorkbench().getDisplay());
        }
        return this.tracker;
    }

    public CustomizePerspectiveDialog createCustomizePerspectiveDialog(Perspective perspective) {
        return new CustomizePerspectiveDialog(this.getWindowConfigurer(), perspective);
    }

    IAdaptable getDefaultPageInput() {
        return this.getWorkbenchImpl().getDefaultPageInput();
    }

    public void addPerspectiveReorderListener(IReorderListener iReorderListener) {
        if (this.perspectiveSwitcher != null) {
            this.perspectiveSwitcher.addReorderListener(iReorderListener);
        }
    }

    public void showHeapStatus(boolean bl) {
        if (bl) {
            if (this.heapStatus == null) {
                this.createHeapStatus((Composite)this.getShell());
                this.updateLayoutDataForContents();
                this.getShell().layout();
            }
        } else if (this.heapStatus != null) {
            this.heapStatus.dispose();
            this.heapStatus = null;
        }
    }

    public ITrimManager getTrimManager() {
        return this.defaultLayout;
    }

    private final void initializeDefaultServices() {
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.IWorkbenchWindow", this.getWorkbench(), this, null, null, null, 1));
        this.serviceLocator.registerService(IWorkbenchWindow.class, this);
        ActionCommandMappingService actionCommandMappingService = new ActionCommandMappingService();
        this.serviceLocator.registerService(IActionCommandMappingService.class, actionCommandMappingService);
        LegacyActionPersistence legacyActionPersistence = new LegacyActionPersistence(this);
        this.serviceLocator.registerService(LegacyActionPersistence.class, legacyActionPersistence);
        legacyActionPersistence.read();
    }

    @Override
    public final Object getService(Class clazz) {
        return this.serviceLocator.getService(clazz);
    }

    @Override
    public final boolean hasService(Class clazz) {
        return this.serviceLocator.hasService(clazz);
    }

    public void toggleToolbarVisibility() {
        boolean bl = this.getCoolBarVisible();
        boolean bl2 = this.getPerspectiveBarVisible();
        IPreferenceStore iPreferenceStore = PrefUtil.getInternalPreferenceStore();
        if (this.getWindowConfigurer().getShowCoolBar()) {
            this.setCoolBarVisible(!bl);
            iPreferenceStore.setValue("coolBarVisible", !bl);
        }
        if (this.getWindowConfigurer().getShowPerspectiveBar()) {
            this.setPerspectiveBarVisible(!bl2);
            iPreferenceStore.setValue(PROP_PERSPECTIVEBAR_VISIBLE, !bl2);
        }
        this.getShell().layout();
    }

    void addBackgroundSaveListener(IBackgroundSaveListener iBackgroundSaveListener) {
        this.backgroundSaveListeners.add((Object)iBackgroundSaveListener);
    }

    void fireBackgroundSaveStarted() {
        Object[] objectArray = this.backgroundSaveListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IBackgroundSaveListener iBackgroundSaveListener = (IBackgroundSaveListener)objectArray[n];
            iBackgroundSaveListener.handleBackgroundSaveStarted();
            ++n;
        }
    }

    void removeBackgroundSaveListener(IBackgroundSaveListener iBackgroundSaveListener) {
        this.backgroundSaveListeners.remove((Object)iBackgroundSaveListener);
    }

    class PageList {
        private List pagesInCreationOrder = new ArrayList(4);
        private List pageInActivationOrder = new ArrayList(4);
        private Object active;

        public boolean add(Object object) {
            this.pagesInCreationOrder.add(object);
            this.pageInActivationOrder.add(0, object);
            return true;
        }

        public Iterator iterator() {
            return this.pagesInCreationOrder.iterator();
        }

        public boolean contains(Object object) {
            return this.pagesInCreationOrder.contains(object);
        }

        public boolean remove(Object object) {
            if (this.active == object) {
                this.active = null;
            }
            this.pageInActivationOrder.remove(object);
            return this.pagesInCreationOrder.remove(object);
        }

        public boolean isEmpty() {
            return this.pagesInCreationOrder.isEmpty();
        }

        public IWorkbenchPage[] getPages() {
            int n = this.pagesInCreationOrder.size();
            IWorkbenchPage[] iWorkbenchPageArray = new IWorkbenchPage[n];
            this.pagesInCreationOrder.toArray(iWorkbenchPageArray);
            return iWorkbenchPageArray;
        }

        public void setActive(Object object) {
            if (this.active == object) {
                return;
            }
            this.active = object;
            if (object != null) {
                this.pageInActivationOrder.remove(object);
                this.pageInActivationOrder.add(object);
            }
        }

        public WorkbenchPage getActive() {
            return (WorkbenchPage)this.active;
        }

        public WorkbenchPage getNextActive() {
            if (this.active == null) {
                if (this.pageInActivationOrder.isEmpty()) {
                    return null;
                }
                return (WorkbenchPage)this.pageInActivationOrder.get(this.pageInActivationOrder.size() - 1);
            }
            if (this.pageInActivationOrder.size() < 2) {
                return null;
            }
            return (WorkbenchPage)this.pageInActivationOrder.get(this.pageInActivationOrder.size() - 2);
        }
    }
}

