/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.text.Bidi;
import com.ibm.icu.text.MessageFormat;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.JFaceUtil;
import org.eclipse.ui.internal.ProductInfo;
import org.eclipse.ui.internal.SharedImages;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkingSetManager;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.intro.IIntroRegistry;
import org.eclipse.ui.internal.intro.IntroRegistry;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.operations.WorkbenchOperationSupport;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistryReader;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.wizards.ExportWizardRegistry;
import org.eclipse.ui.internal.wizards.ImportWizardRegistry;
import org.eclipse.ui.internal.wizards.NewWizardRegistry;
import org.eclipse.ui.operations.IWorkbenchOperationSupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

public class WorkbenchPlugin
extends AbstractUIPlugin {
    private static final String DATA_SPLASH_SHELL = "org.eclipse.ui.workbench.splashShell";
    private static final String PROP_SPLASH_HANDLE = "org.eclipse.equinox.launcher.splash.handle";
    private static final String LEFT_TO_RIGHT = "ltr";
    private static final String RIGHT_TO_LEFT = "rtl";
    private static final String ORIENTATION_COMMAND_LINE = "-dir";
    private static final String ORIENTATION_PROPERTY = "eclipse.orientation";
    private static final String NL_USER_PROPERTY = "osgi.nl.user";
    private static WorkbenchPlugin inst;
    private EditorRegistry editorRegistry;
    private DecoratorManager decoratorManager;
    private ThemeRegistry themeRegistry;
    private WorkingSetManager workingSetManager;
    private WorkingSetRegistry workingSetRegistry;
    private BundleContext bundleContext;
    private Collection startingBundles = new HashSet();
    public static boolean DEBUG;
    public static String PI_WORKBENCH;
    public static char PREFERENCE_PAGE_CATEGORY_SEPARATOR;
    private WorkbenchPreferenceManager preferenceManager;
    private ViewRegistry viewRegistry;
    private PerspectiveRegistry perspRegistry;
    private ActionSetRegistry actionSetRegistry;
    private SharedImages sharedImages;
    private ProductInfo productInfo = null;
    private IntroRegistry introRegistry;
    private WorkbenchOperationSupport operationSupport;
    private BundleListener bundleListener;

    static {
        DEBUG = false;
        PI_WORKBENCH = "org.eclipse.ui";
        PREFERENCE_PAGE_CATEGORY_SEPARATOR = (char)47;
    }

    public WorkbenchPlugin() {
        inst = this;
    }

    void reset() {
        this.editorRegistry = null;
        if (this.decoratorManager != null) {
            this.decoratorManager.shutdown();
            this.decoratorManager = null;
        }
        ProgressManager.shutdownProgressManager();
        this.themeRegistry = null;
        if (this.workingSetManager != null) {
            this.workingSetManager.dispose();
            this.workingSetManager = null;
        }
        this.workingSetRegistry = null;
        this.preferenceManager = null;
        if (this.viewRegistry != null) {
            this.viewRegistry.dispose();
            this.viewRegistry = null;
        }
        if (this.perspRegistry != null) {
            this.perspRegistry.dispose();
            this.perspRegistry = null;
        }
        this.actionSetRegistry = null;
        this.sharedImages = null;
        this.productInfo = null;
        this.introRegistry = null;
        if (this.operationSupport != null) {
            this.operationSupport.dispose();
            this.operationSupport = null;
        }
        DragCursors.dispose();
        DEBUG = false;
    }

    public static Object createExtension(final IConfigurationElement iConfigurationElement, final String string) throws CoreException {
        try {
            if (BundleUtility.isActivated(iConfigurationElement.getDeclaringExtension().getNamespace())) {
                return iConfigurationElement.createExecutableExtension(string);
            }
            final Object[] objectArray = new Object[1];
            final CoreException[] coreExceptionArray = new CoreException[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        objectArray[0] = iConfigurationElement.createExecutableExtension(string);
                    }
                    catch (CoreException coreException) {
                        coreExceptionArray[0] = coreException;
                    }
                }
            });
            if (coreExceptionArray[0] != null) {
                throw coreExceptionArray[0];
            }
            return objectArray[0];
        }
        catch (CoreException coreException) {
            throw coreException;
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, PI_WORKBENCH, 4, WorkbenchMessages.WorkbenchPlugin_extension, (Throwable)exception));
        }
    }

    public static boolean hasExecutableExtension(IConfigurationElement iConfigurationElement, String string) {
        if (iConfigurationElement.getAttribute(string) != null) {
            return true;
        }
        String string2 = iConfigurationElement.getValue();
        if (string2 != null && !string2.equals("")) {
            return true;
        }
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(string);
        return iConfigurationElementArray.length == 1 && iConfigurationElementArray[0].getAttribute("class") != null;
    }

    public static boolean isBundleLoadedForExecutableExtension(IConfigurationElement iConfigurationElement, String string) {
        Bundle bundle = WorkbenchPlugin.getBundleForExecutableExtension(iConfigurationElement, string);
        if (bundle == null) {
            return true;
        }
        return bundle.getState() == 32;
    }

    public static Bundle getBundleForExecutableExtension(IConfigurationElement iConfigurationElement, String string) {
        String string2 = null;
        String string3 = null;
        if (string != null) {
            string2 = iConfigurationElement.getAttribute(string);
        } else {
            string2 = iConfigurationElement.getValue();
            if (string2 != null && (string2 = string2.trim()).equals("")) {
                string2 = null;
            }
        }
        if (string2 == null) {
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(string);
            if (iConfigurationElementArray.length != 0) {
                string3 = iConfigurationElementArray[0].getAttribute("plugin");
            }
        } else {
            int n = string2.indexOf(58);
            String string4 = n != -1 ? string2.substring(0, n).trim() : string2;
            n = string4.indexOf(47);
            if (n != -1) {
                string3 = string4.substring(0, n).trim();
            }
        }
        if (string3 == null) {
            string3 = iConfigurationElement.getContributor().getName();
        }
        return Platform.getBundle(string3);
    }

    @Override
    protected ImageRegistry createImageRegistry() {
        return WorkbenchImages.getImageRegistry();
    }

    public ActionSetRegistry getActionSetRegistry() {
        if (this.actionSetRegistry == null) {
            this.actionSetRegistry = new ActionSetRegistry();
        }
        return this.actionSetRegistry;
    }

    public static WorkbenchPlugin getDefault() {
        return inst;
    }

    public IEditorRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = new EditorRegistry();
        }
        return this.editorRegistry;
    }

    public IElementFactory getElementFactory(String string) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_WORKBENCH, "elementFactories");
        if (iExtensionPoint == null) {
            WorkbenchPlugin.log("Unable to find element factory. Extension point: elementFactories not found");
            return null;
        }
        IConfigurationElement iConfigurationElement = null;
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string2 = iConfigurationElementArray[n].getAttribute("id");
            if (string.equals(string2)) {
                iConfigurationElement = iConfigurationElementArray[n];
                break;
            }
            ++n;
        }
        if (iConfigurationElement == null) {
            WorkbenchPlugin.log("Unable to find element factory: " + string);
            return null;
        }
        IElementFactory iElementFactory = null;
        try {
            iElementFactory = (IElementFactory)WorkbenchPlugin.createExtension(iConfigurationElement, "class");
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Unable to create element factory.", coreException.getStatus());
            iElementFactory = null;
        }
        return iElementFactory;
    }

    public AbstractPresentationFactory getPresentationFactory(String string) {
        Object object = this.createExtension("presentationFactories", "factory", string);
        if (object instanceof AbstractPresentationFactory) {
            return (AbstractPresentationFactory)object;
        }
        WorkbenchPlugin.log("Error creating presentation factory: " + string + " -- class is not an AbstractPresentationFactory");
        return null;
    }

    private Object createExtension(String string, String string2, String string3) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_WORKBENCH, string);
        if (iExtensionPoint == null) {
            WorkbenchPlugin.log("Unable to find extension. Extension point: " + string + " not found");
            return null;
        }
        IConfigurationElement iConfigurationElement = null;
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string4;
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            if ((string2 == null || string2.equals(iConfigurationElement2.getName())) && string3.equals(string4 = iConfigurationElement2.getAttribute("id"))) {
                iConfigurationElement = iConfigurationElement2;
                break;
            }
            ++n;
        }
        if (iConfigurationElement == null) {
            WorkbenchPlugin.log("Unable to find extension: " + string3 + " in extension point: " + string);
            return null;
        }
        try {
            return WorkbenchPlugin.createExtension(iConfigurationElement, "class");
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Unable to create extension: " + string3 + " in extension point: " + string + ", status: ", coreException.getStatus());
            return null;
        }
    }

    public IPerspectiveRegistry getPerspectiveRegistry() {
        if (this.perspRegistry == null) {
            this.perspRegistry = new PerspectiveRegistry();
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    WorkbenchPlugin.this.perspRegistry.load();
                }
            });
        }
        return this.perspRegistry;
    }

    public IWorkingSetManager getWorkingSetManager() {
        if (this.workingSetManager == null) {
            this.workingSetManager = new WorkingSetManager(this.bundleContext);
            this.workingSetManager.restoreState();
        }
        return this.workingSetManager;
    }

    public WorkingSetRegistry getWorkingSetRegistry() {
        if (this.workingSetRegistry == null) {
            this.workingSetRegistry = new WorkingSetRegistry();
            this.workingSetRegistry.load();
        }
        return this.workingSetRegistry;
    }

    public IIntroRegistry getIntroRegistry() {
        if (this.introRegistry == null) {
            this.introRegistry = new IntroRegistry();
        }
        return this.introRegistry;
    }

    public IWorkbenchOperationSupport getOperationSupport() {
        if (this.operationSupport == null) {
            this.operationSupport = new WorkbenchOperationSupport();
        }
        return this.operationSupport;
    }

    public PreferenceManager getPreferenceManager() {
        if (this.preferenceManager == null) {
            this.preferenceManager = new WorkbenchPreferenceManager(PREFERENCE_PAGE_CATEGORY_SEPARATOR);
            PreferencePageRegistryReader preferencePageRegistryReader = new PreferencePageRegistryReader(this.getWorkbench());
            preferencePageRegistryReader.loadFromRegistry(Platform.getExtensionRegistry());
            this.preferenceManager.addPages(preferencePageRegistryReader.getTopLevelNodes());
        }
        return this.preferenceManager;
    }

    public ISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = new SharedImages();
        }
        return this.sharedImages;
    }

    public IThemeRegistry getThemeRegistry() {
        if (this.themeRegistry == null) {
            this.themeRegistry = new ThemeRegistry();
            ThemeRegistryReader themeRegistryReader = new ThemeRegistryReader();
            themeRegistryReader.readThemes(Platform.getExtensionRegistry(), this.themeRegistry);
        }
        return this.themeRegistry;
    }

    public IViewRegistry getViewRegistry() {
        if (this.viewRegistry == null) {
            this.viewRegistry = new ViewRegistry();
        }
        return this.viewRegistry;
    }

    @Override
    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    @Override
    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
    }

    public static void log(String string) {
        WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, string, null));
    }

    public static void log(Throwable throwable) {
        WorkbenchPlugin.getDefault().getLog().log(WorkbenchPlugin.getStatus(throwable));
    }

    public static IStatus getStatus(Throwable throwable) {
        String string = StatusUtil.getLocalizedMessage(throwable);
        return WorkbenchPlugin.newError(string, throwable);
    }

    public static IStatus newError(String string, Throwable throwable) {
        String string2 = "org.eclipse.ui.workbench";
        int n = 0;
        if (throwable instanceof CoreException) {
            CoreException coreException = (CoreException)throwable;
            string2 = coreException.getStatus().getPlugin();
            n = coreException.getStatus().getCode();
        }
        return new Status(4, string2, n, string, StatusUtil.getCause(throwable));
    }

    public static void log(String string, Throwable throwable) {
        IStatus iStatus = StatusUtil.newStatus(4, string, throwable);
        WorkbenchPlugin.log(string, iStatus);
    }

    public static void log(Class clazz, String string, Throwable throwable) {
        String string2 = MessageFormat.format((String)"Exception in {0}.{1}: {2}", (Object[])new Object[]{clazz.getName(), string, throwable});
        WorkbenchPlugin.log(string2, throwable);
    }

    public static void log(String string, IStatus iStatus) {
        if (string != null) {
            WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, string, null));
        }
        WorkbenchPlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(IStatus iStatus) {
        WorkbenchPlugin.getDefault().getLog().log(iStatus);
    }

    public DecoratorManager getDecoratorManager() {
        if (this.decoratorManager == null) {
            this.decoratorManager = new DecoratorManager();
        }
        return this.decoratorManager;
    }

    @Override
    public void start(BundleContext bundleContext) throws Exception {
        bundleContext.addBundleListener(this.getBundleListener());
        super.start(bundleContext);
        this.bundleContext = bundleContext;
        JFaceUtil.initializeJFace();
        Window.setDefaultOrientation((int)this.getDefaultOrientation());
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        try {
            if (bundle != null) {
                bundle.start(1);
            }
        }
        catch (BundleException bundleException) {
            WorkbenchPlugin.log("Unable to load UI activator", bundleException);
        }
    }

    private int getDefaultOrientation() {
        String[] stringArray = Platform.getCommandLineArgs();
        int n = this.getCommandLineOrientation(stringArray);
        if (n != 0) {
            return n;
        }
        n = this.getSystemPropertyOrientation();
        if (n != 0) {
            return n;
        }
        return this.checkCommandLineLocale();
    }

    private Boolean isBidiMessageText() {
        String string = WorkbenchMessages.Startup_Loading_Workbench;
        if (string == null) {
            return null;
        }
        try {
            boolean bl = Bidi.requiresBidi((char[])string.toCharArray(), (int)0, (int)string.length());
            return new Boolean(bl);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    private int checkCommandLineLocale() {
        if (System.getProperty(NL_USER_PROPERTY) == null) {
            Boolean bl = this.isBidiMessageText();
            if (bl != null && bl.booleanValue()) {
                return 0x4000000;
            }
        } else {
            boolean bl;
            String string = Locale.getDefault().getLanguage();
            boolean bl2 = bl = "iw".equals(string) || "he".equals(string) || "ar".equals(string) || "fa".equals(string) || "ur".equals(string);
            if (bl) {
                Boolean bl3 = this.isBidiMessageText();
                if (bl3 == null) {
                    return 0x4000000;
                }
                if (bl3.booleanValue()) {
                    return 0x4000000;
                }
            }
        }
        return 0;
    }

    private int getSystemPropertyOrientation() {
        String string = System.getProperty(ORIENTATION_PROPERTY);
        if (RIGHT_TO_LEFT.equals(string)) {
            return 0x4000000;
        }
        if (LEFT_TO_RIGHT.equals(string)) {
            return 0x2000000;
        }
        return 0;
    }

    private int getCommandLineOrientation(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[n].equalsIgnoreCase(ORIENTATION_COMMAND_LINE)) {
                String string = stringArray[n + 1];
                if (string.equals(RIGHT_TO_LEFT)) {
                    System.setProperty(ORIENTATION_PROPERTY, RIGHT_TO_LEFT);
                    return 0x4000000;
                }
                if (string.equals(LEFT_TO_RIGHT)) {
                    System.setProperty(ORIENTATION_PROPERTY, LEFT_TO_RIGHT);
                    return 0x2000000;
                }
            }
            ++n;
        }
        return 0;
    }

    public Bundle[] getBundles() {
        return this.bundleContext == null ? new Bundle[]{} : this.bundleContext.getBundles();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public String getAppName() {
        return this.getProductInfo().getAppName();
    }

    public String getAppVersion() {
        return this.getProductInfo().getAppVersion();
    }

    public String getProductName() {
        return this.getProductInfo().getProductName();
    }

    public ImageDescriptor[] getWindowImages() {
        return this.getProductInfo().getWindowImages();
    }

    private ProductInfo getProductInfo() {
        if (this.productInfo == null) {
            this.productInfo = new ProductInfo(Platform.getProduct());
        }
        return this.productInfo;
    }

    @Override
    public void stop(BundleContext bundleContext) throws Exception {
        if (this.bundleListener != null) {
            bundleContext.removeBundleListener(this.bundleListener);
            this.bundleListener = null;
        }
        super.stop(bundleContext);
    }

    public IWizardRegistry getNewWizardRegistry() {
        return NewWizardRegistry.getInstance();
    }

    public IWizardRegistry getImportWizardRegistry() {
        return ImportWizardRegistry.getInstance();
    }

    public IWizardRegistry getExportWizardRegistry() {
        return ExportWizardRegistry.getInstance();
    }

    public IPath getDataLocation() {
        try {
            return this.getStateLocation();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    void addBundleListener(BundleListener bundleListener) {
        this.bundleContext.addBundleListener(bundleListener);
    }

    void removeBundleListener(BundleListener bundleListener) {
        this.bundleContext.removeBundleListener(bundleListener);
    }

    int getBundleCount() {
        return this.bundleContext.getBundles().length;
    }

    OutputStream getSplashStream() {
        ServiceReference[] serviceReferenceArray;
        try {
            serviceReferenceArray = this.bundleContext.getServiceReferences(OutputStream.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        if (serviceReferenceArray == null) {
            return null;
        }
        int n = 0;
        while (n < serviceReferenceArray.length) {
            String string = (String)serviceReferenceArray[n].getProperty("name");
            if (string != null && string.equals("splashstream")) {
                Object object = this.bundleContext.getService(serviceReferenceArray[n]);
                this.bundleContext.ungetService(serviceReferenceArray[n]);
                return (OutputStream)object;
            }
            ++n;
        }
        return null;
    }

    private BundleListener getBundleListener() {
        if (this.bundleListener == null) {
            this.bundleListener = new SynchronousBundleListener(){

                public void bundleChanged(BundleEvent bundleEvent) {
                    WorkbenchPlugin.this.bundleChanged(bundleEvent);
                }
            };
        }
        return this.bundleListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bundleChanged(BundleEvent bundleEvent) {
        int n = bundleEvent.getType();
        Collection collection = this.startingBundles;
        synchronized (collection) {
            switch (n) {
                case 128: {
                    this.startingBundles.add(bundleEvent.getBundle());
                    break;
                }
                case 2: 
                case 4: {
                    this.startingBundles.remove(bundleEvent.getBundle());
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarting(Bundle bundle) {
        Collection collection = this.startingBundles;
        synchronized (collection) {
            return this.startingBundles.contains(bundle);
        }
    }

    public static boolean isSplashHandleSpecified() {
        return System.getProperty(PROP_SPLASH_HANDLE) != null;
    }

    public static Shell getSplashShell(Display display) throws NumberFormatException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Shell shell = (Shell)display.getData(DATA_SPLASH_SHELL);
        if (shell != null) {
            return shell;
        }
        String string = System.getProperty(PROP_SPLASH_HANDLE);
        if (string == null) {
            return null;
        }
        try {
            Method method = Shell.class.getMethod("internal_new", Display.class, Integer.TYPE);
            shell = (Shell)method.invoke(null, display, new Integer(string));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Method method = Shell.class.getMethod("internal_new", Display.class, Long.TYPE);
                shell = (Shell)method.invoke(null, display, new Long(string));
            }
            catch (NoSuchMethodException noSuchMethodException2) {}
        }
        display.setData(DATA_SPLASH_SHELL, (Object)shell);
        return shell;
    }

    public static void unsetSplashShell(Display display) {
        Shell shell = (Shell)display.getData(DATA_SPLASH_SHELL);
        if (shell != null) {
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            display.setData(DATA_SPLASH_SHELL, null);
        }
    }
}

