/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.UIListenerLogging;
import org.eclipse.ui.internal.util.Util;

public abstract class WorkbenchPartReference
implements IWorkbenchPartReference,
ISizeProvider {
    public static final int INTERNAL_PROPERTY_OPENED = 529;
    public static final int INTERNAL_PROPERTY_CLOSED = 530;
    public static final int INTERNAL_PROPERTY_PINNED = 531;
    public static final int INTERNAL_PROPERTY_VISIBLE = 532;
    public static final int INTERNAL_PROPERTY_ZOOMED = 533;
    public static final int INTERNAL_PROPERTY_ACTIVE_CHILD_CHANGED = 534;
    public static final int INTERNAL_PROPERTY_MAXIMIZED = 535;
    public static int STATE_LAZY = 0;
    public static int STATE_CREATION_IN_PROGRESS = 1;
    public static int STATE_CREATED = 2;
    public static int STATE_DISPOSED = 3;
    private int state = STATE_LAZY;
    protected IWorkbenchPart part;
    private String id;
    protected PartPane pane;
    private boolean pinned = false;
    private String title;
    private String tooltip;
    private Image image = null;
    private ImageDescriptor defaultImageDescriptor;
    private ImageDescriptor imageDescriptor;
    private ListenerList propChangeListeners = new ListenerList();
    private ListenerList internalPropChangeListeners = new ListenerList();
    private ListenerList partChangeListeners = new ListenerList();
    private String partName;
    private String contentDescription;
    protected Map propertyCache = new HashMap();
    private BitSet queuedEvents = new BitSet();
    private boolean queueEvents = false;
    private DisposeListener prematureDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            WorkbenchPlugin.log(new RuntimeException("Widget disposed too early for part " + WorkbenchPartReference.this.getId()));
        }
    };
    private IPropertyListener propertyChangeListener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object object, int n) {
            WorkbenchPartReference.this.partPropertyChanged(object, n);
        }
    };
    private IPropertyChangeListener partPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WorkbenchPartReference.this.partPropertyChanged(propertyChangeEvent);
        }
    };

    public boolean isDisposed() {
        return this.state == STATE_DISPOSED;
    }

    protected void checkReference() {
        if (this.state == STATE_DISPOSED) {
            throw new RuntimeException("Error: IWorkbenchPartReference disposed");
        }
    }

    private void deferEvents(boolean bl) {
        this.queueEvents = bl;
        if (!this.queueEvents) {
            int n = 0;
            int n2 = this.queuedEvents.size();
            while (n < n2) {
                if (this.queuedEvents.get(n)) {
                    this.firePropertyChange(n);
                    this.queuedEvents.clear(n);
                }
                ++n;
            }
        }
    }

    protected void setTitle(String string) {
        if (Util.equals(this.title, string)) {
            return;
        }
        this.title = string;
        this.firePropertyChange(1);
    }

    protected void setPartName(String string) {
        if (Util.equals(this.partName, string)) {
            return;
        }
        this.partName = string;
        this.firePropertyChange(260);
    }

    protected void setContentDescription(String string) {
        if (Util.equals(this.contentDescription, string)) {
            return;
        }
        this.contentDescription = string;
        this.firePropertyChange(261);
    }

    protected void setImageDescriptor(ImageDescriptor imageDescriptor) {
        if (Util.equals(this.imageDescriptor, imageDescriptor)) {
            return;
        }
        Image image = this.image;
        ImageDescriptor imageDescriptor2 = this.imageDescriptor;
        this.image = null;
        this.imageDescriptor = imageDescriptor;
        this.immediateFirePropertyChange(1);
        if (this.queueEvents) {
            this.queuedEvents.clear(1);
        }
        if (image != null) {
            JFaceResources.getResources().destroy((DeviceResourceDescriptor)imageDescriptor2);
        }
    }

    protected void setToolTip(String string) {
        if (Util.equals(this.tooltip, string)) {
            return;
        }
        this.tooltip = string;
        this.firePropertyChange(1);
    }

    protected void partPropertyChanged(Object object, int n) {
        IWorkbenchPart iWorkbenchPart;
        if (n == 261 || n == 260 || n == 1 || n == 1799) {
            this.refreshFromPart();
            if (n == 1799) {
                this.immediateFirePropertyChange(1);
                if (this.queueEvents) {
                    this.queuedEvents.clear(1);
                }
            }
        } else {
            this.firePropertyChange(n);
        }
        if (n == 257 && (iWorkbenchPart = this.getPart(false)) != null) {
            SaveablesList saveablesList = (SaveablesList)iWorkbenchPart.getSite().getService(ISaveablesLifecycleListener.class);
            saveablesList.dirtyChanged(iWorkbenchPart);
        }
    }

    protected void partPropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        this.firePartPropertyChange(propertyChangeEvent);
    }

    protected void refreshFromPart() {
        this.deferEvents(true);
        this.setPartName(this.computePartName());
        this.setTitle(this.computeTitle());
        this.setContentDescription(this.computeContentDescription());
        this.setToolTip(this.getRawToolTip());
        this.setImageDescriptor(this.computeImageDescriptor());
        this.deferEvents(false);
    }

    protected ImageDescriptor computeImageDescriptor() {
        if (this.part != null) {
            return ImageDescriptor.createFromImage((Image)this.part.getTitleImage(), (Device)Display.getCurrent());
        }
        return this.defaultImageDescriptor;
    }

    public void init(String string, String string2, String string3, ImageDescriptor imageDescriptor, String string4, String string5) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        Assert.isNotNull((Object)string3);
        Assert.isNotNull((Object)imageDescriptor);
        Assert.isNotNull((Object)string4);
        Assert.isNotNull((Object)string5);
        this.id = string;
        this.title = string2;
        this.tooltip = string3;
        this.partName = string4;
        this.contentDescription = string5;
        this.defaultImageDescriptor = imageDescriptor;
        this.imageDescriptor = this.computeImageDescriptor();
    }

    protected void releaseReferences() {
    }

    void addInternalPropertyListener(IPropertyListener iPropertyListener) {
        this.internalPropChangeListeners.add((Object)iPropertyListener);
    }

    void removeInternalPropertyListener(IPropertyListener iPropertyListener) {
        this.internalPropChangeListeners.remove((Object)iPropertyListener);
    }

    protected void fireInternalPropertyChange(int n) {
        Object[] objectArray = this.internalPropChangeListeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            ((IPropertyListener)objectArray[n2]).propertyChanged(this, n);
            ++n2;
        }
    }

    @Override
    public void addPropertyListener(IPropertyListener iPropertyListener) {
        if (this.isDisposed()) {
            return;
        }
        this.propChangeListeners.add((Object)iPropertyListener);
    }

    @Override
    public void removePropertyListener(IPropertyListener iPropertyListener) {
        if (this.isDisposed()) {
            return;
        }
        this.propChangeListeners.remove((Object)iPropertyListener);
    }

    @Override
    public final String getId() {
        IWorkbenchPartSite iWorkbenchPartSite;
        if (this.part != null && (iWorkbenchPartSite = this.part.getSite()) != null) {
            return iWorkbenchPartSite.getId();
        }
        return Util.safeString(this.id);
    }

    @Override
    public String getTitleToolTip() {
        return Util.safeString(this.tooltip);
    }

    protected final String getRawToolTip() {
        return Util.safeString(this.part.getTitleToolTip());
    }

    @Override
    public String getPartName() {
        return Util.safeString(this.partName);
    }

    protected final String getRawPartName() {
        String string = "";
        if (this.part instanceof IWorkbenchPart2) {
            IWorkbenchPart2 iWorkbenchPart2 = (IWorkbenchPart2)this.part;
            string = Util.safeString(iWorkbenchPart2.getPartName());
        }
        return string;
    }

    protected String computePartName() {
        return this.getRawPartName();
    }

    @Override
    public String getContentDescription() {
        return Util.safeString(this.contentDescription);
    }

    protected String computeContentDescription() {
        return this.getRawContentDescription();
    }

    protected final String getRawContentDescription() {
        if (this.part instanceof IWorkbenchPart2) {
            IWorkbenchPart2 iWorkbenchPart2 = (IWorkbenchPart2)this.part;
            return iWorkbenchPart2.getContentDescription();
        }
        return "";
    }

    @Override
    public boolean isDirty() {
        if (!(this.part instanceof ISaveablePart)) {
            return false;
        }
        return ((ISaveablePart)((Object)this.part)).isDirty();
    }

    @Override
    public String getTitle() {
        return Util.safeString(this.title);
    }

    protected String computeTitle() {
        return this.getRawTitle();
    }

    protected final String getRawTitle() {
        return Util.safeString(this.part.getTitle());
    }

    @Override
    public final Image getTitleImage() {
        if (this.isDisposed()) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
        }
        if (this.image == null) {
            this.image = JFaceResources.getResources().createImageWithDefault(this.imageDescriptor);
        }
        return this.image;
    }

    public ImageDescriptor getTitleImageDescriptor() {
        if (this.isDisposed()) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEF_VIEW");
        }
        return this.imageDescriptor;
    }

    void fireVisibilityChange() {
        this.fireInternalPropertyChange(532);
    }

    void fireZoomChange() {
        this.fireInternalPropertyChange(533);
    }

    public boolean getVisible() {
        if (this.isDisposed()) {
            return false;
        }
        return this.getPane().getVisible();
    }

    public void setVisible(boolean bl) {
        if (this.isDisposed()) {
            return;
        }
        this.getPane().setVisible(bl);
    }

    protected void firePropertyChange(int n) {
        if (this.queueEvents) {
            this.queuedEvents.set(n);
            return;
        }
        this.immediateFirePropertyChange(n);
    }

    private void immediateFirePropertyChange(int n) {
        UIListenerLogging.logPartReferencePropertyChange(this, n);
        Object[] objectArray = this.propChangeListeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            ((IPropertyListener)objectArray[n2]).propertyChanged(this.part, n);
            ++n2;
        }
        this.fireInternalPropertyChange(n);
    }

    @Override
    public final IWorkbenchPart getPart(boolean bl) {
        if (this.isDisposed()) {
            return null;
        }
        if (this.part == null && bl) {
            if (this.state == STATE_CREATION_IN_PROGRESS) {
                IStatus iStatus = WorkbenchPlugin.getStatus((Throwable)((Object)new PartInitException(NLS.bind((String)"Warning: Detected recursive attempt by part {0} to create itself (this is probably, but not necessarily, a bug)", (Object)this.getId()))));
                WorkbenchPlugin.log(iStatus);
                return null;
            }
            try {
                this.state = STATE_CREATION_IN_PROGRESS;
                IWorkbenchPart iWorkbenchPart = this.createPart();
                if (iWorkbenchPart != null) {
                    this.part = iWorkbenchPart;
                    this.getPane().getControl().addDisposeListener(this.prematureDisposeListener);
                    this.part.addPropertyListener(this.propertyChangeListener);
                    if (this.part instanceof IWorkbenchPart3) {
                        ((IWorkbenchPart3)this.part).addPartPropertyListener(this.partPropertyChangeListener);
                    }
                    this.refreshFromPart();
                    this.releaseReferences();
                    this.fireInternalPropertyChange(529);
                    ISizeProvider iSizeProvider = (ISizeProvider)Util.getAdapter(this.part, ISizeProvider.class);
                    if (iSizeProvider != null && (iSizeProvider.getSizeFlags(true) != 0 || iSizeProvider.getSizeFlags(false) != 0)) {
                        this.fireInternalPropertyChange(771);
                    }
                }
            }
            finally {
                this.state = STATE_CREATED;
            }
        }
        return this.part;
    }

    protected abstract IWorkbenchPart createPart();

    protected abstract PartPane createPane();

    public final PartPane getPane() {
        if (this.pane == null) {
            this.pane = this.createPane();
        }
        return this.pane;
    }

    public final void dispose() {
        Control control;
        if (this.isDisposed()) {
            return;
        }
        this.partName = this.getPartName();
        this.contentDescription = this.getContentDescription();
        this.tooltip = this.getTitleToolTip();
        this.title = this.getTitle();
        if (this.state == STATE_CREATION_IN_PROGRESS) {
            IStatus iStatus = WorkbenchPlugin.getStatus((Throwable)((Object)new PartInitException(NLS.bind((String)"Warning: Blocked recursive attempt by part {0} to dispose itself during creation", (Object)this.getId()))));
            WorkbenchPlugin.log(iStatus);
            return;
        }
        this.doDisposeNestedParts();
        if (this.pane != null) {
            control = this.getPane().getControl();
            if (control != null) {
                control.removeDisposeListener(this.prematureDisposeListener);
            }
            this.pane.dispose();
        }
        this.doDisposePart();
        if (this.pane != null) {
            this.pane.removeContributions();
        }
        this.clearListenerList(this.internalPropChangeListeners);
        this.clearListenerList(this.partChangeListeners);
        control = this.image;
        ImageDescriptor imageDescriptor = this.imageDescriptor;
        this.image = null;
        this.state = STATE_DISPOSED;
        this.imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        this.defaultImageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        this.immediateFirePropertyChange(1);
        this.clearListenerList(this.propChangeListeners);
        if (control != null) {
            JFaceResources.getResources().destroy((DeviceResourceDescriptor)imageDescriptor);
        }
    }

    protected void doDisposeNestedParts() {
    }

    private final void clearListenerList(ListenerList listenerList) {
        Object[] objectArray = listenerList.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            listenerList.remove(objectArray[n]);
            ++n;
        }
    }

    protected void doDisposePart() {
        if (this.part != null) {
            this.fireInternalPropertyChange(530);
            try {
                this.part.removePropertyListener(this.propertyChangeListener);
                if (this.part instanceof IWorkbenchPart3) {
                    ((IWorkbenchPart3)this.part).removePartPropertyListener(this.partPropertyChangeListener);
                }
                this.part.dispose();
            }
            catch (Exception exception) {
                WorkbenchPlugin.log(exception);
            }
            this.part = null;
        }
    }

    public void setPinned(boolean bl) {
        if (this.isDisposed()) {
            return;
        }
        if (bl == this.pinned) {
            return;
        }
        this.pinned = bl;
        this.setImageDescriptor(this.computeImageDescriptor());
        this.fireInternalPropertyChange(531);
    }

    public boolean isPinned() {
        return this.pinned;
    }

    @Override
    public String getPartProperty(String string) {
        if (this.part != null) {
            if (this.part instanceof IWorkbenchPart3) {
                return ((IWorkbenchPart3)this.part).getPartProperty(string);
            }
        } else {
            return (String)this.propertyCache.get(string);
        }
        return null;
    }

    @Override
    public void addPartPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.isDisposed()) {
            return;
        }
        this.partChangeListeners.add((Object)iPropertyChangeListener);
    }

    @Override
    public void removePartPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.isDisposed()) {
            return;
        }
        this.partChangeListeners.remove((Object)iPropertyChangeListener);
    }

    protected void firePartPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.partChangeListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    protected void createPartProperties(IWorkbenchPart3 iWorkbenchPart3) {
        for (Map.Entry entry : this.propertyCache.entrySet()) {
            iWorkbenchPart3.setPartProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        ISizeProvider iSizeProvider = (ISizeProvider)Util.getAdapter(this.part, ISizeProvider.class);
        if (iSizeProvider != null) {
            return iSizeProvider.computePreferredSize(bl, n, n2, n3);
        }
        return n3;
    }

    @Override
    public int getSizeFlags(boolean bl) {
        ISizeProvider iSizeProvider = (ISizeProvider)Util.getAdapter(this.part, ISizeProvider.class);
        if (iSizeProvider != null) {
            return iSizeProvider.getSizeFlags(bl);
        }
        return 0;
    }
}

