/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationHistory;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.MultiPartInitException;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.AbstractWorkingSetManager;
import org.eclipse.ui.internal.ActionSetManager;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.CompatibleWorkbenchPage;
import org.eclipse.ui.internal.DirtyPerspectiveMarker;
import org.eclipse.ui.internal.EditorAreaHelper;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.FastViewManager;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.IReorderListener;
import org.eclipse.ui.internal.IStickyViewManager;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutPartSash;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.LayoutTreeNode;
import org.eclipse.ui.internal.MultiEditorInnerPane;
import org.eclipse.ui.internal.NavigationHistory;
import org.eclipse.ui.internal.PageSelectionService;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectiveHelper;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.StickyViewManager;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewIntroAdapterPart;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchIntroManager;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPagePartList;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dialogs.CustomizePerspectiveDialog;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.misc.UIListenerLogging;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.UIExtensionTracker;
import org.eclipse.ui.internal.tweaklets.GrabFocus;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.tweaklets.WorkbenchImplementation;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.AbstractMultiEditor;

public class WorkbenchPage
extends CompatibleWorkbenchPage
implements IWorkbenchPage {
    private static final String ATT_AGGREGATE_WORKING_SET_ID = "aggregateWorkingSetId";
    protected WorkbenchWindow window;
    private IAdaptable input;
    private IWorkingSet workingSet;
    private AggregateWorkingSet aggregateWorkingSet;
    private Composite composite;
    private ActivationList activationList = new ActivationList();
    private EditorManager editorMgr;
    private EditorAreaHelper editorPresentation;
    private ArrayList removedEditors = new ArrayList();
    private ListenerList propertyChangeListeners = new ListenerList();
    private PageSelectionService selectionService = new PageSelectionService(this);
    private WorkbenchPagePartList partList = new WorkbenchPagePartList(this.selectionService);
    private IActionBars actionBars;
    private ActionSetManager actionSets;
    private ViewFactory viewFactory;
    private PerspectiveList perspList = new PerspectiveList();
    private PerspectiveDescriptor deferredActivePersp;
    private NavigationHistory navigationHistory = new NavigationHistory(this);
    private IStickyViewManager stickyViewMan = StickyViewManager.getInstance(this);
    private IWorkbenchPartReference partBeingActivated = null;
    private boolean partBeingOpened = false;
    private Set dirtyPerspectives = new HashSet();
    private IPropertyChangeListener workingSetPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            if ("workingSetRemove".equals(string)) {
                ArrayList<IWorkingSet> arrayList;
                if (propertyChangeEvent.getOldValue().equals(WorkbenchPage.this.workingSet)) {
                    WorkbenchPage.this.setWorkingSet(null);
                }
                if ((arrayList = new ArrayList<IWorkingSet>(Arrays.asList(WorkbenchPage.this.workingSets))).remove(propertyChangeEvent.getOldValue())) {
                    WorkbenchPage.this.setWorkingSets(arrayList.toArray(new IWorkingSet[arrayList.size()]));
                }
            }
        }
    };
    private ActionSwitcher actionSwitcher = new ActionSwitcher();
    private IExtensionTracker tracker;
    private int deferCount = 0;
    private List pendingDisposals = new ArrayList();
    private IExtensionChangeHandler perspectiveChangeHandler = new IExtensionChangeHandler(){

        public void removeExtension(IExtension iExtension, Object[] objectArray) {
            boolean bl = false;
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof DirtyPerspectiveMarker) {
                    PerspectiveDescriptor perspectiveDescriptor;
                    String string = ((DirtyPerspectiveMarker)objectArray[n]).perspectiveId;
                    if (!WorkbenchPage.this.dirtyPerspectives.remove(string)) {
                        WorkbenchPage.this.dirtyPerspectives.add(string);
                    }
                    if ((perspectiveDescriptor = (PerspectiveDescriptor)WorkbenchPage.this.getPerspective()) != null && !perspectiveDescriptor.hasCustomDefinition() && perspectiveDescriptor.getId().equals(string)) {
                        bl = true;
                    }
                }
                ++n;
            }
            if (bl) {
                WorkbenchPage.this.suggestReset();
            }
        }

        public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
            if (WorkbenchPage.this != WorkbenchPage.this.getWorkbenchWindow().getActivePage()) {
                return;
            }
            PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)WorkbenchPage.this.getPerspective();
            if (perspectiveDescriptor == null) {
                return;
            }
            String string = perspectiveDescriptor.getId();
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            boolean bl = false;
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string2 = iConfigurationElementArray[n].getAttribute("targetID");
                if (string2 != null) {
                    if (string2.equals(string) && !perspectiveDescriptor.hasCustomDefinition()) {
                        bl = true;
                    } else {
                        WorkbenchPage.this.dirtyPerspectives.add(string2);
                    }
                    DirtyPerspectiveMarker dirtyPerspectiveMarker = new DirtyPerspectiveMarker(string2);
                    iExtensionTracker.registerObject(iExtension, (Object)dirtyPerspectiveMarker, 0);
                }
                ++n;
            }
            if (bl) {
                WorkbenchPage.this.suggestReset();
            }
        }
    };
    private IWorkingSet[] workingSets = new IWorkingSet[0];
    private String aggregateWorkingSetId;

    private IExtensionPoint getPerspectiveExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "perspectiveExtensions");
    }

    public WorkbenchPage(WorkbenchWindow workbenchWindow, String string, IAdaptable iAdaptable) throws WorkbenchException {
        if (string == null) {
            throw new WorkbenchException(WorkbenchMessages.WorkbenchPage_UndefinedPerspective);
        }
        this.init(workbenchWindow, string, iAdaptable, true);
    }

    public WorkbenchPage(WorkbenchWindow workbenchWindow, IAdaptable iAdaptable) throws WorkbenchException {
        this.init(workbenchWindow, null, iAdaptable, false);
    }

    @Override
    public void activate(IWorkbenchPart iWorkbenchPart) {
        this.internalActivate(iWorkbenchPart, false);
    }

    private void internalActivate(IWorkbenchPart iWorkbenchPart, boolean bl) {
        if (!this.certifyPart(iWorkbenchPart)) {
            return;
        }
        if (this.window.isClosing()) {
            return;
        }
        if (this.composite != null && this.composite.isVisible() && !((GrabFocus)Tweaklets.get(GrabFocus.KEY)).grabFocusAllowed(iWorkbenchPart)) {
            return;
        }
        this.zoomOutIfNecessary(iWorkbenchPart);
        if (iWorkbenchPart instanceof AbstractMultiEditor) {
            iWorkbenchPart = ((AbstractMultiEditor)iWorkbenchPart).getActiveEditor();
        }
        IWorkbenchPartReference iWorkbenchPartReference = this.getReference(iWorkbenchPart);
        this.internalBringToTop(iWorkbenchPartReference);
        this.setActivePart(iWorkbenchPart, bl);
    }

    private void activatePart(final IWorkbenchPart iWorkbenchPart) {
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.WorkbenchPage_ErrorActivatingView){

            public void run() {
                if (iWorkbenchPart != null) {
                    PartPane partPane = WorkbenchPage.this.getPane(iWorkbenchPart);
                    partPane.setFocus();
                    PartSite partSite = (PartSite)iWorkbenchPart.getSite();
                    partPane.showFocus(true);
                    WorkbenchPage.this.updateTabList(iWorkbenchPart);
                    SubActionBars subActionBars = (SubActionBars)partSite.getActionBars();
                    subActionBars.partChanged(iWorkbenchPart);
                }
            }
        });
    }

    public void addFastView(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        perspective.getFastViewManager().addViewReference(FastViewBar.FASTVIEWBAR_ID, -1, iViewReference, true);
    }

    public void makeFastView(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        FastViewManager fastViewManager = perspective.getFastViewManager();
        if (fastViewManager.isFastView(iViewReference)) {
            return;
        }
        perspective.makeFastView(iViewReference);
        this.updateActivePart();
        this.window.firePerspectiveChanged(this, this.getPerspective(), iViewReference, "fastViewAdd");
        this.window.firePerspectiveChanged(this, this.getPerspective(), "fastViewAdd");
    }

    @Override
    public void addPartListener(IPartListener iPartListener) {
        this.partList.getPartService().addPartListener(iPartListener);
    }

    @Override
    public void addPartListener(IPartListener2 iPartListener2) {
        this.partList.getPartService().addPartListener(iPartListener2);
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyChangeListeners.add((Object)iPropertyChangeListener);
    }

    @Override
    public void addSelectionListener(ISelectionListener iSelectionListener) {
        this.selectionService.addSelectionListener(iSelectionListener);
    }

    @Override
    public void addSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.selectionService.addSelectionListener(string, iSelectionListener);
    }

    @Override
    public void addPostSelectionListener(ISelectionListener iSelectionListener) {
        this.selectionService.addPostSelectionListener(iSelectionListener);
    }

    @Override
    public void addPostSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.selectionService.addPostSelectionListener(string, iSelectionListener);
    }

    private ILayoutContainer getContainer(IWorkbenchPart iWorkbenchPart) {
        PartPane partPane = this.getPane(iWorkbenchPart);
        if (partPane == null) {
            return null;
        }
        return partPane.getContainer();
    }

    private ILayoutContainer getContainer(IWorkbenchPartReference iWorkbenchPartReference) {
        PartPane partPane = this.getPane(iWorkbenchPartReference);
        if (partPane == null) {
            return null;
        }
        return partPane.getContainer();
    }

    private PartPane getPane(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == null) {
            return null;
        }
        return this.getPane(this.getReference(iWorkbenchPart));
    }

    private PartPane getPane(IWorkbenchPartReference iWorkbenchPartReference) {
        if (iWorkbenchPartReference == null) {
            return null;
        }
        return ((WorkbenchPartReference)iWorkbenchPartReference).getPane();
    }

    private boolean internalBringToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        Perspective perspective;
        boolean bl = false;
        if (iWorkbenchPartReference instanceof IEditorReference) {
            ILayoutContainer iLayoutContainer = this.getContainer(iWorkbenchPartReference);
            if (iLayoutContainer instanceof PartStack) {
                PartStack partStack = (PartStack)iLayoutContainer;
                PartPane partPane = this.getPane(iWorkbenchPartReference);
                if (partStack.getSelection() != partPane) {
                    partStack.setSelection(partPane);
                }
                bl = true;
            }
        } else if (iWorkbenchPartReference instanceof IViewReference && (perspective = this.getActivePerspective()) != null) {
            bl = perspective.bringToTop((IViewReference)iWorkbenchPartReference);
        }
        this.activationList.bringToTop(iWorkbenchPartReference);
        return bl;
    }

    @Override
    public void bringToTop(IWorkbenchPart iWorkbenchPart) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null || !this.certifyPart(iWorkbenchPart)) {
            return;
        }
        if (!((GrabFocus)Tweaklets.get(GrabFocus.KEY)).grabFocusAllowed(iWorkbenchPart)) {
            return;
        }
        String string = null;
        if (UIStats.isDebugging(8)) {
            string = iWorkbenchPart != null ? iWorkbenchPart.getTitle() : "none";
        }
        try {
            UIStats.start(8, string);
            IWorkbenchPartReference iWorkbenchPartReference = this.getReference(iWorkbenchPart);
            ILayoutContainer iLayoutContainer = this.getContainer(this.getActiveEditor());
            ILayoutContainer iLayoutContainer2 = this.getContainer(this.getActivePart());
            ILayoutContainer iLayoutContainer3 = this.getContainer(iWorkbenchPart);
            if (iLayoutContainer3 == iLayoutContainer2) {
                this.makeActive(iWorkbenchPartReference);
            } else if (iLayoutContainer3 != null && iLayoutContainer3 == iLayoutContainer) {
                if (iWorkbenchPartReference instanceof IEditorReference) {
                    IWorkbenchPartSite iWorkbenchPartSite;
                    if (iWorkbenchPart != null && (iWorkbenchPartSite = iWorkbenchPart.getSite()) instanceof PartSite) {
                        iWorkbenchPartReference = ((PartSite)iWorkbenchPartSite).getPane().getPartReference();
                    }
                    this.makeActiveEditor((IEditorReference)iWorkbenchPartReference);
                } else {
                    this.makeActiveEditor(null);
                }
            } else {
                this.internalBringToTop(iWorkbenchPartReference);
                if (iWorkbenchPartReference != null) {
                    this.partList.firePartBroughtToTop(iWorkbenchPartReference);
                }
            }
        }
        finally {
            UIStats.end(8, iWorkbenchPart, string);
        }
    }

    private void busyResetPerspective() {
        ViewIntroAdapterPart viewIntroAdapterPart = ((WorkbenchIntroManager)this.getWorkbenchWindow().getWorkbench().getIntroManager()).getViewIntroAdapterPart();
        PartPane partPane = null;
        boolean bl = false;
        if (viewIntroAdapterPart != null) {
            partPane = ((PartSite)viewIntroAdapterPart.getSite()).getPane();
            viewIntroAdapterPart.setHandleZoomEvents(false);
            bl = partPane.isZoomed();
        }
        if (bl) {
            this.window.getShell().setRedraw(false);
        }
        try {
            PerspectiveDescriptor perspectiveDescriptor;
            block25: {
                Object object;
                if (this.isZoomed()) {
                    this.zoomOut();
                }
                Perspective perspective = this.getActivePerspective();
                IPerspectiveRegistry iPerspectiveRegistry = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
                perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveRegistry.findPerspectiveWithId(perspective.getDesc().getId());
                if (perspectiveDescriptor == null) {
                    perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveRegistry.findPerspectiveWithId(((PerspectiveDescriptor)perspective.getDesc()).getOriginalId());
                }
                if (perspectiveDescriptor == null) {
                    return;
                }
                this.window.firePerspectiveChanged(this, perspectiveDescriptor, "reset");
                Perspective perspective2 = this.createPerspective(perspectiveDescriptor, false);
                if (perspective2 == null) {
                    this.window.firePerspectiveChanged(this, perspectiveDescriptor, "resetComplete");
                    return;
                }
                IViewReference[] iViewReferenceArray = perspective.getViewReferences();
                ArrayList<IWorkbenchPart> arrayList = new ArrayList<IWorkbenchPart>();
                int n = 0;
                while (n < iViewReferenceArray.length) {
                    IWorkbenchPart iWorkbenchPart;
                    object = iViewReferenceArray[n];
                    int n2 = this.getViewFactory().getReferenceCount((IViewReference)object);
                    if (n2 == 1 && (iWorkbenchPart = object.getPart(false)) != null) {
                        arrayList.add(iWorkbenchPart);
                    }
                    ++n;
                }
                SaveablesList saveablesList = null;
                object = null;
                if (arrayList.size() > 0 && (object = (saveablesList = (SaveablesList)this.getWorkbenchWindow().getService(ISaveablesLifecycleListener.class)).preCloseParts(arrayList, true, this.getWorkbenchWindow())) == null) {
                    this.window.firePerspectiveChanged(this, perspectiveDescriptor, "resetComplete");
                    return;
                }
                this.perspList.swap(perspective, perspective2);
                this.setPerspective(perspective2);
                this.disposePerspective(perspective, false);
                if (saveablesList != null) {
                    saveablesList.postClose(object);
                }
                this.resetToolBarLayout();
                this.getActionBars().getMenuManager().updateAll(true);
                if (viewIntroAdapterPart != null) {
                    try {
                        try {
                            this.showView("org.eclipse.ui.internal.introview");
                            if (bl) {
                                this.toggleZoom(partPane.getPartReference());
                            }
                        }
                        catch (PartInitException partInitException) {
                            WorkbenchPlugin.log("Could not restore intro", WorkbenchPlugin.getStatus((Throwable)((Object)partInitException)));
                            viewIntroAdapterPart.setHandleZoomEvents(true);
                            break block25;
                        }
                    }
                    catch (Throwable throwable) {
                        viewIntroAdapterPart.setHandleZoomEvents(true);
                        throw throwable;
                    }
                    viewIntroAdapterPart.setHandleZoomEvents(true);
                }
            }
            this.window.firePerspectiveChanged(this, perspectiveDescriptor, "resetComplete");
        }
        finally {
            if (viewIntroAdapterPart != null) {
                viewIntroAdapterPart.setHandleZoomEvents(true);
            }
            if (bl) {
                this.window.getShell().setRedraw(true);
            }
        }
    }

    private void busySetPerspective(IPerspectiveDescriptor iPerspectiveDescriptor) {
        String string = iPerspectiveDescriptor.getId();
        Perspective perspective = null;
        try {
            UIStats.start(10, string);
            PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveDescriptor;
            perspective = this.findPerspective(perspectiveDescriptor);
            if (perspective == null && (perspective = this.createPerspective(perspectiveDescriptor, true)) == null) {
                return;
            }
            this.setPerspective(perspective);
        }
        finally {
            UIStats.end(10, iPerspectiveDescriptor.getId(), string);
        }
    }

    protected IViewPart busyShowView(String string, String string2, int n) throws PartInitException {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return null;
        }
        IViewReference iViewReference = perspective.findView(string, string2);
        IViewPart iViewPart = null;
        if (iViewReference != null) {
            iViewPart = iViewReference.getView(true);
        }
        if (iViewPart != null) {
            this.busyShowView(iViewPart, n);
            return iViewPart;
        }
        iViewPart = perspective.showView(string, string2);
        if (iViewPart != null) {
            this.busyShowView(iViewPart, n);
            IWorkbenchPartReference iWorkbenchPartReference = this.getReference(iViewPart);
            PartPane partPane = this.getPane(iWorkbenchPartReference);
            partPane.setInLayout(true);
            this.window.firePerspectiveChanged(this, this.getPerspective(), iWorkbenchPartReference, "viewShow");
            this.window.firePerspectiveChanged(this, this.getPerspective(), "viewShow");
        }
        return iViewPart;
    }

    private void busyShowView(IViewPart iViewPart, int n) {
        if (!((GrabFocus)Tweaklets.get(GrabFocus.KEY)).grabFocusAllowed(iViewPart)) {
            return;
        }
        if (n != 3) {
            this.checkIntro();
        }
        if (n == 1) {
            this.activate(iViewPart);
        } else if (n == 2) {
            IWorkbenchPartReference iWorkbenchPartReference = this.getActivePartReference();
            if (iWorkbenchPartReference == null || !(iWorkbenchPartReference instanceof IViewReference)) {
                this.bringToTop(iViewPart);
            } else {
                IViewReference iViewReference = (IViewReference)iWorkbenchPartReference;
                IViewReference[] iViewReferenceArray = this.getViewReferenceStack(iViewPart);
                int n2 = 0;
                while (n2 < iViewReferenceArray.length) {
                    if (iViewReferenceArray[n2].equals(iViewReference)) {
                        return;
                    }
                    ++n2;
                }
                this.bringToTop(iViewPart);
            }
        }
    }

    private void checkIntro() {
        IIntroManager iIntroManager = this.getWorkbenchWindow().getWorkbench().getIntroManager();
        IIntroPart iIntroPart = iIntroManager.getIntro();
        if (iIntroPart == null) {
            return;
        }
        if (!iIntroManager.isIntroStandby(iIntroPart)) {
            iIntroManager.setIntroStandby(iIntroPart, true);
        }
    }

    private boolean certifyPart(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart != null && !(iWorkbenchPart.getSite() instanceof PartSite)) {
            return false;
        }
        if (iWorkbenchPart instanceof IEditorPart) {
            IEditorReference iEditorReference = (IEditorReference)this.getReference(iWorkbenchPart);
            return iEditorReference != null && this.getEditorManager().containsEditor(iEditorReference);
        }
        if (iWorkbenchPart instanceof IViewPart) {
            Perspective perspective = this.getActivePerspective();
            return perspective != null && perspective.containsView((IViewPart)iWorkbenchPart);
        }
        return false;
    }

    @Override
    public boolean close() {
        final boolean[] blArray = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                blArray[0] = WorkbenchPage.this.window.closePage(WorkbenchPage.this, true);
            }
        });
        return blArray[0];
    }

    public boolean closeAllSavedEditors() {
        IEditorReference[] iEditorReferenceArray = this.getAllEditorReferences();
        IEditorReference[] iEditorReferenceArray2 = new IEditorReference[iEditorReferenceArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < iEditorReferenceArray.length) {
            IEditorReference iEditorReference = iEditorReferenceArray[n2];
            if (!iEditorReference.isDirty()) {
                iEditorReferenceArray2[n++] = iEditorReference;
            }
            ++n2;
        }
        if (n == 0) {
            return true;
        }
        IEditorReference[] iEditorReferenceArray3 = new IEditorReference[n];
        System.arraycopy(iEditorReferenceArray2, 0, iEditorReferenceArray3, 0, n);
        return this.closeEditors(iEditorReferenceArray3, false);
    }

    @Override
    public boolean closeAllEditors(boolean bl) {
        return this.closeEditors(this.getAllEditorReferences(), bl);
    }

    private void updateActivePart() {
        if (this.isDeferred()) {
            return;
        }
        IWorkbenchPartReference iWorkbenchPartReference = this.partList.getActivePartReference();
        IEditorReference iEditorReference = this.partList.getActiveEditorReference();
        IWorkbenchPartReference iWorkbenchPartReference2 = null;
        IEditorReference iEditorReference2 = null;
        if (!this.window.isClosing()) {
            if (iWorkbenchPartReference == iEditorReference) {
                iEditorReference2 = (IEditorReference)this.activationList.getActiveReference(true);
                iWorkbenchPartReference2 = iEditorReference2;
                if (iWorkbenchPartReference2 == null) {
                    iWorkbenchPartReference2 = this.activationList.getActiveReference(false);
                }
            } else {
                iWorkbenchPartReference2 = this.activationList.getActiveReference(false);
                iEditorReference2 = iWorkbenchPartReference2 instanceof IEditorReference ? (IEditorReference)iWorkbenchPartReference2 : (IEditorReference)this.activationList.getActiveReference(true);
            }
        }
        if (iEditorReference2 != iEditorReference) {
            this.makeActiveEditor(iEditorReference2);
        }
        if (iWorkbenchPartReference2 != iWorkbenchPartReference) {
            this.makeActive(iWorkbenchPartReference2);
        }
    }

    private void makeActive(IWorkbenchPartReference iWorkbenchPartReference) {
        if (iWorkbenchPartReference == null) {
            this.setActivePart(null, false);
        } else {
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(true);
            if (iWorkbenchPart == null) {
                this.setActivePart(null, false);
            } else {
                this.activate(iWorkbenchPart);
            }
        }
    }

    private void makeActiveEditor(IEditorReference iEditorReference) {
        IEditorPart iEditorPart;
        if (iEditorReference == this.getActiveEditorReference()) {
            return;
        }
        IEditorPart iEditorPart2 = iEditorPart = iEditorReference == null ? null : iEditorReference.getEditor(true);
        if (iEditorPart != null) {
            this.editorMgr.setVisibleEditor(iEditorReference, false);
            this.navigationHistory.markEditor(iEditorPart);
        }
        this.actionSwitcher.updateTopEditor(iEditorPart);
        if (iEditorReference != null) {
            this.activationList.bringToTop(this.getReference(iEditorPart));
        }
        this.partList.setActiveEditor(iEditorReference);
    }

    @Override
    public boolean closeEditors(IEditorReference[] iEditorReferenceArray, boolean bl) {
        IEditorReference iEditorReference;
        Object object;
        IWorkbenchPartReference iWorkbenchPartReference;
        if (iEditorReferenceArray.length == 0) {
            return true;
        }
        ArrayList<IEditorReference> arrayList = new ArrayList<IEditorReference>();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorReference iEditorReference2 = iEditorReferenceArray[n];
            if (iEditorReference2 == this.partBeingActivated) {
                WorkbenchPlugin.log(new RuntimeException("WARNING: Blocked recursive attempt to close part " + this.partBeingActivated.getId() + " while still in the middle of activating it"));
                return false;
            }
            if (!(iEditorReference2 instanceof WorkbenchPartReference) || !((WorkbenchPartReference)(iWorkbenchPartReference = (WorkbenchPartReference)((Object)iEditorReference2))).isDisposed()) {
                arrayList.add(iEditorReference2);
            }
            ++n;
        }
        IEditorReference[] iEditorReferenceArray2 = arrayList.toArray(new IEditorReference[arrayList.size()]);
        int n2 = 0;
        while (n2 < iEditorReferenceArray2.length) {
            iWorkbenchPartReference = iEditorReferenceArray2[n2];
            if (iWorkbenchPartReference != null && (object = iWorkbenchPartReference.getEditor(false)) != null && this.navigationHistory.updateActive((IEditorPart)object)) break;
            ++n2;
        }
        ArrayList<IEditorPart> arrayList2 = new ArrayList<IEditorPart>();
        int n3 = 0;
        while (n3 < iEditorReferenceArray2.length) {
            object = iEditorReferenceArray2[n3].getEditor(false);
            if (object != null) {
                arrayList2.add((IEditorPart)object);
            }
            ++n3;
        }
        SaveablesList saveablesList = null;
        object = null;
        if (arrayList2.size() > 0 && (object = (saveablesList = (SaveablesList)this.getWorkbenchWindow().getService(ISaveablesLifecycleListener.class)).preCloseParts(arrayList2, bl, this.getWorkbenchWindow())) == null) {
            return false;
        }
        int n4 = 0;
        while (n4 < iEditorReferenceArray2.length) {
            iEditorReference = iEditorReferenceArray2[n4];
            this.window.firePerspectiveChanged(this, this.getPerspective(), iEditorReference, "editorClose");
            ++n4;
        }
        this.deferUpdates(true);
        try {
            if (saveablesList != null) {
                saveablesList.postClose(object);
            }
            n4 = 0;
            while (n4 < iEditorReferenceArray2.length) {
                iEditorReference = iEditorReferenceArray2[n4];
                this.removedEditors.remove(iEditorReference);
                this.editorPresentation.closeEditor(iEditorReference);
                this.partRemoved((WorkbenchPartReference)((Object)iEditorReference));
                ++n4;
            }
        }
        finally {
            this.deferUpdates(false);
        }
        this.window.firePerspectiveChanged(this, this.getPerspective(), "editorClose");
        return true;
    }

    private void deferUpdates(boolean bl) {
        if (bl) {
            if (this.deferCount == 0) {
                this.startDeferring();
            }
            ++this.deferCount;
        } else {
            --this.deferCount;
            if (this.deferCount == 0) {
                this.handleDeferredEvents();
            }
        }
    }

    private void startDeferring() {
        this.editorPresentation.getLayoutPart().deferUpdates(true);
    }

    private void handleDeferredEvents() {
        this.editorPresentation.getLayoutPart().deferUpdates(false);
        this.updateActivePart();
        WorkbenchPartReference[] workbenchPartReferenceArray = this.pendingDisposals.toArray(new WorkbenchPartReference[this.pendingDisposals.size()]);
        this.pendingDisposals.clear();
        int n = 0;
        while (n < workbenchPartReferenceArray.length) {
            WorkbenchPartReference workbenchPartReference = workbenchPartReferenceArray[n];
            this.disposePart(workbenchPartReference);
            ++n;
        }
    }

    private boolean isDeferred() {
        return this.deferCount > 0;
    }

    public boolean closeEditor(IEditorReference iEditorReference, boolean bl) {
        return this.closeEditors(new IEditorReference[]{iEditorReference}, bl);
    }

    @Override
    public boolean closeEditor(IEditorPart iEditorPart, boolean bl) {
        IWorkbenchPartReference iWorkbenchPartReference = this.getReference(iEditorPart);
        if (iWorkbenchPartReference instanceof IEditorReference) {
            return this.closeEditors(new IEditorReference[]{(IEditorReference)iWorkbenchPartReference}, bl);
        }
        return false;
    }

    @Override
    public void closePerspective(IPerspectiveDescriptor iPerspectiveDescriptor, boolean bl, boolean bl2) {
        Perspective perspective = this.findPerspective(iPerspectiveDescriptor);
        if (perspective != null) {
            this.closePerspective(perspective, bl, bl2);
        }
    }

    public void closePerspective(IPerspectiveDescriptor iPerspectiveDescriptor, IPerspectiveDescriptor iPerspectiveDescriptor2, boolean bl, boolean bl2) {
        Perspective perspective = this.findPerspective(iPerspectiveDescriptor);
        Perspective perspective2 = this.findPerspective(iPerspectiveDescriptor2);
        if (perspective != null) {
            this.closePerspective(perspective, perspective2, bl, bl2);
        }
    }

    void closePerspective(Perspective perspective, boolean bl, boolean bl2) {
        this.closePerspective(perspective, null, bl, bl2);
    }

    void closePerspective(Perspective perspective, Perspective perspective2, boolean bl, boolean bl2) {
        boolean bl3;
        Object object;
        Object object2;
        if (this.isZoomed()) {
            this.zoomOut();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<IViewPart> arrayList2 = new ArrayList<IViewPart>();
        IViewReference[] iViewReferenceArray = perspective.getViewReferences();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            object2 = iViewReferenceArray[n];
            if (this.getViewFactory().getReferenceCount((IViewReference)object2) == 1 && (object = object2.getView(false)) != null) {
                arrayList2.add((IViewPart)object);
                if (bl && object2.isDirty()) {
                    arrayList.add(object);
                }
            }
            ++n;
        }
        if (bl && this.perspList.size() == 1) {
            IEditorReference[] iEditorReferenceArray = this.getEditorReferences();
            int n2 = 0;
            while (n2 < iEditorReferenceArray.length) {
                IEditorPart iEditorPart;
                object = iEditorReferenceArray[n2];
                if (object.isDirty() && (iEditorPart = object.getEditor(false)) != null) {
                    arrayList.add(iEditorPart);
                }
                ++n2;
            }
        }
        if (bl && !arrayList.isEmpty() && !EditorManager.saveAll(arrayList, true, true, false, this.window)) {
            return;
        }
        if (this.perspList.size() == 1 && this.getEditorManager().getEditorCount() > 0 && !this.closeAllEditors(false)) {
            return;
        }
        SaveablesList saveablesList = (SaveablesList)this.getWorkbenchWindow().getWorkbench().getService(ISaveablesLifecycleListener.class);
        object2 = saveablesList.preCloseParts(arrayList2, false, this.getWorkbenchWindow());
        saveablesList.postClose(object2);
        boolean bl4 = bl3 = this.perspList.getActive() == perspective;
        if (bl3) {
            if (perspective2 != null) {
                this.setPerspective(perspective2);
            } else {
                this.setPerspective(this.perspList.getNextActive());
            }
        }
        this.disposePerspective(perspective, true);
        if (bl2 && this.perspList.size() == 0) {
            this.close();
        }
    }

    public void unzoomAllPerspectives() {
        Iterator iterator = this.perspList.iterator();
        while (iterator.hasNext()) {
            Perspective perspective = (Perspective)iterator.next();
            perspective.getPresentation().forceNoZoom();
        }
    }

    @Override
    public void closeAllPerspectives(boolean bl, boolean bl2) {
        if (this.perspList.isEmpty()) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (bl && !this.getEditorManager().saveAll(true, true, false)) {
            return;
        }
        if (!this.closeAllEditors(false)) {
            return;
        }
        this.setPerspective((Perspective)null);
        PerspectiveList perspectiveList = this.perspList;
        this.perspList = new PerspectiveList();
        Iterator iterator = perspectiveList.iterator();
        while (iterator.hasNext()) {
            this.closePerspective((Perspective)iterator.next(), false, false);
        }
        if (bl2) {
            this.close();
        }
    }

    private void createClientComposite() {
        final Composite composite = this.window.getPageComposite();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                WorkbenchPage.this.composite = new Composite(composite, 0);
                new MnemonicDisabler(WorkbenchPage.this.composite);
                WorkbenchPage.this.composite.setVisible(false);
                composite.layout();
            }
        });
    }

    private Perspective createPerspective(PerspectiveDescriptor perspectiveDescriptor, boolean bl) {
        String string = perspectiveDescriptor.getId();
        try {
            UIStats.start(3, string);
            Perspective perspective = ((WorkbenchImplementation)Tweaklets.get(WorkbenchImplementation.KEY)).createPerspective(perspectiveDescriptor, this);
            this.perspList.add(perspective);
            if (bl) {
                this.window.firePerspectiveOpened(this, perspectiveDescriptor);
            }
            if (!perspectiveDescriptor.hasCustomDefinition()) {
                this.dirtyPerspectives.remove(perspectiveDescriptor.getId());
            }
            Perspective perspective2 = perspective;
            return perspective2;
        }
        catch (WorkbenchException workbenchException) {
            if (!((Workbench)this.window.getWorkbench()).isStarting()) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)WorkbenchMessages.Error, (String)NLS.bind((String)WorkbenchMessages.Workbench_showPerspectiveError, (Object)perspectiveDescriptor.getId()));
            }
            return null;
        }
        finally {
            UIStats.end(3, perspectiveDescriptor.getId(), string);
        }
    }

    void partAdded(WorkbenchPartReference workbenchPartReference) {
        this.activationList.add(workbenchPartReference);
        this.partList.addPart(workbenchPartReference);
        this.updateActivePart();
    }

    void partRemoved(WorkbenchPartReference workbenchPartReference) {
        this.activationList.remove(workbenchPartReference);
        this.disposePart(workbenchPartReference);
    }

    private void disposePart(WorkbenchPartReference workbenchPartReference) {
        if (this.isDeferred()) {
            this.pendingDisposals.add(workbenchPartReference);
        } else {
            this.partList.removePart(workbenchPartReference);
            workbenchPartReference.dispose();
        }
    }

    private void deactivatePart(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart != null) {
            PartSite partSite = (PartSite)iWorkbenchPart.getSite();
            partSite.getPane().showFocus(false);
        }
    }

    public void detachView(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        PerspectiveHelper perspectiveHelper = perspective.getPresentation();
        perspectiveHelper.detachPart(iViewReference);
    }

    public void attachView(IViewReference iViewReference) {
        PerspectiveHelper perspectiveHelper = this.getPerspectivePresentation();
        perspectiveHelper.attachPart(iViewReference);
    }

    public void dispose() {
        IViewReference[] iViewReferenceArray;
        Object object;
        if (this.isZoomed()) {
            this.zoomOut();
        }
        this.makeActiveEditor(null);
        this.makeActive(null);
        this.closeAllEditors(false);
        IWorkbenchPartReference[] iWorkbenchPartReferenceArray = this.getOpenParts();
        ArrayList<IWorkbenchPart> arrayList = new ArrayList<IWorkbenchPart>(iWorkbenchPartReferenceArray.length);
        int n = 0;
        while (n < iWorkbenchPartReferenceArray.length) {
            object = iWorkbenchPartReferenceArray[n].getPart(false);
            if (object != null && object instanceof IViewPart) {
                arrayList.add((IWorkbenchPart)object);
            }
            ++n;
        }
        SaveablesList saveablesList = (SaveablesList)this.getWorkbenchWindow().getWorkbench().getService(ISaveablesLifecycleListener.class);
        object = saveablesList.preCloseParts(arrayList, false, this.getWorkbenchWindow());
        saveablesList.postClose(object);
        Iterator iterator = this.perspList.iterator();
        while (iterator.hasNext()) {
            iViewReferenceArray = (IViewReference[])iterator.next();
            this.window.firePerspectiveClosed(this, iViewReferenceArray.getDesc());
            iViewReferenceArray.dispose();
        }
        this.perspList = new PerspectiveList();
        iViewReferenceArray = this.viewFactory.getViews();
        if (iViewReferenceArray.length > 0) {
            int n2 = 0;
            while (n2 < iViewReferenceArray.length) {
                final WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)((Object)iViewReferenceArray[n2]);
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        workbenchPartReference.dispose();
                    }

                    public void handleException(Throwable throwable) {
                    }
                });
                ++n2;
            }
        }
        this.activationList = new ActivationList();
        this.editorPresentation.dispose();
        this.composite.dispose();
        this.navigationHistory.dispose();
        this.stickyViewMan.clear();
        if (this.tracker != null) {
            this.tracker.close();
        }
        if (!this.window.getWorkbench().isClosing() && this.aggregateWorkingSet != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removeWorkingSet(this.aggregateWorkingSet);
        }
    }

    private void disposePerspective(Perspective perspective, boolean bl) {
        this.perspList.remove(perspective);
        if (bl) {
            this.window.firePerspectiveClosed(this, perspective.getDesc());
        }
        perspective.dispose();
        this.stickyViewMan.remove(perspective.getDesc().getId());
    }

    @Override
    public INavigationHistory getNavigationHistory() {
        return this.navigationHistory;
    }

    public boolean editActionSets() {
        boolean bl;
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return false;
        }
        CustomizePerspectiveDialog customizePerspectiveDialog = this.window.createCustomizePerspectiveDialog(perspective);
        boolean bl2 = bl = customizePerspectiveDialog.open() == 0;
        if (bl) {
            this.window.updateActionSets();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "reset");
            this.window.firePerspectiveChanged(this, this.getPerspective(), "resetComplete");
        }
        return bl;
    }

    public Perspective findPerspective(IPerspectiveDescriptor iPerspectiveDescriptor) {
        Iterator iterator = this.perspList.iterator();
        while (iterator.hasNext()) {
            Perspective perspective = (Perspective)iterator.next();
            if (!iPerspectiveDescriptor.getId().equals(perspective.getDesc().getId())) continue;
            return perspective;
        }
        return null;
    }

    @Override
    public IViewPart findView(String string) {
        IViewReference iViewReference = this.findViewReference(string);
        if (iViewReference == null) {
            return null;
        }
        return iViewReference.getView(true);
    }

    @Override
    public IViewReference findViewReference(String string) {
        return this.findViewReference(string, null);
    }

    @Override
    public IViewReference findViewReference(String string, String string2) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return null;
        }
        return perspective.findView(string, string2);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        UIListenerLogging.logPagePropertyChanged(this, string, object, object2);
        Object[] objectArray = this.propertyChangeListeners.getListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public IActionBars getActionBars() {
        if (this.actionBars == null) {
            this.actionBars = new WWinActionBars(this.window);
        }
        return this.actionBars;
    }

    public IActionSetDescriptor[] getActionSets() {
        Collection collection = this.actionSets.getVisibleItems();
        return collection.toArray(new IActionSetDescriptor[collection.size()]);
    }

    @Override
    public IEditorPart getActiveEditor() {
        return this.partList.getActiveEditor();
    }

    public IEditorReference getActiveEditorReference() {
        return this.partList.getActiveEditorReference();
    }

    @Override
    public IWorkbenchPart getActivePart() {
        return this.partList.getActivePart();
    }

    @Override
    public IWorkbenchPartReference getActivePartReference() {
        return this.partList.getActivePartReference();
    }

    public Perspective getActivePerspective() {
        return this.perspList.getActive();
    }

    public Composite getClientComposite() {
        return this.composite;
    }

    public EditorManager getEditorManager() {
        return this.editorMgr;
    }

    public PerspectiveHelper getPerspectivePresentation() {
        if (this.getActivePerspective() != null) {
            return this.getActivePerspective().getPresentation();
        }
        return null;
    }

    public EditorAreaHelper getEditorPresentation() {
        return this.editorPresentation;
    }

    @Override
    public IEditorPart[] getEditors() {
        final IEditorReference[] iEditorReferenceArray = this.getEditorReferences();
        final ArrayList arrayList = new ArrayList(iEditorReferenceArray.length);
        Display display = this.getWorkbenchWindow().getShell().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                int n = 0;
                while (n < iEditorReferenceArray.length) {
                    IWorkbenchPart iWorkbenchPart = iEditorReferenceArray[n].getPart(true);
                    if (iWorkbenchPart != null) {
                        arrayList.add(iWorkbenchPart);
                    }
                    ++n;
                }
            }
        });
        IEditorPart[] iEditorPartArray = new IEditorPart[arrayList.size()];
        return arrayList.toArray(iEditorPartArray);
    }

    @Override
    public IEditorPart[] getDirtyEditors() {
        return this.getEditorManager().getDirtyEditors();
    }

    public ISaveablePart[] getDirtyParts() {
        ArrayList<ISaveablePart> arrayList = new ArrayList<ISaveablePart>(3);
        IWorkbenchPartReference[] iWorkbenchPartReferenceArray = this.getAllParts();
        int n = 0;
        while (n < iWorkbenchPartReferenceArray.length) {
            ISaveablePart iSaveablePart;
            IWorkbenchPartReference iWorkbenchPartReference = iWorkbenchPartReferenceArray[n];
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
            if (iWorkbenchPart != null && iWorkbenchPart instanceof ISaveablePart && (iSaveablePart = (ISaveablePart)((Object)iWorkbenchPart)).isDirty()) {
                arrayList.add(iSaveablePart);
            }
            ++n;
        }
        return arrayList.toArray(new ISaveablePart[arrayList.size()]);
    }

    @Override
    public IEditorPart findEditor(IEditorInput iEditorInput) {
        return this.getEditorManager().findEditor(iEditorInput);
    }

    @Override
    public IEditorReference[] findEditors(IEditorInput iEditorInput, String string, int n) {
        return this.getEditorManager().findEditors(iEditorInput, string, n);
    }

    @Override
    public IEditorReference[] getEditorReferences() {
        return this.editorPresentation.getEditors();
    }

    public IEditorReference[] getAllEditorReferences() {
        ArrayList<IEditorReference> arrayList = new ArrayList<IEditorReference>(this.removedEditors);
        arrayList.addAll(Arrays.asList(this.editorPresentation.getEditors()));
        return arrayList.toArray(new IEditorReference[arrayList.size()]);
    }

    public IViewReference[] getFastViews() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.getFastViews();
        }
        return new IViewReference[0];
    }

    @Override
    public IAdaptable getInput() {
        return this.input;
    }

    @Override
    public String getLabel() {
        Perspective perspective;
        String string = WorkbenchMessages.WorkbenchPage_UnknownLabel;
        IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)Util.getAdapter(this.input, IWorkbenchAdapter.class);
        if (iWorkbenchAdapter != null) {
            string = iWorkbenchAdapter.getLabel(this.input);
        }
        if ((perspective = this.getActivePerspective()) != null) {
            string = NLS.bind((String)WorkbenchMessages.WorkbenchPage_PerspectiveFormat, (Object)string, (Object)perspective.getDesc().getLabel());
        } else if (this.deferredActivePersp != null) {
            string = NLS.bind((String)WorkbenchMessages.WorkbenchPage_PerspectiveFormat, (Object)string, (Object)this.deferredActivePersp.getLabel());
        }
        return string;
    }

    @Override
    public IPerspectiveDescriptor getPerspective() {
        if (this.deferredActivePersp != null) {
            return this.deferredActivePersp;
        }
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.getDesc();
        }
        return null;
    }

    @Override
    public ISelection getSelection() {
        return this.selectionService.getSelection();
    }

    @Override
    public ISelection getSelection(String string) {
        return this.selectionService.getSelection(string);
    }

    public ArrayList getShowInPartIds() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.getShowInPartIds();
        }
        return new ArrayList();
    }

    public void performedShowIn(String string) {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            perspective.performedShowIn(string);
        }
    }

    public void sortShowInPartIds(ArrayList arrayList) {
        final Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    long l;
                    long l2 = perspective.getShowInTime((String)object);
                    return l2 == (l = perspective.getShowInTime((String)object2)) ? 0 : (l2 > l ? -1 : 1);
                }
            });
        }
    }

    public ViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new ViewFactory(this, WorkbenchPlugin.getDefault().getViewRegistry());
        }
        return this.viewFactory;
    }

    @Override
    public IViewReference[] getViewReferences() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.getViewReferences();
        }
        return new IViewReference[0];
    }

    @Override
    public IViewPart[] getViews() {
        return this.getViews(null, true);
    }

    IViewPart[] getViews(Perspective perspective, boolean bl) {
        if (perspective == null) {
            perspective = this.getActivePerspective();
        }
        if (perspective != null) {
            IViewReference[] iViewReferenceArray = perspective.getViewReferences();
            ArrayList<IWorkbenchPart> arrayList = new ArrayList<IWorkbenchPart>(iViewReferenceArray.length);
            int n = 0;
            while (n < iViewReferenceArray.length) {
                IWorkbenchPart iWorkbenchPart = iViewReferenceArray[n].getPart(bl);
                if (iWorkbenchPart != null) {
                    arrayList.add(iWorkbenchPart);
                }
                ++n;
            }
            IViewPart[] iViewPartArray = new IViewPart[arrayList.size()];
            return arrayList.toArray(iViewPartArray);
        }
        return new IViewPart[0];
    }

    @Override
    public IWorkbenchWindow getWorkbenchWindow() {
        return this.window;
    }

    @Override
    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    @Override
    public void hideActionSet(String string) {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            perspective.removeActionSet(string);
            this.window.updateActionSets();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "actionSetHide");
        }
    }

    @Override
    public void hideView(IViewReference iViewReference) {
        Object object;
        Object object2;
        if (iViewReference == null) {
            return;
        }
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        boolean bl = false;
        IViewPart iViewPart = iViewReference.getView(false);
        if (iViewPart != null) {
            ISaveablePart iSaveablePart;
            if (!this.certifyPart(iViewPart)) {
                return;
            }
            if (iViewPart instanceof ISaveablePart && (iSaveablePart = (ISaveablePart)((Object)iViewPart)).isSaveOnCloseNeeded()) {
                object2 = iViewPart.getSite().getWorkbenchWindow();
                boolean bl2 = EditorManager.saveAll(Collections.singletonList(iViewPart), true, true, false, (IWorkbenchWindow)object2);
                if (!bl2) {
                    return;
                }
                bl = true;
            }
        }
        int n = this.getViewFactory().getReferenceCount(iViewReference);
        object2 = null;
        Object object3 = null;
        if (n == 1 && (object = iViewReference.getPart(false)) != null && (object3 = ((SaveablesList)(object2 = (SaveablesList)object.getSite().getService(ISaveablesLifecycleListener.class))).preCloseParts(Collections.singletonList(object), !bl, this.getWorkbenchWindow())) == null) {
            return;
        }
        this.window.firePerspectiveChanged(this, perspective.getDesc(), iViewReference, "viewHide");
        object = this.getPane(iViewReference);
        ((PartPane)object).setInLayout(false);
        this.updateActivePart();
        if (object2 != null) {
            ((SaveablesList)object2).postClose(object3);
        }
        perspective.hideView(iViewReference);
        this.window.firePerspectiveChanged(this, this.getPerspective(), "viewHide");
    }

    void refreshActiveView() {
        this.updateActivePart();
    }

    @Override
    public void hideView(IViewPart iViewPart) {
        this.hideView((IViewReference)this.getReference(iViewPart));
    }

    private void init(WorkbenchWindow workbenchWindow, String string, IAdaptable iAdaptable, boolean bl) throws WorkbenchException {
        this.window = workbenchWindow;
        this.input = iAdaptable;
        this.actionSets = new ActionSetManager(workbenchWindow);
        this.createClientComposite();
        this.editorPresentation = new EditorAreaHelper(this);
        this.editorMgr = new EditorManager(this.window, this, this.editorPresentation);
        workbenchWindow.addPerspectiveReorderListener(new IReorderListener(){

            @Override
            public void reorder(Object object, int n) {
                WorkbenchPage.this.perspList.reorder((IPerspectiveDescriptor)object, n);
            }
        });
        if (bl) {
            this.openPerspectiveExtras();
        }
        if (string != null) {
            PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(string);
            if (perspectiveDescriptor == null) {
                throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)string));
            }
            Perspective perspective = this.findPerspective(perspectiveDescriptor);
            if (perspective == null) {
                perspective = this.createPerspective(perspectiveDescriptor, true);
            }
            this.perspList.setActive(perspective);
            this.window.firePerspectiveActivated(this, perspectiveDescriptor);
        }
        this.getExtensionTracker().registerHandler(this.perspectiveChangeHandler, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getPerspectiveExtensionPoint()));
    }

    public void openPerspectiveExtras() {
        IPerspectiveDescriptor iPerspectiveDescriptor;
        String string = PrefUtil.getAPIPreferenceStore().getString("PERSPECTIVE_BAR_EXTRAS");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        ArrayList<IPerspectiveDescriptor> arrayList = new ArrayList<IPerspectiveDescriptor>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            iPerspectiveDescriptor = WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(string2);
            if (iPerspectiveDescriptor == null) continue;
            arrayList.add(iPerspectiveDescriptor);
        }
        int n = arrayList.size();
        while (--n >= 0) {
            iPerspectiveDescriptor = (PerspectiveDescriptor)arrayList.get(n);
            if (this.findPerspective(iPerspectiveDescriptor) != null) continue;
            this.createPerspective((PerspectiveDescriptor)iPerspectiveDescriptor, true);
        }
    }

    @Override
    public boolean isPartVisible(IWorkbenchPart iWorkbenchPart) {
        PartPane partPane = this.getPane(iWorkbenchPart);
        return partPane != null && partPane.getVisible();
    }

    @Override
    public boolean isEditorAreaVisible() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return false;
        }
        return perspective.isEditorAreaVisible();
    }

    public boolean isFastView(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.isFastView(iViewReference);
        }
        return false;
    }

    public boolean isCloseable(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.isCloseable(iViewReference);
        }
        return false;
    }

    public boolean isMoveable(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.isMoveable(iViewReference);
        }
        return false;
    }

    public boolean isFixedLayout() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.isFixedLayout();
        }
        return false;
    }

    public IViewReference getActiveFastView() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            return perspective.getActiveFastView();
        }
        return null;
    }

    protected boolean isSaveNeeded() {
        return this.getEditorManager().isSaveAllNeeded();
    }

    @Override
    public boolean isPageZoomed() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return false;
        }
        if (perspective.getPresentation() == null) {
            return false;
        }
        if (Perspective.useNewMinMax(perspective)) {
            return perspective.getPresentation().getMaximizedStack() != null;
        }
        return this.isZoomed();
    }

    public boolean isZoomed() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return false;
        }
        if (perspective.getPresentation() == null) {
            return false;
        }
        return perspective.getPresentation().isZoomed();
    }

    protected void onActivate() {
        this.composite.setVisible(true);
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            perspective.onActivate();
            this.updateVisibility(null, perspective);
        }
    }

    protected void onDeactivate() {
        this.makeActiveEditor(null);
        this.makeActive(null);
        if (this.getActivePerspective() != null) {
            this.getActivePerspective().onDeactivate();
        }
        this.composite.setVisible(false);
    }

    @Override
    public void reuseEditor(IReusableEditor iReusableEditor, IEditorInput iEditorInput) {
        IWorkbenchPartReference iWorkbenchPartReference = this.getReference(iReusableEditor);
        if (iWorkbenchPartReference instanceof EditorReference) {
            EditorReference editorReference = (EditorReference)iWorkbenchPartReference;
            editorReference.setInput(iEditorInput);
        } else {
            iReusableEditor.setInput(iEditorInput);
        }
        this.navigationHistory.markEditor(iReusableEditor);
    }

    @Override
    public IEditorPart openEditor(IEditorInput iEditorInput, String string) throws PartInitException {
        return this.openEditor(iEditorInput, string, true, 1);
    }

    @Override
    public IEditorPart openEditor(IEditorInput iEditorInput, String string, boolean bl) throws PartInitException {
        return this.openEditor(iEditorInput, string, bl, 1);
    }

    @Override
    public IEditorPart openEditor(IEditorInput iEditorInput, String string, boolean bl, int n) throws PartInitException {
        return this.openEditor(iEditorInput, string, bl, n, null);
    }

    public IEditorPart openEditor(final IEditorInput iEditorInput, final String string, final boolean bl, final int n, final IMemento iMemento) throws PartInitException {
        if (iEditorInput == null || string == null) {
            throw new IllegalArgumentException();
        }
        final IEditorPart[] iEditorPartArray = new IEditorPart[1];
        final PartInitException[] partInitExceptionArray = new PartInitException[1];
        BusyIndicator.showWhile((Display)this.window.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    iEditorPartArray[0] = WorkbenchPage.this.busyOpenEditor(iEditorInput, string, bl, n, iMemento);
                }
                catch (PartInitException partInitException) {
                    partInitExceptionArray[0] = partInitException;
                }
            }
        });
        if (partInitExceptionArray[0] != null) {
            throw partInitExceptionArray[0];
        }
        return iEditorPartArray[0];
    }

    public IEditorPart openEditorFromDescriptor(final IEditorInput iEditorInput, final IEditorDescriptor iEditorDescriptor, final boolean bl, final IMemento iMemento) throws PartInitException {
        if (iEditorInput == null || !(iEditorDescriptor instanceof EditorDescriptor)) {
            throw new IllegalArgumentException();
        }
        final IEditorPart[] iEditorPartArray = new IEditorPart[1];
        final PartInitException[] partInitExceptionArray = new PartInitException[1];
        BusyIndicator.showWhile((Display)this.window.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    iEditorPartArray[0] = WorkbenchPage.this.busyOpenEditorFromDescriptor(iEditorInput, (EditorDescriptor)iEditorDescriptor, bl, iMemento);
                }
                catch (PartInitException partInitException) {
                    partInitExceptionArray[0] = partInitException;
                }
            }
        });
        if (partInitExceptionArray[0] != null) {
            throw partInitExceptionArray[0];
        }
        return iEditorPartArray[0];
    }

    private IEditorPart busyOpenEditor(IEditorInput iEditorInput, String string, boolean bl, int n, IMemento iMemento) throws PartInitException {
        Workbench workbench = (Workbench)this.getWorkbenchWindow().getWorkbench();
        workbench.largeUpdateStart();
        try {
            IEditorPart iEditorPart = this.busyOpenEditorBatched(iEditorInput, string, bl, n, iMemento);
            return iEditorPart;
        }
        finally {
            workbench.largeUpdateEnd();
        }
    }

    private IEditorPart busyOpenEditorFromDescriptor(IEditorInput iEditorInput, EditorDescriptor editorDescriptor, boolean bl, IMemento iMemento) throws PartInitException {
        Workbench workbench = (Workbench)this.getWorkbenchWindow().getWorkbench();
        workbench.largeUpdateStart();
        try {
            IEditorPart iEditorPart = this.busyOpenEditorFromDescriptorBatched(iEditorInput, editorDescriptor, bl, iMemento);
            return iEditorPart;
        }
        finally {
            workbench.largeUpdateEnd();
        }
    }

    protected IEditorPart busyOpenEditorBatched(IEditorInput iEditorInput, String string, boolean bl, int n, IMemento iMemento) throws PartInitException {
        IEditorReference iEditorReference;
        IEditorPart iEditorPart = null;
        iEditorPart = this.getEditorManager().findEditor(string, iEditorInput, ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).getReuseEditorMatchFlags(n));
        if (iEditorPart != null) {
            if ("org.eclipse.ui.systemExternalEditor".equals(string)) {
                if (iEditorPart.isDirty()) {
                    iEditorReference = new MessageDialog(this.getWorkbenchWindow().getShell(), WorkbenchMessages.Save, null, NLS.bind((String)WorkbenchMessages.WorkbenchPage_editorAlreadyOpenedMsg, (Object)iEditorInput.getName()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0){

                        protected int getShellStyle() {
                            return super.getShellStyle() | 0x10000000;
                        }
                    };
                    int n2 = iEditorReference.open();
                    if (n2 == 0) {
                        try {
                            final IEditorPart iEditorPart2 = iEditorPart;
                            this.getWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                                    iEditorPart2.doSave(iProgressMonitor);
                                }
                            });
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throw (RuntimeException)invocationTargetException.getTargetException();
                        }
                        catch (InterruptedException interruptedException) {
                            return null;
                        }
                    } else if (n2 == 2) {
                        return null;
                    }
                }
            } else {
                if (iEditorPart instanceof IShowEditorInput) {
                    ((IShowEditorInput)((Object)iEditorPart)).showEditorInput(iEditorInput);
                }
                this.showEditor(bl, iEditorPart);
                return iEditorPart;
            }
        }
        iEditorReference = null;
        try {
            this.partBeingOpened = true;
            iEditorReference = this.getEditorManager().openEditor(string, iEditorInput, true, iMemento);
            if (iEditorReference != null) {
                iEditorPart = iEditorReference.getEditor(true);
            }
        }
        finally {
            this.partBeingOpened = false;
        }
        if (iEditorPart != null) {
            this.setEditorAreaVisible(true);
            if (bl) {
                if (iEditorPart instanceof AbstractMultiEditor) {
                    this.activate(((AbstractMultiEditor)iEditorPart).getActiveEditor());
                } else {
                    this.activate(iEditorPart);
                }
            } else {
                this.bringToTop(iEditorPart);
            }
            this.window.firePerspectiveChanged(this, this.getPerspective(), iEditorReference, "editorOpen");
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorOpen");
        }
        return iEditorPart;
    }

    private IEditorPart busyOpenEditorFromDescriptorBatched(IEditorInput iEditorInput, EditorDescriptor editorDescriptor, boolean bl, IMemento iMemento) throws PartInitException {
        IEditorPart iEditorPart = null;
        IEditorReference iEditorReference = null;
        iEditorReference = this.getEditorManager().openEditorFromDescriptor(editorDescriptor, iEditorInput, iMemento);
        if (iEditorReference != null) {
            iEditorPart = iEditorReference.getEditor(true);
        }
        if (iEditorPart != null) {
            this.setEditorAreaVisible(true);
            if (bl) {
                if (iEditorPart instanceof AbstractMultiEditor) {
                    this.activate(((AbstractMultiEditor)iEditorPart).getActiveEditor());
                } else {
                    this.activate(iEditorPart);
                }
            } else {
                this.bringToTop(iEditorPart);
            }
            this.window.firePerspectiveChanged(this, this.getPerspective(), iEditorReference, "editorOpen");
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorOpen");
        }
        return iEditorPart;
    }

    public void openEmptyTab() {
        IEditorPart iEditorPart = null;
        EditorReference editorReference = null;
        editorReference = (EditorReference)this.getEditorManager().openEmptyTab();
        if (editorReference != null) {
            iEditorPart = editorReference.getEmptyEditor((EditorDescriptor)((EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry()).findEditor("org.eclipse.ui.internal.emptyEditorTab"));
        }
        if (iEditorPart != null) {
            this.setEditorAreaVisible(true);
            this.activate(iEditorPart);
            this.window.firePerspectiveChanged(this, this.getPerspective(), editorReference, "editorOpen");
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorOpen");
        }
    }

    protected void showEditor(boolean bl, IEditorPart iEditorPart) {
        this.setEditorAreaVisible(true);
        if (bl) {
            this.zoomOutIfNecessary(iEditorPart);
            this.activate(iEditorPart);
        } else {
            this.bringToTop(iEditorPart);
        }
    }

    @Override
    public boolean isEditorPinned(IEditorPart iEditorPart) {
        WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)this.getReference(iEditorPart);
        return workbenchPartReference != null && workbenchPartReference.isPinned();
    }

    private boolean partChangeAffectsZoom(IWorkbenchPartReference iWorkbenchPartReference) {
        PartPane partPane = ((WorkbenchPartReference)iWorkbenchPartReference).getPane();
        if (partPane instanceof MultiEditorInnerPane) {
            partPane = ((MultiEditorInnerPane)partPane).getParentPane();
        }
        return this.getActivePerspective().getPresentation().partChangeAffectsZoom(partPane);
    }

    public void removeFastView(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        perspective.removeFastView(iViewReference);
        this.window.firePerspectiveChanged(this, this.getPerspective(), iViewReference, "fastViewRemove");
        this.window.firePerspectiveChanged(this, this.getPerspective(), "fastViewRemove");
    }

    @Override
    public void removePartListener(IPartListener iPartListener) {
        this.partList.getPartService().removePartListener(iPartListener);
    }

    @Override
    public void removePartListener(IPartListener2 iPartListener2) {
        this.partList.getPartService().removePartListener(iPartListener2);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyChangeListeners.remove((Object)iPropertyChangeListener);
    }

    @Override
    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.selectionService.removeSelectionListener(iSelectionListener);
    }

    @Override
    public void removeSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.selectionService.removeSelectionListener(string, iSelectionListener);
    }

    @Override
    public void removePostSelectionListener(ISelectionListener iSelectionListener) {
        this.selectionService.removePostSelectionListener(iSelectionListener);
    }

    @Override
    public void removePostSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.selectionService.removePostSelectionListener(string, iSelectionListener);
    }

    public void requestActivation(IWorkbenchPart iWorkbenchPart) {
        if (!this.certifyPart(iWorkbenchPart) || this.partBeingOpened) {
            return;
        }
        if (iWorkbenchPart instanceof AbstractMultiEditor) {
            iWorkbenchPart = ((AbstractMultiEditor)iWorkbenchPart).getActiveEditor();
        }
        this.setActivePart(iWorkbenchPart, false);
    }

    @Override
    public void resetPerspective() {
        ICoolBarManager2 iCoolBarManager2 = (ICoolBarManager2)this.window.getCoolBarManager2();
        try {
            iCoolBarManager2.getControl2().setRedraw(false);
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    WorkbenchPage.this.busyResetPerspective();
                }
            });
        }
        finally {
            iCoolBarManager2.getControl2().setRedraw(true);
        }
    }

    /*
     * Loose catch block
     */
    public IStatus restoreState(IMemento iMemento, final IPerspectiveDescriptor iPerspectiveDescriptor) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() throws Throwable {
                WorkbenchPage.this.deferUpdates(true);
            }
        });
        String string = iMemento.getString("label");
        String string2 = null;
        if (UIStats.isDebugging(4)) {
            string2 = string == null ? "" : "::" + string;
        }
        UIStats.start(4, "WorkbenchPage" + string2);
        if (string == null) {
            string = "";
        }
        final MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.WorkbenchPage_unableToRestorePerspective, (Object)string), null);
        String string3 = iMemento.getString("workingSet");
        if (string3 != null) {
            object4 = (AbstractWorkingSetManager)this.getWorkbenchWindow().getWorkbench().getWorkingSetManager();
            this.setWorkingSet(((AbstractWorkingSetManager)object4).getWorkingSet(string3));
        }
        if ((object4 = iMemento.getChild("workingSets")) != null) {
            object3 = object4.getChildren("workingSet");
            object2 = new ArrayList(((IMemento[])object3).length);
            int n = 0;
            while (n < ((IMemento[])object3).length) {
                object = this.getWorkbenchWindow().getWorkbench().getWorkingSetManager().getWorkingSet(object3[n].getID());
                if (object != null) {
                    object2.add(object);
                }
                ++n;
            }
            this.workingSets = object2.toArray(new IWorkingSet[object2.size()]);
        }
        this.aggregateWorkingSetId = iMemento.getString(ATT_AGGREGATE_WORKING_SET_ID);
        object3 = this.window.getWorkbench().getWorkingSetManager().getWorkingSet(this.aggregateWorkingSetId);
        if (object3 instanceof AggregateWorkingSet) {
            this.aggregateWorkingSet = (AggregateWorkingSet)object3;
        }
        object2 = iMemento.getChild("editors");
        multiStatus.merge(this.getEditorManager().restoreState((IMemento)object2));
        object2 = iMemento.getChild("views");
        if (object2 != null) {
            multiStatus.merge(this.getViewFactory().restoreState((IMemento)object2));
        }
        object2 = iMemento.getChild("perspectives");
        String string4 = object2.getString("activePart");
        object = null;
        if (string4 != null && (object = ViewFactory.extractSecondaryId(string4)) != null) {
            string4 = ViewFactory.extractPrimaryId(string4);
        }
        final String string5 = object2.getString("activePerspective");
        IMemento[] iMementoArray = object2.getChildren("perspective");
        final Perspective[] perspectiveArray = new Perspective[1];
        int n = 0;
        while (n < iMementoArray.length) {
            final IMemento iMemento2 = iMementoArray[n];
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    Perspective perspective = ((WorkbenchImplementation)Tweaklets.get(WorkbenchImplementation.KEY)).createPerspective(null, WorkbenchPage.this);
                    multiStatus.merge(perspective.restoreState(iMemento2));
                    IPerspectiveDescriptor iPerspectiveDescriptor2 = perspective.getDesc();
                    if (iPerspectiveDescriptor2.equals(iPerspectiveDescriptor)) {
                        perspectiveArray[0] = perspective;
                    } else if (perspectiveArray[0] == null && iPerspectiveDescriptor2.getId().equals(string5)) {
                        perspectiveArray[0] = perspective;
                    }
                    WorkbenchPage.this.perspList.add(perspective);
                    WorkbenchPage.this.window.firePerspectiveOpened(WorkbenchPage.this, iPerspectiveDescriptor2);
                }
            });
            ++n;
        }
        Perspective perspective = perspectiveArray[0];
        boolean bl = false;
        if (iPerspectiveDescriptor == null) {
            bl = true;
        } else if (perspective != null && perspective.getDesc().equals(iPerspectiveDescriptor)) {
            bl = true;
        } else {
            bl = false;
            perspective = this.createPerspective((PerspectiveDescriptor)iPerspectiveDescriptor, true);
            if (perspective == null) {
                multiStatus.merge((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Workbench_showPerspectiveError, (Object)iPerspectiveDescriptor.getId()), null));
            }
        }
        this.perspList.setActive(perspective);
        perspective = this.perspList.getActive();
        if (perspective == null) {
            perspective = this.perspList.getNextActive();
            this.perspList.setActive(perspective);
        }
        if (perspective != null && bl) {
            multiStatus.merge(perspective.restoreState());
        }
        if (perspective != null) {
            final Perspective perspective2 = perspective;
            final String string6 = string4;
            Object object5 = object;
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((String)object5){
                private final /* synthetic */ String val$mySecondaryId;
                {
                    this.val$mySecondaryId = string2;
                }

                @Override
                public void runWithException() throws Throwable {
                    IViewReference iViewReference;
                    WorkbenchPage.this.window.firePerspectiveActivated(WorkbenchPage.this, perspective2.getDesc());
                    if (string6 != null && (iViewReference = perspective2.findView(string6, this.val$mySecondaryId)) != null) {
                        WorkbenchPage.this.activationList.setActive(iViewReference);
                    }
                }
            });
        }
        if ((object2 = iMemento.getChild("navigationHistory")) != null) {
            this.navigationHistory.restoreState((IMemento)object2);
        } else if (this.getActiveEditor() != null) {
            this.navigationHistory.markEditor(this.getActiveEditor());
        }
        this.stickyViewMan.restore(iMemento);
        MultiStatus multiStatus2 = multiStatus;
        String string7 = iPerspectiveDescriptor == null ? string : iPerspectiveDescriptor.getId();
        UIStats.end(4, string7, "WorkbenchPage" + string2);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() throws Throwable {
                WorkbenchPage.this.deferUpdates(false);
            }
        });
        return multiStatus2;
        {
            catch (Throwable throwable) {
                try {
                    String string8 = iPerspectiveDescriptor == null ? string : iPerspectiveDescriptor.getId();
                    UIStats.end(4, string8, "WorkbenchPage" + string2);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    StartupThreading.runWithoutExceptions(new /* invalid duplicate definition of identical inner class */);
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public boolean saveAllEditors(boolean bl) {
        return this.saveAllEditors(bl, false);
    }

    public boolean saveAllEditors(boolean bl, boolean bl2) {
        return this.getEditorManager().saveAll(bl, false, bl2);
    }

    public boolean savePart(ISaveablePart iSaveablePart, IWorkbenchPart iWorkbenchPart, boolean bl) {
        return this.getEditorManager().savePart(iSaveablePart, iWorkbenchPart, bl);
    }

    @Override
    public boolean saveEditor(IEditorPart iEditorPart, boolean bl) {
        return this.savePart(iEditorPart, iEditorPart, bl);
    }

    @Override
    public void savePerspective() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        perspective.saveDesc();
    }

    @Override
    public void savePerspectiveAs(IPerspectiveDescriptor iPerspectiveDescriptor) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        IPerspectiveDescriptor iPerspectiveDescriptor2 = perspective.getDesc();
        if (this.isZoomed()) {
            this.zoomOut();
        }
        perspective.saveDescAs(iPerspectiveDescriptor);
        this.window.firePerspectiveSavedAs(this, iPerspectiveDescriptor2, iPerspectiveDescriptor);
    }

    public IStatus saveState(IMemento iMemento) {
        Object object;
        Object object2;
        if (this.isZoomed()) {
            this.zoomOut();
        }
        this.hideFastView();
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.WorkbenchPage_unableToSavePerspective, (Object)this.getLabel()), null);
        IMemento iMemento2 = iMemento.createChild("editors");
        multiStatus.merge(this.editorMgr.saveState(iMemento2));
        iMemento2 = iMemento.createChild("views");
        multiStatus.merge(this.getViewFactory().saveState(iMemento2));
        iMemento2 = iMemento.createChild("perspectives");
        if (this.getPerspective() != null) {
            iMemento2.putString("activePerspective", this.getPerspective().getId());
        }
        if (this.getActivePart() != null) {
            if (this.getActivePart() instanceof IViewPart) {
                object2 = (IViewReference)this.getReference(this.getActivePart());
                if (object2 != null) {
                    iMemento2.putString("activePart", ViewFactory.getKey((IViewReference)object2));
                }
            } else {
                iMemento2.putString("activePart", this.getActivePart().getSite().getId());
            }
        }
        object2 = this.perspList.iterator();
        while (object2.hasNext()) {
            object = (Perspective)object2.next();
            IMemento iMemento3 = iMemento2.createChild("perspective");
            multiStatus.merge(((Perspective)object).saveState(iMemento3));
        }
        if (this.workingSet != null) {
            iMemento.putString("workingSet", this.workingSet.getName());
        }
        object = iMemento.createChild("workingSets");
        int n = 0;
        while (n < this.workingSets.length) {
            object.createChild("workingSet", this.workingSets[n].getName());
            ++n;
        }
        if (this.aggregateWorkingSetId != null) {
            iMemento.putString(ATT_AGGREGATE_WORKING_SET_ID, this.aggregateWorkingSetId);
        }
        this.navigationHistory.saveState(iMemento.createChild("navigationHistory"));
        this.stickyViewMan.save(iMemento);
        return multiStatus;
    }

    private String getId(IWorkbenchPart iWorkbenchPart) {
        return this.getId(this.getReference(iWorkbenchPart));
    }

    private String getId(IWorkbenchPartReference iWorkbenchPartReference) {
        if (iWorkbenchPartReference == null) {
            return "null";
        }
        return iWorkbenchPartReference.getId();
    }

    private void setActivePart(IWorkbenchPart iWorkbenchPart, boolean bl) {
        if (!bl && this.getActivePart() == iWorkbenchPart) {
            return;
        }
        if (this.partBeingActivated != null) {
            if (this.partBeingActivated.getPart(false) != iWorkbenchPart) {
                EditorReference editorReference;
                IEditorReference[] iEditorReferenceArray;
                if (this.partBeingActivated instanceof EditorManager.InnerEditor && (iEditorReferenceArray = (editorReference = (EditorReference)((EditorManager.InnerEditor)this.partBeingActivated).getOuterEditor()).getChildren()) != null) {
                    int n = 0;
                    while (n < iEditorReferenceArray.length) {
                        if (iEditorReferenceArray[n].getPart(false) == iWorkbenchPart) {
                            return;
                        }
                        ++n;
                    }
                }
                WorkbenchPlugin.log(new RuntimeException(NLS.bind((String)"WARNING: Prevented recursive attempt to activate part {0} while still in the middle of activating part {1}", (Object)this.getId(iWorkbenchPart), (Object)this.getId(this.partBeingActivated))));
            }
            return;
        }
        String string = null;
        if (UIStats.isDebugging(7)) {
            string = iWorkbenchPart != null ? iWorkbenchPart.getTitle() : "none";
        }
        try {
            IWorkbenchPart iWorkbenchPart2;
            Object object;
            IWorkbenchPartReference iWorkbenchPartReference = this.getReference(iWorkbenchPart);
            IWorkbenchPartReference iWorkbenchPartReference2 = null;
            if (iWorkbenchPart != null && (object = iWorkbenchPart.getSite()) instanceof PartSite) {
                iWorkbenchPartReference2 = ((PartSite)object).getPane().getPartReference();
            }
            this.partBeingActivated = iWorkbenchPartReference2;
            UIStats.start(7, string);
            object = this.getActivePerspective();
            if (object != null) {
                ((Perspective)object).partActivated(iWorkbenchPart);
            }
            if ((iWorkbenchPart2 = this.getActivePart()) != null) {
                this.deactivatePart(iWorkbenchPart2);
            }
            if (iWorkbenchPart != null) {
                this.activationList.setActive(iWorkbenchPart);
                if (iWorkbenchPart instanceof IEditorPart) {
                    this.makeActiveEditor((IEditorReference)iWorkbenchPartReference2);
                }
            }
            this.activatePart(iWorkbenchPart);
            this.actionSwitcher.updateActivePart(iWorkbenchPart);
            this.partList.setActivePart(iWorkbenchPartReference);
        }
        catch (Throwable throwable) {
            this.partBeingActivated = null;
            Object object = iWorkbenchPart == null ? this : iWorkbenchPart;
            UIStats.end(7, object, string);
            throw throwable;
        }
        this.partBeingActivated = null;
        Object object = iWorkbenchPart == null ? this : iWorkbenchPart;
        UIStats.end(7, object, string);
    }

    @Override
    public void setEditorAreaVisible(boolean bl) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        if (bl == perspective.isEditorAreaVisible()) {
            return;
        }
        if (this.isZoomed()) {
            this.zoomOut();
        }
        if (bl) {
            perspective.showEditorArea();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorAreaShow");
        } else {
            perspective.hideEditorArea();
            this.updateActivePart();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "editorAreaHide");
        }
    }

    private void setPerspective(Perspective perspective) {
        Perspective perspective2 = this.getActivePerspective();
        if (perspective2 == perspective) {
            return;
        }
        this.window.largeUpdateStart();
        try {
            IStatus iStatus;
            if (perspective2 != null) {
                this.window.firePerspectivePreDeactivate(this, perspective2.getDesc());
            }
            if (perspective != null && (iStatus = perspective.restoreState()).getSeverity() != 0) {
                String string = WorkbenchMessages.WorkbenchPage_problemRestoringTitle;
                String string2 = WorkbenchMessages.WorkbenchPage_errorReadingState;
                ErrorDialog.openError((Shell)this.getWorkbenchWindow().getShell(), (String)string, (String)string2, (IStatus)iStatus);
            }
            if (perspective2 != null) {
                perspective2.onDeactivate();
                this.window.firePerspectiveDeactivated(this, perspective2.getDesc());
            }
            this.perspList.setActive(perspective);
            if (perspective != null) {
                perspective.onActivate();
                this.window.firePerspectiveActivated(this, perspective.getDesc());
            }
            this.updateVisibility(perspective2, perspective);
            this.window.updateActionSets();
            this.stickyViewMan.update(perspective2, perspective);
        }
        finally {
            this.window.largeUpdateEnd();
            if (perspective == null) {
                return;
            }
            IPerspectiveDescriptor iPerspectiveDescriptor = perspective.getDesc();
            if (iPerspectiveDescriptor == null) {
                return;
            }
            if (this.dirtyPerspectives.remove(iPerspectiveDescriptor.getId())) {
                this.suggestReset();
            }
        }
    }

    void perspectiveActionSetChanged(Perspective perspective, IActionSetDescriptor iActionSetDescriptor, int n) {
        if (perspective == this.getActivePerspective()) {
            this.actionSets.change(iActionSetDescriptor, n);
        }
    }

    private void updateVisibility(Perspective perspective, Perspective perspective2) {
        ISizeProvider iSizeProvider;
        Object object;
        IWorkbenchPartReference[] iWorkbenchPartReferenceArray = new IWorkbenchPartReference[]{};
        if (perspective != null) {
            iWorkbenchPartReferenceArray = perspective.getViewReferences();
            int n = 0;
            while (n < iWorkbenchPartReferenceArray.length) {
                object = ((WorkbenchPartReference)iWorkbenchPartReferenceArray[n]).getPane();
                ((PartPane)object).setInLayout(false);
                ++n;
            }
        }
        PerspectiveHelper perspectiveHelper = null;
        if (perspective2 != null) {
            perspectiveHelper = perspective2.getPresentation();
            object = perspective2.getViewReferences();
            int n = 0;
            while (n < ((IViewReference[])object).length) {
                iSizeProvider = (WorkbenchPartReference)object[n];
                PartPane partPane = ((WorkbenchPartReference)iSizeProvider).getPane();
                if (perspectiveHelper.isPartVisible((IWorkbenchPartReference)((Object)iSizeProvider))) {
                    this.activationList.bringToTop((IWorkbenchPartReference)((Object)iSizeProvider));
                }
                partPane.setInLayout(true);
                ++n;
            }
        }
        this.updateActivePart();
        int n = 0;
        while (n < iWorkbenchPartReferenceArray.length) {
            WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)iWorkbenchPartReferenceArray[n];
            iSizeProvider = workbenchPartReference.getPane();
            if (perspectiveHelper == null || !perspectiveHelper.isPartVisible(workbenchPartReference)) {
                ((PartPane)iSizeProvider).setVisible(false);
            }
            ++n;
        }
    }

    @Override
    public void setPerspective(final IPerspectiveDescriptor iPerspectiveDescriptor) {
        if (Util.equals(this.getPerspective(), iPerspectiveDescriptor)) {
            return;
        }
        ICoolBarManager2 iCoolBarManager2 = (ICoolBarManager2)this.window.getCoolBarManager2();
        try {
            if (iCoolBarManager2 != null) {
                iCoolBarManager2.getControl2().setRedraw(false);
            }
            this.getClientComposite().setRedraw(false);
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    WorkbenchPage.this.busySetPerspective(iPerspectiveDescriptor);
                }
            });
        }
        finally {
            IWorkbenchPart iWorkbenchPart;
            this.getClientComposite().setRedraw(true);
            if (iCoolBarManager2 != null) {
                iCoolBarManager2.getControl2().setRedraw(true);
            }
            if ((iWorkbenchPart = this.getActivePart()) != null) {
                iWorkbenchPart.setFocus();
            }
        }
    }

    public PartService getPartService() {
        return (PartService)this.partList.getPartService();
    }

    protected void resetToolBarLayout() {
        ICoolBarManager2 iCoolBarManager2 = (ICoolBarManager2)this.window.getCoolBarManager2();
        iCoolBarManager2.resetItemOrder();
    }

    public void setWorkingSet(IWorkingSet iWorkingSet) {
        IWorkingSet iWorkingSet2 = this.workingSet;
        this.workingSet = iWorkingSet;
        if (iWorkingSet2 != iWorkingSet) {
            this.firePropertyChange("workingSetReplace", iWorkingSet2, iWorkingSet);
        }
        if (iWorkingSet != null) {
            WorkbenchPlugin.getDefault().getWorkingSetManager().addPropertyChangeListener(this.workingSetPropertyChangeListener);
        } else {
            WorkbenchPlugin.getDefault().getWorkingSetManager().removePropertyChangeListener(this.workingSetPropertyChangeListener);
        }
    }

    @Override
    public void showActionSet(String string) {
        ActionSetRegistry actionSetRegistry;
        IActionSetDescriptor iActionSetDescriptor;
        Perspective perspective = this.getActivePerspective();
        if (perspective != null && (iActionSetDescriptor = (actionSetRegistry = WorkbenchPlugin.getDefault().getActionSetRegistry()).findActionSet(string)) != null) {
            perspective.addActionSet(iActionSetDescriptor);
            this.window.updateActionSets();
            this.window.firePerspectiveChanged(this, this.getPerspective(), "actionSetShow");
        }
    }

    @Override
    public IViewPart showView(String string) throws PartInitException {
        return this.showView(string, null, 1);
    }

    @Override
    public IViewPart showView(final String string, final String string2, final int n) throws PartInitException {
        if (string2 != null && (string2.length() == 0 || string2.indexOf(":") != -1)) {
            throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalSecondaryId);
        }
        if (!this.certifyMode(n)) {
            throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalViewMode);
        }
        final Object[] objectArray = new Object[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    objectArray[0] = WorkbenchPage.this.busyShowView(string, string2, n);
                }
                catch (PartInitException partInitException) {
                    objectArray[0] = partInitException;
                }
            }
        });
        if (objectArray[0] instanceof IViewPart) {
            return (IViewPart)objectArray[0];
        }
        if (objectArray[0] instanceof PartInitException) {
            throw (PartInitException)((Object)objectArray[0]);
        }
        throw new PartInitException(WorkbenchMessages.WorkbenchPage_AbnormalWorkbenchCondition);
    }

    private boolean certifyMode(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void hideFastView() {
        IViewReference iViewReference;
        Perspective perspective = this.getActivePerspective();
        if (perspective != null && (iViewReference = perspective.getActiveFastView()) != null) {
            this.toggleFastView(iViewReference);
        }
    }

    public void toggleFastView(IViewReference iViewReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            perspective.toggleFastView(iViewReference);
            if (iViewReference != perspective.getActiveFastView()) {
                IWorkbenchPart iWorkbenchPart = this.activationList.getPreviouslyActive();
                IEditorPart iEditorPart = this.getActiveEditor();
                if (iEditorPart != null && iWorkbenchPart instanceof IEditorPart) {
                    this.setActivePart(iEditorPart, false);
                } else {
                    this.setActivePart(iWorkbenchPart, false);
                }
            }
        }
    }

    public void setState(IWorkbenchPartReference iWorkbenchPartReference, int n) {
        boolean bl;
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return;
        }
        PartPane partPane = ((WorkbenchPartReference)iWorkbenchPartReference).getPane();
        if (!partPane.isDocked()) {
            partPane.setZoomed(n == 1);
            return;
        }
        if (iWorkbenchPartReference instanceof IViewReference && perspective.isFastView((IViewReference)iWorkbenchPartReference)) {
            perspective.setFastViewState((IViewReference)iWorkbenchPartReference, n);
            return;
        }
        if (Perspective.useNewMinMax(perspective)) {
            PartStack partStack = (PartStack)partPane.getContainer();
            partStack.setState(n);
            return;
        }
        boolean bl2 = this.isZoomed();
        boolean bl3 = bl = n == 1;
        if (bl2 && !bl) {
            this.zoomOut();
        } else if (!bl2 && bl) {
            perspective.getPresentation().zoomIn(iWorkbenchPartReference);
            this.activate(iWorkbenchPartReference.getPart(true));
        }
        PartStack partStack = (PartStack)partPane.getContainer();
        if (partStack != null) {
            partStack.setMinimized(n == 0);
        }
    }

    @Override
    public void setPartState(IWorkbenchPartReference iWorkbenchPartReference, int n) {
        this.setState(iWorkbenchPartReference, n);
    }

    int getState(IWorkbenchPartReference iWorkbenchPartReference) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return 2;
        }
        PartPane partPane = ((WorkbenchPartReference)iWorkbenchPartReference).getPane();
        if (iWorkbenchPartReference instanceof IViewReference && perspective.isFastView((IViewReference)iWorkbenchPartReference)) {
            return perspective.getFastViewState();
        }
        PartStack partStack = (PartStack)partPane.getContainer();
        if (partStack != null) {
            return partStack.getState();
        }
        return 2;
    }

    @Override
    public int getPartState(IWorkbenchPartReference iWorkbenchPartReference) {
        return this.getState(iWorkbenchPartReference);
    }

    @Override
    public void toggleZoom(IWorkbenchPartReference iWorkbenchPartReference) {
        int n = this.getState(iWorkbenchPartReference);
        boolean bl = n != 1;
        int n2 = bl ? 1 : 2;
        this.setState(iWorkbenchPartReference, n2);
    }

    public void updateActionBars() {
        this.window.updateActionBars();
    }

    private void updateTabList(IWorkbenchPart iWorkbenchPart) {
        PartSite partSite = (PartSite)iWorkbenchPart.getSite();
        PartPane partPane = partSite.getPane();
        if (partPane instanceof ViewPane) {
            ViewPane viewPane = (ViewPane)partPane;
            Control[] controlArray = viewPane.getTabList();
            if (!partPane.isDocked()) {
                viewPane.getControl().getShell().setTabList(controlArray);
            } else {
                this.getClientComposite().setTabList(controlArray);
            }
        } else if (partPane instanceof EditorPane) {
            EditorSashContainer editorSashContainer = ((EditorPane)partPane).getWorkbook().getEditorArea();
            editorSashContainer.updateTabList();
            this.getClientComposite().setTabList(new Control[]{editorSashContainer.getParent()});
        }
    }

    @Override
    public void zoomOut() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            perspective.getPresentation().zoomOut();
        }
    }

    private void zoomOutIfNecessary(IWorkbenchPart iWorkbenchPart) {
        if (this.isZoomed() && this.partChangeAffectsZoom(((PartSite)iWorkbenchPart.getSite()).getPartReference())) {
            this.zoomOut();
        }
    }

    @Override
    public int getEditorReuseThreshold() {
        return ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).getEditorReuseThreshold();
    }

    @Override
    public void setEditorReuseThreshold(int n) {
    }

    public IEditorReference[] getSortedEditors() {
        return this.activationList.getEditors();
    }

    @Override
    public IPerspectiveDescriptor[] getOpenPerspectives() {
        Perspective[] perspectiveArray = this.perspList.getOpenedPerspectives();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = new IPerspectiveDescriptor[perspectiveArray.length];
        int n = 0;
        while (n < iPerspectiveDescriptorArray.length) {
            iPerspectiveDescriptorArray[n] = perspectiveArray[n].getDesc();
            ++n;
        }
        return iPerspectiveDescriptorArray;
    }

    Perspective[] getOpenInternalPerspectives() {
        return this.perspList.getOpenedPerspectives();
    }

    Perspective getFirstPerspectiveWithView(IViewPart iViewPart) {
        Perspective[] perspectiveArray = this.perspList.getSortedPerspectives();
        int n = perspectiveArray.length - 1;
        while (n >= 0) {
            if (perspectiveArray[n].containsView(iViewPart)) {
                return perspectiveArray[n];
            }
            --n;
        }
        return null;
    }

    @Override
    public IPerspectiveDescriptor[] getSortedPerspectives() {
        Perspective[] perspectiveArray = this.perspList.getSortedPerspectives();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = new IPerspectiveDescriptor[perspectiveArray.length];
        int n = 0;
        while (n < iPerspectiveDescriptorArray.length) {
            iPerspectiveDescriptorArray[n] = perspectiveArray[n].getDesc();
            ++n;
        }
        return iPerspectiveDescriptorArray;
    }

    public IWorkbenchPartReference[] getSortedParts() {
        return this.activationList.getParts();
    }

    @Override
    public IWorkbenchPartReference getReference(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == null) {
            return null;
        }
        IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchPart.getSite();
        if (!(iWorkbenchPartSite instanceof PartSite)) {
            return null;
        }
        PartSite partSite = (PartSite)iWorkbenchPartSite;
        PartPane partPane = partSite.getPane();
        if (partPane instanceof MultiEditorInnerPane) {
            MultiEditorInnerPane multiEditorInnerPane = (MultiEditorInnerPane)partPane;
            return multiEditorInnerPane.getParentPane().getPartReference();
        }
        return partSite.getPartReference();
    }

    protected void addPerspective(Perspective perspective) {
        this.perspList.add(perspective);
        this.window.firePerspectiveOpened(this, perspective.getDesc());
    }

    private IViewReference[] getViewReferenceStack(IViewPart iViewPart) {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null || !this.certifyPart(iViewPart)) {
            return null;
        }
        ILayoutContainer iLayoutContainer = ((PartSite)iViewPart.getSite()).getPane().getContainer();
        if (iLayoutContainer instanceof ViewStack) {
            ViewStack viewStack = (ViewStack)iLayoutContainer;
            ArrayList<IViewReference> arrayList = new ArrayList<IViewReference>(viewStack.getChildren().length);
            int n = 0;
            while (n < viewStack.getChildren().length) {
                IViewReference iViewReference;
                LayoutPart layoutPart = viewStack.getChildren()[n];
                if (layoutPart instanceof ViewPane && (iViewReference = ((ViewPane)layoutPart).getViewReference()) != null) {
                    arrayList.add(iViewReference);
                }
                ++n;
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = -1 * WorkbenchPage.this.activationList.indexOf((IWorkbenchPartReference)object);
                    int n2 = -1 * WorkbenchPage.this.activationList.indexOf((IWorkbenchPartReference)object2);
                    return n - n2;
                }
            });
            return arrayList.toArray(new IViewReference[arrayList.size()]);
        }
        return new IViewReference[]{(IViewReference)this.getReference(iViewPart)};
    }

    @Override
    public IViewPart[] getViewStack(IViewPart iViewPart) {
        IViewReference[] iViewReferenceArray = this.getViewReferenceStack(iViewPart);
        if (iViewReferenceArray == null) {
            return null;
        }
        ArrayList<IViewPart> arrayList = new ArrayList<IViewPart>();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            IViewPart iViewPart2 = iViewReferenceArray[n].getView(false);
            if (iViewPart2 != null) {
                arrayList.add(iViewPart2);
            }
            ++n;
        }
        return arrayList.toArray(new IViewPart[arrayList.size()]);
    }

    public void resizeView(IViewPart iViewPart, int n, int n2) {
        Rectangle rectangle;
        SashInfo sashInfo = new SashInfo();
        PartPane partPane = ((PartSite)iViewPart.getSite()).getPane();
        ILayoutContainer iLayoutContainer = partPane.getContainer();
        LayoutTree layoutTree = this.getPerspectivePresentation().getLayout().root.find((ViewStack)iLayoutContainer);
        this.findSashParts(layoutTree, partPane.findSashes(), sashInfo);
        float f = n - partPane.getBounds().width;
        if (sashInfo.right != null) {
            rectangle = sashInfo.rightNode.getBounds();
            sashInfo.right.setRatio((f + (float)((SashInfo)sashInfo).right.getBounds().x - (float)rectangle.x) / (float)rectangle.width);
            sashInfo.rightNode.setBounds(rectangle);
        } else if (sashInfo.left != null) {
            rectangle = sashInfo.leftNode.getBounds();
            sashInfo.left.setRatio(((float)((SashInfo)sashInfo).left.getBounds().x - f - (float)rectangle.x) / (float)rectangle.width);
            sashInfo.leftNode.setBounds(sashInfo.leftNode.getBounds());
        }
        float f2 = n2 - partPane.getBounds().height;
        if (sashInfo.bottom != null) {
            Rectangle rectangle2 = sashInfo.bottomNode.getBounds();
            sashInfo.bottom.setRatio((f2 + (float)((SashInfo)sashInfo).bottom.getBounds().y - (float)rectangle2.y) / (float)rectangle2.height);
            sashInfo.bottomNode.setBounds(rectangle2);
        } else if (sashInfo.top != null) {
            Rectangle rectangle3 = sashInfo.topNode.getBounds();
            sashInfo.top.setRatio(((float)((SashInfo)sashInfo).top.getBounds().y - f2 - (float)rectangle3.y) / (float)rectangle3.height);
            sashInfo.topNode.setBounds(rectangle3);
        }
    }

    private void findSashParts(LayoutTree layoutTree, PartPane.Sashes sashes, SashInfo sashInfo) {
        LayoutPartSash layoutPartSash;
        Control control;
        LayoutTreeNode layoutTreeNode = layoutTree.getParent();
        if (layoutTreeNode == null) {
            return;
        }
        if (layoutTreeNode.part instanceof LayoutPartSash && (control = (layoutPartSash = (LayoutPartSash)layoutTreeNode.part).getControl()) != null) {
            if (layoutPartSash.isVertical()) {
                if (sashes.left == control) {
                    sashInfo.left = layoutPartSash;
                    sashInfo.leftNode = ((LayoutTree)layoutTreeNode).findSash(layoutPartSash);
                } else if (sashes.right == control) {
                    sashInfo.right = layoutPartSash;
                    sashInfo.rightNode = ((LayoutTree)layoutTreeNode).findSash(layoutPartSash);
                }
            } else if (sashes.top == control) {
                sashInfo.top = layoutPartSash;
                sashInfo.topNode = ((LayoutTree)layoutTreeNode).findSash(layoutPartSash);
            } else if (sashes.bottom == control) {
                sashInfo.bottom = layoutPartSash;
                sashInfo.bottomNode = ((LayoutTree)layoutTreeNode).findSash(layoutPartSash);
            }
        }
        this.findSashParts(layoutTreeNode, sashes, sashInfo);
    }

    IWorkbenchPartReference[] getAllParts() {
        ArrayList<IWorkbenchPartReference> arrayList = new ArrayList<IWorkbenchPartReference>();
        IViewReference[] iViewReferenceArray = this.viewFactory.getViews();
        IEditorReference[] iEditorReferenceArray = this.getAllEditorReferences();
        if (iViewReferenceArray.length > 0) {
            arrayList.addAll(Arrays.asList(iViewReferenceArray));
        }
        if (iEditorReferenceArray.length > 0) {
            arrayList.addAll(Arrays.asList(iEditorReferenceArray));
        }
        return arrayList.toArray(new IWorkbenchPartReference[arrayList.size()]);
    }

    IWorkbenchPartReference[] getOpenParts() {
        IWorkbenchPartReference[] iWorkbenchPartReferenceArray = this.getAllParts();
        ArrayList<IWorkbenchPartReference> arrayList = new ArrayList<IWorkbenchPartReference>();
        int n = 0;
        while (n < iWorkbenchPartReferenceArray.length) {
            IWorkbenchPartReference iWorkbenchPartReference = iWorkbenchPartReferenceArray[n];
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
            if (iWorkbenchPart != null) {
                arrayList.add(iWorkbenchPartReference);
            }
            ++n;
        }
        return arrayList.toArray(new IWorkbenchPartReference[arrayList.size()]);
    }

    public void testInvariants() {
        Perspective perspective = this.getActivePerspective();
        if (perspective != null) {
            perspective.testInvariants();
            if (!SwtUtil.isDisposed((Control)this.getClientComposite()) && this.editorPresentation.getLayoutPart().isVisible()) {
                Assert.isTrue((boolean)perspective.isEditorAreaVisible());
            }
        }
    }

    @Override
    public IExtensionTracker getExtensionTracker() {
        if (this.tracker == null) {
            this.tracker = new UIExtensionTracker(this.getWorkbenchWindow().getWorkbench().getDisplay());
        }
        return this.tracker;
    }

    @Override
    public String[] getNewWizardShortcuts() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return new String[0];
        }
        return perspective.getNewWizardShortcuts();
    }

    @Override
    public String[] getPerspectiveShortcuts() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return new String[0];
        }
        return perspective.getPerspectiveShortcuts();
    }

    @Override
    public String[] getShowViewShortcuts() {
        Perspective perspective = this.getActivePerspective();
        if (perspective == null) {
            return new String[0];
        }
        return perspective.getShowViewShortcuts();
    }

    private void suggestReset() {
        final IWorkbench iWorkbench = this.getWorkbenchWindow().getWorkbench();
        iWorkbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = null;
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) {
                    if (iWorkbench.getWorkbenchWindowCount() == 0) {
                        return;
                    }
                    iWorkbenchWindow = iWorkbench.getWorkbenchWindows()[0];
                }
                if (MessageDialog.openQuestion((Shell)(shell = iWorkbenchWindow.getShell()), (String)WorkbenchMessages.Dynamic_resetPerspectiveTitle, (String)WorkbenchMessages.Dynamic_resetPerspectiveMessage)) {
                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                    if (iWorkbenchPage == null) {
                        return;
                    }
                    iWorkbenchPage.resetPerspective();
                }
            }
        });
    }

    public boolean isPartVisible(IWorkbenchPartReference iWorkbenchPartReference) {
        IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
        if (iWorkbenchPart == null) {
            return false;
        }
        return this.isPartVisible(iWorkbenchPart);
    }

    @Override
    public IWorkingSet[] getWorkingSets() {
        return this.workingSets;
    }

    @Override
    public void setWorkingSets(IWorkingSet[] iWorkingSetArray) {
        if (iWorkingSetArray != null) {
            WorkbenchPlugin.getDefault().getWorkingSetManager().addPropertyChangeListener(this.workingSetPropertyChangeListener);
        } else {
            WorkbenchPlugin.getDefault().getWorkingSetManager().removePropertyChangeListener(this.workingSetPropertyChangeListener);
        }
        if (iWorkingSetArray == null) {
            iWorkingSetArray = new IWorkingSet[]{};
        }
        Object[] objectArray = this.workingSets;
        if (iWorkingSetArray.length > 1) {
            HashSet<IWorkingSet> hashSet = new HashSet<IWorkingSet>();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                if (iWorkingSetArray[n] == null) {
                    throw new IllegalArgumentException();
                }
                hashSet.add(iWorkingSetArray[n]);
                ++n;
            }
            iWorkingSetArray = hashSet.toArray(new IWorkingSet[hashSet.size()]);
        }
        this.workingSets = iWorkingSetArray;
        if (!Arrays.equals(objectArray, iWorkingSetArray)) {
            this.firePropertyChange("workingSetsReplace", objectArray, iWorkingSetArray);
            if (this.aggregateWorkingSet != null) {
                this.aggregateWorkingSet.setComponents(this.workingSets);
            }
        }
    }

    @Override
    public IWorkingSet getAggregateWorkingSet() {
        if (this.aggregateWorkingSet == null) {
            IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.aggregateWorkingSet = (AggregateWorkingSet)iWorkingSetManager.getWorkingSet(this.getAggregateWorkingSetId());
            if (this.aggregateWorkingSet == null) {
                this.aggregateWorkingSet = (AggregateWorkingSet)iWorkingSetManager.createAggregateWorkingSet(this.getAggregateWorkingSetId(), WorkbenchMessages.WorkbenchPage_workingSet_default_label, this.getWorkingSets());
                iWorkingSetManager.addWorkingSet(this.aggregateWorkingSet);
            }
        }
        return this.aggregateWorkingSet;
    }

    private String getAggregateWorkingSetId() {
        if (this.aggregateWorkingSetId == null) {
            this.aggregateWorkingSetId = "Aggregate for window " + System.currentTimeMillis();
        }
        return this.aggregateWorkingSetId;
    }

    @Override
    public void showEditor(IEditorReference iEditorReference) {
        if (((WorkbenchPartReference)((Object)iEditorReference)).isDisposed()) {
            WorkbenchPlugin.log("adding a disposed part: " + iEditorReference);
            return;
        }
        if (this.editorPresentation.containsEditor((EditorReference)iEditorReference)) {
            return;
        }
        this.removedEditors.remove(iEditorReference);
        this.editorPresentation.addEditor((EditorReference)iEditorReference, "", false);
        this.activationList.add(iEditorReference);
        this.updateActivePart();
    }

    @Override
    public void hideEditor(IEditorReference iEditorReference) {
        if (!this.editorPresentation.containsEditor((EditorReference)iEditorReference)) {
            return;
        }
        this.editorPresentation.closeEditor(iEditorReference);
        this.activationList.remove(iEditorReference);
        this.removedEditors.add(iEditorReference);
        this.updateActivePart();
    }

    @Override
    public IEditorReference[] openEditors(final IEditorInput[] iEditorInputArray, final String[] stringArray, final int n) throws MultiPartInitException {
        if (iEditorInputArray == null) {
            throw new IllegalArgumentException();
        }
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        if (iEditorInputArray.length != stringArray.length) {
            throw new IllegalArgumentException();
        }
        IWorkbenchPartReference[] iWorkbenchPartReferenceArray = new IEditorReference[iEditorInputArray.length];
        PartInitException[] partInitExceptionArray = new PartInitException[iEditorInputArray.length];
        BusyIndicator.showWhile((Display)this.window.getWorkbench().getDisplay(), (Runnable)new Runnable((IEditorReference[])iWorkbenchPartReferenceArray, partInitExceptionArray){
            private final /* synthetic */ IEditorReference[] val$results;
            private final /* synthetic */ PartInitException[] val$exceptions;
            {
                this.val$results = iEditorReferenceArray;
                this.val$exceptions = partInitExceptionArray;
            }

            @Override
            public void run() {
                Workbench workbench = (Workbench)WorkbenchPage.this.getWorkbenchWindow().getWorkbench();
                workbench.largeUpdateStart();
                try {
                    WorkbenchPage.this.deferUpdates(true);
                    int n2 = iEditorInputArray.length - 1;
                    while (n2 >= 0) {
                        if (iEditorInputArray[n2] == null || stringArray[n2] == null) {
                            throw new IllegalArgumentException();
                        }
                        boolean bl = n2 == 0;
                        try {
                            IEditorReference iEditorReference = WorkbenchPage.this.batchReuseEditor(iEditorInputArray[n2], stringArray[n2], bl, n);
                            if (iEditorReference == null) {
                                iEditorReference = WorkbenchPage.this.batchOpenEditor(iEditorInputArray[n2], stringArray[n2], bl);
                            }
                            this.val$results[n2] = iEditorReference;
                        }
                        catch (PartInitException partInitException) {
                            this.val$exceptions[n2] = partInitException;
                            this.val$results[n2] = null;
                        }
                        --n2;
                    }
                    WorkbenchPage.this.deferUpdates(false);
                    n2 = iEditorInputArray.length - 1;
                    while (n2 >= 0) {
                        if (this.val$results[n2] != null) {
                            WorkbenchPage.this.activationList.bringToTop(this.val$results[n2]);
                        }
                        --n2;
                    }
                    n2 = 0;
                    while (n2 < this.val$results.length) {
                        IEditorPart iEditorPart;
                        if (this.val$results[n2] != null && (iEditorPart = this.val$results[n2].getEditor(true)) != null) {
                            if (iEditorPart instanceof AbstractMultiEditor) {
                                WorkbenchPage.this.internalActivate(((AbstractMultiEditor)iEditorPart).getActiveEditor(), true);
                            } else {
                                WorkbenchPage.this.internalActivate(iEditorPart, true);
                            }
                            break;
                        }
                        ++n2;
                    }
                }
                finally {
                    workbench.largeUpdateEnd();
                }
            }
        });
        boolean bl = false;
        int n2 = 0;
        while (n2 < iWorkbenchPartReferenceArray.length) {
            if (partInitExceptionArray[n2] != null) {
                bl = true;
            }
            if (iWorkbenchPartReferenceArray[n2] != null) {
                this.window.firePerspectiveChanged(this, this.getPerspective(), iWorkbenchPartReferenceArray[n2], "editorOpen");
            }
            ++n2;
        }
        this.window.firePerspectiveChanged(this, this.getPerspective(), "editorOpen");
        if (bl) {
            throw new MultiPartInitException(iWorkbenchPartReferenceArray, partInitExceptionArray);
        }
        return iWorkbenchPartReferenceArray;
    }

    private IEditorReference batchReuseEditor(IEditorInput iEditorInput, String string, boolean bl, int n) {
        if ("org.eclipse.ui.systemExternalEditor".equals(string)) {
            return null;
        }
        int n2 = ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).getReuseEditorMatchFlags(n);
        IEditorReference[] iEditorReferenceArray = this.getEditorManager().findEditors(iEditorInput, string, n2);
        if (iEditorReferenceArray.length == 0) {
            return null;
        }
        IEditorPart iEditorPart = iEditorReferenceArray[0].getEditor(bl);
        if (iEditorPart != null && bl) {
            if (iEditorPart instanceof IShowEditorInput) {
                ((IShowEditorInput)((Object)iEditorPart)).showEditorInput(iEditorInput);
            }
            this.showEditor(bl, iEditorPart);
        }
        return iEditorReferenceArray[0];
    }

    private IEditorReference batchOpenEditor(IEditorInput iEditorInput, String string, boolean bl) throws PartInitException {
        IEditorReference iEditorReference;
        IEditorPart iEditorPart = null;
        try {
            this.partBeingOpened = true;
            iEditorReference = this.getEditorManager().openEditor(string, iEditorInput, true, null);
            if (iEditorReference != null) {
                iEditorPart = iEditorReference.getEditor(bl);
            }
        }
        finally {
            this.partBeingOpened = false;
        }
        if (iEditorPart != null) {
            this.setEditorAreaVisible(true);
            if (bl) {
                if (iEditorPart instanceof AbstractMultiEditor) {
                    this.activate(((AbstractMultiEditor)iEditorPart).getActiveEditor());
                } else {
                    this.activate(iEditorPart);
                }
            } else {
                this.bringToTop(iEditorPart);
            }
        }
        return iEditorReference;
    }

    public void resetHiddenEditors() {
        IEditorReference[] iEditorReferenceArray = this.removedEditors.toArray(new IEditorReference[this.removedEditors.size()]);
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            this.showEditor(iEditorReferenceArray[n]);
            ++n;
        }
    }

    private class ActionSwitcher {
        private IWorkbenchPart activePart;
        private IEditorPart topEditor;
        private ArrayList oldActionSets = new ArrayList();

        private ActionSwitcher() {
        }

        public void updateActivePart(IWorkbenchPart iWorkbenchPart) {
            Object object;
            if (this.activePart == iWorkbenchPart) {
                return;
            }
            boolean bl = iWorkbenchPart instanceof IEditorPart;
            if (bl) {
                object = null;
                if (this.topEditor != null) {
                    object = this.topEditor.getSite().getId();
                }
                String string = iWorkbenchPart.getSite().getId();
                if (this.activePart == this.topEditor && string.equals(object)) {
                    this.activePart = iWorkbenchPart;
                    this.topEditor = (IEditorPart)iWorkbenchPart;
                    return;
                }
                if (object != null && !((String)object).equals(string)) {
                    this.deactivateContributions(this.topEditor, true);
                }
                if (this.activePart != null && this.activePart != this.topEditor) {
                    this.deactivateContributions(this.activePart, true);
                }
                if (!string.equals(object) || this.activePart != this.topEditor) {
                    this.activateContributions(iWorkbenchPart, true);
                }
            } else if (iWorkbenchPart == null) {
                if (this.activePart != null) {
                    this.deactivateContributions(this.activePart, true);
                }
            } else {
                if (this.activePart != null) {
                    this.deactivateContributions(this.activePart, this.activePart instanceof IViewPart);
                }
                this.activateContributions(iWorkbenchPart, true);
            }
            object = null;
            object = bl || this.activePart == this.topEditor && iWorkbenchPart == null ? this.calculateActionSets(iWorkbenchPart, null) : this.calculateActionSets(iWorkbenchPart, this.topEditor);
            if (!this.updateActionSets((ArrayList)object)) {
                WorkbenchPage.this.updateActionBars();
            }
            if (bl) {
                this.topEditor = (IEditorPart)iWorkbenchPart;
            } else if (this.activePart == this.topEditor && iWorkbenchPart == null) {
                this.topEditor = null;
            }
            this.activePart = iWorkbenchPart;
        }

        public void updateTopEditor(IEditorPart iEditorPart) {
            ArrayList arrayList;
            if (this.topEditor == iEditorPart) {
                return;
            }
            if (this.activePart == this.topEditor) {
                this.updateActivePart(iEditorPart);
                return;
            }
            String string = null;
            if (this.topEditor != null) {
                string = this.topEditor.getSite().getId();
            }
            String string2 = null;
            if (iEditorPart != null) {
                string2 = iEditorPart.getSite().getId();
            }
            if (string == null ? string2 == null : string.equals(string2)) {
                this.topEditor = iEditorPart;
                return;
            }
            if (this.topEditor != null) {
                this.deactivateContributions(this.topEditor, true);
            }
            if (iEditorPart != null) {
                this.activateContributions(iEditorPart, false);
            }
            if (!this.updateActionSets(arrayList = this.calculateActionSets(this.activePart, iEditorPart))) {
                WorkbenchPage.this.updateActionBars();
            }
            this.topEditor = iEditorPart;
        }

        private void activateContributions(IWorkbenchPart iWorkbenchPart, boolean bl) {
            PartSite partSite = (PartSite)iWorkbenchPart.getSite();
            partSite.activateActionBars(bl);
        }

        private void deactivateContributions(IWorkbenchPart iWorkbenchPart, boolean bl) {
            PartSite partSite = (PartSite)iWorkbenchPart.getSite();
            partSite.deactivateActionBars(bl);
        }

        private ArrayList calculateActionSets(IWorkbenchPart iWorkbenchPart, IEditorPart iEditorPart) {
            int n;
            IActionSetDescriptor[] iActionSetDescriptorArray;
            ArrayList<IActionSetDescriptor> arrayList = new ArrayList<IActionSetDescriptor>();
            if (iWorkbenchPart != null) {
                iActionSetDescriptorArray = WorkbenchPlugin.getDefault().getActionSetRegistry().getActionSetsFor(iWorkbenchPart.getSite().getId());
                n = 0;
                while (n < iActionSetDescriptorArray.length) {
                    arrayList.add(iActionSetDescriptorArray[n]);
                    ++n;
                }
            }
            if (iEditorPart != null && iEditorPart != iWorkbenchPart) {
                iActionSetDescriptorArray = WorkbenchPlugin.getDefault().getActionSetRegistry().getActionSetsFor(iEditorPart.getSite().getId());
                n = 0;
                while (n < iActionSetDescriptorArray.length) {
                    arrayList.add(iActionSetDescriptorArray[n]);
                    ++n;
                }
            }
            return arrayList;
        }

        private boolean updateActionSets(ArrayList arrayList) {
            if (this.oldActionSets.equals(arrayList)) {
                return false;
            }
            IContextService iContextService = (IContextService)WorkbenchPage.this.window.getService(IContextService.class);
            try {
                iContextService.deferUpdates(true);
                int n = 0;
                while (n < arrayList.size()) {
                    WorkbenchPage.this.actionSets.showAction((IActionSetDescriptor)arrayList.get(n));
                    ++n;
                }
                n = 0;
                while (n < this.oldActionSets.size()) {
                    WorkbenchPage.this.actionSets.hideAction((IActionSetDescriptor)this.oldActionSets.get(n));
                    ++n;
                }
                this.oldActionSets = arrayList;
            }
            finally {
                iContextService.deferUpdates(false);
            }
            Perspective perspective = WorkbenchPage.this.getActivePerspective();
            if (perspective == null) {
                return false;
            }
            WorkbenchPage.this.window.updateActionSets();
            WorkbenchPage.this.window.firePerspectiveChanged(WorkbenchPage.this, WorkbenchPage.this.getPerspective(), "actionSetShow");
            return true;
        }
    }

    private class ActivationList {
        List parts = new ArrayList();

        private ActivationList() {
        }

        void setActive(IWorkbenchPart iWorkbenchPart) {
            if (this.parts.size() <= 0) {
                return;
            }
            IWorkbenchPartReference iWorkbenchPartReference = WorkbenchPage.this.getReference(iWorkbenchPart);
            if (iWorkbenchPartReference != null) {
                if (iWorkbenchPartReference == this.parts.get(this.parts.size() - 1)) {
                    return;
                }
                this.parts.remove(iWorkbenchPartReference);
                this.parts.add(iWorkbenchPartReference);
            }
        }

        void bringToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            ILayoutContainer iLayoutContainer = WorkbenchPage.this.getContainer(iWorkbenchPartReference);
            int n = this.lastIndexOfContainer(iLayoutContainer);
            if (n >= 0 && iWorkbenchPartReference == this.parts.get(n)) {
                return;
            }
            this.parts.remove(iWorkbenchPartReference);
            if (n >= 0) {
                this.parts.add(n, iWorkbenchPartReference);
            } else {
                this.parts.add(iWorkbenchPartReference);
            }
        }

        int lastIndexOfContainer(ILayoutContainer iLayoutContainer) {
            int n = this.parts.size() - 1;
            while (n >= 0) {
                IWorkbenchPartReference iWorkbenchPartReference = (IWorkbenchPartReference)this.parts.get(n);
                ILayoutContainer iLayoutContainer2 = WorkbenchPage.this.getContainer(iWorkbenchPartReference);
                if (iLayoutContainer2 == iLayoutContainer) {
                    return n;
                }
                --n;
            }
            return -1;
        }

        void setActive(IWorkbenchPartReference iWorkbenchPartReference) {
            this.setActive(iWorkbenchPartReference.getPart(true));
        }

        void add(IWorkbenchPartReference iWorkbenchPartReference) {
            PartPane partPane;
            if (this.parts.indexOf(iWorkbenchPartReference) >= 0) {
                return;
            }
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
            if (iWorkbenchPart != null && (partPane = ((PartSite)iWorkbenchPart.getSite()).getPane()) instanceof MultiEditorInnerPane) {
                MultiEditorInnerPane multiEditorInnerPane = (MultiEditorInnerPane)partPane;
                this.add(multiEditorInnerPane.getParentPane().getPartReference());
                return;
            }
            this.parts.add(0, iWorkbenchPartReference);
        }

        IWorkbenchPart getPreviouslyActive() {
            if (this.parts.size() < 2) {
                return null;
            }
            return this.getActive(this.parts.size() - 2);
        }

        private IWorkbenchPart getActive(int n) {
            IWorkbenchPartReference iWorkbenchPartReference = this.getActiveReference(n, false);
            if (iWorkbenchPartReference == null) {
                return null;
            }
            return iWorkbenchPartReference.getPart(true);
        }

        public IWorkbenchPartReference getActiveReference(boolean bl) {
            return this.getActiveReference(this.parts.size() - 1, bl);
        }

        private IWorkbenchPartReference getActiveReference(int n, boolean bl) {
            IWorkbenchPartReference iWorkbenchPartReference = this.getActiveReference(n, bl, true);
            if (iWorkbenchPartReference != null) {
                return iWorkbenchPartReference;
            }
            return this.getActiveReference(n, bl, false);
        }

        private IWorkbenchPartReference getActiveReference(int n, boolean bl, boolean bl2) {
            IViewReference[] iViewReferenceArray = WorkbenchPage.this.getViewReferences();
            int n2 = n;
            while (n2 >= 0) {
                PartPane partPane;
                WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)this.parts.get(n2);
                if (!(bl && !(workbenchPartReference instanceof IEditorReference) || (partPane = workbenchPartReference.getPane()) != null && (!partPane.allowsAutoFocus() || bl2 && partPane.isObscuredByZoom()))) {
                    if (workbenchPartReference instanceof IViewReference) {
                        if (workbenchPartReference == WorkbenchPage.this.getActiveFastView() || !((IViewReference)((Object)workbenchPartReference)).isFastView()) {
                            int n3 = 0;
                            while (n3 < iViewReferenceArray.length) {
                                if (iViewReferenceArray[n3] == workbenchPartReference) {
                                    return workbenchPartReference;
                                }
                                ++n3;
                            }
                        }
                    } else {
                        return workbenchPartReference;
                    }
                }
                --n2;
            }
            return null;
        }

        int indexOf(IWorkbenchPartReference iWorkbenchPartReference) {
            return this.parts.indexOf(iWorkbenchPartReference);
        }

        boolean remove(IWorkbenchPartReference iWorkbenchPartReference) {
            return this.parts.remove(iWorkbenchPartReference);
        }

        private IEditorReference[] getEditors() {
            ArrayList<IWorkbenchPartReference> arrayList = new ArrayList<IWorkbenchPartReference>(this.parts.size());
            for (IWorkbenchPartReference iWorkbenchPartReference : this.parts) {
                if (!(iWorkbenchPartReference instanceof IEditorReference)) continue;
                arrayList.add(iWorkbenchPartReference);
            }
            return arrayList.toArray(new IEditorReference[arrayList.size()]);
        }

        private IWorkbenchPartReference[] getParts() {
            IViewReference[] iViewReferenceArray = WorkbenchPage.this.getViewReferences();
            ArrayList<IWorkbenchPartReference> arrayList = new ArrayList<IWorkbenchPartReference>(this.parts.size());
            block0: for (IWorkbenchPartReference iWorkbenchPartReference : this.parts) {
                if (iWorkbenchPartReference instanceof IViewReference) {
                    int n = 0;
                    while (n < iViewReferenceArray.length) {
                        if (iViewReferenceArray[n] == iWorkbenchPartReference) {
                            arrayList.add(iWorkbenchPartReference);
                            continue block0;
                        }
                        ++n;
                    }
                    continue;
                }
                arrayList.add(iWorkbenchPartReference);
            }
            IWorkbenchPartReference[] iWorkbenchPartReferenceArray = new IWorkbenchPartReference[arrayList.size()];
            return arrayList.toArray(iWorkbenchPartReferenceArray);
        }
    }

    class MnemonicDisabler
    implements Listener {
        private final Composite root;
        private boolean enabled = false;

        public MnemonicDisabler(Composite composite) {
            this.root = composite;
            composite.getShell().addListener(26, (Listener)this);
            composite.getShell().addListener(27, (Listener)this);
            composite.addListener(12, (Listener)this);
            composite.getDisplay().addFilter(31, (Listener)this);
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    this.enabled = true;
                    break;
                }
                case 12: {
                    this.root.getDisplay().removeFilter(31, (Listener)this);
                    this.root.getShell().removeListener(26, (Listener)this);
                    this.root.getShell().removeListener(27, (Listener)this);
                }
                case 27: {
                    this.enabled = false;
                    break;
                }
                case 31: {
                    if (!this.enabled) {
                        return;
                    }
                    this.handleTraverse(event);
                }
            }
        }

        private void handleTraverse(Event event) {
            if (event.detail != 128 || !event.doit) {
                return;
            }
            Control control = (Control)event.widget;
            ArrayList<Control> arrayList = new ArrayList<Control>();
            arrayList.add(((PartSite)WorkbenchPage.this.getActivePart().getSite()).getPane().getControl());
            IWorkbenchPartReference[] iWorkbenchPartReferenceArray = WorkbenchPage.this.getSortedParts();
            ArrayList<Control> arrayList2 = new ArrayList<Control>();
            int n = 0;
            while (n < iWorkbenchPartReferenceArray.length) {
                IWorkbenchPartReference iWorkbenchPartReference = iWorkbenchPartReferenceArray[n];
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                if (iWorkbenchPart != null && WorkbenchPage.this.isPartVisible(iWorkbenchPart)) {
                    arrayList2.add(((PartSite)iWorkbenchPart.getSite()).getPane().getControl());
                }
                ++n;
            }
            arrayList2.removeAll(arrayList);
            while (control != null) {
                if (arrayList.contains(control)) {
                    return;
                }
                if (arrayList2.contains(control)) {
                    event.doit = false;
                    return;
                }
                control = control.getParent();
            }
        }
    }

    private class PerspectiveList {
        private List openedList = new ArrayList();
        private List usedList = new ArrayList();
        private Perspective active;

        public void reorder(IPerspectiveDescriptor iPerspectiveDescriptor, int n) {
            int n2 = 0;
            Perspective perspective = null;
            for (Perspective perspective2 : this.openedList) {
                if (!perspective2.getDesc().equals(iPerspectiveDescriptor)) continue;
                n2 = this.openedList.indexOf(perspective2);
                perspective = perspective2;
            }
            if (n2 == n) {
                return;
            }
            this.openedList.remove(n2);
            this.openedList.add(n, perspective);
        }

        public Perspective[] getSortedPerspectives() {
            Perspective[] perspectiveArray = new Perspective[this.usedList.size()];
            return this.usedList.toArray(perspectiveArray);
        }

        public boolean add(Perspective perspective) {
            this.openedList.add(perspective);
            this.usedList.add(0, perspective);
            return true;
        }

        public Iterator iterator() {
            return this.openedList.iterator();
        }

        public Perspective[] getOpenedPerspectives() {
            Perspective[] perspectiveArray = new Perspective[this.openedList.size()];
            return this.openedList.toArray(perspectiveArray);
        }

        public boolean remove(Perspective perspective) {
            if (this.active == perspective) {
                this.updateActionSets(this.active, null);
                this.active = null;
            }
            this.usedList.remove(perspective);
            return this.openedList.remove(perspective);
        }

        public void swap(Perspective perspective, Perspective perspective2) {
            int n = this.openedList.indexOf(perspective);
            int n2 = this.openedList.indexOf(perspective2);
            if (n < 0 || n2 < 0) {
                return;
            }
            this.openedList.set(n, perspective2);
            this.openedList.set(n2, perspective);
        }

        public boolean isEmpty() {
            return this.openedList.isEmpty();
        }

        public Perspective getActive() {
            return this.active;
        }

        public Perspective getNextActive() {
            if (this.active == null) {
                if (this.usedList.isEmpty()) {
                    return null;
                }
                return (Perspective)this.usedList.get(this.usedList.size() - 1);
            }
            if (this.usedList.size() < 2) {
                return null;
            }
            return (Perspective)this.usedList.get(this.usedList.size() - 2);
        }

        public int size() {
            return this.openedList.size();
        }

        public void setActive(Perspective perspective) {
            if (perspective == this.active) {
                return;
            }
            this.updateActionSets(this.active, perspective);
            this.active = perspective;
            if (perspective != null) {
                this.usedList.remove(perspective);
                this.usedList.add(perspective);
            }
        }

        private void updateActionSets(Perspective perspective, Perspective perspective2) {
            IContextService iContextService = (IContextService)WorkbenchPage.this.window.getService(IContextService.class);
            try {
                IActionSetDescriptor iActionSetDescriptor;
                IActionSetDescriptor[] iActionSetDescriptorArray;
                iContextService.deferUpdates(true);
                if (perspective2 != null) {
                    iActionSetDescriptorArray = perspective2.getAlwaysOnActionSets();
                    int n = 0;
                    while (n < iActionSetDescriptorArray.length) {
                        IActionSetDescriptor iActionSetDescriptor2 = iActionSetDescriptorArray[n];
                        WorkbenchPage.this.actionSets.showAction(iActionSetDescriptor2);
                        ++n;
                    }
                    IActionSetDescriptor[] iActionSetDescriptorArray2 = perspective2.getAlwaysOffActionSets();
                    int n2 = 0;
                    while (n2 < iActionSetDescriptorArray2.length) {
                        iActionSetDescriptor = iActionSetDescriptorArray2[n2];
                        WorkbenchPage.this.actionSets.maskAction(iActionSetDescriptor);
                        ++n2;
                    }
                }
                if (perspective != null) {
                    iActionSetDescriptorArray = perspective.getAlwaysOnActionSets();
                    int n = 0;
                    while (n < iActionSetDescriptorArray.length) {
                        IActionSetDescriptor iActionSetDescriptor3 = iActionSetDescriptorArray[n];
                        WorkbenchPage.this.actionSets.hideAction(iActionSetDescriptor3);
                        ++n;
                    }
                    IActionSetDescriptor[] iActionSetDescriptorArray3 = perspective.getAlwaysOffActionSets();
                    int n3 = 0;
                    while (n3 < iActionSetDescriptorArray3.length) {
                        iActionSetDescriptor = iActionSetDescriptorArray3[n3];
                        WorkbenchPage.this.actionSets.unmaskAction(iActionSetDescriptor);
                        ++n3;
                    }
                }
            }
            finally {
                iContextService.deferUpdates(false);
            }
        }
    }

    private class SashInfo {
        private LayoutPartSash right;
        private LayoutPartSash left;
        private LayoutPartSash top;
        private LayoutPartSash bottom;
        private LayoutTreeNode rightNode;
        private LayoutTreeNode leftNode;
        private LayoutTreeNode topNode;
        private LayoutTreeNode bottomNode;

        private SashInfo() {
        }
    }
}

