/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.preferences.WorkbenchSettingsTransfer;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.presentations.AbstractPresentationFactory;

public class WorkbenchLayoutSettingsTransfer
extends WorkbenchSettingsTransfer {
    public XMLMemento recordSharableWorkbenchState() {
        XMLMemento xMLMemento = XMLMemento.createWriteRoot("workbench");
        IStatus iStatus = this.saveSettings(xMLMemento);
        if (iStatus.getSeverity() != 0) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.Workbench_problemsSaving, (String)WorkbenchMessages.Workbench_problemsSavingMsg, (IStatus)iStatus);
        }
        return xMLMemento;
    }

    private IStatus saveSettings(XMLMemento xMLMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Workbench_problemsSaving, null);
        xMLMemento.putString("version", Workbench.VERSION_STRING[1]);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n];
            IMemento iMemento = xMLMemento.createChild("window");
            multiStatus.merge(this.saveState(workbenchWindow, iMemento));
            ++n;
        }
        return multiStatus;
    }

    private IStatus saveState(WorkbenchWindow workbenchWindow, IMemento iMemento) {
        int n;
        Object object;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.WorkbenchWindow_problemsSavingWindow, null);
        IWorkbenchPage iWorkbenchPage = workbenchWindow.getActivePage();
        if (iWorkbenchPage != null && iWorkbenchPage.findView("org.eclipse.ui.internal.introview") != null) {
            object = iMemento.createChild("intro");
            n = this.getWorkbench().getIntroManager().isIntroStandby(this.getWorkbench().getIntroManager().getIntro()) ? 1 : 0;
            object.putString("standby", String.valueOf(n != 0));
        }
        object = workbenchWindow.getPages();
        n = 0;
        while (n < ((IWorkbenchPage[])object).length) {
            IAdaptable iAdaptable;
            IWorkbenchPage iWorkbenchPage2 = object[n];
            IMemento iMemento2 = iMemento.createChild("page");
            iMemento2.putString("label", iWorkbenchPage2.getLabel());
            multiStatus.add(this.saveState((WorkbenchPage)iWorkbenchPage2, iMemento2));
            if (iWorkbenchPage2 == workbenchWindow.getActivePage()) {
                iMemento2.putString("focus", "true");
            }
            if ((iAdaptable = iWorkbenchPage2.getInput()) != null) {
                IPersistableElement iPersistableElement = (IPersistableElement)Util.getAdapter(iAdaptable, IPersistableElement.class);
                if (iPersistableElement == null) {
                    WorkbenchPlugin.log("Unable to save page input: " + iAdaptable + ", because it does not adapt to IPersistableElement");
                } else {
                    IMemento iMemento3 = iMemento2.createChild("input");
                    iMemento3.putString("factoryID", iPersistableElement.getFactoryId());
                    iPersistableElement.saveState(iMemento3);
                }
            }
            ++n;
        }
        return multiStatus;
    }

    private IStatus saveState(WorkbenchPage workbenchPage, IMemento iMemento) {
        Object object;
        Object object2;
        Object object3;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.WorkbenchPage_unableToSavePerspective, (Object)workbenchPage.getLabel()), null);
        this.saveEditorState(iMemento);
        IMemento iMemento2 = iMemento.createChild("views");
        IViewReference[] iViewReferenceArray = workbenchPage.getViewReferences();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            object3 = iViewReferenceArray[n];
            String string = ViewFactory.getKey((IViewReference)object3);
            if (string != null) {
                object2 = iMemento2.createChild("view");
                object2.putString("id", string);
                object = object3.getPartName();
                if (object != null) {
                    object2.putString("partName", (String)object);
                }
            }
            ++n;
        }
        IMemento iMemento3 = iMemento.createChild("perspectives");
        if (workbenchPage.getPerspective() != null) {
            iMemento3.putString("activePerspective", workbenchPage.getPerspective().getId());
        }
        if (workbenchPage.getActivePart() != null) {
            if (workbenchPage.getActivePart() instanceof IViewPart) {
                object3 = (IViewReference)workbenchPage.getReference(workbenchPage.getActivePart());
                if (object3 != null) {
                    iMemento3.putString("activePart", ViewFactory.getKey((IViewReference)object3));
                }
            } else {
                iMemento3.putString("activePart", workbenchPage.getActivePart().getSite().getId());
            }
        }
        object3 = workbenchPage.getOpenPerspectives();
        int n2 = 0;
        while (n2 < ((IPerspectiveDescriptor[])object3).length) {
            object2 = object3[n2];
            object = iMemento3.createChild("perspective");
            Perspective perspective = workbenchPage.findPerspective((IPerspectiveDescriptor)object2);
            perspective.saveState((IMemento)object);
            ++n2;
        }
        return multiStatus;
    }

    private void saveEditorState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.createChild("editors");
        IMemento iMemento3 = iMemento2.createChild("editorArea");
        iMemento3.putString("activeWorkbook", "DefaultEditorWorkbook");
        IMemento iMemento4 = iMemento3.createChild("info");
        iMemento4.putString("part", "DefaultEditorWorkbook");
        IMemento iMemento5 = iMemento4.createChild("folder");
        iMemento5.putInteger("appearance", 1);
        iMemento5.putInteger("expanded", 2);
        IMemento iMemento6 = iMemento5.createChild("presentation");
        iMemento6.putString("id", this.getCurrentPresentationClassName());
    }

    private String getCurrentPresentationClassName() {
        String string = PrefUtil.getAPIPreferenceStore().getString("presentationFactoryId");
        AbstractPresentationFactory abstractPresentationFactory = WorkbenchPlugin.getDefault().getPresentationFactory(string);
        if (abstractPresentationFactory == null) {
            abstractPresentationFactory = WorkbenchPlugin.getDefault().getPresentationFactory("org.eclipse.ui.presentations.default");
        }
        return abstractPresentationFactory.getClass().getName();
    }

    private IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    @Override
    public IStatus transferSettings(IPath iPath) {
        try {
            File file = this.createFileAndDirectories(iPath);
            if (file == null) {
                return new Status(4, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.WorkbenchSettings_CouldNotCreateDirectories);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            XMLMemento xMLMemento = XMLMemento.createWriteRoot("workbench");
            IStatus iStatus = this.saveSettings(xMLMemento);
            if (iStatus.getSeverity() != 0) {
                return iStatus;
            }
            xMLMemento.save(outputStreamWriter);
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            return new Status(4, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.Workbench_problemsSavingMsg, (Throwable)iOException);
        }
        return Status.OK_STATUS;
    }

    private File createFileAndDirectories(IPath iPath) {
        IPath iPath2 = this.getNewWorkbenchStateLocation(iPath).append("workbench.xml");
        File file = new File(iPath2.toOSString());
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            return null;
        }
        return file;
    }

    @Override
    public String getName() {
        return WorkbenchMessages.WorkbenchLayoutSettings_Name;
    }
}

