/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.TrimArea;
import org.eclipse.ui.internal.TrimLayoutData;
import org.eclipse.ui.internal.layout.TrimCommonUIHandle;

public class WorkbenchLayout
extends Layout {
    private static int defaultMargin = 5;
    public static final String TRIMID_CMD_PRIMARY = "Command Primary";
    public static final String TRIMID_CMD_SECONDARY = "Command Secondary";
    public static final String TRIMID_VERTICAL1 = "vertical1";
    public static final String TRIMID_VERTICAL2 = "vertical2";
    public static final String TRIMID_STATUS = "Status";
    public static final String TRIMID_CENTER = "Center";
    public CBanner banner;
    private int topMax;
    public Composite centerComposite;
    private int spacing = 0;
    private TrimArea cmdPrimaryTrimArea = new TrimArea("Command Primary", 128, defaultMargin);
    private TrimArea cmdSecondaryTrimArea = new TrimArea("Command Secondary", 128, defaultMargin);
    private TrimArea leftTrimArea = new TrimArea("vertical1", 16384, defaultMargin);
    private TrimArea rightTrimArea = new TrimArea("vertical2", 131072, defaultMargin);
    private TrimArea bottomTrimArea = new TrimArea("Status", 1024, defaultMargin);
    private int horizontalHandleSize = -1;
    private int verticalHandleSize = -1;
    private List dragHandles = new ArrayList();
    private static Composite layoutComposite;
    private static Rectangle clientRect;

    public void createCBanner(Composite composite) {
        this.banner = new CBanner(composite, 0);
        this.banner.setSimple(false);
        this.banner.setRightWidth(175);
        this.banner.setLocation(0, 0);
        Composite composite2 = new Composite((Composite)this.banner, 0){

            public Point computeSize(int n, int n2, boolean bl) {
                if (layoutComposite != null) {
                    return WorkbenchLayout.this.computeSize(WorkbenchLayout.TRIMID_CMD_PRIMARY, n);
                }
                return super.computeSize(n, n2, bl);
            }
        };
        composite2.setLayout((Layout)new LeftBannerLayout());
        composite2.setBackground(composite.getDisplay().getSystemColor(10));
        this.banner.setLeft((Control)composite2);
        Composite composite3 = new Composite((Composite)this.banner, 0){

            public Point computeSize(int n, int n2, boolean bl) {
                if (layoutComposite != null) {
                    return WorkbenchLayout.this.computeSize(WorkbenchLayout.TRIMID_CMD_SECONDARY, n);
                }
                return super.computeSize(n, n2, bl);
            }
        };
        composite3.setBackground(composite.getDisplay().getSystemColor(10));
        this.banner.setRight((Control)composite3);
        composite3.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                Composite composite = (Composite)controlEvent.widget;
                composite.getShell().layout(true);
            }
        });
        this.banner.moveBelow(null);
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Point point = new Point(n, n2);
        if (point.x == -1) {
            point.x = 300;
        }
        if (point.y == -1) {
            point.y = 300;
        }
        return point;
    }

    protected void layout(Composite composite, boolean bl) {
        Point point;
        Point point2;
        Point point3;
        layoutComposite = composite;
        clientRect = composite.getClientArea();
        this.resetDragHandles();
        if (this.useCBanner()) {
            this.banner.moveBelow(null);
            point3 = this.banner.computeSize(WorkbenchLayout.clientRect.width, -1);
            this.topMax = point3.y;
            this.banner.setSize(point3);
        } else {
            point3 = this.computeSize(TRIMID_CMD_PRIMARY, WorkbenchLayout.clientRect.width);
            point2 = this.computeSize(TRIMID_CMD_SECONDARY, WorkbenchLayout.clientRect.width);
            this.topMax = point3.y + point2.y;
        }
        point3 = this.computeSize(TRIMID_VERTICAL1, WorkbenchLayout.clientRect.height - this.topMax);
        point2 = this.computeSize(TRIMID_VERTICAL2, WorkbenchLayout.clientRect.height - this.topMax);
        this.computeSize(TRIMID_STATUS, WorkbenchLayout.clientRect.width - (point3.x + point2.x));
        if (this.useCBanner()) {
            point = this.banner.getLeft().getLocation();
            this.cmdPrimaryTrimArea.areaBounds.x = point.x;
            this.cmdPrimaryTrimArea.areaBounds.y = point.y;
        } else {
            this.cmdPrimaryTrimArea.areaBounds.x = 0;
            this.cmdPrimaryTrimArea.areaBounds.y = 0;
        }
        this.layoutTrim(this.cmdPrimaryTrimArea, this.cmdPrimaryTrimArea.areaBounds);
        if (this.useCBanner()) {
            point = this.banner.getRight().getLocation();
            this.cmdSecondaryTrimArea.areaBounds.x = point.x;
            this.cmdSecondaryTrimArea.areaBounds.y = point.y;
        } else {
            this.cmdSecondaryTrimArea.areaBounds.x = 0;
            this.cmdSecondaryTrimArea.areaBounds.y = this.cmdPrimaryTrimArea.areaBounds.height;
        }
        this.layoutTrim(this.cmdSecondaryTrimArea, this.cmdSecondaryTrimArea.areaBounds);
        this.leftTrimArea.areaBounds.x = 0;
        this.leftTrimArea.areaBounds.y = this.topMax;
        this.layoutTrim(this.leftTrimArea, this.leftTrimArea.areaBounds);
        this.rightTrimArea.areaBounds.x = WorkbenchLayout.clientRect.width - this.rightTrimArea.areaBounds.width;
        this.rightTrimArea.areaBounds.y = this.topMax;
        this.layoutTrim(this.rightTrimArea, this.rightTrimArea.areaBounds);
        this.bottomTrimArea.areaBounds.x = this.leftTrimArea.areaBounds.width;
        this.bottomTrimArea.areaBounds.y = WorkbenchLayout.clientRect.height - this.bottomTrimArea.areaBounds.height;
        this.layoutTrim(this.bottomTrimArea, this.bottomTrimArea.areaBounds);
        this.layoutCenter();
    }

    private boolean useCBanner() {
        return this.banner != null && this.banner.getVisible();
    }

    private TrimArea getTrimArea(String string) {
        if (TRIMID_CMD_PRIMARY.equals(string)) {
            return this.cmdPrimaryTrimArea;
        }
        if (TRIMID_CMD_SECONDARY.equals(string)) {
            return this.cmdSecondaryTrimArea;
        }
        if (TRIMID_VERTICAL1.equals(string)) {
            return this.leftTrimArea;
        }
        if (TRIMID_VERTICAL2.equals(string)) {
            return this.rightTrimArea;
        }
        if (TRIMID_STATUS.equals(string)) {
            return this.bottomTrimArea;
        }
        return null;
    }

    private List getTrimContents(String string) {
        ArrayList<Control> arrayList = new ArrayList<Control>();
        Control[] controlArray = layoutComposite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (!controlArray[n].isDisposed() && controlArray[n].getVisible() && controlArray[n].getLayoutData() instanceof TrimLayoutData) {
                TrimLayoutData trimLayoutData = (TrimLayoutData)controlArray[n].getLayoutData();
                if (trimLayoutData.areaId.equals(string)) {
                    arrayList.add(controlArray[n]);
                }
            }
            ++n;
        }
        return arrayList;
    }

    private void layoutCenter() {
        if (this.centerComposite != null) {
            Rectangle rectangle = new Rectangle(this.leftTrimArea.areaBounds.x + this.leftTrimArea.areaBounds.width, this.topMax, WorkbenchLayout.clientRect.width - (this.leftTrimArea.areaBounds.width + this.rightTrimArea.areaBounds.width), WorkbenchLayout.clientRect.height - (this.topMax + this.bottomTrimArea.areaBounds.height));
            this.centerComposite.setBounds(rectangle);
        }
    }

    private Point computeSize(String string, int n) {
        TrimArea trimArea = this.getTrimArea(string);
        boolean bl = trimArea.orientation == 128 || trimArea.orientation == 1024;
        trimArea.trimContents = this.getTrimContents(trimArea.areaId);
        trimArea.trimLines = this.computeWrappedTrim(trimArea, n);
        int n2 = 0;
        for (TrimLine trimLine : trimArea.trimLines) {
            n2 += trimLine.minorMax;
        }
        n2 = Math.max(n2, trimArea.defaultMinor);
        Point point = new Point(0, 0);
        if (bl) {
            point.x = trimArea.areaBounds.width = n;
            point.y = trimArea.areaBounds.height = n2;
        } else {
            point.x = trimArea.areaBounds.width = n2;
            point.y = trimArea.areaBounds.height = n;
        }
        return point;
    }

    private List computeWrappedTrim(TrimArea trimArea, int n) {
        boolean bl = trimArea.orientation == 128 || trimArea.orientation == 1024;
        ArrayList<TrimLine> arrayList = new ArrayList<TrimLine>();
        TrimLine trimLine = new TrimLine();
        arrayList.add(trimLine);
        trimLine.minorMax = trimArea.defaultMinor;
        int n2 = 0;
        for (Control control : trimArea.trimContents) {
            int n3;
            int n4;
            TrimLayoutData trimLayoutData = (TrimLayoutData)control.getLayoutData();
            Point point = bl ? control.computeSize(-1, -1) : control.computeSize(-1, n);
            int n5 = n4 = bl ? point.x : point.y;
            if (trimLine.controls.size() > 0) {
                n4 += this.spacing;
            }
            if (trimLayoutData.listener != null) {
                n4 += bl ? this.horizontalHandleSize : this.verticalHandleSize;
            }
            if (n2 + n4 <= n || trimLine.controls.size() == 0) {
                trimLine.controls.add(control);
                int n6 = n3 = bl ? point.y : point.x;
                if (n3 > trimLine.minorMax) {
                    trimLine.minorMax = n3;
                }
                n2 += n4;
            } else {
                trimLine.extraSpace = n - n2;
                trimLine = new TrimLine();
                arrayList.add(trimLine);
                trimLine.controls.add(control);
                int n7 = n3 = bl ? point.y : point.x;
                if (n3 > trimLine.minorMax) {
                    trimLine.minorMax = n3;
                }
                n2 = n4;
            }
            if ((trimLayoutData.flags & 1) == 0) continue;
            ++trimLine.resizableCount;
        }
        trimLine.extraSpace = n - n2;
        return arrayList;
    }

    private void layoutTrim(TrimArea trimArea, Rectangle rectangle) {
        boolean bl = trimArea.orientation == 128 || trimArea.orientation == 1024;
        int n = bl ? rectangle.width : rectangle.height;
        List list = trimArea.trimLines;
        int n2 = bl ? rectangle.y : rectangle.x;
        for (TrimLine trimLine : list) {
            int n3 = 0;
            if (trimLine.resizableCount > 0 && trimLine.extraSpace > 0) {
                n3 = trimLine.extraSpace / trimLine.resizableCount;
            }
            int n4 = bl ? rectangle.x : rectangle.y;
            for (Control control : trimLine.controls) {
                int n5;
                TrimLayoutData trimLayoutData = (TrimLayoutData)control.getLayoutData();
                Point point = control.computeSize(-1, -1);
                int n6 = bl ? point.x : point.y;
                int n7 = n5 = bl ? point.y : point.x;
                if (n6 > n) {
                    n6 = n;
                }
                if ((trimLayoutData.flags & 4) != 0) {
                    n5 = trimLine.minorMax;
                }
                if ((trimLayoutData.flags & 1) != 0) {
                    n6 += n3;
                }
                if (trimLayoutData.listener != null && this.createHandles()) {
                    TrimCommonUIHandle trimCommonUIHandle = this.getDragHandle(trimArea.orientation);
                    if (bl) {
                        trimCommonUIHandle.setBounds(n4, n2, this.getHandleSize(true), trimLine.minorMax);
                    } else {
                        trimCommonUIHandle.setBounds(n2, n4, trimLine.minorMax, this.getHandleSize(false));
                    }
                    n4 += bl ? this.getHandleSize(true) : this.getHandleSize(false);
                }
                switch (trimArea.orientation) {
                    case 128: {
                        control.setBounds(n4, n2, n6, n5);
                        break;
                    }
                    case 16384: {
                        control.setBounds(n2, n4, n5, n6);
                        break;
                    }
                    case 131072: {
                        int n8 = n2 + trimLine.minorMax;
                        control.setBounds(n8 - n5, n4, n5, n6);
                        break;
                    }
                    case 1024: {
                        int n9 = n2 + trimLine.minorMax;
                        control.setBounds(n4, n9 - n5, n6, n5);
                    }
                }
                n4 += n6 + this.spacing;
            }
            n2 += trimLine.minorMax;
            int n10 = n4 = bl ? rectangle.x : rectangle.y;
        }
    }

    private boolean createHandles() {
        return false;
    }

    private void resetDragHandles() {
        Iterator iterator = this.dragHandles.iterator();
        while (iterator.hasNext()) {
        }
    }

    private TrimCommonUIHandle getDragHandle(int n) {
        Iterator iterator = this.dragHandles.iterator();
        if (iterator.hasNext()) {
            TrimCommonUIHandle trimCommonUIHandle = (TrimCommonUIHandle)((Object)iterator.next());
            return trimCommonUIHandle;
        }
        System.out.println("new Handle");
        return null;
    }

    public static int getOrientation(String string) {
        if (TRIMID_CMD_PRIMARY.equals(string)) {
            return 128;
        }
        if (TRIMID_CMD_SECONDARY.equals(string)) {
            return 128;
        }
        if (TRIMID_VERTICAL1.equals(string)) {
            return 16384;
        }
        if (TRIMID_VERTICAL2.equals(string)) {
            return 131072;
        }
        if (TRIMID_STATUS.equals(string)) {
            return 1024;
        }
        return 0;
    }

    private int getHandleSize(boolean bl) {
        int n;
        if (bl && this.horizontalHandleSize != -1) {
            return this.horizontalHandleSize;
        }
        if (!bl && this.verticalHandleSize != -1) {
            return this.verticalHandleSize;
        }
        CoolBar coolBar = new CoolBar(layoutComposite, bl ? 256 : 512);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Label label = new Label((Composite)coolBar, 8);
        label.setText("Button 1");
        Point point = label.computeSize(-1, -1);
        Point point2 = coolItem.computeSize(point.x, point.y);
        coolItem.setPreferredSize(point2);
        coolItem.setControl((Control)label);
        coolBar.pack();
        Point point3 = label.getLocation();
        Point point4 = coolBar.getLocation();
        label.dispose();
        coolItem.dispose();
        coolBar.dispose();
        if (bl) {
            this.horizontalHandleSize = n = point3.x - point4.x;
        } else {
            this.verticalHandleSize = n = point3.y - point4.y;
        }
        return n;
    }

    private class LeftBannerLayout
    extends Layout {
        private LeftBannerLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            return new Point(n, WorkbenchLayout.this.topMax);
        }

        protected void layout(Composite composite, boolean bl) {
        }
    }

    private class TrimLine {
        List controls = new ArrayList();
        int minorMax = 0;
        int resizableCount = 0;
        int extraSpace = 0;

        private TrimLine() {
        }
    }
}

