/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ViewIntroAdapterPart;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.intro.IntroDescriptor;
import org.eclipse.ui.internal.intro.IntroMessages;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IntroContentDetector;

public class WorkbenchIntroManager
implements IIntroManager {
    private final Workbench workbench;
    private IIntroPart introPart;

    WorkbenchIntroManager(Workbench workbench) {
        this.workbench = workbench;
        workbench.getExtensionTracker().registerHandler(new IExtensionChangeHandler(){

            public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
            }

            public void removeExtension(IExtension iExtension, Object[] objectArray) {
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof IIntroPart) {
                        WorkbenchIntroManager.this.closeIntro((IIntroPart)objectArray[n]);
                    }
                    ++n;
                }
            }
        }, null);
    }

    @Override
    public boolean closeIntro(IIntroPart iIntroPart) {
        if (this.introPart == null || !this.introPart.equals(iIntroPart)) {
            return false;
        }
        ViewIntroAdapterPart viewIntroAdapterPart = this.getViewIntroAdapterPart();
        if (viewIntroAdapterPart != null) {
            IWorkbenchPage iWorkbenchPage = viewIntroAdapterPart.getSite().getPage();
            IViewReference iViewReference = iWorkbenchPage.findViewReference("org.eclipse.ui.internal.introview");
            iWorkbenchPage.hideView(viewIntroAdapterPart);
            if (iViewReference == null || iViewReference.getPart(false) == null) {
                this.introPart = null;
                return true;
            }
            return false;
        }
        this.introPart = null;
        return true;
    }

    @Override
    public IIntroPart showIntro(IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        if (iWorkbenchWindow == null) {
            iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        }
        if (iWorkbenchWindow == null) {
            return null;
        }
        ViewIntroAdapterPart viewIntroAdapterPart = this.getViewIntroAdapterPart();
        if (viewIntroAdapterPart == null) {
            this.createIntro(iWorkbenchWindow);
        } else {
            try {
                IWorkbenchPage iWorkbenchPage = viewIntroAdapterPart.getSite().getPage();
                IWorkbenchWindow iWorkbenchWindow2 = iWorkbenchPage.getWorkbenchWindow();
                if (!iWorkbenchWindow2.equals(iWorkbenchWindow)) {
                    iWorkbenchWindow2.getShell().setActive();
                }
                iWorkbenchPage.showView("org.eclipse.ui.internal.introview");
            }
            catch (PartInitException partInitException) {
                WorkbenchPlugin.log("Could not open intro", (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "Could not open intro", (Throwable)((Object)partInitException)));
            }
        }
        this.setIntroStandby(this.introPart, bl);
        return this.introPart;
    }

    boolean isIntroInWindow(IWorkbenchWindow iWorkbenchWindow) {
        ViewIntroAdapterPart viewIntroAdapterPart = this.getViewIntroAdapterPart();
        if (viewIntroAdapterPart == null) {
            return false;
        }
        IWorkbenchWindow iWorkbenchWindow2 = viewIntroAdapterPart.getSite().getWorkbenchWindow();
        return iWorkbenchWindow2.equals(iWorkbenchWindow);
    }

    private void createIntro(IWorkbenchWindow iWorkbenchWindow) {
        if (this.workbench.getIntroDescriptor() == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        try {
            iWorkbenchPage.showView("org.eclipse.ui.internal.introview");
        }
        catch (PartInitException partInitException) {
            WorkbenchPlugin.log(IntroMessages.Intro_could_not_create_part, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, IntroMessages.Intro_could_not_create_part, (Throwable)((Object)partInitException)));
        }
    }

    @Override
    public void setIntroStandby(IIntroPart iIntroPart, boolean bl) {
        if (this.introPart == null || !this.introPart.equals(iIntroPart)) {
            return;
        }
        ViewIntroAdapterPart viewIntroAdapterPart = this.getViewIntroAdapterPart();
        if (viewIntroAdapterPart == null) {
            return;
        }
        PartPane partPane = ((PartSite)viewIntroAdapterPart.getSite()).getPane();
        if (bl == !partPane.isZoomed()) {
            viewIntroAdapterPart.setStandby(bl);
            return;
        }
        viewIntroAdapterPart.getSite().getPage().toggleZoom(partPane.getPartReference());
    }

    @Override
    public boolean isIntroStandby(IIntroPart iIntroPart) {
        IViewReference iViewReference;
        if (this.introPart == null || !this.introPart.equals(iIntroPart)) {
            return false;
        }
        ViewIntroAdapterPart viewIntroAdapterPart = this.getViewIntroAdapterPart();
        if (viewIntroAdapterPart == null) {
            return false;
        }
        WorkbenchPage workbenchPage = (WorkbenchPage)viewIntroAdapterPart.getSite().getPage();
        if (workbenchPage.isFastView(iViewReference = workbenchPage.findViewReference("org.eclipse.ui.internal.introview"))) {
            return true;
        }
        return !((PartSite)viewIntroAdapterPart.getSite()).getPane().isZoomed();
    }

    @Override
    public IIntroPart getIntro() {
        return this.introPart;
    }

    ViewIntroAdapterPart getViewIntroAdapterPart() {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
            WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchWindow.getActivePage();
            if (workbenchPage != null) {
                IPerspectiveDescriptor[] iPerspectiveDescriptorArray = workbenchPage.getOpenPerspectives();
                int n2 = 0;
                while (n2 < iPerspectiveDescriptorArray.length) {
                    IViewPart iViewPart;
                    IPerspectiveDescriptor iPerspectiveDescriptor = iPerspectiveDescriptorArray[n2];
                    IViewReference iViewReference = workbenchPage.findPerspective(iPerspectiveDescriptor).findView("org.eclipse.ui.internal.introview");
                    if (iViewReference != null && (iViewPart = iViewReference.getView(false)) != null && iViewPart instanceof ViewIntroAdapterPart) {
                        return (ViewIntroAdapterPart)iViewPart;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    IIntroPart createNewIntroPart() throws CoreException {
        IntroDescriptor introDescriptor = this.workbench.getIntroDescriptor();
        IIntroPart iIntroPart = this.introPart = introDescriptor == null ? null : introDescriptor.createIntro();
        if (this.introPart != null) {
            this.workbench.getExtensionTracker().registerObject(introDescriptor.getConfigurationElement().getDeclaringExtension(), (Object)this.introPart, 2);
        }
        return this.introPart;
    }

    @Override
    public boolean hasIntro() {
        return this.workbench.getIntroDescriptor() != null;
    }

    @Override
    public boolean isNewContentAvailable() {
        IntroDescriptor introDescriptor = this.workbench.getIntroDescriptor();
        if (introDescriptor == null) {
            return false;
        }
        try {
            IntroContentDetector introContentDetector = introDescriptor.getIntroContentDetector();
            if (introContentDetector != null) {
                return introContentDetector.isNewContentAvailable();
            }
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, 2, "Could not load intro content detector", (Throwable)coreException));
        }
        return false;
    }
}

