/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.WindowManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchWindow;

public final class WorkbenchConfigurer
implements IWorkbenchConfigurer {
    private Map extraData = new HashMap();
    private boolean saveAndRestore = false;
    private boolean isEmergencyClosing = false;
    private boolean exitOnLastWindowClose = true;

    WorkbenchConfigurer() {
    }

    @Override
    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    @Override
    public WindowManager getWorkbenchWindowManager() {
        return ((Workbench)this.getWorkbench()).getWindowManager();
    }

    @Override
    public void declareImage(String string, ImageDescriptor imageDescriptor, boolean bl) {
        if (string == null || imageDescriptor == null) {
            throw new IllegalArgumentException();
        }
        WorkbenchImages.declareImage(string, imageDescriptor, bl);
    }

    @Override
    public IWorkbenchWindowConfigurer getWindowConfigurer(IWorkbenchWindow iWorkbenchWindow) {
        if (iWorkbenchWindow == null) {
            throw new IllegalArgumentException();
        }
        return ((WorkbenchWindow)iWorkbenchWindow).getWindowConfigurer();
    }

    @Override
    public boolean getSaveAndRestore() {
        return this.saveAndRestore;
    }

    @Override
    public void setSaveAndRestore(boolean bl) {
        this.saveAndRestore = bl;
    }

    @Override
    public Object getData(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.extraData.get(string);
    }

    @Override
    public void setData(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (object != null) {
            this.extraData.put(string, object);
        } else {
            this.extraData.remove(string);
        }
    }

    @Override
    public void emergencyClose() {
        if (!this.isEmergencyClosing) {
            this.isEmergencyClosing = true;
            if (Workbench.getInstance() != null && !Workbench.getInstance().isClosing()) {
                Workbench.getInstance().close(3, true);
            }
        }
    }

    @Override
    public boolean emergencyClosing() {
        return this.isEmergencyClosing;
    }

    @Override
    public IStatus restoreState() {
        return ((Workbench)this.getWorkbench()).restoreState();
    }

    @Override
    public void openFirstTimeWindow() {
        ((Workbench)this.getWorkbench()).openFirstTimeWindow();
    }

    @Override
    public IWorkbenchWindowConfigurer restoreWorkbenchWindow(IMemento iMemento) throws WorkbenchException {
        return this.getWindowConfigurer(((Workbench)this.getWorkbench()).restoreWorkbenchWindow(iMemento));
    }

    @Override
    public boolean getExitOnLastWindowClose() {
        return this.exitOnLastWindowClose;
    }

    @Override
    public void setExitOnLastWindowClose(boolean bl) {
        this.exitOnLastWindowClose = bl;
    }
}

